/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class HPStOVTLPerfTest
extends HPStoreOnceBase {
    private String logMessage = "";
    private boolean isFirstTime = true;
    double counter = 300.0;

    public HPStOVTLPerfTest(String[] stringArray) {
        super(stringArray);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        HPStOVTLPerfTest hPStOVTLPerfTest = new HPStOVTLPerfTest(stringArray);
        hPStOVTLPerfTest.debugComputeMeasures(new Hashtable(), true);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        String string = "[debugComputeMeasures] :";
        try {
            this.setData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace(string + " Exception occured in setData()", exception);
        }
        try {
            if (this.isFirstTime) {
                this.counter = (double)this.measurePeriod / 1000.0;
                this.printOut("[debugComputeMeasures] :First time collected time for statistics( " + this.counter + " seconds back time  - Time format is GMT) :" + this.startTime);
                this.isFirstTime = false;
            } else {
                this.counter = this.timeSinceLastTest;
                this.printOut("[debugComputeMeasures] :After first time collected time for statistics(" + this.counter + " seconds delayed - Time format is GMT) :" + this.startTime);
            }
            if (this.counter <= 0.0) {
                this.logMessage = "[debugComputeMeasures] :Counter value is zero or negative for " + this.targetHost + ",So returning";
                this.printOut(this.logMessage, debug);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            String string2 = "Virtual Tape Library";
            String string3 = "/services/vtl/parametrics/throughput/reports/min";
            string3 = string3 + this.getHPStoreOnceFrequencyURI(this.counter);
            Hashtable hashtable2 = this.getThroughputInfo(string3, string2, THROUGHPUT_PROPERTY_KEYS_ARRAYLIST);
            this.printOut(string + "Measure from " + string2 + " info : " + hashtable2);
            if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                this.logMessage = "[debugComputeMeasures] :command output null or size is zero or empty for " + this.targetHost + ",So returning";
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                return;
            }
            double d = this.getDoubleData(hashtable2, "readThroughput");
            double d2 = this.getDoubleData(hashtable2, "writeThroughput");
            double d3 = this.getDoubleData(hashtable2, "openFDCount");
            this.printOut(string + " readThroughput\t    :" + d);
            this.printOut(string + " writeThroughput\t    :" + d2);
            this.printOut(string + " openFDCount\t    \t:" + d3);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            d = this.getBytesToMBConverter(d);
            d2 = this.getBytesToMBConverter(d2);
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            if (!bl) {
                this.addNewMeasure(arrayList);
            }
            this.printOut(string + "Measure list " + arrayList);
        }
        catch (Exception exception) {
            this.logMessage = "[debugComputeMeasures] :Exception occured ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
    }
}

