/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class HanaDbWorkloadTest
extends GenericTest {
    private static final int DB_WORKLOAD_MEASURE_COUNT = 11;
    private String userName = "";
    private String password = "";
    private Hashtable prevhash = new Hashtable();
    private String hostNameToFilter = "";
    private boolean checkHostName = true;
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);

    public HanaDbWorkloadTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.needAgentlessDD = true;
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.dfs.setDecimalSeparator('.');
        this.df.applyPattern("#.####");
        this.df.setDecimalFormatSymbols(this.dfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void computeMeasures(Hashtable hashtable) {
        block30: {
            Statement statement;
            ResultSet resultSet;
            Connection connection;
            block29: {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                Hashtable<String, ArrayList<Double>> hashtable2;
                ArrayList<Double> arrayList;
                block28: {
                    if (this.checkHostName) {
                        ConnectionManager.collectHanaHostDetails(this.reportingName, this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                        arrayList = ConnectionManager.getHanaDbDetails(this.reportingName + ":" + this.targetHost + ":" + this.portNo);
                        if (arrayList != null && arrayList.size() > 0) {
                            this.hostNameToFilter = (String)arrayList.get(0);
                            this.hostNameToFilter = this.hostNameToFilter.toLowerCase().trim();
                            this.checkHostName = false;
                        } else {
                            this.logToErrorFile("INFO :", this.entity, "Failed to find the Hana Host details for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                            return;
                        }
                    }
                    System.out.println(this.entity + " ::hostNameToFilter==>" + this.hostNameToFilter + ":targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    arrayList = new ArrayList<Double>();
                    hashtable2 = new Hashtable<String, ArrayList<Double>>();
                    connection = null;
                    resultSet = null;
                    statement = null;
                    d10 = 0.0;
                    d9 = 0.0;
                    d8 = 0.0;
                    d7 = 0.0;
                    d6 = 0.0;
                    d5 = 0.0;
                    d4 = 0.0;
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                    string9 = "";
                    string8 = "";
                    string7 = "";
                    string6 = "";
                    string5 = "";
                    string4 = "";
                    string3 = "";
                    string2 = "";
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Select   host,  port,  execution_count,  compilation_count,  update_transaction_count,  ");
                    stringBuffer.append(" commit_count,rollback_count    from  m_workload where lower(host)='" + this.hostNameToFilter + "'");
                    string = stringBuffer.toString();
                    System.out.println(this.entity + "==>Query:" + string + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    connection = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.userName, this.password, debug);
                    if (connection != null) break block28;
                    this.logToErrorFile("ERROR :", this.entity, "Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo);
                    try {
                        this.closeRs(resultSet);
                        this.closeSt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                    this.closeSt(statement);
                    this.closeConn(connection);
                    exception.printStackTrace();
                    try {
                        this.closeRs(resultSet);
                        this.closeSt(statement);
                        this.closeConn(connection);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return;
                }
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    arrayList = new ArrayList();
                    string9 = resultSet.getString(1);
                    string8 = resultSet.getString(2);
                    string7 = string9 + ":" + string8;
                    string6 = resultSet.getString(3);
                    d10 = this.getDoubleValue(string6);
                    string5 = resultSet.getString(4);
                    d9 = this.getDoubleValue(string5);
                    string4 = resultSet.getString(5);
                    d8 = this.getDoubleValue(string4);
                    string3 = resultSet.getString(6);
                    d7 = this.getDoubleValue(string3);
                    string2 = resultSet.getString(7);
                    d6 = this.getDoubleValue(string2);
                    arrayList.add(new Double(d10));
                    arrayList.add(new Double(d9));
                    arrayList.add(new Double(d8));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d6));
                    System.out.println("ArrayList values are  without rates calculation  " + arrayList);
                    hashtable2.put(string7, arrayList);
                }
                if (hashtable2 == null) break block29;
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    ArrayList arrayList2;
                    String string10 = (String)enumeration.nextElement();
                    if (this.prevhash != null && this.prevhash.size() > 0) {
                        arrayList2 = (ArrayList)this.prevhash.get(string10);
                        ArrayList arrayList3 = (ArrayList)hashtable2.get(string10);
                        if (arrayList2 == null || arrayList3 == null) continue;
                        double d11 = (Double)arrayList3.get(0);
                        double d12 = (Double)arrayList3.get(1);
                        double d13 = (Double)arrayList3.get(2);
                        double d14 = (Double)arrayList3.get(3);
                        double d15 = (Double)arrayList3.get(4);
                        double d16 = (Double)arrayList2.get(0);
                        double d17 = (Double)arrayList2.get(1);
                        double d18 = (Double)arrayList2.get(2);
                        double d19 = (Double)arrayList2.get(3);
                        double d20 = (Double)arrayList2.get(4);
                        double d21 = d11 - d16;
                        double d22 = d12 - d17;
                        double d23 = d13 - d18;
                        double d24 = d14 - d19;
                        double d25 = d15 - d20;
                        double d26 = d25 / (d25 + d24) * 100.0;
                        if (this.timeSinceLastTest <= 0.0) continue;
                        d5 = d21 / this.timeSinceLastTest;
                        d5 = this.roundDouble(d5);
                        d4 = d22 / this.timeSinceLastTest;
                        d4 = this.roundDouble(d4);
                        d3 = d23 / this.timeSinceLastTest;
                        d3 = this.roundDouble(d3);
                        d2 = d24 / this.timeSinceLastTest;
                        d2 = this.roundDouble(d2);
                        d = d25 / this.timeSinceLastTest;
                        d = this.roundDouble(d);
                        System.out.println("[" + this.entity + "]Diff executionCount ======>" + d21);
                        System.out.println("[" + this.entity + "]Diff compilationCount======>" + d22);
                        System.out.println("[" + this.entity + "]Diff updateTransactionCount======>" + d23);
                        System.out.println("[" + this.entity + "]Diff commitCount======>" + d24);
                        System.out.println("[" + this.entity + "]Diff rollbackCount ==========>" + d25);
                        System.out.println("[" + this.entity + "]Diff rollbackPercentage ======>" + d26);
                        System.out.println("[" + this.entity + "]Diff executionRate======>" + d5);
                        System.out.println("[" + this.entity + "]Diff compilationRate======>" + d4);
                        System.out.println("[" + this.entity + "]Diff updateTransactionRate======>" + d3);
                        System.out.println("[" + this.entity + "]Diff commitRate ==========>" + d2);
                        System.out.println("[" + this.entity + "]Diff rollbackRate ==========>" + d);
                        ArrayList<Double> arrayList4 = new ArrayList<Double>();
                        arrayList4.add(new Double(d21));
                        arrayList4.add(new Double(d22));
                        arrayList4.add(new Double(d23));
                        arrayList4.add(new Double(d24));
                        arrayList4.add(new Double(d25));
                        arrayList4.add(new Double(d26));
                        arrayList4.add(new Double(d5));
                        arrayList4.add(new Double(d4));
                        arrayList4.add(new Double(d3));
                        arrayList4.add(new Double(d2));
                        arrayList4.add(new Double(d));
                        System.out.println("[" + this.entity + "] key1====>" + string10 + " value1===>" + arrayList4);
                        this.addNewMeasure(string10, arrayList4);
                        continue;
                    }
                    arrayList2 = new ArrayList();
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    System.out.println("[" + this.entity + "]NotAvaliablevalue key==>" + string10 + " value===>" + arrayList2);
                    this.addNewMeasure(string10, arrayList2);
                }
                this.prevhash = (Hashtable)hashtable2.clone();
                System.out.println("[" + this.entity + "]previoushash======>" + this.prevhash);
            }
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block30;
            catch (SQLException sQLException) {
                this.logToErrorFile("ERROR :", this.entity + " SQL Error in computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, sQLException.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + sQLException.toString());
                sQLException.printStackTrace();
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break block30;
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR :", this.entity + " computeMeasures targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo, exception.toString());
                System.out.println("ERROR : Exception occured in " + this.entity + "targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " Exception:" + exception.toString());
                exception.printStackTrace();
                {
                    catch (Throwable throwable) {
                        try {
                            this.closeRs(resultSet);
                            this.closeSt(statement);
                            this.closeConn(connection);
                        }
                        catch (Exception exception3) {
                            exception3.printStackTrace();
                        }
                        throw throwable;
                    }
                }
                try {
                    this.closeRs(resultSet);
                    this.closeSt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
            }
        }
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else {
            try {
                string = string.trim();
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    private double roundDouble(double d) {
        BigDecimal bigDecimal = new BigDecimal(d);
        String string = this.df.format(bigDecimal);
        return Double.parseDouble(string);
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        HanaDbWorkloadTest hanaDbWorkloadTest = new HanaDbWorkloadTest(stringArray);
        int n = 0;
        while (n < 2) {
            try {
                hanaDbWorkloadTest.computeMeasures(new Hashtable());
                Thread.sleep(10000L);
                ++n;
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
        }
    }
}

