/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class HostStorageTest
extends EgSnmpGenericTest {
    private static String descrOid = ".1.3.6.1.2.1.25.2.3.1.3";
    private static String unitsOid = ".1.3.6.1.2.1.25.2.3.1.4";
    private static String sizeOid = ".1.3.6.1.2.1.25.2.3.1.5";
    private static String usedOid = ".1.3.6.1.2.1.25.2.3.1.6";
    private static String failOid = ".1.3.6.1.2.1.25.2.3.1.7";
    private double bToGb = 1.073741824E9;
    private static int numMeasures = 4;
    private int rediscCount = -1;
    private int maxRediscPeriod = 4;
    private int numStorageAreas = 0;
    private Hashtable indexToDescMap = new Hashtable();
    private Hashtable indexToUnitsMap = new Hashtable();
    private Hashtable indexToSizeMap = new Hashtable();
    private Hashtable indexToLastFailMap = new Hashtable();

    public HostStorageTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isNewDynamicInfoTest = true;
    }

    private void discStorageAreas() {
        int n;
        ++this.rediscCount;
        if (this.rediscCount >= this.maxRediscPeriod) {
            this.rediscCount = 0;
        }
        if (this.rediscCount != 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(descrOid);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.indexToDescMap = new Hashtable();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.lhs.length; ++n) {
            String string = this.rhs[n];
            if (arrayList.contains(string)) {
                string = string + "_" + this.lhs[n];
            }
            arrayList.add(string);
            this.indexToDescMap.put(this.lhs[n], string);
        }
        arrayList = null;
        bl = this.runSnmpCmdForOid(unitsOid);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.indexToUnitsMap = new Hashtable();
        for (n = 0; n < this.lhs.length; ++n) {
            double d = -1.0;
            try {
                d = Double.parseDouble(this.rhs[n]) / this.bToGb;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.indexToUnitsMap.put(this.lhs[n], new Double(d));
        }
        bl = this.runSnmpCmdForOid(sizeOid);
        if (!bl || this.lhs == null || this.lhs.length <= 0) {
            this.rediscCount = -1;
            return;
        }
        this.indexToSizeMap = new Hashtable();
        for (n = 0; n < this.lhs.length; ++n) {
            double d = -1.0;
            try {
                d = Double.parseDouble(this.rhs[n]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.indexToSizeMap.put(this.lhs[n], new Double(d));
        }
        this.numStorageAreas = this.lhs.length;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.discStorageAreas();
        if (this.numStorageAreas == 0) {
            return;
        }
        boolean bl = this.runSnmpCmdForOid(usedOid);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return;
        }
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        for (int i = 0; i < this.lhs.length; ++i) {
            double d = -1.0;
            try {
                d = Double.parseDouble(this.rhs[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!(d >= 0.0)) continue;
            hashtable2.put(this.lhs[i], new Double(d));
        }
        bl = this.runSnmpCmdForOid(failOid);
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        if (bl && this.lhs != null && this.lhs.length > 0) {
            for (int i = 0; i < this.lhs.length; ++i) {
                double d = -1.0;
                try {
                    d = Double.parseDouble(this.rhs[i]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(d >= 0.0)) continue;
                hashtable3.put(this.lhs[i], new Double(d));
            }
        }
        if (hashtable2 != null && hashtable2.size() > 0) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                double d;
                Serializable serializable;
                Double d2;
                double d3;
                Double d4;
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.indexToDescMap.get(string);
                if (string2 == null || (d4 = (Double)hashtable2.get(string)) == null) continue;
                double d5 = d4;
                Double d6 = (Double)this.indexToUnitsMap.get(string);
                if (d6 == null || (d3 = d6.doubleValue()) < 0.0 || (d2 = (Double)this.indexToSizeMap.get(string)) == null) continue;
                double d7 = d2;
                double d8 = -5.0;
                d8 = d7 <= 0.0 ? -5.0 : d5 * 100.0 / d7;
                double d9 = -5.0;
                if (hashtable3 != null && hashtable3.size() > 0 && (serializable = (Double)hashtable3.get(string)) != null) {
                    d = (Double)serializable;
                    Double d10 = (Double)this.indexToLastFailMap.get(string);
                    double d11 = -1.0;
                    if (d10 != null) {
                        d11 = d10;
                        if (d >= 0.0 && d11 >= 0.0 && (d9 = d - d11) < 0.0) {
                            d9 = -5.0;
                        }
                    }
                }
                serializable = new ArrayList();
                d = d7 * d3;
                if (d < 0.0) {
                    d = -5.0;
                }
                ((ArrayList)serializable).add(new Double(d));
                if (d8 < 0.0) {
                    d8 = -5.0;
                } else if (d8 > 100.0) {
                    d8 = 100.0;
                }
                ((ArrayList)serializable).add(new Double(d8));
                double d12 = (d7 - d5) * d3;
                if (d12 < 0.0 && d12 != -1.0 && d12 != -5.0) {
                    d12 = 0.0;
                }
                ((ArrayList)serializable).add(new Double(d12));
                ((ArrayList)serializable).add(new Double(d9));
                System.out.println("HostStorage al_measures::" + serializable);
                this.addNewMeasure(string2, (ArrayList)serializable);
            }
        }
        this.indexToLastFailMap = hashtable3;
    }
}

