/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaAPMStatusCodeObject;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStatusCodeTest
extends BTMBase {
    private static final Double ZERO_VALUE = 0.0;
    private static final Double MINUS_VALUE = -5.0;
    private static final String SUMMARY = "Summary";
    private ArrayList<String> specificStatusTrackingList = new ArrayList();
    private static final String STATUS = " status";
    private static final String TOTAL_REQUEST_COUNT = "TOTAL_REQUEST_COUNT";
    private static final String TOTAL_REDIRECT_COUNT = "TOTAL_REDIRECT_COUNT";
    private static final String REDIRECTED = "_Redirected";
    private long maxDDLimit = 10L;
    protected Hashtable ddSourceTable;

    public HttpStatusCodeTest(String[] stringArray) {
        super(stringArray);
        Object object;
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [HttpResponseStatusTest]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        String string = this.getValueForParam("Specific_Status_Code_List");
        if (string != null && !string.equalsIgnoreCase("None")) {
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreElements()) {
                String string2 = (String)((StringTokenizer)object).nextElement();
                this.specificStatusTrackingList.add(string2);
            }
            JavaBTMLogger.btmLogger.debug("{} Specific status code tracking list updated with {} : for JVM {}", new Object[]{this.loggerDispStr, this.specificStatusTrackingList, this.jvmGUID});
        }
        if ((object = this.getValueForParam("Max_Per_Status_Code_DD_Limit")) != null) {
            try {
                this.maxDDLimit = Long.parseLong((String)object);
                JavaBTMLogger.btmLogger.debug("{} Max DD capture for each status code descriptor is  updated to {} : for JVM {}", new Object[]{this.loggerDispStr, this.maxDDLimit, this.jvmGUID});
            }
            catch (Exception exception) {
                this.maxDDLimit = 10L;
                JavaBTMLogger.btmLogger.error("{} Max DD capture for each status code descriptor is  updated to {} : for JVM {}", new Object[]{this.loggerDispStr, this.maxDDLimit, this.jvmGUID});
                JavaBTMLogger.btmLogger.error("Exception while parsing javaStatusCodeTest DD limit {}", (Throwable)exception);
            }
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        Object object2;
        Object object3;
        boolean bl;
        this.getJvmGuid();
        JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(this.jvmGUID);
        if (javaAPMComponent == null) {
            return;
        }
        ArrayList<JavaAPMStatusCodeObject> arrayList = javaAPMComponent.getJavaAPMStatusCode();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        this.ddSourceTable = new Hashtable();
        long l = this.measurePeriod / 1000L / 60L;
        JavaBTMLogger.btmLogger.trace("{}  {} received status code details list : {} specificStatusTrackingList : {} ", new Object[]{this.loggerDispStr, this.entity, arrayList, this.specificStatusTrackingList});
        boolean bl2 = bl = javaAPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
        if (arrayList == null && bl) {
            object3 = this.createDefaultValueList();
            for (int i = 2; i <= 5; ++i) {
                object2 = this.getDisplayDescriptor(String.valueOf(i));
                this.addNewMeasure((String)object2, (ArrayList)object3);
            }
        } else if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                JavaAPMStatusCodeObject javaAPMStatusCodeObject = arrayList.get(i);
                object2 = javaAPMStatusCodeObject.getStatusCode();
                string = this.getDisplayDescriptor((String)object2);
                boolean bl3 = this.specificStatusTrackingList.contains(object2);
                if (javaAPMStatusCodeObject.isStatus404Redirect()) {
                    double d = javaAPMStatusCodeObject.getStatus404Count();
                    double d2 = javaAPMStatusCodeObject.getStatus404RedirectCount();
                    this.update404CallCountDetails(string, d, d2, hashMap, hashMap2);
                    continue;
                }
                boolean bl4 = javaAPMStatusCodeObject.isErrorRedirectRequest();
                if (bl3) {
                    object = this.getSpecificDisplayDescriptor((String)object2);
                    this.updateCallCountDetails((String)object, hashMap, bl4, hashMap2, javaAPMStatusCodeObject, true);
                    this.updateCallCountDetails(string, hashMap, bl4, hashMap2, javaAPMStatusCodeObject, false);
                    continue;
                }
                this.updateCallCountDetails(string, hashMap, bl4, hashMap2, javaAPMStatusCodeObject, true);
            }
        }
        JavaBTMLogger.btmLogger.trace("{}  {} callCountDetailsMap {}  redirectedCallCountDetailsMap {} ", new Object[]{this.loggerDispStr, this.entity, hashMap, hashMap2});
        this.calculateSummaryAllDetails(hashMap, hashMap2, l);
        if (hashMap != null && hashMap.size() > 0) {
            object3 = hashMap.entrySet().iterator();
            while (object3.hasNext()) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                object2 = (Map.Entry)object3.next();
                string = (String)object2.getKey();
                Double d = (Double)object2.getValue();
                Double d3 = hashMap2.remove(string + REDIRECTED);
                object = d / (double)l;
                arrayList2.add(d);
                arrayList2.add(object);
                arrayList2.add(d3);
                arrayList2.add(MINUS_VALUE);
                arrayList2.add(MINUS_VALUE);
                arrayList2.add(MINUS_VALUE);
                arrayList2.add(MINUS_VALUE);
                this.addNewMeasure(string, arrayList2);
            }
        }
    }

    private void calculateSummaryAllDetails(HashMap<String, Double> hashMap, HashMap<String, Double> hashMap2, long l) {
        HashMap hashMap3 = new HashMap();
        if (hashMap != null && hashMap.size() > 0) {
            double d = hashMap.remove(TOTAL_REQUEST_COUNT);
            Double d2 = hashMap2.get(TOTAL_REDIRECT_COUNT);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(d);
            arrayList.add(d / (double)l);
            if (d2 == null) {
                d2 = 0.0;
            }
            arrayList.add(d2);
            for (int i = 2; i <= 5; ++i) {
                String string = this.getDisplayDescriptor(String.valueOf(i));
                Double d3 = hashMap.get(string);
                if (d3 == null) {
                    arrayList.add(ZERO_VALUE);
                    continue;
                }
                double d4 = d3 * 100.0 / d;
                arrayList.add(d4);
            }
            this.addNewMeasure("All Responses", arrayList);
        }
    }

    private void prepareDDDetails(String string, JavaAPMStatusCodeObject javaAPMStatusCodeObject) {
        if (this.ddSourceTable.containsKey(string)) {
            ArrayList arrayList = (ArrayList)this.ddSourceTable.get(string);
            ArrayList arrayList2 = this.getDDData(javaAPMStatusCodeObject);
            arrayList.add(arrayList2);
            this.ddSourceTable.put(string, arrayList);
        } else {
            ArrayList arrayList = this.getDDData(javaAPMStatusCodeObject);
            ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
            arrayList3.add(arrayList);
            this.ddSourceTable.put(string, arrayList3);
        }
    }

    private ArrayList getDDData(JavaAPMStatusCodeObject javaAPMStatusCodeObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = javaAPMStatusCodeObject.getReqGUID();
        String string2 = string.substring(0, string.indexOf("#~#"));
        String string3 = string.substring(string.indexOf("#~#") + 3);
        arrayList.add(string2);
        arrayList.add(string3);
        arrayList.add(javaAPMStatusCodeObject.getPatternString());
        arrayList.add(javaAPMStatusCodeObject.getStatusMesage());
        arrayList.add(javaAPMStatusCodeObject.getStatusCode());
        JavaBTMLogger.btmLogger.trace("{} DDD data is prepared for status code {} {}", new Object[]{this.loggerDispStr, javaAPMStatusCodeObject.getStatusCode(), arrayList});
        return arrayList;
    }

    private void update404CallCountDetails(String string, double d, double d2, HashMap<String, Double> hashMap, HashMap<String, Double> hashMap2) {
        if (hashMap.containsKey(string)) {
            double d3 = hashMap.get(string);
            double d4 = d3 + d;
            hashMap.put(string, d4);
        } else {
            hashMap.put(string, d);
        }
        this.updateCallCountDetails(hashMap2, string + REDIRECTED, d2);
        this.updateCallCountDetails(hashMap2, TOTAL_REDIRECT_COUNT, d2);
        this.updateCallCountDetails(hashMap, TOTAL_REQUEST_COUNT, d);
    }

    private void updateCallCountDetails(String string, HashMap<String, Double> hashMap, boolean bl, HashMap<String, Double> hashMap2, JavaAPMStatusCodeObject javaAPMStatusCodeObject, boolean bl2) {
        if (hashMap.containsKey(string)) {
            double d = hashMap.get(string);
            if (d < (double)this.maxDDLimit && bl2) {
                this.prepareDDDetails(string, javaAPMStatusCodeObject);
            }
            hashMap.put(string, d += 1.0);
        } else {
            if (bl2) {
                this.prepareDDDetails(string, javaAPMStatusCodeObject);
            }
            hashMap.put(string, 1.0);
        }
        if (bl) {
            this.updateCallCountDetails(hashMap, string + REDIRECTED, 1.0);
            this.updateCallCountDetails(hashMap2, TOTAL_REDIRECT_COUNT, 1.0);
        } else {
            hashMap2.put(string + REDIRECTED, 0.0);
        }
        if (bl2) {
            this.updateCallCountDetails(hashMap, TOTAL_REQUEST_COUNT, 1.0);
        }
    }

    private void updateCallCountDetails(HashMap<String, Double> hashMap, String string, double d) {
        Double d2 = hashMap.get(string);
        if (d2 == null) {
            hashMap.put(string, d);
        } else {
            d2 = d2 + d;
            hashMap.put(string, d2);
        }
    }

    private String getDisplayDescriptor(String string) {
        if (string.startsWith("2")) {
            return "HTTP 2xx Status:Summary";
        }
        if (string.startsWith("3")) {
            return "HTTP 3xx Status:Summary";
        }
        if (string.startsWith("4")) {
            return "HTTP 4xx Status:Summary";
        }
        if (string.startsWith("5")) {
            return "HTTP 5xx Status:Summary";
        }
        return null;
    }

    private String getSpecificDisplayDescriptor(String string) {
        if (string.startsWith("2")) {
            return "HTTP 2xx Status:" + string + STATUS;
        }
        if (string.startsWith("3")) {
            return "HTTP 3xx Status:" + string + STATUS;
        }
        if (string.startsWith("4")) {
            return "HTTP 4xx Status:" + string + STATUS;
        }
        if (string.startsWith("5")) {
            return "HTTP 5xx Status:" + string + STATUS;
        }
        return null;
    }

    private ArrayList createDefaultValueList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(ZERO_VALUE);
        arrayList.add(ZERO_VALUE);
        arrayList.add(ZERO_VALUE);
        arrayList.add(MINUS_VALUE);
        arrayList.add(MINUS_VALUE);
        arrayList.add(MINUS_VALUE);
        arrayList.add(MINUS_VALUE);
        return arrayList;
    }

    public ArrayList getStatusCodeDDDetails(String string) {
        ArrayList arrayList = null;
        if (this.ddSourceTable != null && this.ddSourceTable.size() > 0) {
            arrayList = (ArrayList)this.ddSourceTable.get(string);
        }
        JavaBTMLogger.btmLogger.trace("{} Method getDDDetails returns {} ", (Object)this.loggerDispStr, arrayList);
        return arrayList;
    }
}

