/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IBMDb2PoolTest
extends GenericTest {
    private static final int MEASURES_COUNT = 9;
    private String user;
    private String password;
    private String dbName;
    private Hashtable prevValues = null;
    private ArrayList activeDatabases;

    public IBMDb2PoolTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.prevValues = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getBufferPoolStats();
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getBufferPoolStats() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = -5.0;
        double d15 = -5.0;
        double d16 = -5.0;
        double d17 = -5.0;
        double d18 = -5.0;
        double d19 = -5.0;
        double d20 = -5.0;
        double d21 = -5.0;
        double d22 = -5.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        Hashtable hashtable = new Hashtable();
        dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
        connection = dB2JdbcHelper.getConnection();
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT DB_NAME, POOL_DATA_P_READS, POOL_INDEX_P_READS,POOL_DATA_L_READS,POOL_INDEX_L_READS,CAT_CACHE_INSERTS, CAT_CACHE_LOOKUPS,POOL_ASYNC_DATA_READS,POOL_ASYNC_INDEX_READS,POOL_LSN_GAP_CLNS,POOL_DRTY_PG_STEAL_CLNS,POOL_DRTY_PG_THRSH_CLNS,PKG_CACHE_INSERTS,PKG_CACHE_LOOKUPS FROM TABLE(" + string + ") DB";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            this.activeDatabases = new ArrayList();
            while (resultSet.next()) {
                String string3 = resultSet.getString("DB_NAME");
                d = resultSet.getDouble("POOL_DATA_L_READS");
                d2 = resultSet.getDouble("POOL_DATA_P_READS");
                d3 = resultSet.getDouble("POOL_INDEX_L_READS");
                d4 = resultSet.getDouble("POOL_INDEX_P_READS");
                d5 = resultSet.getDouble("POOL_ASYNC_DATA_READS");
                d6 = resultSet.getDouble("POOL_ASYNC_INDEX_READS");
                d7 = resultSet.getDouble("POOL_LSN_GAP_CLNS");
                d8 = resultSet.getDouble("POOL_DRTY_PG_STEAL_CLNS");
                d9 = resultSet.getDouble("POOL_DRTY_PG_THRSH_CLNS");
                d10 = resultSet.getDouble("CAT_CACHE_INSERTS");
                d11 = resultSet.getDouble("CAT_CACHE_LOOKUPS");
                d12 = resultSet.getDouble("PKG_CACHE_INSERTS");
                d13 = resultSet.getDouble("PKG_CACHE_LOOKUPS");
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList = (ArrayList<Double>)this.prevValues.get(string3);
                if (arrayList == null) {
                    arrayList = new ArrayList<Double>(13);
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d8));
                    arrayList.add(new Double(d9));
                    arrayList.add(new Double(d10));
                    arrayList.add(new Double(d11));
                    arrayList.add(new Double(d12));
                    arrayList.add(new Double(d13));
                } else {
                    double d23 = (Double)arrayList.get(0);
                    double d24 = (Double)arrayList.get(1);
                    double d25 = (Double)arrayList.get(2);
                    double d26 = (Double)arrayList.get(3);
                    double d27 = (Double)arrayList.get(4);
                    double d28 = (Double)arrayList.get(5);
                    double d29 = (Double)arrayList.get(6);
                    double d30 = (Double)arrayList.get(7);
                    double d31 = (Double)arrayList.get(8);
                    double d32 = (Double)arrayList.get(9);
                    double d33 = (Double)arrayList.get(10);
                    double d34 = (Double)arrayList.get(11);
                    double d35 = (Double)arrayList.get(12);
                    double d36 = d - d23;
                    double d37 = d2 - d24;
                    double d38 = d3 - d25;
                    double d39 = d4 - d26;
                    double d40 = d5 - d27;
                    double d41 = d6 - d28;
                    double d42 = d7 - d29;
                    double d43 = d8 - d30;
                    double d44 = d9 - d31;
                    double d45 = d10 - d32;
                    double d46 = d11 - d33;
                    double d47 = d12 - d34;
                    double d48 = d13 - d35;
                    double d49 = d36 + d38 + d37 + d39;
                    d14 = d49 > 0.0 ? ((d14 = 100.0 * ((d36 + d38) / d49)) == 0.0 ? 100.0 : d14) : 100.0;
                    d15 = d37 + d36 > 0.0 ? ((d15 = 100.0 * (d36 / (d37 + d36))) == 0.0 ? 100.0 : d15) : 100.0;
                    d16 = d39 + d38 > 0.0 ? ((d16 = 100.0 * (d38 / (d39 + d38))) == 0.0 ? 100.0 : d16) : 100.0;
                    d17 = d36 + d38 > 0.0 ? (d40 + d41) * 100.0 / (d36 + d38) : 100.0;
                    double d50 = d42 + d43 + d44;
                    if (d50 > 0.0) {
                        d18 = d42 * 100.0 / (d42 + d43 + d44);
                        d19 = d44 * 100.0 / (d42 + d43 + d44);
                        d20 = d43 * 100.0 / (d42 + d43 + d44);
                    } else {
                        d18 = 0.0;
                        d19 = 0.0;
                        d20 = 0.0;
                    }
                    d21 = d46 > 0.0 ? (1.0 - d45 / d46) * 100.0 : 100.0;
                    d22 = d48 > 0.0 ? (1.0 - d47 / d48) * 100.0 : 100.0;
                    arrayList.set(0, new Double(d));
                    arrayList.set(1, new Double(d2));
                    arrayList.set(2, new Double(d3));
                    arrayList.set(3, new Double(d4));
                    arrayList.set(4, new Double(d5));
                    arrayList.set(5, new Double(d6));
                    arrayList.set(6, new Double(d7));
                    arrayList.set(7, new Double(d8));
                    arrayList.set(8, new Double(d9));
                    arrayList.set(9, new Double(d10));
                    arrayList.set(10, new Double(d11));
                    arrayList.set(11, new Double(d12));
                    arrayList.set(12, new Double(d13));
                }
                this.prevValues.put(string3, arrayList);
                ArrayList<Double> arrayList2 = new ArrayList<Double>(9);
                arrayList2.add(new Double(d14));
                arrayList2.add(new Double(d15));
                arrayList2.add(new Double(d16));
                arrayList2.add(new Double(d17));
                arrayList2.add(new Double(d18));
                arrayList2.add(new Double(d19));
                arrayList2.add(new Double(d20));
                arrayList2.add(new Double(d21));
                arrayList2.add(new Double(d22));
                hashtable.put(string3, arrayList2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception occured in IBMDb2BuffPoolTest " + exception);
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        ArrayList<Double> arrayList = new ArrayList<Double>(9);
        for (int i = 0; i < 9; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

