/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IIBParserStTest
extends IIBResourceStatisticsBase {
    private static final int PARSER_STAT_MEASURE_COUNT = 8;
    public Hashtable prevhash = new Hashtable();

    public IIBParserStTest(String[] args) {
        super(args);
        this.setMeasureCount(8);
    }

    public void computeMeasures(Hashtable params) {
        this.setData();
        Hashtable currHashtable = new Hashtable();
        currHashtable = this.getData("Parsers");
        if (currHashtable == null || currHashtable.size() == 0 || currHashtable.isEmpty()) {
            return;
        }
        if (currHashtable != null) {
            Enumeration en = currHashtable.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (this.prevhash != null && this.prevhash.size() > 0) {
                    ArrayList prevlist = (ArrayList)this.prevhash.get(key);
                    ArrayList currentlist = (ArrayList)currHashtable.get(key);
                    if (prevlist == null || currentlist == null) continue;
                    double threads = 0.0;
                    double memoryUtil = 0.0;
                    double maxReadBitStream = 0.0;
                    double maxWrittenBitStream = 0.0;
                    double reads = 0.0;
                    double failedReads = 0.0;
                    double writes = 0.0;
                    double failedWrites = 0.0;
                    double currThreads = (Double)currentlist.get(0);
                    double currMemoryUtil = (Double)currentlist.get(1);
                    double currMaxReadBitStream = (Double)currentlist.get(2);
                    double currMaxWrittenBitStream = (Double)currentlist.get(3);
                    double currReads = (Double)currentlist.get(4);
                    double currFailedReads = (Double)currentlist.get(5);
                    double currWrites = (Double)currentlist.get(6);
                    double currFailedWrites = (Double)currentlist.get(7);
                    double prevThreads = (Double)prevlist.get(0);
                    double prevMemoryUtil = (Double)prevlist.get(1);
                    double prevMaxReadBitStream = (Double)prevlist.get(2);
                    double prevMaxWrittenBitStream = (Double)prevlist.get(3);
                    double prevReads = (Double)prevlist.get(4);
                    double prevFailedReads = (Double)prevlist.get(5);
                    double prevWrites = (Double)prevlist.get(6);
                    double prevFailedWrites = (Double)prevlist.get(7);
                    threads = prevThreads - currThreads;
                    memoryUtil = prevMemoryUtil - currMemoryUtil;
                    maxReadBitStream = prevMaxReadBitStream - currMaxReadBitStream;
                    maxWrittenBitStream = prevMaxWrittenBitStream - currMaxWrittenBitStream;
                    reads = prevReads - currReads;
                    failedReads = prevFailedReads - currFailedReads;
                    writes = prevWrites - currWrites;
                    failedWrites = prevFailedWrites - currFailedWrites;
                    if (this.timeSinceLastTest > 0.0) {
                        reads /= this.timeSinceLastTest;
                        failedReads /= this.timeSinceLastTest;
                        writes /= this.timeSinceLastTest;
                        failedWrites /= this.timeSinceLastTest;
                    } else {
                        this.printOut("WARNING : timeSinceLastTest  value was less than zero");
                        reads = -5.0;
                        failedReads = -5.0;
                        writes = -5.0;
                        failedWrites = -5.0;
                    }
                    if (EgTest.debug) {
                        this.printOut(" threads ======>" + threads);
                        this.printOut(" memoryUtil ======>" + memoryUtil);
                        this.printOut(" maxReadBitStream ======>" + maxReadBitStream);
                        this.printOut(" maxWrittenBitStream ======>" + maxWrittenBitStream);
                        this.printOut(" reads ======>" + reads);
                        this.printOut(" failedReads ======>" + failedReads);
                        this.printOut(" writes ======>" + writes);
                        this.printOut(" failedWrites ======>" + failedWrites);
                    }
                    ArrayList<Double> measurelist = new ArrayList<Double>();
                    measurelist.add(new Double(threads));
                    measurelist.add(new Double(memoryUtil));
                    measurelist.add(new Double(maxReadBitStream));
                    measurelist.add(new Double(maxWrittenBitStream));
                    measurelist.add(new Double(reads));
                    measurelist.add(new Double(failedReads));
                    measurelist.add(new Double(writes));
                    measurelist.add(new Double(failedWrites));
                    if (EgTest.debug) {
                        this.printOut(" key1====>" + key + " value1===>" + measurelist);
                    }
                    this.addNewMeasure(key, measurelist);
                    continue;
                }
                ArrayList<Double> al = new ArrayList<Double>();
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                al.add(new Double(-5.0));
                if (EgTest.debug) {
                    this.printOut("NotAvaliablevalue key==>" + key + " value===>" + al);
                }
                this.addNewMeasure(key, al);
            }
            this.prevhash = currHashtable;
            if (EgTest.debug) {
                this.printOut(" previoushash======>" + this.prevhash);
            }
        }
    }

    public static void main(String[] args) {
        IIBParserStTest obj = new IIBParserStTest(args);
        while (true) {
            obj.computeMeasures(new Hashtable());
            try {
                Thread.sleep(120000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

