/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class IbNodeServiceTest
extends EgSnmpGenericTest {
    boolean isFirst = true;
    private static final Hashtable serviceNameHash = new Hashtable();

    public IbNodeServiceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.7779.3.1.1.2.1.10.1.1");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.7779.3.1.1.2.1.10.1.2");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Error :", "IbNodeServiceTest error occured in getMeasure for targetHost:", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = this.getServiceName(string2);
                if (string3 == null) continue;
                String string4 = (String)hashtable3.get(string);
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "-5";
                }
                if (string4.equalsIgnoreCase("1")) {
                    string4 = "100";
                } else if (string4.equalsIgnoreCase("3")) {
                    string4 = "1";
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(string4));
                this.addNewMeasure(string3, arrayList);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "IbNodeServiceTest error occured in getMeasure", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private String getServiceName(String string) {
        String string2 = null;
        try {
            if (string == null) {
                return null;
            }
            string2 = (String)serviceNameHash.get(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    static {
        serviceNameHash.put("9", "node-status");
        serviceNameHash.put("10", "disk-usage");
        serviceNameHash.put("11", "enet-lan");
        serviceNameHash.put("12", "enet-lan2");
        serviceNameHash.put("13", "enet-ha");
        serviceNameHash.put("14", "enet-mgmt");
        serviceNameHash.put("15", "lcd");
        serviceNameHash.put("16", "memory");
        serviceNameHash.put("17", "replication");
        serviceNameHash.put("18", "db-object");
        serviceNameHash.put("19", "raid-summary");
        serviceNameHash.put("20", "raid-disk1");
        serviceNameHash.put("21", "raid-disk2");
        serviceNameHash.put("22", "raid-disk3");
        serviceNameHash.put("23", "raid-disk4");
        serviceNameHash.put("24", "raid-disk5");
        serviceNameHash.put("25", "raid-disk6");
        serviceNameHash.put("26", "raid-disk7");
        serviceNameHash.put("27", "raid-disk8");
        serviceNameHash.put("28", "fan1");
        serviceNameHash.put("29", "fan2");
        serviceNameHash.put("30", "fan3");
        serviceNameHash.put("31", "fan4");
        serviceNameHash.put("32", "fan5");
        serviceNameHash.put("33", "fan6");
        serviceNameHash.put("34", "fan7");
        serviceNameHash.put("35", "fan8");
        serviceNameHash.put("36", "power-supply1");
        serviceNameHash.put("37", "power-supply2");
        serviceNameHash.put("38", "ntp-sync");
        serviceNameHash.put("39", "cpu1-temp");
        serviceNameHash.put("40", "cpu2-temp");
        serviceNameHash.put("41", "sys-temp");
        serviceNameHash.put("42", "raid-battery");
        serviceNameHash.put("43", "cpu-usage");
        serviceNameHash.put("44", "ospf");
        serviceNameHash.put("45", "bgp");
        serviceNameHash.put("46", "mgm-service");
        serviceNameHash.put("47", "subgrid-conn");
        serviceNameHash.put("48", "network-capacity");
        serviceNameHash.put("49", "reporting");
        serviceNameHash.put("50", "dns-cache-acceleration");
        serviceNameHash.put("51", "ospf6");
        serviceNameHash.put("52", "swap-usage");
        serviceNameHash.put("53", "discovery-consolidator");
        serviceNameHash.put("54", "discovery-collector");
        serviceNameHash.put("55", "discovery-capacity");
        serviceNameHash.put("56", "threat-protection");
    }
}

