/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class IbmDiskStorageHelper
extends GenericTest {
    EgUtilities egu;
    protected long lastTime = 0L;
    public static Hashtable ht_lastTime = new Hashtable();
    public static Hashtable final_measures = new Hashtable();
    public static String syncString = "SAN";
    protected Hashtable all_values = null;
    String systemIP = "";
    String rptName = "";
    String smCLILoc = "";
    String processName = "";
    String tmpCmd = "";
    String sys_OS = null;
    boolean debug = false;
    long timeout = 30L;

    public IbmDiskStorageHelper(String[] stringArray) {
        super(stringArray);
        try {
            CharSequence charSequence;
            String string;
            Object object;
            this.egu = EgUtilities.createInstance();
            this.systemIP = this.getValueForParam("AlternateControllerIP");
            if (this.systemIP == null || this.systemIP.trim().equalsIgnoreCase("none")) {
                this.systemIP = this.targetHost;
            } else {
                object = new StringTokenizer(this.systemIP, ",");
                string = "";
                charSequence = "";
                while (((StringTokenizer)object).hasMoreTokens()) {
                    charSequence = ((StringTokenizer)object).nextToken();
                    if (charSequence == null || ((String)charSequence).trim().equalsIgnoreCase(this.targetHost)) continue;
                    string = string + (String)charSequence + " ";
                }
                string = string.trim();
                this.systemIP = this.targetHost + " " + string;
            }
            this.smCLILoc = this.getValueForParam("SMCliLocation");
            object = this.getValueForParam("timeout");
            string = this.getValueForParam("debug");
            if (object == null || ((String)object).trim().length() == 0) {
                this.timeout = 30L;
            } else {
                try {
                    this.timeout = Long.parseLong((String)object);
                }
                catch (Exception exception) {
                    this.timeout = 30L;
                }
            }
            this.rptName = this.reportingName;
            if (string == null) {
                this.debug = false;
            }
            if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
                this.debug = true;
            }
            if (this.systemIP == null) {
                this.systemIP = "";
            } else if (this.systemIP.indexOf(",") > 0) {
                this.systemIP = IbmDiskStorageHelper.replace(this.systemIP, ",", " ");
            }
            if (this.rptName == null) {
                this.rptName = "";
            }
            if (this.smCLILoc == null) {
                this.smCLILoc = "";
            } else {
                this.smCLILoc = this.smCLILoc.trim();
                this.smCLILoc = IbmDiskStorageHelper.replace(this.smCLILoc, "\\", "\\\\");
            }
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper]=======IBM SAN SMCli User Input params============");
                System.out.println("[IbmDiskStorageHelper] Storage System IP is ==> " + this.systemIP);
                System.out.println("[IbmDiskStorageHelper] SMCli Location is ==>" + this.smCLILoc);
                System.out.println("[IbmDiskStorageHelper] Timeout value in Seconds ==>" + this.timeout);
                System.out.println("[IbmDiskStorageHelper] Debug ==>" + this.debug);
                System.out.println();
            }
            this.sys_OS = System.getProperty("os.name");
            if (this.sys_OS == null) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.constructor", "Operating System Name not Found");
                return;
            }
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append("SMcli ");
            ((StringBuffer)charSequence).append(this.systemIP + " -c ");
            ((StringBuffer)charSequence).append("\"show storagesubsystem profile;\"");
            this.tmpCmd = ((StringBuffer)charSequence).toString();
            boolean bl = this.createBatchFile(this.tmpCmd);
            if (!bl) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.execCommand", "Batch File not created");
                return;
            }
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper] Batch File created successfully");
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception in the IBMDiskStorageHelper class constructor for target ", this.rptName, " Exception: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public Hashtable getMeasures() {
        ArrayList<String> arrayList;
        String string = "";
        this.all_values = new Hashtable();
        ArrayList arrayList2 = new ArrayList();
        HitachiUSPThread hitachiUSPThread = null;
        try {
            this.processName = this.tmpCmd;
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper] Process Name is ==>" + this.processName);
            }
            string = EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".bat";
            if (this.sys_OS.indexOf("UNIX") >= 0 || this.sys_OS.indexOf("LINUX") >= 0 || this.sys_OS.indexOf("SOLARIS") >= 0 || this.sys_OS.indexOf("SUNOS") >= 0) {
                boolean bl = true;
                string = EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".sh";
                hitachiUSPThread = new HitachiUSPThread(string, this.timeout, this.processName, this.sys_OS, bl);
            } else {
                hitachiUSPThread = this.debug ? new HitachiUSPThread(string, this.timeout, this.processName, this.debug) : new HitachiUSPThread(string, this.timeout, this.processName);
            }
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper].getMeasures() ===> Going to invoke the Execution Thread " + new Date());
            }
            hitachiUSPThread.t.start();
            hitachiUSPThread.t.join();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "IbmDiskStorageHelper.execCommand", exception.toString());
            return null;
        }
        ArrayList arrayList3 = null;
        if (hitachiUSPThread.done) {
            arrayList3 = hitachiUSPThread.output;
        }
        if (arrayList3 == null) {
            System.out.println("[IbmDiskStorageHelper].getMeasures command wrong or Command Execution Hangs & Output is null");
            this.logToErrorFile("Error", "IbmDiskStorageHelper.getMeasures", "command wrong or Command Execution Hangs & Output is null");
            return null;
        }
        if (arrayList3 != null && arrayList3.size() > 1 && (arrayList = (ArrayList<String>)arrayList3.get(1)) != null && arrayList.size() > 0) {
            if (final_measures.containsKey(this.reportingName)) {
                final_measures.remove(this.reportingName);
            }
            this.logToErrorFile("Error", "IbmDiskStorageHelper.execCommand", "Command Execution error" + arrayList);
            return null;
        }
        arrayList2 = (ArrayList)arrayList3.get(0);
        if (arrayList2 == null) {
            this.logToErrorFile("Error", "IbmDiskStorageHelper.getMeasures", "Measures File not available in Directory " + this.rptName);
            return null;
        }
        arrayList = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string2 = (String)arrayList2.get(i);
            if (string2 == null || string2.length() == 0) continue;
            if ((string2 = string2.toUpperCase().trim()).startsWith("SUMMARY---") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES---") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES--")) {
                bl7 = false;
                bl2 = false;
                bl = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                continue;
            }
            if (string2.startsWith("CONTROLLERS---")) {
                bl = true;
                bl2 = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
                continue;
            }
            if (!(!bl || string2.startsWith("SUMMARY---") || string2.startsWith("ARRAYS---") || string2.startsWith("STANDARD LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVES---") || string2.startsWith("DRIVE CHANNELS---") || string2.startsWith("ENCLOSURES---") || string2.startsWith("MAPPINGS"))) {
                arrayList.add(string2);
                continue;
            }
            if (string2.startsWith("ARRAYS---")) {
                bl2 = true;
                bl = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
                continue;
            }
            if (!(!bl2 || string2.startsWith("CONTROLLERS---") || string2.startsWith("SUMMARY---") || string2.startsWith("STANDARD LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVES---") || string2.startsWith("DRIVE CHANNELS---") || string2.startsWith("ENCLOSURES---") || string2.startsWith("MAPPINGS"))) {
                arrayList4.add(string2);
                continue;
            }
            if (string2.startsWith("STANDARD LOGICAL DRIVES--")) {
                bl3 = true;
                bl2 = false;
                bl = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
                continue;
            }
            if (!(!bl3 || string2.startsWith("CONTROLLERS---") || string2.startsWith("SUMMARY---") || string2.startsWith("ARRAYS---") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVES---") || string2.startsWith("DRIVE CHANNELS---") || string2.startsWith("ENCLOSURES---") || string2.startsWith("MAPPINGS"))) {
                arrayList5.add(string2);
                continue;
            }
            if (string2.startsWith("DRIVES---")) {
                bl4 = true;
                bl2 = false;
                bl = false;
                bl3 = false;
                bl5 = false;
                bl6 = false;
                bl7 = false;
                continue;
            }
            if (!(!bl4 || string2.startsWith("CONTROLLERS---") || string2.startsWith("SUMMARY---") || string2.startsWith("ARRAYS---") || string2.startsWith("STANDARD LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVE CHANNELS---") || string2.startsWith("ENCLOSURES---") || string2.startsWith("MAPPINGS"))) {
                arrayList6.add(string2);
                continue;
            }
            if (string2.startsWith("DRIVE CHANNELS---")) {
                bl5 = true;
                bl2 = false;
                bl = false;
                bl3 = false;
                bl4 = false;
                bl6 = false;
                bl7 = false;
                continue;
            }
            if (!(!bl5 || string2.startsWith("CONTROLLERS---") || string2.startsWith("SUMMARY---") || string2.startsWith("ARRAYS---") || string2.startsWith("STANDARD LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVES---") || string2.startsWith("ENCLOSURES---") || string2.startsWith("MAPPINGS"))) {
                arrayList7.add(string2);
                continue;
            }
            if (string2.startsWith("ENCLOSURES----")) {
                bl6 = true;
                bl2 = false;
                bl = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl7 = false;
                continue;
            }
            if (!(!bl6 || string2.startsWith("CONTROLLERS---") || string2.startsWith("SUMMARY---") || string2.startsWith("ARRAYS---") || string2.startsWith("STANDARD LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVES---") || string2.startsWith("DRIVE CHANNELS---") || string2.startsWith("MAPPINGS"))) {
                arrayList8.add(string2);
                continue;
            }
            if (string2.startsWith("MAPPINGS")) {
                bl7 = true;
                bl2 = false;
                bl = false;
                bl3 = false;
                bl4 = false;
                bl5 = false;
                bl6 = false;
                continue;
            }
            if (!bl7 || string2.startsWith("CONTROLLERS---") || string2.startsWith("SUMMARY---") || string2.startsWith("ARRAYS---") || string2.startsWith("STANDARD LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT REPOSITORY LOGICAL DRIVES--") || string2.startsWith("SNAPSHOT LOGICAL DRIVES---") || string2.startsWith("COPIES---") || string2.startsWith("MISSING LOGICAL DRIVES---") || string2.startsWith("DRIVES---") || string2.startsWith("DRIVE CHANNELS---") || string2.startsWith("ENCLOSURES---")) continue;
            arrayList9.add(string2);
        }
        if (this.debug) {
            try {
                System.out.println("*****************Collected Measures Size**************");
                System.out.println("CONTROLLER ==>" + arrayList.size());
                System.out.println("ARRAY ==>" + arrayList4.size());
                System.out.println("LOGICAL DRIVES ==>" + arrayList5.size());
                System.out.println("DRIVES ==>" + arrayList6.size());
                System.out.println("DRIVE CHANNELS ==>" + arrayList7.size());
                System.out.println("ENCLOSURE ==>" + arrayList8.size());
                System.out.println("MAPPING ==>" + arrayList9.size());
                System.out.println("******************************************************");
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getMeasures", exception.toString());
            }
        }
        if (arrayList != null) {
            this.all_values.put("CNTL", arrayList);
        }
        if (arrayList4 != null) {
            this.all_values.put("ARR", arrayList4);
        }
        if (arrayList5 != null) {
            this.all_values.put("LOGDRIV", arrayList5);
        }
        if (arrayList6 != null) {
            this.all_values.put("DRIVE", arrayList6);
        }
        if (arrayList7 != null) {
            this.all_values.put("DRIVECHANN", arrayList7);
        }
        if (arrayList8 != null) {
            this.all_values.put("ENCL", arrayList8);
        }
        if (arrayList9 != null) {
            this.all_values.put("MAPP", arrayList9);
        }
        return this.all_values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setData() {
        boolean bl = false;
        String string = syncString;
        synchronized (string) {
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper].setData() STARTS ===> SanBox ===> " + this.rptName);
            }
            Long l = null;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            try {
                l4 = System.currentTimeMillis();
                if (this.debug) {
                    System.out.println("[IbmDiskStorageHelper] ===> Current Time in Millis--->" + l4);
                }
                if ((l = (Long)ht_lastTime.get(this.rptName)) != null) {
                    l2 = l;
                    l3 = l4 - l2;
                    if (this.debug) {
                        System.out.println("[IbmDiskStorageHelper] ===> Differential Timing--->" + l3);
                    }
                } else if (l == null) {
                    l3 = l4;
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.setData", "Last measure time taken not available " + exception.toString());
                return;
            }
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper] ===> Measure Period value ===> " + this.measurePeriod);
            }
            if ((double)l3 >= 0.9 * (double)this.measurePeriod) {
                bl = false;
                l2 = l4;
                try {
                    ht_lastTime.put(this.rptName, new Long(l2));
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error", "IbmDiskStorageHelper.setData", "Last measure time taken not available " + exception.toString());
                    return;
                }
            } else {
                bl = true;
            }
            if (!bl) {
                try {
                    if (this.debug) {
                        System.out.println("------------------invoke getMeasures()------------------");
                    }
                    Hashtable hashtable = this.getMeasures();
                    if (this.debug) {
                        System.out.println("-----------invoke getMeasures() completed-----------------------");
                    }
                    if (hashtable != null) {
                        final_measures.put(this.rptName, hashtable);
                    } else {
                        if (final_measures.containsKey(this.rptName)) {
                            final_measures.remove(this.rptName);
                        }
                        this.logToErrorFile("Error", "IbmDiskStorageHelper.setData", "Measures not available");
                    }
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error", "IbmDiskStorageHelper.setData", "Measures not found :" + exception.toString());
                }
            }
            if (this.debug) {
                System.out.println("[IbmDiskStorageHelper].setData() ENDS ===> SanBox ===> " + this.rptName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getControllerData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("CNTL");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getPortData", "Controller Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getArrayData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("ARR");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getArrayData", "Array Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getLdevData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("LOGDRIV");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getLdevData", "Ldev Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getDriveData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("DRIVE");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getDriveData", "Drive Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getDrChannData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("DRIVECHANN");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getDrChannData", "Drive Channel Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getEnclosureData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("ENCL");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getEnclosureData", "Enclosure Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getMappingData() {
        ArrayList arrayList = null;
        Hashtable hashtable = null;
        String string = syncString;
        synchronized (string) {
            try {
                hashtable = (Hashtable)final_measures.get(this.rptName);
                if (hashtable != null) {
                    arrayList = (ArrayList)hashtable.get("MAPP");
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error", "IbmDiskStorageHelper.getMappingData", "Mapping Information not found :" + exception.toString());
                return null;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createBatchFile(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        File file = null;
        PrintWriter printWriter = null;
        String string2 = "";
        try {
            if (this.sys_OS.indexOf("UNIX") >= 0 || this.sys_OS.indexOf("LINUX") >= 0 || this.sys_OS.indexOf("SOLARIS") >= 0 || this.sys_OS.indexOf("SUNOS") >= 0) {
                ArrayList arrayList;
                printWriter = new PrintWriter(new FileWriter(EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".sh"));
                printWriter.println("\n#!/bin/sh");
                printWriter.println("cd " + this.smCLILoc);
                printWriter.println(string);
                ArrayList arrayList2 = null;
                string2 = "chmod 777 " + EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".sh\"";
                arrayList2 = this.egu.getExecOutputLines(string2);
                if (arrayList2 != null && (arrayList = (ArrayList)arrayList2.get(1)) != null && arrayList.size() > 0) {
                    this.logToErrorFile("Error", "IbmDiskStorageHelper.execCommand", "Shell Script File permission error " + arrayList);
                    boolean bl2 = false;
                    return bl2;
                }
                file = new File(EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".sh");
                if (file.exists()) {
                    bl = true;
                }
            } else {
                printWriter = new PrintWriter(new FileWriter(EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".bat"));
                printWriter.println("cd /D " + this.smCLILoc);
                printWriter.println(string);
                file = new File(EgInstallInfo.getInstallDir() + "/lib/" + this.rptName + "DsHelp" + ".bat");
                if (file.exists()) {
                    bl = true;
                }
            }
            printWriter.close();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error", "IbmDiskStorageHelper.getMeasures", "Batch file creation problem " + exception.toString());
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
                return bl;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static final String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string.length();
        while ((n2 = string.lastIndexOf(string2, n2 - 1)) > -1) {
            stringBuffer.replace(n2, n2 + n, string3);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        IbmDiskStorageHelper ibmDiskStorageHelper = new IbmDiskStorageHelper(stringArray);
        ibmDiskStorageHelper.setData();
    }
}

