/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;

public class IplanetConfig {
    String serverRoot = null;
    InputStream in = null;
    Vector servers = null;
    ArrayList ips = null;
    ArrayList ports = null;
    ArrayList security = null;
    ArrayList finalList = new ArrayList();

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Usage: java IplanetConfig -serverRoot <server root directory> ");
            return;
        }
        if (!stringArray[0].equalsIgnoreCase("-serverRoot")) {
            System.out.println("Usage: java IplanetConfig -serverRoot <server root directory> ");
            return;
        }
        File file = new File(stringArray[1]);
        if (!file.exists()) {
            System.out.println(" Server root directory \"" + stringArray[1] + "\" does not exist Please Enter a valid directory ");
            return;
        }
        String string = stringArray[1];
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        String string2 = string + "config/server.xml";
        String string3 = string + "config/ssl.xml";
        IplanetConfig iplanetConfig = new IplanetConfig();
        iplanetConfig.serverRoot = string;
        File file2 = new File(string2);
        if (file2.exists()) {
            iplanetConfig.readConfigFile(string2);
            iplanetConfig.getConfigInfo();
        }
        if ((file2 = new File(string3)).exists()) {
            iplanetConfig.readConfigFile(string3);
            iplanetConfig.getConfigInfo();
        }
        iplanetConfig.writeData();
    }

    public void getConfigInfo() {
        int n;
        Object object;
        String string;
        if (this.servers == null || this.servers.size() <= 0) {
            System.out.println("No IpAddresses assigned for this server");
            return;
        }
        for (int i = 0; i < this.servers.size(); ++i) {
            string = (String)this.servers.get(i);
            string = string.toLowerCase();
            object = new StringTokenizer(string);
            n = ((StringTokenizer)object).countTokens();
            for (int j = 0; j < n; ++j) {
                StringTokenizer stringTokenizer;
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.startsWith("ip") || string2.startsWith("bindingip")) {
                    stringTokenizer = new StringTokenizer(string2, "\"");
                    stringTokenizer.nextToken();
                    this.ips.add(stringTokenizer.nextToken());
                }
                if (string2.startsWith("port")) {
                    stringTokenizer = new StringTokenizer(string2, "\"");
                    stringTokenizer.nextToken();
                    this.ports.add(stringTokenizer.nextToken());
                }
                if (!string2.startsWith("security")) continue;
                stringTokenizer = new StringTokenizer(string2, "\"");
                stringTokenizer.nextToken();
                this.security.add(stringTokenizer.nextToken());
            }
        }
        for (n = 0; n < this.ips.size(); ++n) {
            String string3 = (String)this.ips.get(n);
            string = (String)this.ports.get(n);
            object = (String)this.security.get(n);
            if (string3.equalsIgnoreCase("any") || string3.equalsIgnoreCase("inaddr_any") || string3.equals("0.0.0.0")) {
                string3 = "*";
            }
            string3 = (String)object + "#" + string3 + ":" + string;
            this.finalList.add(string3);
        }
    }

    void writeData() {
        String string = this.serverRoot + "logs/.egurkha_info";
        File file = new File(string);
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
        }
        catch (Exception exception) {
            System.out.println(" File : " + string + " cannot be created ");
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
        }
        catch (Exception exception) {
            System.out.println(string + " cannot be found");
        }
        for (int i = 0; i < this.finalList.size(); ++i) {
            String string2 = (String)this.finalList.get(i);
            try {
                bufferedWriter.write(string2, 0, string2.length());
                bufferedWriter.newLine();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            bufferedWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readConfigFile(String string) {
        this.servers = new Vector();
        this.ips = new ArrayList();
        this.ports = new ArrayList();
        this.security = new ArrayList();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!(string2 = string2.trim()).startsWith("<LS")) continue;
                this.servers.add(string2);
            }
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

