/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JEUSConfBase
extends GenericTest {
    private String responseString = null;
    private URL endpoint = null;
    protected String logMessage = "";
    protected static final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    protected static final SimpleDateFormat EG_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final int DEFAULT_MINUS_ONE = -1;
    protected static final String DEBUG_COMPUTE_MEASURES = "[debugComputeMeasures] :";
    private String username = this.getValueForParam("username");
    private String password = null;
    protected String server_name = null;
    protected String methodName = "[JEUSConfBase] : ";

    public JEUSConfBase(String[] stringArray) {
        super(stringArray);
        if (this.username == null || this.username.trim().length() == 0 || this.username.equalsIgnoreCase("NONE") || this.username.equalsIgnoreCase("null")) {
            this.username = "none";
        }
        this.password = this.getValueForParam("password");
        if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase("NONE") || this.password.equalsIgnoreCase("null")) {
            this.password = "none";
        }
        this.server_name = this.getValueForParam("server_name");
        if (this.server_name == null || this.server_name.trim().length() == 0 || this.server_name.equalsIgnoreCase("NONE") || this.server_name.equalsIgnoreCase("null")) {
            this.server_name = "none";
        }
        this.printOut(this.methodName + "Host " + this.targetHost);
        this.printOut(this.methodName + "username " + this.username);
        this.printOut(this.methodName + "server_port " + this.portNo);
        this.printOut(this.methodName + "server_name " + this.server_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeAPIRequest(String string) {
        this.methodName = "[executeAPIRequest] : ";
        String string2 = "[executeAPIRequest] ";
        this.printOut(string2 + "requestString " + string);
        HttpURLConnection httpURLConnection = null;
        try {
            try {
                this.endpoint = new URL("http://" + this.targetHost + ":" + this.portNo + "/jsonCommand/command.json");
                this.printOut(string2 + "Endpoint URL  :" + this.endpoint);
            }
            catch (MalformedURLException malformedURLException) {
                this.logMessage = string2 + "Error in endpoint URL   ";
                this.printOutStackTrace(this.logMessage, malformedURLException);
                this.logMessage = "";
                malformedURLException.printStackTrace();
                String string3 = "";
                if (httpURLConnection != null) {
                    try {
                        httpURLConnection.disconnect();
                        httpURLConnection = null;
                    }
                    catch (Exception exception) {
                        this.logMessage = string2 + "Error in closing connection ";
                        this.printOutStackTrace(this.logMessage, exception);
                        this.logMessage = "";
                        exception.printStackTrace();
                    }
                }
                return string3;
            }
            try {
                httpURLConnection = (HttpURLConnection)this.endpoint.openConnection();
                this.printOut(string2 + "Connection opened " + httpURLConnection);
            }
            catch (IOException iOException) {
                this.logMessage = string2 + "HttpsURLConnection  error  ";
                this.printOutStackTrace(this.logMessage, iOException);
                this.logMessage = "";
                iOException.printStackTrace();
                String string4 = "";
                if (httpURLConnection != null) {
                    try {
                        httpURLConnection.disconnect();
                        httpURLConnection = null;
                    }
                    catch (Exception exception) {
                        this.logMessage = string2 + "Error in closing connection ";
                        this.printOutStackTrace(this.logMessage, exception);
                        this.logMessage = "";
                        exception.printStackTrace();
                    }
                }
                return string4;
            }
            try {
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setDoOutput(true);
            }
            catch (ProtocolException protocolException) {
                this.logMessage = string2 + "Your HTTP connection does not support  GET  ";
                this.printOutStackTrace(this.logMessage, protocolException);
                this.logMessage = "";
                protocolException.printStackTrace();
                String string5 = "";
                if (httpURLConnection != null) {
                    try {
                        httpURLConnection.disconnect();
                        httpURLConnection = null;
                    }
                    catch (Exception exception) {
                        this.logMessage = string2 + "Error in closing connection ";
                        this.printOutStackTrace(this.logMessage, exception);
                        this.logMessage = "";
                        exception.printStackTrace();
                    }
                }
                return string5;
            }
            String string6 = this.username + ":" + this.password;
            byte[] byArray = Base64.encodeBase64((byte[])string6.getBytes());
            String string7 = new String(byArray);
            httpURLConnection.addRequestProperty("Accept", "application/json");
            httpURLConnection.setConnectTimeout(15000);
            httpURLConnection.setReadTimeout(60000);
            httpURLConnection.addRequestProperty("Authorization", "Basic " + string7);
            JeusConnectionThread jeusConnectionThread = new JeusConnectionThread(httpURLConnection, string);
            int n = 0;
            boolean bl = this.checkForTimeout(jeusConnectionThread);
            if (bl) {
                n = jeusConnectionThread.code;
                if (n != 200) {
                    this.logMessage = string2 + "Error in  REST URL connection .Response code :" + n;
                    this.putErrorMessageToLogfile(this.logMessage);
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                }
                this.responseString = jeusConnectionThread.responseString;
            }
            if (!bl || n != 200) {
                this.logMessage = string2 + "Timing out or invalid response code:" + n;
                this.putWarningMessageToLogfile(this.logMessage);
                this.printOut(this.logMessage);
                this.logMessage = "";
            }
            httpURLConnection.disconnect();
            httpURLConnection = null;
        }
        finally {
            if (httpURLConnection != null) {
                try {
                    httpURLConnection.disconnect();
                    httpURLConnection = null;
                }
                catch (Exception exception) {
                    this.logMessage = string2 + "Error in closing connection ";
                    this.printOutStackTrace(this.logMessage, exception);
                    this.logMessage = "";
                    exception.printStackTrace();
                }
            }
        }
        return this.responseString;
    }

    protected String decodeResponse(InputStream inputStream) throws IOException {
        this.methodName = "[decodeResponse] : ";
        Scanner scanner = new Scanner(inputStream);
        scanner.useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + EG_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + exception.toString());
        this.putErrorMessageToLogfile(string2 + string3);
    }

    private boolean checkForTimeout(JeusConnectionThread jeusConnectionThread) {
        long l;
        String string = "[checkForTimeout] :";
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (jeusConnectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                this.logMessage = string + "Timed out and hence going to kill the thread :" + System.currentTimeMillis();
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                jeusConnectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.logMessage = string + "Timed out and killed the thread :" + System.currentTimeMillis();
                this.printOut(this.logMessage);
                this.putWarningMessageToLogfile(this.logMessage);
                this.logMessage = "";
                jeusConnectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        this.logMessage = string + "sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis();
        this.printOut(this.logMessage);
        this.putWarningMessageToLogfile(this.logMessage);
        this.logMessage = "";
        jeusConnectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        jeusConnectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    protected Hashtable getNodeMeasureData() {
        Hashtable<String, Hashtable> hashtable;
        String string;
        block5: {
            string = "[getNodeMeasureData] : ";
            String string2 = null;
            String string3 = null;
            hashtable = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{");
                stringBuffer.append("\"jeusadmin\": {");
                stringBuffer.append("\"command\": \"list-nodes\",");
                stringBuffer.append("\"argument\": null");
                stringBuffer.append("}");
                stringBuffer.append("}");
                string3 = stringBuffer.toString();
                string2 = this.executeAPIRequest(string3);
                this.printOut(string + "Request json string is  :" + string2);
                if (string2 != null && string2.trim().length() > 0) {
                    hashtable = new Hashtable<String, Hashtable>();
                    ArrayList arrayList = this.getNodeList(string2);
                    this.printOut(string + "nodeNameList returns  :" + arrayList);
                    if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
                        return null;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string4 = "" + arrayList.get(i);
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("{");
                        stringBuffer.append("\"jeusadmin\": {");
                        stringBuffer.append("\"command\": \"show-node\",");
                        stringBuffer.append("\"options\":[");
                        stringBuffer.append("\"" + string4 + "\"");
                        stringBuffer.append("],");
                        stringBuffer.append("\"argument\": null");
                        stringBuffer.append("}");
                        stringBuffer.append("}");
                        string3 = stringBuffer.toString();
                        string2 = this.executeAPIRequest(string3);
                        this.printOut(string + "Request json string is  :" + string2);
                        Hashtable hashtable2 = this.getNodeDataList(string2);
                        if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) continue;
                        this.printOut(string + "nodeDataHT returns  :" + hashtable2);
                        hashtable.put(string4, hashtable2);
                    }
                    break block5;
                }
                return null;
            }
            catch (Exception exception) {
                this.logMessage = string + "Exception raised ";
                this.printOutStackTrace(this.logMessage, exception);
                this.logMessage = "";
                exception.printStackTrace();
            }
        }
        this.printOut(string + "return finalNodeDataHT " + hashtable);
        return hashtable;
    }

    private ArrayList getNodeList(String string) {
        String string2 = "[getNodeList] : ";
        ArrayList<String> arrayList = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            block2: for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"column-names");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    String string3 = "" + jSONArray2.get(j);
                    if (!string3.equalsIgnoreCase("Node Name") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                    arrayList = new ArrayList<String>();
                    for (int k = 0; k < jSONArray2.size(); ++k) {
                        jSONObject = (JSONObject)jSONArray2.get(k);
                        JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                        if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                        String string4 = "" + jSONArray3.get(j);
                        arrayList.add(string4);
                    }
                    continue block2;
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return arrayList;
    }

    private Hashtable getNodeDataList(String string) {
        String string2 = "[getNodeDataList] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) {
                    return null;
                }
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) {
                        return null;
                    }
                    String string3 = "" + jSONArray3.get(0).toString().trim();
                    String string4 = "" + jSONArray3.get(1).toString().trim();
                    string4 = string4.length() == 0 ? "-" : string4;
                    hashtable.put(string3, string4);
                }
            }
            this.printOut(string2 + "Node name list " + hashtable);
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getSecurityMeasureData() {
        Hashtable<String, Hashtable> hashtable;
        String string;
        block7: {
            string = "[getSecurityMeasureData] : ";
            String string2 = null;
            String string3 = null;
            hashtable = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("{");
                stringBuffer.append("\"jeusadmin\": {");
                stringBuffer.append("\"command\": \"list-user-names\",");
                stringBuffer.append("\"argument\": null");
                stringBuffer.append("}");
                stringBuffer.append("}");
                string3 = stringBuffer.toString();
                string2 = this.executeAPIRequest(string3);
                this.printOut(string + "Request json string is  :" + string2);
                if (string2 != null && string2.trim().length() > 0) {
                    hashtable = new Hashtable<String, Hashtable>();
                    ArrayList arrayList = this.getUserList(string2);
                    this.printOut(string + "userNameList returns " + arrayList);
                    if (arrayList == null || arrayList.isEmpty() || arrayList.size() == 0) {
                        return null;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        String string4 = "" + arrayList.get(i);
                        stringBuffer = new StringBuffer();
                        stringBuffer.append("{");
                        stringBuffer.append("\"jeusadmin\": {");
                        stringBuffer.append("\"command\": \"show-user\",");
                        stringBuffer.append("\"options\":[");
                        stringBuffer.append("\"" + string4 + "\"");
                        stringBuffer.append("],");
                        stringBuffer.append("\"argument\": null");
                        stringBuffer.append("}");
                        stringBuffer.append("}");
                        string3 = stringBuffer.toString();
                        string2 = this.executeAPIRequest(string3);
                        this.printOut(string + "Request json string is  :" + string2);
                        if (string2 == null || string2.trim().length() == 0) {
                            return null;
                        }
                        Hashtable hashtable2 = this.getUserDataList(string2);
                        this.printOut(string + "securityDataHT returns " + hashtable2);
                        if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
                            return null;
                        }
                        hashtable.put(string4, hashtable2);
                    }
                    break block7;
                }
                return null;
            }
            catch (Exception exception) {
                this.logMessage = string + "Exception raised ";
                this.printOutStackTrace(this.logMessage, exception);
                this.logMessage = "";
                exception.printStackTrace();
            }
        }
        this.printOut(string + "finalDataHT returns " + hashtable);
        return hashtable;
    }

    private ArrayList getUserList(String string) {
        String string2 = "[getUserList] : ";
        ArrayList<String> arrayList = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) {
                    return null;
                }
                arrayList = new ArrayList<String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) {
                        return null;
                    }
                    String string3 = "" + jSONArray3.get(0);
                    arrayList.add(string3);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return arrayList;
    }

    private Hashtable getUserDataList(String string) {
        String string2 = "[getUserDataList] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            String string3 = "" + jSONObject.get((Object)"message");
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\r\n");
            hashtable = new Hashtable<String, String>();
            while (stringTokenizer.countTokens() > 0 && stringTokenizer.hasMoreTokens()) {
                String string4;
                String string5 = stringTokenizer.nextToken().trim();
                if (string5.startsWith("Description:")) {
                    string4 = string5.indexOf(":") > -1 ? string5.substring(string5.indexOf(":") + 1).trim() : "-";
                    hashtable.put("Description", string4);
                    continue;
                }
                if (string5.startsWith("Domain:")) {
                    string4 = string5.indexOf(":") > -1 ? string5.substring(string5.indexOf(":") + 1).trim() : "-";
                    hashtable.put("Domain", string4);
                    continue;
                }
                if (string5.startsWith("Main principal:")) {
                    string4 = string5.indexOf(":") > -1 ? string5.substring(string5.indexOf(":") + 1).trim() : "-";
                    hashtable.put("Main principal", string4);
                    continue;
                }
                if (string5.startsWith("Principals:")) {
                    string4 = string5.indexOf(":") > -1 ? string5.substring(string5.indexOf(":") + 1).trim() : "-";
                    hashtable.put("Principals", string4);
                    continue;
                }
                if (!string5.startsWith("Public credentials:")) continue;
                string4 = string5.indexOf(":") > -1 ? string5.substring(string5.indexOf(":") + 1).trim() : "-";
                hashtable.put("Public credentials", string4);
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getTransactionMeasureData() {
        String string = "[getTransactionMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-transaction-manager\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"" + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getTransactionData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "finalNodeDataHT returns " + hashtable);
        return hashtable;
    }

    private Hashtable getTransactionData(String string) {
        String string2 = "[getTransactionData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string3 = "" + jSONArray3.get(0);
                    String string4 = "" + jSONArray3.get(1);
                    if (string3.equalsIgnoreCase("Active Timeout")) {
                        hashtable.put("Active Timeout", string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Prepare Timeout")) {
                        hashtable.put("Prepare Timeout", string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Prepared Timeout")) {
                        hashtable.put("Prepared Timeout", string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Commit Timeout")) {
                        hashtable.put("Commit Timeout", string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Recovery Timeout")) {
                        hashtable.put("Recovery Timeout", string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Uncompleted Timeout")) {
                        hashtable.put("Uncompleted Timeout", string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("Tx Log Dir")) {
                        hashtable.put("Transaction Log Dir", string4);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("Automatic Recovery")) continue;
                    hashtable.put("Automatic Recovery", string4);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getEJBMeasureData() {
        String string = "[getEJBMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-active-management\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getEJBData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "finalEJBMeasureHT returns " + hashtable);
        return hashtable;
    }

    private Hashtable getEJBData(String string) {
        String string2 = "[getEJBData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string3 = "" + jSONArray3.get(0);
                    String string4 = "" + jSONArray3.get(1);
                    if (string3.equalsIgnoreCase("Max Blocked Thread")) {
                        hashtable.put("Max Blocked Thread", string4);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("Max Idle Time")) continue;
                    hashtable.put("Max Idle Time", string4);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getEngineMeasureData() {
        String string = "[getEngineMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-web-engine-configuration\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getEngineData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus Engine measure data returns " + hashtable);
        return hashtable;
    }

    private Hashtable getEngineData(String string) {
        String string2 = "[getEngineData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title");
                if (!string3.startsWith("JSP engine configuration for") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string4 = "" + jSONArray3.get(0).toString().trim();
                    String string5 = "" + jSONArray3.get(1).toString().trim();
                    String string6 = string5 = string5.trim().length() == 0 ? "-" : string5;
                    if (string4.equalsIgnoreCase("jsp-work-dir")) {
                        hashtable.put("jsp-work-dir", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("java-compiler")) {
                        hashtable.put("java-compiler", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("compile-output-dir")) {
                        hashtable.put("compile-output-dir", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("compile-option")) {
                        hashtable.put("compile-option", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("compile-encoding")) {
                        hashtable.put("compile-encoding", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("check-included-jspfile")) {
                        hashtable.put("check-included-jspfile", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("keep-generated")) {
                        hashtable.put("keep-generated", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("graceful-jsp-reloading")) {
                        hashtable.put("graceful-jsp-reloading", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("graceful-jsp-reloading-period")) {
                        hashtable.put("graceful-jsp-reloading-period", string5);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("use-in-memory-compilation")) continue;
                    hashtable.put("use-in-memory-compilation", string5);
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getHTTPMeasureData() {
        String string = "[getHTTPMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-web-engine-configuration\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getHTTPData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus http listener meaure data returns " + hashtable);
        return hashtable;
    }

    private Hashtable getHTTPData(String string) {
        String string2 = "[getHTTPData] : ";
        Hashtable<String, String> hashtable = null;
        Hashtable hashtable2 = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            hashtable2 = new Hashtable();
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title").toString().trim();
                if (!string3.startsWith("Http listener[http1] configuration for") && !string3.startsWith("Http listener[ADMIN-HTTP] configuration for") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                String string4 = "";
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string5 = "" + jSONArray3.get(0);
                    String string6 = "" + jSONArray3.get(1);
                    String string7 = string6 = string6.trim().length() == 0 || string6.trim().equalsIgnoreCase("null") ? "-" : string6;
                    if (string5.equalsIgnoreCase("name")) {
                        string4 = string6;
                        hashtable.put("name", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("server-listener-ref")) {
                        hashtable.put("server-listener-ref", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("max-keep-alive-request")) {
                        hashtable.put("max-keep-alive-request", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("server-access-control")) {
                        hashtable.put("server-access-control", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("allowed-server")) {
                        hashtable.put("allowed-server", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("connection-type")) {
                        hashtable.put("connection-type", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("output-buffer-size")) {
                        hashtable.put("output-buffer-size", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("postdata-read-timeout")) {
                        hashtable.put("postdata-read-timeout", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("max-post-size")) {
                        hashtable.put("max-post-size", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("max-parameter-count")) {
                        hashtable.put("max-parameter-count", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("max-header-count")) {
                        hashtable.put("max-header-count", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("max-header-size")) {
                        hashtable.put("max-header-size", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("max-querystring-size")) {
                        hashtable.put("max-querystring-size", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("threadpool.min")) {
                        hashtable.put("threadpool.min", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("threadpool.max")) {
                        hashtable.put("threadpool.max", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("threadpool.max-idle-time")) {
                        hashtable.put("threadpool.max-idle-time", string6);
                        continue;
                    }
                    if (string5.equalsIgnoreCase("threadpool.max-queue")) {
                        hashtable.put("threadpool.max-queue", string6);
                        continue;
                    }
                    if (!string5.equalsIgnoreCase("threadpool.thread-state-notify")) continue;
                    hashtable.put("threadpool.thread-state-notify", string6);
                }
                if (hashtable != null && !hashtable.isEmpty() && hashtable.size() > 0) {
                    hashtable2.put(string4, hashtable);
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable2;
    }

    protected Hashtable getLogAccessMeasureData() {
        String string = "[getLogAccessMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-web-engine-configuration\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getLogAccessData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus LogAccess measure data returns " + hashtable);
        return hashtable;
    }

    private Hashtable getLogAccessData(String string) {
        String string2 = "[getLogAccessData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title");
                if (!string3.startsWith("Access-log configuration for") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string4 = "" + jSONArray3.get(0);
                    String string5 = "" + jSONArray3.get(1);
                    if (string4.equalsIgnoreCase("enable")) {
                        hashtable.put("enable", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("format")) {
                        hashtable.put("format", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("use-parent-handlerst")) {
                        hashtable.put("use-parent-handlerst", string5);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("formatter-class")) continue;
                    hashtable.put("formatter-class", string5);
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getSessionMeasureData() {
        String string = "[getSessionMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-web-engine-configuration\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getSessionData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus session measure data return " + hashtable);
        return hashtable;
    }

    private Hashtable getSessionData(String string) {
        String string2 = "[getSessionData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title");
                if (!string3.startsWith("Session-config configuration for") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string4 = "" + jSONArray3.get(0);
                    String string5 = "" + jSONArray3.get(1);
                    String string6 = string5 = string5.trim().length() == 0 ? "-" : string5;
                    if (string4.equalsIgnoreCase("timeout")) {
                        hashtable.put("timeout", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("shared")) {
                        hashtable.put("shared", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("reload-persistent")) {
                        hashtable.put("reload-persistent", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("tracking-mode.cookie")) {
                        hashtable.put("tracking-mode.cookie", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("tracking-mode.url")) {
                        hashtable.put("tracking-mode.url", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("tracking-mode.ssl")) {
                        hashtable.put("tracking-mode.ssl", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.cookie-name")) {
                        hashtable.put("session-cookie.cookie-name", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.version")) {
                        hashtable.put("session-cookie.version", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.domain")) {
                        hashtable.put("session-cookie.domain", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.path")) {
                        hashtable.put("session-cookie.path", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.max-age")) {
                        hashtable.put("session-cookie.max-age", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.secure")) {
                        hashtable.put("session-cookie.secure", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("session-cookie.http-only")) {
                        hashtable.put("session-cookie.http-only", string5);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("session-cookie.comment")) continue;
                    hashtable.put("session-cookie.comment", string5);
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getThreadPoolMeasureData() {
        String string = "[getThreadPoolMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-system-thread-pool\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"" + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getThreadPoolData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus threadPool measure data returns " + hashtable);
        return hashtable;
    }

    private Hashtable getThreadPoolData(String string) {
        String string2 = "[getThreadPoolData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title");
                if (!string3.startsWith("the system thread pool of the server") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string4 = "" + jSONArray3.get(0).toString().trim();
                    String string5 = "" + jSONArray3.get(1).toString().trim();
                    String string6 = string5 = string5.trim().length() == 0 ? "-" : string5;
                    if (string4.equalsIgnoreCase("Min")) {
                        hashtable.put("Min", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Max")) {
                        hashtable.put("Max", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Keep-Alive Time")) {
                        hashtable.put("Keep-Alive Time", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Queue Size")) {
                        hashtable.put("Queue Size", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Max Stuck Thread Time")) {
                        hashtable.put("Max Stuck Thread Time", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Action On Stuck Thread")) {
                        hashtable.put("Action On Stuck Thread", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Stuck Thread Check Period")) {
                        hashtable.put("Stuck Thread Check Period", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Reserved Threads for the Service transaction")) {
                        hashtable.put("Reserved Threads for the Service transaction", string5);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("Reserved Threads for the Service namingserver")) continue;
                    hashtable.put("Reserved Threads for the Service namingserver", string5);
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected Hashtable getGroupCommMeasureData() {
        String string = "[getGroupCommMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"show-group-communication-info\",");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getGroupCommData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus group communication meaure data returns " + hashtable);
        return hashtable;
    }

    private Hashtable getGroupCommData(String string) {
        String string2 = "[getGroupCommData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title");
                if (!string3.startsWith("Group Communication Information") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                hashtable = new Hashtable<String, String>();
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string4 = "" + jSONArray3.get(0).toString().trim();
                    String string5 = "" + jSONArray3.get(1).toString().trim();
                    String string6 = string5 = string5.trim().length() == 0 ? "-" : string5;
                    if (string4.equalsIgnoreCase("Heartbeat Address")) {
                        hashtable.put("Heartbeat Address", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Heartbeat Port")) {
                        hashtable.put("Heartbeat Port", string5);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("Use Virtual-multicast")) continue;
                    hashtable.put("Use Virtual-multicast", string5);
                }
                break;
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected ArrayList getJNDIMeasureData() {
        String string = "[getJNDIMeasureData] : ";
        String string2 = null;
        String string3 = null;
        ArrayList arrayList = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"jndi-info\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            arrayList = this.getJNDIData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus jndi measure data returns " + arrayList);
        return arrayList;
    }

    private ArrayList getJNDIData(String string) {
        String string2 = "[getJNDIData] : ";
        ArrayList arrayList = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string3 = "" + jSONArray3.get(0).toString().trim();
                    String string4 = "" + jSONArray3.get(1).toString().trim();
                    String string5 = "" + jSONArray3.get(1).toString().trim();
                    arrayList2.add(string3);
                    arrayList2.add(string4);
                    arrayList2.add(string5);
                    arrayList.add(arrayList2);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return arrayList;
    }

    protected ArrayList getLoggerMeasureData() {
        String string = "[getLoggerMeasureData] : ";
        String string2 = null;
        String string3 = null;
        ArrayList arrayList = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"list-loggers\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"" + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            arrayList = this.getLoggerData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus logger measure data returns " + arrayList);
        return arrayList;
    }

    private ArrayList getLoggerData(String string) {
        String string2 = "[getLoggerData] : ";
        ArrayList arrayList = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.size() == 0) continue;
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string3 = "" + jSONArray3.get(0).toString().trim();
                    String string4 = "" + jSONArray3.get(1).toString().trim();
                    String string5 = "" + jSONArray3.get(2).toString().trim();
                    String string6 = "" + jSONArray3.get(4).toString().trim();
                    arrayList2.add(string3);
                    arrayList2.add(string4);
                    arrayList2.add(string5);
                    arrayList2.add(string6);
                    arrayList.add(arrayList2);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return arrayList;
    }

    protected ArrayList getServerMeasureData() {
        String string = "[getServerMeasureData] : ";
        String string2 = null;
        String string3 = null;
        ArrayList arrayList = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"server-info\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"-server " + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            arrayList = this.getServerData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus server status measure data returns " + arrayList);
        return arrayList;
    }

    private ArrayList getServerData(String string) {
        String string2 = "[getServerData] : ";
        ArrayList arrayList = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string3 = "" + jSONArray3.get(0).toString().trim();
                    String string4 = "" + jSONArray3.get(1).toString().trim();
                    String string5 = "" + jSONArray3.get(2).toString().trim();
                    String string6 = "" + jSONArray3.get(3).toString().trim();
                    String string7 = "" + jSONArray3.get(4).toString().trim();
                    String string8 = "" + jSONArray3.get(5).toString().trim();
                    String string9 = "" + jSONArray3.get(6).toString().trim();
                    String string10 = "" + jSONArray3.get(7).toString().trim();
                    string10 = string10.indexOf("\n") > 0 ? string10.replace("\n", " ") : string10;
                    String string11 = "" + jSONArray3.get(8).toString().trim();
                    string4 = string4.indexOf("(") > 0 ? string4.substring(0, string4.indexOf("(")).trim() : string4;
                    arrayList2.add(string3);
                    arrayList2.add(string4);
                    arrayList2.add(string5);
                    arrayList2.add(string6);
                    arrayList2.add(string7);
                    arrayList2.add(string8);
                    arrayList2.add(string9);
                    arrayList2.add(string10);
                    arrayList2.add(string11);
                    arrayList.add(arrayList2);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return arrayList;
    }

    protected Hashtable getJVMInfoMeasureData() {
        String string = "[getJVMInfoMeasureData] : ";
        String string2 = null;
        String string3 = null;
        Hashtable hashtable = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"system-info\",");
            stringBuffer.append("\"options\":[");
            stringBuffer.append("\"" + this.server_name + "\"");
            stringBuffer.append("],");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            hashtable = new Hashtable();
            hashtable = this.getJVMInfoData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "Jeus JVM measure data returns " + hashtable);
        return hashtable;
    }

    private Hashtable getJVMInfoData(String string) {
        String string2 = "[getEngineData] : ";
        Hashtable<String, String> hashtable = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            hashtable = new Hashtable<String, String>();
            for (int i = 0; i < jSONArray.size(); ++i) {
                JSONArray jSONArray2;
                jSONObject = (JSONObject)jSONArray.get(i);
                String string3 = "" + jSONObject.get((Object)"title");
                if (!string3.startsWith("JEUS JVM Information") || (jSONArray2 = (JSONArray)jSONObject.get((Object)"rows")) == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    ArrayList arrayList = new ArrayList();
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string4 = "" + jSONArray3.get(0).toString().trim();
                    String string5 = "" + jSONArray3.get(1).toString().trim();
                    String string6 = string5 = string5.length() == 0 ? "-" : string5;
                    if (string4.equalsIgnoreCase("JEUS Version")) {
                        hashtable.put("JEUS Version", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Patch Information")) {
                        hashtable.put("Patch Information", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("License Information")) {
                        hashtable.put("License Information", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("License Due")) {
                        hashtable.put("License Due", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("OS Name")) {
                        hashtable.put("OS Name", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("OS Version")) {
                        hashtable.put("OS Version", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Java Vendor")) {
                        hashtable.put("Java Vendor", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Java Spec Version")) {
                        hashtable.put("Java Spec Version", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Java Version")) {
                        hashtable.put("Java Version", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Vm Version")) {
                        hashtable.put("Vm Version", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Classpath")) {
                        hashtable.put("Classpath", string5);
                        continue;
                    }
                    if (string4.equalsIgnoreCase("Booting Arguments")) {
                        hashtable.put("Booting Arguments", string5);
                        continue;
                    }
                    if (!string4.equalsIgnoreCase("System Properties")) continue;
                    hashtable.put("System Properties", string5);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return hashtable;
    }

    protected ArrayList getAppMeasureData() {
        String string = "[getAppMeasureData] : ";
        String string2 = null;
        String string3 = null;
        ArrayList arrayList = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append("\"jeusadmin\": {");
            stringBuffer.append("\"command\": \"application-info\",");
            stringBuffer.append("\"argument\": null");
            stringBuffer.append("}");
            stringBuffer.append("}");
            string3 = stringBuffer.toString();
            string2 = this.executeAPIRequest(string3);
            this.printOut(string + "Request json string is  :" + string2);
            if (string2 == null || string2.trim().length() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            arrayList = this.getAppData(string2);
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        this.printOut(string + "jeus app measure data returns " + arrayList);
        return arrayList;
    }

    private ArrayList getAppData(String string) {
        String string2 = "[getAppData] : ";
        ArrayList arrayList = null;
        try {
            JSONParser jSONParser = new JSONParser();
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
            jSONObject = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
            jSONArray = (JSONArray)jSONObject.get((Object)"data");
            if (jSONArray == null || jSONArray.isEmpty() || jSONArray.size() == 0) {
                return null;
            }
            arrayList = new ArrayList();
            for (int i = 0; i < jSONArray.size(); ++i) {
                jSONObject = (JSONObject)jSONArray.get(i);
                JSONArray jSONArray2 = (JSONArray)jSONObject.get((Object)"rows");
                if (jSONArray2 == null || jSONArray2.isEmpty() || jSONArray2.size() == 0) continue;
                for (int j = 0; j < jSONArray2.size(); ++j) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    jSONObject = (JSONObject)jSONArray2.get(j);
                    JSONArray jSONArray3 = (JSONArray)jSONObject.get((Object)"values");
                    if (jSONArray3 == null || jSONArray3.isEmpty() || jSONArray3.size() == 0) continue;
                    String string3 = "" + jSONArray3.get(0).toString().trim();
                    String string4 = "" + jSONArray3.get(1).toString().trim();
                    String string5 = "" + jSONArray3.get(2).toString().trim();
                    String string6 = "" + jSONArray3.get(3).toString().trim();
                    String string7 = "" + jSONArray3.get(4).toString().trim();
                    String string8 = "" + jSONArray3.get(5).toString().trim();
                    string3 = string3.length() == 0 ? "-" : string3;
                    string4 = string4.length() == 0 ? "-" : string4;
                    string5 = string5.length() == 0 ? "-" : string5;
                    string6 = string6.length() == 0 ? "-" : string6;
                    string7 = string7.length() == 0 ? "-" : string7;
                    string8 = string8.length() == 0 ? "-" : string8;
                    arrayList2.add(string3);
                    arrayList2.add(string4);
                    arrayList2.add(string5);
                    arrayList2.add(string6);
                    arrayList2.add(string7);
                    arrayList2.add(string8);
                    arrayList.add(arrayList2);
                }
            }
        }
        catch (Exception exception) {
            this.logMessage = string2 + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
        }
        return arrayList;
    }

    class JeusConnectionThread
    extends Thread {
        private HttpURLConnection connection;
        private byte[] encodedRequest = null;
        public String responseString = null;
        public boolean done = false;
        public int code = 0;
        String methodName = "[run ] :";

        public JeusConnectionThread(HttpURLConnection httpURLConnection, String string) {
            this.connection = httpURLConnection;
            this.encodedRequest = string.getBytes();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OutputStream outputStream = null;
            try {
                outputStream = this.connection.getOutputStream();
                outputStream.write(this.encodedRequest);
                outputStream.flush();
            }
            catch (IOException iOException) {
                JEUSConfBase.this.logMessage = this.methodName + "Exception raised in getoutputStream ";
                JEUSConfBase.this.printOutStackTrace(JEUSConfBase.this.logMessage, iOException);
                JEUSConfBase.this.logMessage = "";
                iOException.printStackTrace();
            }
            try {
                JEUSConfBase.this.logMessage = this.methodName + "Response code :" + this.connection.getResponseCode();
                JEUSConfBase.this.printOut(JEUSConfBase.this.logMessage);
                JEUSConfBase.this.putInfoMessageToLogfile(JEUSConfBase.this.logMessage);
                JEUSConfBase.this.logMessage = "";
            }
            catch (IOException iOException) {
                JEUSConfBase.this.logMessage = this.methodName + "IOException raised  while collecting the response code";
                JEUSConfBase.this.printOutStackTrace(JEUSConfBase.this.logMessage, iOException);
                JEUSConfBase.this.logMessage = "";
                iOException.printStackTrace();
            }
            InputStream inputStream = null;
            try {
                this.code = this.connection.getResponseCode();
                inputStream = this.code == 200 ? this.connection.getInputStream() : this.connection.getErrorStream();
            }
            catch (IOException iOException) {
                JEUSConfBase.this.logMessage = this.methodName + "Exception raised in getResponseCode ";
                JEUSConfBase.this.printOutStackTrace(JEUSConfBase.this.logMessage, iOException);
                JEUSConfBase.this.logMessage = "";
                iOException.printStackTrace();
            }
            try {
                this.responseString = JEUSConfBase.this.decodeResponse(inputStream);
            }
            catch (IOException iOException) {
                JEUSConfBase.this.logMessage = this.methodName + "Exception raised while  decode the response ";
                JEUSConfBase.this.printOutStackTrace(JEUSConfBase.this.logMessage, iOException);
                JEUSConfBase.this.logMessage = "";
                iOException.printStackTrace();
            }
            finally {
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        JEUSConfBase.this.logMessage = this.methodName + "Exception raised while closing the  response ";
                        JEUSConfBase.this.printOutStackTrace(JEUSConfBase.this.logMessage, iOException);
                        JEUSConfBase.this.logMessage = "";
                        iOException.printStackTrace();
                    }
                }
            }
            this.done = true;
        }
    }
}

