/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSEgGenericTest
extends GenericTest {
    private static final String WEBLOGIC_INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String WEBSPHERE_MQ_FILE_BASED_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.fscontext.RefFSContextFactory";
    private static final String WEBSPHERE_MQ_LDAP_BASED_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String WEBSPHERE_WAS_INITIAL_CONTEXT_FACTORY = "com.ibm.websphere.naming.WsnInitialContextFactory";
    private static final String JBOSS_INITIAL_CONTEXT_FACTORY = "org.jboss.naming.remote.client.InitialContextFactory";
    private static final int JMS_MEASURE_COUNT = 2;
    private static InitialContext INITIAL_CONTEXT = null;
    private boolean isFirstTime = true;
    private String initialContextFactory = null;
    private Connection connection;
    private Session session;
    protected String providerURL = null;
    protected String connectionFactory = null;
    protected String destinationName = null;
    protected int topNMessages = 5;
    protected boolean showJMSMessageInDD = true;
    protected String userName = "";
    protected String password = "";
    protected String jmsPortNo = null;
    protected String mqServer = null;
    protected boolean isWMQLDAP = false;
    protected String user_DN = null;
    protected String user_DN_Password = null;
    protected boolean isSSL = false;
    private static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    public static String[] pad = new String[]{"", "0", "00", "000", "0000"};
    private String errorMessage = "";
    private String infoMessage = "";
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    public ArrayList mqJMSDDArrayList = new ArrayList();
    private boolean validParams = true;
    public static int providerStatus = -1;
    public static String tlsVersion = "SSLv3,TLSv1,TLSv1.1,TLSv1.2";
    public static String keyMgrFactory = "IbmX509";
    public static String securityProvider = "com.ibm.jsse2.IBMJSSEProvider2";
    public static String protocolHandler = "com.ibm.net.ssl.www2.protocol";
    boolean isSSLFirstTime = true;
    static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSEgGenericTest(String[] stringArray) {
        super(stringArray);
        String string;
        String string2;
        String string3;
        this.setMeasureCount(2);
        String string4 = this.getValueForParam("jms_Port");
        this.jmsPortNo = string4 == null || string4.trim().length() == 0 ? this.portNo : string4;
        this.mqServer = this.getValueForParam("application_Server");
        if (this.mqServer != null && this.mqServer.trim().length() > 0 && (this.mqServer.equalsIgnoreCase("WebSphereMQ") || this.mqServer.equalsIgnoreCase("WebLogic") || this.mqServer.equalsIgnoreCase("WebSphereAS") || this.mqServer.equalsIgnoreCase("JBoss7") || this.mqServer.equalsIgnoreCase("JBossWildFly"))) {
            if (this.mqServer.equalsIgnoreCase("WebSphereMQ")) {
                string3 = this.getValueForParam("jndi_Namespace_Location");
                if (string3 == null || string3.trim().length() == 0 || string3.equalsIgnoreCase("FILE")) {
                    this.initialContextFactory = WEBSPHERE_MQ_FILE_BASED_INITIAL_CONTEXT_FACTORY;
                    this.isWMQLDAP = false;
                    this.providerURL = this.getValueForParam("provider_URL");
                    if (this.providerURL == null || this.providerURL.trim().length() == 0) {
                        this.errorMessage = "Please provide the  providerURL for File ";
                        this.printOut(this.errorMessage);
                        this.putErrorMessageToLogfile(this.errorMessage);
                        this.validParams = false;
                    }
                } else {
                    this.initialContextFactory = WEBSPHERE_MQ_LDAP_BASED_INITIAL_CONTEXT_FACTORY;
                    this.isWMQLDAP = true;
                    this.printOut("Is IBM WMQ monitored throw LDAP ? :" + this.isWMQLDAP);
                    this.providerURL = this.getValueForParam("provider_URL");
                    if (this.providerURL == null || this.providerURL.trim().length() == 0) {
                        this.errorMessage = "Please provide the  providerURL for LDAP ";
                        this.printOut(this.errorMessage);
                        this.putErrorMessageToLogfile(this.errorMessage);
                        this.validParams = false;
                    }
                    this.user_DN = this.getValueForParam("user_DN");
                    this.user_DN_Password = this.getValueForParam("user_DN_Password");
                    string2 = this.getValueForParam("ssl");
                    if (this.user_DN == null || this.user_DN.trim().length() == 0 || this.user_DN.equalsIgnoreCase("NONE")) {
                        this.validParams = false;
                        this.errorMessage = " Please provide a valid User DN";
                        this.printOut(this.errorMessage);
                        this.putErrorMessageToLogfile(this.errorMessage);
                    }
                    if (this.user_DN_Password == null || this.user_DN_Password.trim().length() == 0 || this.user_DN_Password.equalsIgnoreCase("NONE")) {
                        this.validParams = false;
                        this.errorMessage = " Please provide a valid password";
                        this.printOut(this.errorMessage);
                        this.putErrorMessageToLogfile(this.errorMessage);
                    }
                    this.isSSL = string2 != null && string2.trim().length() != 0 && !string2.equalsIgnoreCase("FALSE");
                    this.printOut("WebSphereMQ user_DN   :" + this.user_DN);
                    string = EgCrypt.encrypt(this.user_DN_Password);
                    this.printOut("WebSphereMQ user_DN_Password(encrypted)  :" + string);
                    this.printOut("WebSphereMQ isSSL  :" + this.isSSL);
                }
            } else if (this.mqServer.equalsIgnoreCase("WebLogic")) {
                this.initialContextFactory = WEBLOGIC_INITIAL_CONTEXT_FACTORY;
                this.providerURL = "t3://" + this.targetHost + ":" + this.jmsPortNo;
            } else if (this.mqServer.equalsIgnoreCase("WebSphereAS")) {
                this.initialContextFactory = WEBSPHERE_WAS_INITIAL_CONTEXT_FACTORY;
                this.providerURL = "iiop://" + this.targetHost + ":" + this.jmsPortNo;
            } else if (this.mqServer.equalsIgnoreCase("JBoss7")) {
                this.initialContextFactory = JBOSS_INITIAL_CONTEXT_FACTORY;
                this.providerURL = "remote://" + this.targetHost + ":" + this.jmsPortNo;
            } else if (this.mqServer.equalsIgnoreCase("JBossWildFly")) {
                this.initialContextFactory = JBOSS_INITIAL_CONTEXT_FACTORY;
                this.providerURL = "http-remoting://" + this.targetHost + ":" + this.jmsPortNo;
            }
            this.printOut("Monitored application server :" + this.mqServer);
        } else {
            this.validParams = false;
            this.errorMessage = "Please provide the application server vendor(Example : WebSphereMQ or WebLogic or WebSphereAS or JBoss7 or JBossWildFly) ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
        }
        this.printOut("Provider URL  :" + this.providerURL);
        this.connectionFactory = this.getValueForParam("connection_Factory");
        if (this.connectionFactory == null || this.connectionFactory.trim().length() == 0) {
            this.errorMessage = "Please provide the  connection factory name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
            this.validParams = false;
        }
        this.printOut("Connection factory :" + this.connectionFactory);
        this.destinationName = this.getValueForParam("destination_Name");
        if (this.destinationName == null || this.destinationName.trim().length() == 0) {
            this.errorMessage = "Please provide the destination  name ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
            this.validParams = false;
        }
        this.printOut("Destination name :" + this.destinationName);
        string3 = this.getValueForParam("top_N_Messages");
        if (string3 == null || string3.trim().length() == 0 || string3.equalsIgnoreCase("default")) {
            this.topNMessages = 5;
        } else {
            try {
                this.topNMessages = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                this.topNMessages = 5;
            }
        }
        string2 = this.getValueForParam("show_JMS_Message_In_DD");
        this.showJMSMessageInDD = string2 == null || string2.trim().length() <= 0 || !string2.equalsIgnoreCase("No");
        this.userName = this.getValueForParam("user");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        this.printOut("User name :" + this.userName);
        this.password = this.getValueForParam("password");
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.infoMessage = "Reporting Name :" + this.reportingName;
        this.printOut(this.infoMessage);
        if (fieldSep.length() == 0) {
            string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(this.params, false);
    }

    public static void main(String[] stringArray) {
        JMSEgGenericTest jMSEgGenericTest = new JMSEgGenericTest(stringArray);
        int n = 0;
        while (n++ < 2) {
            jMSEgGenericTest.debugComputeMeasures(new Hashtable(), true);
            if (n >= 2) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        ArrayList<Double> arrayList;
        if (!this.validParams) {
            this.errorMessage = "Test returned due to required parameter(s) missing  ";
            this.printOut(this.errorMessage);
            this.putErrorMessageToLogfile(this.errorMessage);
            return;
        }
        this.isSSLFirstTime = false;
        if (this.mqServer.equalsIgnoreCase("WebSphereAS") && this.isSSLFirstTime) {
            try {
                if (securityProvider != null && securityProvider.length() > 0) {
                    Class<?> clazz = Class.forName(securityProvider);
                    Class[] classArray = new Class[]{};
                    arrayList = clazz.getConstructor(classArray);
                    Object[] objectArray = new Object[]{};
                    Object t = ((Constructor)((Object)arrayList)).newInstance(objectArray);
                    providerStatus = Security.addProvider((Provider)t);
                }
                if (protocolHandler != null && protocolHandler.length() > 0) {
                    System.setProperty("java.protocol.handler.pkgs", protocolHandler);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.isSSLFirstTime = false;
        }
        long l = System.currentTimeMillis();
        this.printOut("eG MQ JMS monitoring  started.", debug);
        arrayList = new ArrayList();
        int n = 0;
        int n2 = 0;
        this.connection = null;
        boolean bl2 = false;
        String string = "";
        try {
            int n3;
            InitialContext initialContext = this.getInitialContext();
            if (initialContext == null) {
                this.printOut("Context is null ,and not process the Queue monitoring ,Please check the IntialContext  ");
            }
            this.connection = this.getConnection(initialContext);
            this.session = this.connection.createSession(bl2, 1);
            this.connection.stop();
            this.connection.start();
            Queue queue = null;
            try {
                queue = this.isWMQLDAP ? (Queue)initialContext.lookup("cn=" + this.destinationName) : (Queue)initialContext.lookup(this.destinationName);
            }
            catch (NamingException namingException) {
                namingException.printStackTrace();
            }
            TimeZone timeZone = TimeZone.getDefault();
            this.printOut("TimeZone DisplayName  " + timeZone.getDisplayName(), debug);
            this.printOut("TimeZone ID  " + timeZone.getID(), debug);
            long l2 = timeZone.getOffset(l);
            this.printOut("TimeZone Offset  " + l2, debug);
            long l3 = 0L;
            if (bl) {
                this.timeSinceLastTest = 60.0;
            }
            this.printOut("timeSinceLastTest  :" + this.timeSinceLastTest);
            if (this.mqServer.equalsIgnoreCase("WebSphereMQ")) {
                if (this.timeSinceLastTest > 0.0) {
                    if (l2 > 0L) {
                        l3 = l - ((long)this.timeSinceLastTest * 1000L + l2);
                        this.printOut("Offset  is greater than zero :" + l2);
                    } else {
                        l3 = l + l2 - (long)this.timeSinceLastTest * 1000L;
                        this.printOut("Offset  is less than zero :" + l2);
                    }
                }
            } else if (this.timeSinceLastTest > 0.0) {
                l3 = l - (long)this.timeSinceLastTest * 1000L;
            }
            this.printOut("Current time in milli seconds :" + l);
            QueueBrowser queueBrowser = null;
            queueBrowser = this.session.createBrowser(queue);
            n = Collections.list(queueBrowser.getEnumeration()).size();
            this.printOut("Total messages in queue :" + n);
            String string2 = null;
            string2 = "JMSTimestamp > " + l3;
            queueBrowser = string2 == null ? this.session.createBrowser(queue) : this.session.createBrowser(queue, string2);
            this.printOut("Qname : " + queueBrowser.getQueue());
            this.printOut("Message selector :" + queueBrowser.getMessageSelector());
            Enumeration enumeration = queueBrowser.getEnumeration();
            ArrayList arrayList2 = Collections.list(enumeration);
            if (this.isFirstTime) {
                n2 = 0;
                this.printOut("Very first time sending recent message count as zero ,because agent restarted ");
                this.isFirstTime = false;
            } else {
                n2 = arrayList2.size();
            }
            ArrayList arrayList3 = null;
            if (arrayList2 != null && !arrayList2.isEmpty() && arrayList2.size() > 0) {
                int n4;
                arrayList3 = new ArrayList();
                this.printOut("Top " + this.topNMessages + " message details :");
                if (n2 >= this.topNMessages) {
                    n4 = n2 - 1;
                    for (n3 = 0; n3 < this.topNMessages; ++n3) {
                        arrayList3.add(arrayList2.get(n4));
                        --n4;
                    }
                } else {
                    this.printOut("recentMessagesCount is less than topNMessages ");
                    for (n4 = n2 - 1; n4 >= 0; --n4) {
                        arrayList3.add(arrayList2.get(n4));
                    }
                }
            }
            this.printOut("Recent messages in queue  :" + n2);
            if (n2 > 0) {
                if (n2 >= this.topNMessages) {
                    this.printOut("Top " + this.topNMessages + " message  DD information from recent messages ");
                } else {
                    this.printOut("Recent message(s) " + n2 + " only ,So displaying  DD information from recent message(s) ");
                }
                this.printOut("----------------------------------------------");
            } else {
                this.printOut("There is no recent messages in queue  ");
            }
            if (arrayList3 != null && !arrayList3.isEmpty() && arrayList3.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n3 = 0; n3 < arrayList3.size(); ++n3) {
                    stringBuffer = new StringBuffer();
                    string = "";
                    Message message = (Message)arrayList3.get(n3);
                    String string3 = null;
                    try {
                        string3 = this.messageType(message);
                        this.printOut("messageType :" + string3, debug);
                    }
                    catch (Exception exception) {
                        string3 = "-";
                        this.printOut("messageType exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(string3);
                    String string4 = "-";
                    try {
                        string4 = message.getJMSType();
                        this.printOut("jmsType :" + string4, debug);
                    }
                    catch (Exception exception) {
                        string4 = "-";
                        this.printOut("jmsType exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string4);
                    String string5 = "-";
                    try {
                        string5 = message.getJMSMessageID();
                        this.printOut("jmsMessageID :" + string5, debug);
                    }
                    catch (Exception exception) {
                        string5 = "-";
                        this.printOut("jmsMessageID exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string5);
                    String string6 = "-";
                    try {
                        string6 = message.getJMSDestination().toString();
                        this.printOut("jmsDestination :" + string6, debug);
                    }
                    catch (Exception exception) {
                        string6 = "-";
                        this.printOut("jmsDestination exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string6);
                    String string7 = "-";
                    try {
                        boolean bl3 = message.getJMSRedelivered();
                        string7 = bl3 ? "Yes" : "No";
                        this.printOut("jmsRedeliveredEnabled :" + string7, debug);
                    }
                    catch (Exception exception) {
                        string7 = "-";
                        this.printOut("jmsRedeliveredEnabled exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string7);
                    String string8 = "-";
                    try {
                        long l4 = message.getJMSTimestamp();
                        long l5 = l - l4;
                        long l6 = 0L;
                        if (l5 > 0L) {
                            l6 = l5 / 60000L;
                            string8 = "" + l6;
                        } else {
                            string8 = "-";
                        }
                        this.printOut("jmsMessageQueueDurationInMins :" + string8, debug);
                    }
                    catch (Exception exception) {
                        string8 = "-";
                        this.printOut("jmsMessageQueueDuration exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string8);
                    String string9 = "unknown";
                    int n5 = -1;
                    try {
                        n5 = message.getJMSDeliveryMode();
                    }
                    catch (JMSException jMSException) {
                        this.printOut("deliveryMode exception :" + jMSException.toString());
                    }
                    if (n5 == 1) {
                        string9 = "non_persistent";
                    } else if (n5 == 2) {
                        string9 = "persistent";
                    }
                    this.printOut("jmsDeliveryMode :" + string9, debug);
                    stringBuffer = stringBuffer.append(fieldSep).append(string9);
                    String string10 = "-";
                    try {
                        long l7 = message.getJMSExpiration();
                        this.printOut("JMSExpiration :" + l7, debug);
                        string10 = l >= l7 ? "Expired" : "" + (l7 - l);
                        this.printOut("jmsTimeToLive :" + string10, debug);
                        this.printOut("Message.DEFAULT_TIME_TO_LIVE :0", debug);
                    }
                    catch (Exception exception) {
                        string10 = "-";
                        this.printOut("jmsTimeToLive exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string10);
                    String string11 = "-";
                    try {
                        int n6 = message.getJMSPriority();
                        string11 = n6 == 4 ? "Default" : (n6 > 4 && n6 <= 9 ? "High" : (n6 >= 0 && n6 < 4 ? "Low" : "Unknown"));
                        this.printOut("jmsPriority :" + string11, debug);
                    }
                    catch (Exception exception) {
                        string11 = "-";
                        this.printOut("jmsPriority exception :" + exception.toString());
                    }
                    stringBuffer = stringBuffer.append(fieldSep).append(string11);
                    String string12 = "-";
                    String string13 = "-";
                    Object object = message.getPropertyNames();
                    while (object.hasMoreElements()) {
                        String string14 = object.nextElement().toString();
                        if (string14.equalsIgnoreCase("JMSXAppID")) {
                            string12 = message.getObjectProperty(string14).toString();
                        }
                        if (!string14.equalsIgnoreCase("JMSXDeliveryCount")) continue;
                        string13 = message.getObjectProperty(string14).toString();
                    }
                    this.printOut("jmxAppId :" + string12, debug);
                    this.printOut("jmsXDeliveryCount :" + string13, debug);
                    stringBuffer = stringBuffer.append(fieldSep).append(string12);
                    stringBuffer = stringBuffer.append(fieldSep).append(string13);
                    object = "User requested to eG to hide this message";
                    if (this.showJMSMessageInDD) {
                        object = JMSEgGenericTest.jmsMsgBodyAsString(message);
                    }
                    this.printOut("jmsMessage :" + (String)object, debug);
                    stringBuffer = stringBuffer.append(fieldSep).append((String)object);
                    string = stringBuffer.toString();
                    this.printOut("DD String " + string);
                    this.mqJMSDDArrayList.add(string);
                    this.printOut("----------------------------------------------");
                }
            }
            if (queueBrowser != null) {
                queueBrowser.close();
            }
        }
        catch (JMSException jMSException) {
            this.printOut("Error: " + jMSException.getMessage());
            jMSException.printStackTrace();
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
                if (this.connection != null) {
                    this.connection.stop();
                    this.connection.close();
                }
            }
            catch (JMSException jMSException) {
                jMSException.printStackTrace();
            }
            this.printOut("eG MQ JMS monitoring  stopped.", debug);
        }
        arrayList = new ArrayList<Double>();
        arrayList.add(new Double(n));
        arrayList.add(new Double(n2));
        if (!bl) {
            this.addNewMeasure(arrayList);
        }
        long l8 = System.currentTimeMillis();
        this.printOut("Total time took to complete the test cycle (in milliseconds) " + (l8 - l));
    }

    public void freeTest() {
        this.mqJMSDDArrayList = new ArrayList();
    }

    private String messageType(Message message) {
        if (message instanceof TextMessage) {
            return "TextMessage";
        }
        if (message instanceof BytesMessage) {
            return "BytesMessage";
        }
        if (message instanceof MapMessage) {
            return "MapMessage";
        }
        if (message instanceof ObjectMessage) {
            return "ObjectMessage";
        }
        if (message instanceof StreamMessage) {
            return "StreamMessage";
        }
        if (message instanceof Message) {
            return "Message";
        }
        String string = message.getClass().getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private static String jmsBytesBodyAsString(Message message) {
        byte[] byArray = new byte[1024];
        int n = 0;
        if (message instanceof BytesMessage) {
            try {
                ((BytesMessage)message).reset();
                n = ((BytesMessage)message).readBytes(byArray);
            }
            catch (JMSException jMSException) {
                return jMSException.toString();
            }
        }
        if (message instanceof StreamMessage) {
            try {
                ((StreamMessage)message).reset();
                n = ((StreamMessage)message).readBytes(byArray);
            }
            catch (JMSException jMSException) {
                return jMSException.toString();
            }
        }
        if (n <= 0) {
            return "-";
        }
        return JMSEgGenericTest.toHexDump(byArray, n) + (n >= byArray.length ? "\n. . ." : "");
    }

    private static String jmsMsgBodyAsString(Message message) {
        if (message instanceof TextMessage) {
            try {
                return ((TextMessage)message).getText();
            }
            catch (JMSException jMSException) {
                return jMSException.toString();
            }
        }
        if (message instanceof BytesMessage) {
            return JMSEgGenericTest.jmsBytesBodyAsString(message);
        }
        if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            try {
                Enumeration enumeration = mapMessage.getMapNames();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().toString();
                    hashMap.put(string, mapMessage.getObject(string).toString());
                }
                return hashMap.toString();
            }
            catch (JMSException jMSException) {
                return jMSException.toString();
            }
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable serializable = null;
            try {
                serializable = objectMessage.getObject();
                if (serializable != null) {
                    return serializable.toString();
                }
                return "null";
            }
            catch (Exception exception) {
                return exception.toString();
            }
        }
        if (message instanceof StreamMessage) {
            return JMSEgGenericTest.jmsBytesBodyAsString(message);
        }
        if (message instanceof Message) {
            return "Can't get body for message of type Message";
        }
        return "Unknown message type " + message;
    }

    private static String toHexDump(byte[] byArray, int n) {
        if (byArray.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n2 = 0;
        while (n2 < byArray.length && n2 < n) {
            int n3 = byArray[n2 + 1] & 0xFF;
            String string = Integer.toHexString(n3 |= byArray[n2] << 8 & 0xFF00);
            stringBuffer.append(pad[4 - string.length()]);
            stringBuffer.append(string);
            if ((n2 += 2) % 16 == 0) {
                stringBuffer.append("\n");
                continue;
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private String pad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        while (n2 > 0) {
            stringBuffer.append(" ");
            --n2;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public Connection getConnection(InitialContext initialContext) {
        ConnectionFactory connectionFactory = null;
        try {
            this.printOut("Connection Factory name :" + this.connectionFactory);
            connectionFactory = this.isWMQLDAP ? (ConnectionFactory)initialContext.lookup("cn=" + this.connectionFactory) : (ConnectionFactory)initialContext.lookup(this.connectionFactory);
        }
        catch (NamingException namingException) {
            this.putErrorMessageToLogfile("Please check the TopicConnectionFactory name " + namingException.toString());
            namingException.printStackTrace();
        }
        Connection connection = null;
        try {
            String string = EgCrypt.decrypt(this.password);
            connection = this.mqServer.equalsIgnoreCase("WebSphereMQ") ? connectionFactory.createConnection(this.userName, string) : connectionFactory.createConnection(this.userName, string);
        }
        catch (JMSException jMSException) {
            jMSException.printStackTrace();
        }
        return connection;
    }

    protected InitialContext getInitialContext() {
        long l = System.currentTimeMillis();
        INITIAL_CONTEXT = this.getInitialContext(true);
        long l2 = System.currentTimeMillis();
        this.printOut("Total time took to  establish the initial context (in milliseconds)" + (l2 - l));
        return INITIAL_CONTEXT;
    }

    protected InitialContext getInitialContext(boolean bl) {
        String string;
        String string2;
        InitialContext initialContext = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.isWMQLDAP) {
            if (this.isSSL) {
                string2 = System.getProperty("java.home");
                string = string2 + "/lib/security/cacerts";
                System.setProperty("javax.net.ssl.trustStore", string);
                hashtable.put("java.naming.security.protocol", "ssl");
            }
            hashtable.put("java.naming.factory.initial", this.initialContextFactory);
            hashtable.put("java.naming.provider.url", this.providerURL);
            hashtable.put("java.naming.security.principal", this.user_DN);
            hashtable.put("java.naming.security.credentials", this.user_DN_Password);
            hashtable.put("java.naming.security.authentication", "simple");
            hashtable.put("javax.security.sasl.qop", "auth-int");
            hashtable.put("java.naming.referral", "follow");
        } else {
            hashtable.put("java.naming.factory.initial", this.initialContextFactory);
            hashtable.put("java.naming.provider.url", this.providerURL);
            hashtable.put("java.naming.security.principal", this.userName);
            string2 = EgCrypt.decrypt(this.password);
            hashtable.put("java.naming.security.credentials", string2);
        }
        try {
            initialContext = new InitialContext(hashtable);
            this.printOut("Successfully  created  initial context");
        }
        catch (NamingException namingException) {
            string = "Failed to create initial context";
            this.printOut(string);
            this.putErrorMessageToLogfile(string);
            namingException.printStackTrace();
        }
        return initialContext;
    }

    private String getHexHash(String string, String string2) {
        String string3 = string + ":ApplicationRealm:" + string2;
        String string4 = "";
        byte[] byArray = null;
        try {
            byArray = string3.getBytes(System.getProperty("file.encoding"));
        }
        catch (Exception exception) {
            this.printOut("DEBUG: Exception while getting credential bytes : " + exception.toString());
            exception.printStackTrace();
            try {
                byArray = string3.getBytes("UTF-8");
            }
            catch (Exception exception2) {
                this.printOut("DEBUG Exception while getting credential bytes for UTF-8 also : " + exception2.toString());
                exception2.printStackTrace();
                return null;
            }
        }
        this.printOut("DEBUG Obtained bytes");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray2 = messageDigest.digest(byArray);
            this.printOut("DEBUG Digested bytes");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray2.length; ++i) {
                stringBuffer.append(this.byteToHex(byArray2[i]));
            }
            string4 = stringBuffer.toString();
            this.printOut("DEBUG Hex value of hash is " + string4);
            return string4;
        }
        catch (Exception exception) {
            this.printOut("DEBUG: Exception while creating digest : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private String byteToHex(byte by) {
        char[] cArray = new char[]{hexDigit[by >> 4 & 0xF], hexDigit[by & 0xF]};
        return new String(cArray);
    }
}

