/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JRunServiceTest
extends GenericTest {
    double avgQueueingTime;
    double avgProcTime;
    double srvResponceTime;
    double bytesReadRate;
    double bytesWrittenRate;
    double totalTimeInDelayState;
    double requestDelayCount;
    double requestDroppedCount;
    double requestHandledTime;
    double requestHandledCount;
    String homeDir;
    String temp;
    String fileName = null;
    String[] servList = null;
    String serverName = null;
    String line = null;
    StringTokenizer st;
    File f = null;
    BufferedReader data;
    long lastModifiedTime;
    long newTime;
    long startTime;
    boolean flag = true;
    int i;
    EgDateInfo date = new EgDateInfo();
    boolean debug = false;
    ArrayList lastModifiedTimeList = new ArrayList();
    ArrayList currentModifiedTimeList = new ArrayList();
    ArrayList flagList = new ArrayList();
    ArrayList measureList = null;
    boolean firstTime = true;
    long msecPerHour = 3600000L;

    public static void main(String[] stringArray) {
        JRunServiceTest jRunServiceTest = new JRunServiceTest(stringArray);
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < 5; ++i) {
            try {
                jRunServiceTest.executeTest();
                Thread.sleep(20000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public JRunServiceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(8);
        this.startTime = 0L;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            this.usage();
            return;
        }
        if (stringArray.length > 2 && !stringArray[2].equalsIgnoreCase("-port")) {
            this.usage();
            return;
        }
        if (stringArray.length > 4 && !stringArray[4].equalsIgnoreCase("-homeDir")) {
            this.usage();
            return;
        }
        this.homeDir = stringArray[5];
    }

    public void usage() {
        System.err.println("Usage: JRunThreadTest -host <targetHost> -port <Port> -homeDir <homeDir> ");
    }

    public synchronized boolean CheckForUpdate(File file) {
        this.currentModifiedTimeList.set(this.i, new Long(file.lastModified()));
        if (this.debug) {
            System.out.println("currentModifiedTimeList :" + this.currentModifiedTimeList.get(this.i) + " lastModifiedTimeList:" + this.lastModifiedTimeList.get(this.i));
        }
        if ((Long)this.currentModifiedTimeList.get(this.i) <= (Long)this.lastModifiedTimeList.get(this.i)) {
            return false;
        }
        this.lastModifiedTimeList.set(this.i, this.currentModifiedTimeList.get(this.i));
        return true;
    }

    public void cleanUpArrayList(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.remove(0);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        int n;
        this.measureList = new ArrayList();
        if (!hashtable.containsKey("homeDir")) {
            this.setErrorMessage("Home path to JRun server has not been passed");
            return;
        }
        this.homeDir = (String)hashtable.get("homeDir");
        if (System.currentTimeMillis() - this.startTime > this.msecPerHour || this.startTime == 0L) {
            this.servList = this.getServerList(this.homeDir);
            this.startTime = System.currentTimeMillis();
            this.firstTime = true;
            this.cleanUpArrayList(this.currentModifiedTimeList);
            this.cleanUpArrayList(this.lastModifiedTimeList);
            this.cleanUpArrayList(this.flagList);
        }
        if (this.firstTime) {
            for (n = 0; n < this.servList.length; ++n) {
                this.currentModifiedTimeList.add(n, new Long(0L));
                this.lastModifiedTimeList.add(n, new Long(0L));
                this.flagList.add(n, new Boolean(true));
            }
            this.firstTime = false;
        }
        this.i = 0;
        if (this.servList != null) {
            n = 0;
            while (this.i < this.servList.length) {
                this.measureList = new ArrayList();
                this.fileName = this.homeDir + "/logs/" + this.servList[this.i];
                this.serverName = this.servList[this.i].substring(0, this.servList[this.i].indexOf("-"));
                this.f = new File(this.fileName);
                if (((Boolean)this.flagList.get(this.i)).booleanValue()) {
                    this.lastModifiedTimeList.set(this.i, new Long(this.f.lastModified()));
                    this.flagList.set(this.i, new Boolean(false));
                }
                if (this.CheckForUpdate(this.f)) {
                    try {
                        this.data = new BufferedReader(new FileReader(this.fileName));
                        if (this.data == null) {
                            this.setErrorMessage("No data in file");
                            return;
                        }
                        String string = "";
                        while ((this.line = this.data.readLine()) != null) {
                            string = this.line;
                        }
                        this.data.close();
                        this.data = null;
                        if (string != null && string.indexOf("metrics") > 0) {
                            this.st = new StringTokenizer(string);
                            if (this.st.countTokens() == 19) {
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.requestHandledCount = Double.parseDouble(this.st.nextToken());
                                this.requestHandledTime = Double.parseDouble(this.st.nextToken());
                                this.bytesReadRate = Double.parseDouble(this.st.nextToken());
                                this.bytesWrittenRate = Double.parseDouble(this.st.nextToken());
                                this.totalTimeInDelayState = Double.parseDouble(this.st.nextToken());
                                this.requestDelayCount = Double.parseDouble(this.st.nextToken());
                                this.requestDroppedCount = Double.parseDouble(this.st.nextToken());
                            } else if (this.st.countTokens() == 17) {
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.st.nextToken();
                                this.requestHandledCount = this.parse(this.st.nextToken());
                                this.requestHandledTime = this.parse(this.st.nextToken());
                                this.bytesReadRate = this.parse(this.st.nextToken());
                                this.bytesWrittenRate = this.parse(this.st.nextToken());
                                this.totalTimeInDelayState = this.parse(this.st.nextToken());
                                this.requestDelayCount = this.parse(this.st.nextToken());
                                this.requestDroppedCount = this.parse(this.st.nextToken());
                            }
                            if (this.requestHandledCount > 0.0) {
                                this.avgQueueingTime = this.totalTimeInDelayState / this.requestHandledCount / 1000.0;
                                this.avgProcTime = this.requestHandledTime / this.requestHandledCount / 1000.0;
                            } else {
                                this.avgQueueingTime = 0.0;
                                this.avgProcTime = 0.0;
                            }
                            this.srvResponceTime = this.avgQueueingTime + this.avgProcTime;
                            if (this.timeSinceLastTest > 0.0) {
                                this.bytesReadRate = this.bytesReadRate / 1024.0 / this.timeSinceLastTest;
                                this.bytesWrittenRate = this.bytesWrittenRate / 1024.0 / this.timeSinceLastTest;
                            } else {
                                this.bytesReadRate = -1.0;
                                this.bytesWrittenRate = -1.0;
                            }
                            if (this.debug) {
                                System.out.println("\nservList :" + this.serverName);
                                System.out.println("avgQueueingTime (Sec)" + this.avgQueueingTime);
                                System.out.println("avgProcTime (Sec)" + this.avgProcTime);
                                System.out.println("avgResponceTime (Sec)" + this.srvResponceTime);
                                System.out.println("bytesReadRate (KB/Sec)" + this.bytesReadRate);
                                System.out.println("bytesWrittenRate (KB/Sec)" + this.bytesWrittenRate);
                                System.out.println("requestDelayCount (N) " + this.requestDelayCount);
                                System.out.println("requestDroppedCount (N) " + this.requestDroppedCount);
                            }
                            this.setMeasures();
                        }
                        this.resetValue();
                        this.setMeasures();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.setErrorMessage("The monitoring log file not found");
                        if (this.debug) {
                            System.out.println("The monitoring log file not found");
                        }
                        this.resetValue();
                        this.setMeasures();
                        try {
                            if (this.data != null) {
                                this.data.close();
                            }
                            this.data = null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Exception exception) {
                        if (this.debug) {
                            System.out.println("AA" + exception);
                        }
                        exception.printStackTrace();
                        this.resetValue();
                        this.setMeasures();
                        try {
                            if (this.data != null) {
                                this.data.close();
                            }
                            this.data = null;
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        return;
                    }
                } else {
                    try {
                        this.resetValue();
                        this.setMeasures();
                        if (this.data != null) {
                            this.data.close();
                        }
                        this.data = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++this.i;
            }
        } else {
            return;
        }
    }

    private String[] getServerList(String string) {
        string = string + "/logs";
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("metrics.log") <= 0) continue;
            arrayList.add(stringArray[i]);
        }
        String[] stringArray2 = new String[arrayList.size()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = (String)arrayList.get(i);
        }
        return stringArray2;
    }

    private void resetValue() {
        this.requestHandledCount = -1.0;
        this.avgQueueingTime = -1.0;
        this.avgProcTime = -1.0;
        this.srvResponceTime = -1.0;
        this.bytesReadRate = -1.0;
        this.bytesWrittenRate = -1.0;
        this.requestDelayCount = -1.0;
        this.requestDroppedCount = -1.0;
    }

    private void setMeasures() {
        try {
            double d = this.timeSinceLastTest <= 0.0 || this.requestHandledCount == -1.0 ? -1.0 : this.requestHandledCount / this.timeSinceLastTest;
            this.measureList.add(new Double(d));
            this.measureList.add(new Double(this.avgQueueingTime));
            this.measureList.add(new Double(this.avgProcTime));
            this.measureList.add(new Double(this.srvResponceTime));
            this.measureList.add(new Double(this.bytesReadRate));
            this.measureList.add(new Double(this.bytesWrittenRate));
            this.measureList.add(new Double(this.requestDelayCount));
            this.measureList.add(new Double(this.requestDroppedCount));
            this.addNewMeasure(this.serverName, this.measureList);
        }
        catch (Exception exception) {
            System.out.println("EXECP: " + exception);
        }
    }

    private double parse(String string) {
        if (!string.startsWith("{") && string.indexOf("+") < 0) {
            return Double.parseDouble(string);
        }
        int n = (string = string.substring(1, string.length() - 1)).indexOf("+");
        if (n < 0) {
            return Double.parseDouble(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        double d = Double.parseDouble(string2);
        double d2 = Double.parseDouble(string3);
        return d + d2;
    }
}

