/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaAPMExceptionObject;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.Status;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExceptionsTest
extends BTMBase {
    protected Hashtable ddSourceTable;
    private static final int MAX_GROUPED_URL_SIZE = 50;
    private static final Double ZERO_VALUE = 0.0;
    protected boolean isRootCauseExceptionTracking = false;
    private static final String SUMMARY = "Summary";

    public JavaExceptionsTest(String[] stringArray) {
        super(stringArray);
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [JavaExceptionsTest]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        String string = this.getValueForParam("Enable_RootCause_Exception_Tracking");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.isRootCauseExceptionTracking = true;
            this.setCauseExceptionTracingTable(this.jvmGUID, this.isRootCauseExceptionTracking);
            JavaBTMLogger.btmLogger.debug("{} root cause exception tracking is enable : {} \t {} ", new Object[]{this.loggerDispStr, this.isRootCauseExceptionTracking, this.jvmGUID});
        } else {
            this.setCauseExceptionTracingTable(this.jvmGUID, this.isRootCauseExceptionTracking);
            JavaBTMLogger.btmLogger.debug("{} root cause exception tracking is disable : {} \t {} ", new Object[]{this.loggerDispStr, this.isRootCauseExceptionTracking, this.jvmGUID});
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Map.Entry entry;
        Object object4;
        boolean bl;
        this.getJvmGuid();
        JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(this.jvmGUID);
        if (javaAPMComponent == null) {
            return;
        }
        ArrayList<JavaAPMExceptionObject> arrayList = javaAPMComponent.getJavaAPMExceptions();
        boolean bl2 = bl = javaAPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
        if (arrayList == null && bl) {
            ArrayList arrayList2 = this.createDefaultValueList();
            JavaBTMLogger.btmLogger.debug("{} = {}  Sent addNewMeasure: {} = {}", new Object[]{this.loggerDispStr, this.entity, SUMMARY, arrayList2});
            this.addNewMeasure(SUMMARY, arrayList2);
            return;
        }
        if (arrayList == null) {
            return;
        }
        this.ddSourceTable = new Hashtable();
        long l = this.measurePeriod / 1000L / 60L;
        double d = 0.0;
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        JavaBTMLogger.btmLogger.debug("{}  {} received exception details list ", (Object)this.loggerDispStr, (Object)this.entity);
        for (int i = 0; i < arrayList.size(); ++i) {
            object4 = arrayList.get(i);
            entry = ((JavaAPMExceptionObject)object4).getReqGUID();
            object3 = ((JavaAPMExceptionObject)object4).getPatternString();
            object2 = ((JavaAPMExceptionObject)object4).getReqType();
            serializable = ((JavaAPMExceptionObject)object4).getExceptionList();
            for (int j = 0; j < serializable.size(); ++j) {
                int n;
                d += 1.0;
                object = null;
                String[] stringArray = (String[])serializable.get(j);
                object = this.isRootCauseExceptionTracking ? ((object = stringArray[n = this.getDiscriptorIndex(stringArray)]) == null ? stringArray[0] : object) : stringArray[0];
                try {
                    if (hashMap.size() >= 50) {
                        this.prepareDescriptorDetails("Others", hashMap, (String)object2, (String)((Object)entry), stringArray, (String)object3);
                        continue;
                    }
                    this.prepareDescriptorDetails((String)object, hashMap, (String)object2, (String)((Object)entry), stringArray, (String)object3);
                    continue;
                }
                catch (Exception exception) {
                    JavaBTMLogger.btmLogger.error("{} exception occur while preparing descriptor & DD data for Exception Test :{} ", (Object)this.loggerDispStr, (Object)exception);
                }
            }
        }
        if (hashMap != null && hashMap.size() > 0) {
            Iterator iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object4 = new ArrayList();
                entry = iterator.next();
                object3 = (String)entry.getKey();
                object2 = (Double)entry.getValue();
                serializable = Double.valueOf((Double)object2 / (double)l);
                Double d2 = minusFive;
                object = (Double)object2 / d * 100.0;
                ((ArrayList)object4).add(object2);
                ((ArrayList)object4).add(serializable);
                ((ArrayList)object4).add(d2);
                ((ArrayList)object4).add(object);
                ((ArrayList)object4).add(minusFive);
                JavaBTMLogger.btmLogger.debug("{} == {}   Sent addNewMeasure: {} ", new Object[]{this.loggerDispStr, this.entity, object3});
                this.addNewMeasure((String)object3, (ArrayList)object4);
            }
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (d > 0.0) {
            object4 = d / (double)l;
            entry = minusFive;
            object3 = minusFive;
            object2 = (double)hashMap.size();
            arrayList3.add(d);
            arrayList3.add(object4);
            arrayList3.add(entry);
            arrayList3.add(object3);
            arrayList3.add(object2);
            JavaBTMLogger.btmLogger.debug("{} == {}   Sent addNewMeasure: SUMMARY {} ", new Object[]{this.loggerDispStr, this.entity, arrayList3});
            this.addNewMeasure(SUMMARY, arrayList3);
        }
    }

    private int getDiscriptorIndex(String[] stringArray) {
        int n = 0;
        for (int i = 2; i < stringArray.length; i += 2) {
            if (stringArray[i] == null) {
                return i - 2;
            }
            n = i;
        }
        return n;
    }

    private void prepareDescriptorDetails(String string, HashMap<String, Double> hashMap, String string2, String string3, String[] stringArray, String string4) {
        if (hashMap.containsKey(string)) {
            double d = hashMap.get(string);
            hashMap.put(string, d += 1.0);
            ArrayList arrayList = (ArrayList)this.ddSourceTable.get(string);
            ArrayList arrayList2 = this.prepareDDData(string2, string3, stringArray, string4, string);
            arrayList.add(arrayList2);
            this.ddSourceTable.put(string, arrayList);
        } else {
            hashMap.put(string, 1.0);
            ArrayList arrayList = this.prepareDDData(string2, string3, stringArray, string4, string);
            ArrayList<ArrayList> arrayList3 = new ArrayList<ArrayList>();
            arrayList3.add(arrayList);
            this.ddSourceTable.put(string, arrayList3);
        }
    }

    private ArrayList prepareDDData(String string, String string2, String[] stringArray, String string3, String string4) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = string2.substring(0, string2.indexOf("#~#"));
        String string6 = string2.substring(string2.indexOf("#~#") + 3);
        arrayList.add(string5);
        arrayList.add(string6);
        arrayList.add(string);
        arrayList.add(string3);
        try {
            if (stringArray.length == 4) {
                String string7 = null;
                string7 = this.isRootCauseExceptionTracking && string4.equals(stringArray[2]) ? stringArray[3] : stringArray[1];
                arrayList.add(JavaExceptionsTest.getMessage(string7 == null ? "-" : string7));
                for (int i = 0; i < 6; ++i) {
                    arrayList.add("-");
                    arrayList.add("-");
                }
            } else {
                String string8;
                String string9;
                int n;
                int n2;
                for (n2 = 0; n2 < 6; ++n2) {
                    n = n2 * 2;
                    string9 = stringArray[n];
                    string8 = stringArray[n + 1];
                    if (!string4.equals(string9)) continue;
                    string8 = string8 == null ? "-" : string8;
                    arrayList.add(JavaExceptionsTest.getMessage(string8));
                    break;
                }
                for (n2 = 0; n2 < 6; ++n2) {
                    n = n2 * 2;
                    string9 = stringArray[n];
                    string8 = stringArray[n + 1];
                    if (string9 == null) {
                        string9 = "-";
                    }
                    if (string8 == null) {
                        string8 = "-";
                    }
                    arrayList.add(string9);
                    arrayList.add(JavaExceptionsTest.getMessage(string8));
                }
            }
        }
        catch (Exception exception) {
            JavaBTMLogger.btmLogger.error("{} {}  exception occur while preparing java exception dd details :  {} ", new Object[]{this.loggerDispStr, this.entity, exception});
        }
        JavaBTMLogger.btmLogger.debug("{} {}  java exception dd details list for pattern {} prepared ", new Object[]{this.loggerDispStr, this.entity, string3});
        return arrayList;
    }

    private static String getMessage(String string) {
        if ((string.contains("\n") || string.contains("\r")) && (string = string.replaceAll("(\\r\\n|\\n|\\r)", "  ")).endsWith("Stacktrace:")) {
            string = string.substring(0, string.lastIndexOf("Stacktrace:"));
        }
        if (string.length() >= 2048) {
            return string.substring(0, 2045) + "...";
        }
        return string;
    }

    private ArrayList createDefaultValueList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(ZERO_VALUE);
        arrayList.add(ZERO_VALUE);
        arrayList.add(minusFive);
        arrayList.add(minusFive);
        arrayList.add(ZERO_VALUE);
        return arrayList;
    }

    public ArrayList getDDDetails(String string) {
        ArrayList arrayList = null;
        if (this.ddSourceTable != null && this.ddSourceTable.size() > 0) {
            arrayList = (ArrayList)this.ddSourceTable.get(string);
        }
        JavaBTMLogger.btmLogger.debug("{} Method getDDDetails returns : ", (Object)this.loggerDispStr);
        return arrayList;
    }
}

