/*
 * Decompiled with CFR 0.152.
 */
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class JavaTransactionsTest
extends GenericTest {
    public static final String[] subCompNames = new String[]{"ALL_URLS", "SLOW_URLS", "ERROR_URLS", "FILTER", "JSP", "HTTPSERVLET", "GENERICSERVLET", "JDBC", "SQL", "EXCEPTION", "STRUTS", "NATIVE", "RMI", "JAXM", "EMAIL", "EJB", "JNDI", "JXTA", "POJO", "HTTP", "WEBSERVICE"};
    public static final String[] propsOrder = new String[]{"Url_Pattern_Discovery_Mode", "URL_Patterns", "Max_URL_Segments", "Filtered_URL_Patterns", "Slow_URL_Threshold", "Method_Exec_CutOff", "Max_Slow_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period", "egMeasPeriod"};
    public static final String[] propsOrderDefaultValue = new String[]{"Auto", "none", "2", "none", "3", "0.050", "10", "10", "180"};
    public static final int NUM_MEASURES = subCompNames.length * 2;
    private String logPrefix = " JavaTrans : ";
    private final String jtmSecurity = "JTM";
    private Hashtable measuresHt;
    private ArrayList propsList = new ArrayList();
    private static final int SOCK_TIMEOUT = 250;
    private static final String myDatePattern = "dd/MM/yy hh:mm:ss a";
    private static final SimpleDateFormat mySDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a");
    private static String servername = "localhost";
    private Socket cliSock = null;
    private ObjectOutputStream oos = null;
    private ObjectInputStream ois = null;
    private int JTM_Port = 13631;
    private String trgtHost = "localhost";
    private boolean prevTryFailed = false;
    private boolean firstRun;
    private String egMeasHost = "Unknown";
    private Hashtable slowURLTable = null;
    private Hashtable errorURLTable = null;

    public JavaTransactionsTest(String[] stringArray) {
        super(stringArray);
        double d = -1.0;
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        Double d2 = new Double(d);
        ArrayList arrayList = new ArrayList();
        this.setMeasureCount(NUM_MEASURES);
        this.firstRun = true;
        this.initProps();
        this.printOut("Properties initialized. Ready to contact JTM.");
    }

    private void initProps() {
        this.makePropsList();
        this.trgtHost = this.getValueForParam("trgtHost");
        try {
            this.JTM_Port = Integer.parseInt(this.getValueForParam("JTM_Port"));
        }
        catch (NumberFormatException numberFormatException) {
            this.printErr("JTM_Port value " + this.getValueForParam("JTM_Port") + " is invalid. Connecting to default JTM port");
        }
    }

    private void makePropsList() {
        if (this.propsList != null && this.propsList.size() > 0) {
            this.propsList.clear();
        }
        String string = this.getValueForParam(propsOrder[0]);
        String string2 = "Auto";
        String string3 = null;
        String string4 = null;
        if (string != null && string.equalsIgnoreCase("false")) {
            string2 = "Manual";
        }
        this.propsList.add("JTM");
        this.propsList.add(string2);
        for (int i = 1; i < propsOrder.length; ++i) {
            string3 = this.getValueForParam(propsOrder[i]);
            string4 = propsOrderDefaultValue[i];
            try {
                if (propsOrder[i].equals("Slow_URL_Threshold") || propsOrder[i].equals("Method_Exec_CutOff")) {
                    Double.valueOf(string3);
                    this.propsList.add(string3);
                } else if (propsOrder[i].equals("Max_Slow_URLs_Per_Test_Period") || propsOrder[i].equals("Max_Error_URLs_Per_Test_Period")) {
                    Integer.valueOf(string3);
                    this.propsList.add(string3);
                } else if (propsOrder[i].equals("Filtered_URL_Patterns")) {
                    if (string3.equals("")) {
                        this.propsList.add(string4);
                    } else {
                        this.propsList.add(string3);
                    }
                } else {
                    this.propsList.add(string3);
                }
            }
            catch (Exception exception) {
                this.printErr(propsOrder[i] + " is invalid, assigning default value :" + string4);
                this.propsList.add(string4);
            }
            string3 = null;
            string4 = null;
        }
        this.printOut("propsList is " + this.propsList);
    }

    public ArrayList getSlowURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.slowURLTable != null && this.slowURLTable.size() > 0) {
            arrayList = (ArrayList)this.slowURLTable.get(string);
        }
        return arrayList;
    }

    public ArrayList getErrorURLDetails(String string) {
        ArrayList arrayList = null;
        if (this.errorURLTable != null && this.errorURLTable.size() > 0) {
            arrayList = (ArrayList)this.errorURLTable.get(string);
        }
        return arrayList;
    }

    public void computeMeasures(Hashtable hashtable) {
        this.printOut(" ********************* BEGIN RUN ************************* ");
        this.fillInMeasures();
        this.slowURLTable = new Hashtable();
        this.errorURLTable = new Hashtable();
        if (this.measuresHt != null && this.measuresHt.size() > 0) {
            Set set = this.measuresHt.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Serializable serializable;
                double d;
                String string = (String)iterator.next();
                Hashtable hashtable2 = (Hashtable)this.measuresHt.get(string);
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                ArrayList arrayList = (ArrayList)hashtable2.get("patternData");
                if (arrayList != null && arrayList.size() > 0 && (d = ((Double)(serializable = (Double)arrayList.get(0))).doubleValue()) > 0.0) {
                    this.addNewMeasure(string, arrayList);
                }
                serializable = (ArrayList)hashtable2.get("SlowURLLists");
                ArrayList arrayList2 = (ArrayList)hashtable2.get("ErrorURLLists");
                if (serializable != null) {
                    this.slowURLTable.put(string, serializable);
                }
                if (arrayList2 == null) continue;
                this.errorURLTable.put(string, arrayList2);
            }
        }
        this.firstRun = false;
        this.printOut(" ======================  END RUN ====================== ");
    }

    public void fillInMeasures() {
        if (this.establishConnectionResources()) {
            this.queryServer();
            boolean bl = this.getJTMData();
            this.closeConnectionResources();
            this.propsList.clear();
            this.prevTryFailed = false;
            if (!bl) {
                this.makePropsList();
            }
        } else {
            this.printErr("Could not establish connection to JTM");
            this.measuresHt = new Hashtable();
            if (!this.prevTryFailed && !this.firstRun) {
                this.printErr("Could not establish connection following a previous successful connection attempt. Preparing dummy data.");
            }
            this.prevTryFailed = true;
            this.makePropsList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean establishConnectionResources() {
        boolean bl = false;
        try {
            InetAddress inetAddress = InetAddress.getByName(this.trgtHost);
            this.cliSock = new Socket();
            this.cliSock.bind(null);
            this.printOut("Trying to connect to " + inetAddress + " at port " + this.JTM_Port);
            this.cliSock.connect(new InetSocketAddress(inetAddress, this.JTM_Port), 250);
            this.printOut("Connected to " + inetAddress + " on port " + this.JTM_Port);
            bl = true;
            return bl;
        }
        catch (UnknownHostException unknownHostException) {
            this.printErr(unknownHostException.toString());
            this.printErr(this.STEs2Str(unknownHostException.getStackTrace()));
            bl = false;
            return bl;
        }
        catch (IOException iOException) {
            this.printErr(iOException.toString());
            this.printErr(this.STEs2Str(iOException.getStackTrace()));
            bl = false;
            return bl;
        }
        finally {
            if (!bl && this.cliSock != null) {
                try {
                    this.cliSock.close();
                }
                catch (IOException iOException) {
                    this.printErr("Unable to close client socket \n");
                    this.printErr(iOException.toString());
                    this.printErr(this.STEs2Str(iOException.getStackTrace()));
                }
            }
            return bl;
        }
    }

    public void closeConnectionResources() {
        try {
            if (this.ois != null) {
                this.ois.close();
            }
            if (this.oos != null) {
                this.oos.close();
            }
            if (this.cliSock != null) {
                this.cliSock.close();
            }
        }
        catch (IOException iOException) {
            this.printErr("Error closing connection resources after getting measures from JTM");
            this.printErr(iOException.toString());
            this.printErr(this.STEs2Str(iOException.getStackTrace()));
        }
    }

    private void queryServer() {
        try {
            this.oos = new ObjectOutputStream(this.cliSock.getOutputStream());
            if (this.propsList.size() == 0) {
                this.propsList.add("JTM");
            }
            this.oos.writeObject(this.propsList);
            this.oos.flush();
            this.printOut("Sent the following props list to JTM : " + this.propsList);
        }
        catch (IOException iOException) {
            this.printErr(iOException.toString());
            this.printErr(this.STEs2Str(iOException.getStackTrace()));
        }
    }

    public boolean getJTMData() {
        boolean bl = false;
        try {
            this.ois = new ObjectInputStream(this.cliSock.getInputStream());
            Object object = this.ois.readObject();
            if (object != null && object instanceof String) {
                bl = false;
            } else {
                this.measuresHt = (Hashtable)object;
                this.printOut("Obtained measures object from JTM");
                bl = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.printErr(classNotFoundException.toString());
            this.printErr(this.STEs2Str(classNotFoundException.getStackTrace()));
        }
        catch (EOFException eOFException) {
            this.printErr(eOFException.toString());
            this.printErr(this.STEs2Str(eOFException.getStackTrace()));
        }
        catch (IOException iOException) {
            this.printErr(iOException.toString());
            this.printErr(this.STEs2Str(iOException.getStackTrace()));
        }
        catch (Exception exception) {
            this.printErr(exception.toString());
            this.printErr(this.STEs2Str(exception.getStackTrace()));
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        this.propsList.clear();
        this.closeConnectionResources();
        super.finalize();
    }

    public void printOut(String string) {
        System.out.println(this.toString() + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + this.logPrefix + string);
    }

    public void printErr(String string) {
        System.err.println(this.toString() + " " + this.reportingName + " " + mySDF.format(new Date()) + " :" + this.logPrefix + string);
    }

    String STEs2Str(StackTraceElement[] stackTraceElementArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append('\t').append(stackTraceElementArray[i].toString()).append('\n');
        }
        return stringBuffer.toString();
    }
}

