/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;

public class LdRealServerTest
extends EgSnmpTest {
    private String cldeRealIpAddress = ".1.3.6.1.4.1.9.9.99.1.2.2.1.1";
    private String cldeRealPort = ".1.3.6.1.4.1.9.9.99.1.2.2.1.2";
    private String cldeRealBindId = ".1.3.6.1.4.1.9.9.99.1.2.2.1.3";
    private String cldeRealProtocol = ".1.3.6.1.4.1.9.9.99.1.2.2.1.4";
    private String cldeRealState = ".1.3.6.1.4.1.9.9.99.1.2.2.1.5";
    private String cldeRealTotalConnections = ".1.3.6.1.4.1.9.9.99.1.2.2.1.6";
    private String cldeRealTotalBytes = ".1.3.6.1.4.1.9.9.99.1.2.2.1.8";
    private int stateIndex = 0;
    private int connRateIndex = 1;
    private int dataRateIndex = 2;
    private double BtoMB = 1048576.0;
    private int reDiscoveryCount = 12;
    private int reRun = 0;
    private Hashtable prevTotalConnections = new Hashtable();
    private Hashtable prevTotalBytes = new Hashtable();
    private Hashtable keyIndexMapping = new Hashtable();
    private Hashtable realIpAddress;
    private Hashtable realPort;
    private Hashtable realBindId;
    private Hashtable realProtocol;
    private Hashtable realState;
    private Hashtable realTotalConnections;
    private Hashtable realTotalBytes;

    public LdRealServerTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 3;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: LdRealServerTest -host <targetHost> -snmpPort <snmpPort> -snmpCommunity <community>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-snmpPort")) {
                    if (++i < stringArray.length) {
                        this.snmpPortNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage:LdRealServerTest -host <targetHost> -snmpPort <snmpPort> -snmpCommunity <community>");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-snmpCommunity")) continue;
                if (++i < stringArray.length) {
                    this.community = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage:LdRealServerTest -host <targetHost>  -snmpPort <snmpPort> -snmpCommunity <community>");
                return;
            }
        }
    }

    public static void main(String[] stringArray) {
        LdRealServerTest ldRealServerTest = new LdRealServerTest(stringArray);
        ldRealServerTest.executeTest();
    }

    public boolean executeTest() {
        this.initTest();
        if (this.reRun == 0 && !this.getAllLocalDirectors()) {
            this.reRun = 0;
        }
        if (this.reRun == 0) {
            this.updateAllResultSets();
            return true;
        }
        if (this.realIpAddress == null || this.realIpAddress.size() == 0) {
            this.updateAllResultSets();
            this.reRun = 0;
            return true;
        }
        ++this.reRun;
        if (this.reRun >= this.reDiscoveryCount) {
            this.reRun = 0;
        }
        this.findStates();
        this.findTotalConnections();
        this.findTotalBytes();
        String string = null;
        Enumeration enumeration = this.realIpAddress.keys();
        while (enumeration.hasMoreElements()) {
            boolean bl = false;
            double d = 0.0;
            double d2 = 0.0;
            Object k = enumeration.nextElement();
            if (!this.realPort.containsKey(k) || !this.realBindId.containsKey(k) || !this.realProtocol.containsKey(k)) continue;
            string = (String)this.realIpAddress.get(k) + "_" + (String)this.realPort.get(k) + "_" + (String)this.realBindId.get(k) + "_" + (String)this.realProtocol.get(k);
            int n = Integer.parseInt((String)this.realState.get(k));
            long l = Long.parseLong((String)this.realTotalConnections.get(k));
            long l2 = Long.parseLong((String)this.realTotalBytes.get(k));
            Long l3 = (Long)this.prevTotalConnections.get(k);
            Long l4 = (Long)this.prevTotalBytes.get(k);
            if (this.timeSinceLastTest > 0.0) {
                long l5 = l3;
                long l6 = l4;
                d = l5 == -1L ? -1.0 : ((double)l - (double)l5) / this.timeSinceLastTest;
                d2 = l6 == -1L ? -1.0 : ((double)l2 - (double)l6) / (this.BtoMB * this.timeSinceLastTest);
            } else {
                d = -1.0;
                d2 = -1.0;
            }
            this.prevTotalConnections.put(k, new Long(l));
            this.prevTotalBytes.put(k, new Long(l2));
            string = this.siteName + siteAndInfoSeparator + infoFieldSeparator + string;
            if (!this.keyIndexMapping.containsKey(k)) {
                this.keyIndexMapping.put(k, string);
            }
            this.addValueToResultSet(string, this.stateIndex, (double)bl);
            this.addValueToResultSet(string, this.connRateIndex, d);
            this.addValueToResultSet(string, this.dataRateIndex, d2);
        }
        this.updateAllResultSets();
        return true;
    }

    public boolean getAllLocalDirectors() {
        int n;
        this.realIpAddress = new Hashtable();
        this.keyIndexMapping = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealIpAddress)) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.realIpAddress.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            return false;
        }
        this.realPort = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealPort)) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.realPort.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            return false;
        }
        this.realBindId = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealBindId)) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.realBindId.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            return false;
        }
        this.realProtocol = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealProtocol)) {
            for (n = 0; n < this.lhs.length; ++n) {
                this.realProtocol.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            return false;
        }
        return true;
    }

    public void findStates() {
        this.realState = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealState)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                this.realState.put(this.lhs[i], this.rhs[i]);
            }
        }
    }

    public void findTotalConnections() {
        this.realTotalConnections = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealTotalConnections)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                this.realTotalConnections.put(this.lhs[i], this.rhs[i]);
            }
        }
        this.prevTotalConnections = this.hashCompare(this.prevTotalConnections, this.realTotalConnections);
    }

    public void findTotalBytes() {
        this.realTotalBytes = new Hashtable();
        if (this.runSnmpCmdForOid(this.cldeRealTotalBytes)) {
            for (int i = 0; i < this.lhs.length; ++i) {
                this.realTotalBytes.put(this.lhs[i], this.rhs[i]);
            }
        }
        this.prevTotalBytes = this.hashCompare(this.prevTotalBytes, this.realTotalBytes);
    }

    public Hashtable hashCompare(Hashtable hashtable, Hashtable hashtable2) {
        Object k;
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            if (hashtable.containsKey(k)) continue;
            this.getAllLocalDirectors();
            hashtable.put(k, new Long(-1L));
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            if (hashtable2.containsKey(k)) continue;
            hashtable.remove(k);
            if (!this.keyIndexMapping.containsKey(k)) continue;
            String string = (String)this.keyIndexMapping.get(k);
            this.results.remove(string);
        }
        return hashtable;
    }
}

