/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

class LtmDiscTest
extends EgSnmpGenericTest {
    boolean isFirst = true;

    public LtmDiscTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.3375.2.1.7.3.2.1.1");
        if (hashtable2 == null || hashtable2.size() == 0 || hashtable2.isEmpty()) {
            if (this.isFirst) {
                this.logToErrorFile("Error :", "[LtmDiscTest] The specified targetHost is not F5 BIG-IP Traffic Manager.so please manage as F5 BIG-IP for this targetHost:", this.targetHost);
                this.isFirst = false;
            }
            return;
        }
        Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.3375.2.1.7.3.2.1.2");
        Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.3375.2.1.7.3.2.1.3");
        Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.3375.2.1.7.3.2.1.4");
        Enumeration enumeration = hashtable2.keys();
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        double d6 = -5.0;
        double d7 = -5.0;
        double d8 = -5.0;
        double d9 = -5.0;
        double d10 = -5.0;
        double d11 = -5.0;
        double d12 = -5.0;
        double d13 = -5.0;
        while (enumeration.hasMoreElements()) {
            ArrayList<Double> arrayList = new ArrayList<Double>();
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            String string3 = (String)hashtable3.get(string);
            String string4 = (String)hashtable4.get(string);
            String string5 = (String)hashtable5.get(string);
            d = this.getValue(string3);
            d2 = this.getValue(string4);
            d3 = this.getValue(string5);
            if (d2 >= 0.0 && d >= 0.0) {
                d4 = d2 * d;
                d8 = d4 / 1024.0;
                d11 = d8 / 1024.0;
            }
            if (d3 >= 0.0 && d >= 0.0) {
                d5 = d3 * d;
                d9 = d5 / 1024.0;
                d12 = d9 / 1024.0;
            }
            if (d4 > 0.0 && d5 >= 0.0) {
                d6 = d4 - d5;
                d10 = d6 / 1024.0;
                d13 = d10 / 1024.0;
            }
            d7 = d11 > 0.0 && d12 >= 0.0 ? d12 / d11 * 100.0 : -5.0;
            arrayList.add(new Double(d11));
            arrayList.add(new Double(d12));
            arrayList.add(new Double(d13));
            arrayList.add(new Double(d7));
            System.out.println("[LtmDiscTest]info===>" + string2 + "  measure===>" + arrayList);
            this.addNewMeasure(string2, arrayList);
        }
    }

    private double getValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.lhs[i];
                string3 = this.rhs[i];
                hashtable.put(string2, string3);
            }
        } else {
            this.logToErrorFile("Exception", "[LtmDiscTest] Failed to get subtree for the OID:" + string + " at the time:" + new Date() + " from", this.targetHost);
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        LtmDiscTest ltmDiscTest = new LtmDiscTest(stringArray);
        ltmDiscTest.computeMeasures(new Hashtable());
    }
}

