/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

class MPMemoryStatTest
extends EgSnmpGenericTest {
    private static final int MPMEMORYTEST_MEASURE = 4;
    double bytoMB = 1048576.0;

    public MPMemoryStatTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(4);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.5651.3.20.1.1.1.8.0");
            double d2 = this.getMeasure(".1.3.6.1.4.1.5651.3.20.1.1.1.5.0");
            double d3 = -5.0;
            double d4 = -5.0;
            if (d2 >= 0.0 && d > 0.0) {
                d3 = d - d2;
                d4 = Math.round(d2 / d * 100.0);
                d = Math.round(d / this.bytoMB);
                d2 = Math.round(d2 / this.bytoMB);
                d3 = d3 >= 0.0 ? (double)Math.round(d3 / this.bytoMB) : -5.0;
            } else {
                d = -5.0;
                d2 = -5.0;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d4));
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", this.entity + ",Error occur in compute measure", exception.toString());
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                }
            }
        }
        return d;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.8.247", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        MPMemoryStatTest mPMemoryStatTest = new MPMemoryStatTest(stringArray2);
        mPMemoryStatTest.computeMeasures(new Hashtable());
    }
}

