/*
 * Decompiled with CFR 0.152.
 */
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class MSSqlStoreProcBase
extends GenericTest {
    private String driver = "net.sourceforge.jtds.jdbc.Driver";
    private String firstUrl = "jdbc:jtds:sqlserver://";
    private String user = "";
    private String password = "";
    private String db = "";
    private String instance = null;
    private String domain = "none";
    private String ssl = "false";
    private boolean isNTLMv2 = false;
    public String dd_Msg = "";
    private String storedProcName = "";
    private String paramName = "";

    public MSSqlStoreProcBase(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.db = this.getValueForParam("dbname");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.instance = this.getValueForParam("instance");
        this.domain = this.getValueForParam("domain");
        this.ssl = this.getValueForParam("ssl");
        this.storedProcName = this.getValueForParam("storedprocedure");
        this.paramName = this.getValueForParam("paramvalue");
        String string = this.getValueForParam("isntlmv2");
        this.fixedTestPeriod = true;
        if (this.domain == null) {
            this.domain = "none";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        this.isNTLMv2 = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.storedProcName == null || this.storedProcName.length() == 0 || this.paramName == null || this.paramName.length() == 0) {
            this.logToErrorFile(this.entity, " storedProcName =" + this.storedProcName + " or  paramName =" + this.paramName + " is null", " Host IP Address is " + this.targetHost);
            return;
        }
        Connection connection = null;
        connection = this.instance == null ? this.getConnection() : this.getConnection(this.instance);
        if (connection == null) {
            this.logToErrorFile(this.entity, " MsSql db Connection  is null  ", " Host IP Address is  " + this.targetHost);
            return;
        }
        String string = "{call " + this.storedProcName + "(?)}";
        String string2 = "";
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            callableStatement = connection.prepareCall(string);
            callableStatement.setString(1, this.paramName);
            resultSet = callableStatement.executeQuery();
            if (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
                this.dd_Msg = resultSet.getString(2);
            }
            this.closeRs(resultSet);
            this.closeStmt(callableStatement);
            this.close(connection);
        }
        catch (Exception exception) {
            this.logToErrorFile(this.entity, " Failed while executing store procedure ", " Host IP Address is  " + this.targetHost);
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(callableStatement);
            this.close(connection);
        }
        double d = -5.0;
        if (string2 != null && string2.length() > 0) {
            if (string2.equalsIgnoreCase("G")) {
                d = 1.0;
            } else if (string2.equalsIgnoreCase("B")) {
                d = 2.0;
            } else if (string2.equalsIgnoreCase("A")) {
                d = 3.0;
            } else if (string2.equalsIgnoreCase("R")) {
                d = 4.0;
            }
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(d));
        this.addNewMeasure(arrayList);
    }

    private void closeStmt(CallableStatement callableStatement) {
        if (callableStatement != null) {
            try {
                callableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Connection getConnection(String string) {
        String string2 = null;
        try {
            Class.forName(this.driver);
            Properties properties = new Properties();
            if (this.domain != null && !this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
            }
            string2 = string == null || string.length() == 0 || string.equalsIgnoreCase("default") || string.equalsIgnoreCase("none") ? this.firstUrl + this.targetHost + ":" + this.portNo + "/" + this.db : this.firstUrl + this.targetHost + "/" + this.db + ";INSTANCE=" + string;
            if (this.ssl != null && "true".equalsIgnoreCase(this.ssl)) {
                string2 = string2 + ";ssl=request";
            }
            String string3 = new String(string2);
            System.out.println(this.entity + " SQL DB URL  " + string3 + "\tuser =" + this.user);
            Connection connection = this.newConnection(string3, properties);
            if (connection == null) {
                this.logToErrorFile(this.entity, " MsSql db Connection  is null  ", " Host IP Address is  " + this.targetHost);
                return null;
            }
            return connection;
        }
        catch (Exception exception) {
            System.err.println(this.entity + " Failed to establish a MsSql db connection with " + this.targetHost);
            exception.printStackTrace();
            return null;
        }
    }

    private Connection getConnection() {
        try {
            Class.forName(this.driver);
            Properties properties = new Properties();
            if (this.domain != null && !this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
            }
            String string = this.firstUrl + this.targetHost + ":" + this.portNo + "/" + this.db;
            if (this.ssl != null && "true".equalsIgnoreCase(this.ssl)) {
                string = string + ";ssl=request";
            }
            System.out.println(this.entity + " SQL DB URL  " + string + "\tuser =" + this.user);
            String string2 = new String(string);
            Connection connection = this.newConnection(string2, properties);
            if (connection == null) {
                this.logToErrorFile(this.entity, " MsSql db Connection  is null  ", " Host IP Address is  " + this.targetHost);
                return null;
            }
            return connection;
        }
        catch (Exception exception) {
            System.err.println(this.entity + " Failed to establish a MsSql db connection with " + this.targetHost);
            exception.printStackTrace();
            return null;
        }
    }

    private Connection newConnection(String string, Properties properties) throws SQLException {
        Connection connection = null;
        try {
            Driver driver = (Driver)Class.forName("net.sourceforge.jtds.jdbc.Driver").newInstance();
            DriverManager.registerDriver(driver);
            connection = driver.connect(string, properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error  while getting connection for   " + this.entity + "    Test..." + exception.getMessage());
            this.logToErrorFile(this.entity, " MsSql db Connection  is null  ", " Host IP Address is  " + this.targetHost);
            return null;
        }
        return connection;
    }

    public static void main(String[] stringArray) {
        MSSqlStoreProcBase mSSqlStoreProcBase = new MSSqlStoreProcBase(stringArray);
        mSSqlStoreProcBase.computeMeasures(new Hashtable());
    }
}

