/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgTesterInfo;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import netapp.manage.NaAPIFailedException;
import netapp.manage.NaAuthenticationException;
import netapp.manage.NaElement;
import netapp.manage.NaProtocolException;
import netapp.manage.NaServer;

public class NAUSDBase
extends GenericTest {
    private int AuthMech;
    private String user;
    private String password;
    private int APIPort;
    private boolean useSSL;
    private String vFilerName;
    private static final int majorVersion = 1;
    private int minorVersion;
    private int timeout;
    private SimpleDateFormat mySDF;
    protected static final Double NADbl = new Double(-5.0);
    protected static final Double FalseDbl = new Double(0.0);
    protected static final Double TrueDbl = new Double(1.0);
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    public String maxIterRecs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NAUSDBase(String[] stringArray) {
        block25: {
            Object object;
            String string;
            super(stringArray);
            this.useSSL = false;
            this.vFilerName = "none";
            this.minorVersion = 0;
            this.timeout = 120;
            this.mySDF = new SimpleDateFormat("dd/MM/yy hh:mm:ss a");
            this.maxIterRecs = "10";
            if (fieldSep.length() == 0) {
                string = sync0;
                synchronized (string) {
                    if (fieldSep.length() == 0) {
                        object = new EgTesterInfo("agent");
                        fieldSep = ((EgTesterInfo)object).getDDSeparator1();
                    }
                }
            }
            string = this.getValueForParam("Authentication_Mechanism");
            this.AuthMech = 1;
            if (string == null || string.equalsIgnoreCase("LOGIN_PASSWORD")) {
                this.printOut("INFO", "Authentication Mechanism : login/password");
            } else if (string.equalsIgnoreCase("HOSTS.EQUIV FILE")) {
                this.AuthMech = 2;
                this.printOut("INFO", "Authentication Mechanism : hosts.equiv file");
            } else if (string.equalsIgnoreCase("WINDOWS RPC")) {
                this.AuthMech = 3;
                this.printOut("INFO", "Authentication Mechanism : Windows RPC authentication");
            }
            object = this.getValueForParam("Use_SSL");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                this.useSSL = true;
                this.printOut("INFO", "Transport type is HTTPS");
            } else {
                this.useSSL = false;
                this.printOut("INFO", "Transport type is HTTP");
            }
            String string2 = this.getValueForParam("API_Port");
            if (string2 != null && !string2.equalsIgnoreCase("default")) {
                try {
                    this.APIPort = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.useSSL) {
                        this.APIPort = 443;
                        break block25;
                    }
                    this.APIPort = 80;
                }
            } else {
                this.APIPort = this.useSSL ? 443 : 80;
            }
        }
        this.printOut("INFO", "Using API port : " + this.APIPort);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        if (this.AuthMech != 2 && this.user.equalsIgnoreCase("none") && this.password.equalsIgnoreCase("none")) {
            this.logToErrorFile("ERROR", this.entity, "For login/password authentication or Windows RPC authentication, both username and password cannot be 'none'");
            this.printOut("ERROR", "For login/password authentication or Windows RPC authentication, both username and password cannot be 'none'");
        }
        this.vFilerName = this.getValueForParam("vFilerName");
        if (this.vFilerName != null && !this.vFilerName.equalsIgnoreCase("none")) {
            this.printOut("INFO", "Using vFilerName : " + this.vFilerName);
            this.minorVersion = 7;
        }
        String string = this.getValueForParam("timeout(secs)");
        this.printOut("SUPER_DEBUG", "Timeout string is " + string);
        if (string != null && !string.equals("120")) {
            try {
                this.timeout = Integer.parseInt(string);
                this.printOut("INFO", "Timeout in seconds is " + this.timeout);
            }
            catch (NumberFormatException numberFormatException) {
                this.printOut("ERROR", "Could not parse specified timeout " + string + ". Using 120 seconds");
                this.timeout = 120;
            }
        }
        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
        String string3 = egTesterInfo.getValueFor("AGENT_SETTINGS", "MaxIterRecs");
        this.printOut("DEBUG", "maxIterStr is " + string3);
        if (string3 != null && string3.length() > 0) {
            try {
                int n = Integer.parseInt(string3);
                this.maxIterRecs = string3;
                this.printOut("INFO", "Setting Max Iter Recs to " + this.maxIterRecs);
            }
            catch (Exception exception) {
                this.printOut("ERROR", "Error parsing MaxIterRecs value " + string3);
                this.logToErrorFile("ERROR", this.entity, "Error parsing MaxIterRecs value " + string3);
                this.maxIterRecs = "10";
            }
        }
    }

    protected NaServer getConnection() {
        if (this.AuthMech != 2 && this.user.equalsIgnoreCase("none") && this.password.equalsIgnoreCase("none")) {
            this.printOut("ERROR", "Not creating connection due to no user and password being specified");
            return null;
        }
        NaServer naServer = null;
        try {
            naServer = new NaServer(this.targetHost, 1, this.minorVersion);
            this.printOut("DEBUG", "Created NaServer for NA USD at " + this.targetHost + " object with version " + 1 + "." + this.minorVersion);
        }
        catch (UnknownHostException unknownHostException) {
            this.logToErrorFile("ERROR", this.entity, "UnknownHostException upon trying to create server connection to " + this.targetHost + " : " + unknownHostException.toString());
            this.printOut("ERROR", "UnknownHostException upon trying to create server connection to " + this.targetHost + " : " + unknownHostException.toString());
            return null;
        }
        naServer.setStyle(this.AuthMech);
        if (this.AuthMech != 2) {
            naServer.setAdminUser(this.user, this.password);
            this.printOut("DEBUG", "set server admin user");
        }
        if (this.useSSL) {
            naServer.setTransportType(2);
        } else {
            naServer.setTransportType(1);
        }
        if (this.minorVersion == 7) {
            naServer.setVfilerTunneling(this.vFilerName);
        }
        naServer.setPort(this.APIPort);
        naServer.setTimeout(this.timeout);
        if (naServer != null) {
            this.printOut("INFO", "Connection created ");
        }
        return naServer;
    }

    protected NaElement execONTAPI(NaServer naServer, NaElement naElement) {
        this.printOut("DEBUG", "Executing " + naElement.getName() + "." + naElement.getContent());
        NaElement naElement2 = null;
        boolean bl = false;
        String string = "";
        try {
            naElement2 = naServer.invokeElem(naElement);
        }
        catch (NaAuthenticationException naAuthenticationException) {
            string = "username/password is invalid. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + naAuthenticationException.toString();
            bl = true;
        }
        catch (NaAPIFailedException naAPIFailedException) {
            string = "Server returned a failure result. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + naAPIFailedException.toString();
            bl = true;
        }
        catch (NaProtocolException naProtocolException) {
            string = "Protocol issue encountered. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + naProtocolException.toString();
            bl = true;
        }
        catch (IOException iOException) {
            string = "Communication issue encountered. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + iOException.toString();
            bl = true;
        }
        catch (Exception exception) {
            string = "Exception occurred. Could not execute : " + naElement.getName() + "." + naElement.getContent() + " : " + exception.toString();
            bl = true;
        }
        if (!bl && naElement2 == null) {
            string = "No exceptions but output null while executing " + naElement.getName() + "." + naElement.getContent();
            bl = true;
        }
        if (bl) {
            this.logToErrorFile("ERROR", this.entity, string);
            this.printOut("ERROR", string);
            return null;
        }
        return naElement2;
    }

    protected Object execONTAPIlog(NaServer naServer, NaElement naElement) {
        this.printOut("DEBUG", "Executing with output/exception  : " + naElement.getName() + "." + naElement.getContent());
        NaElement naElement2 = null;
        boolean bl = false;
        String string = "";
        try {
            naElement2 = naServer.invokeElem(naElement);
        }
        catch (Exception exception) {
            return exception;
        }
        return naElement2;
    }

    protected void closeConnection(NaServer naServer) {
        if (naServer != null) {
            naServer.close();
            this.printOut("INFO", "Connection closed");
        }
    }

    protected void printOut(String string, String string2) {
        System.out.println("[ " + string + " ] [ " + this.targetHost + " " + this.mySDF.format(new Date()) + "] " + this.entity + " : " + string2);
    }

    protected Double getChildDbl(NaElement naElement, String string) {
        if (naElement == null) {
            this.printOut("DEBUG", "getChildDbl parent Element null for child " + string + ". returning NaDbl");
            return NADbl;
        }
        String string2 = naElement.getChildContent(string);
        Double d = null;
        if (string2 == null) {
            this.printOut("INFO", "Could not find child of name " + string + " in parent element " + naElement.getName());
            return NADbl;
        }
        try {
            d = Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.printOut("ERROR", "Could not parse value '" + string2 + "' for " + naElement.getName() + "." + string);
            d = NADbl;
        }
        return d;
    }

    protected Double getChildBooleanMeas(NaElement naElement, String string) {
        if (naElement == null) {
            this.printOut("DEBUG", "getChildBooleanMeas parent Element null for child " + string + ". returning false");
            return FalseDbl;
        }
        String string2 = naElement.getChildContent(string);
        if (string2.equalsIgnoreCase("true")) {
            return TrueDbl;
        }
        return FalseDbl;
    }

    protected Double calculatePercentage(Object object, Object object2) {
        double d = (Double)object;
        double d2 = (Double)object2;
        if (d2 == 0.0) {
            return NADbl;
        }
        double d3 = d / d2 * 100.0;
        return new Double(d3);
    }

    public Double convertMicroToMilli(Object object) {
        double d = (Double)object;
        if (d == -5.0) {
            return NADbl;
        }
        double d2 = -5.0;
        try {
            d2 = d / 1000.0;
        }
        catch (Exception exception) {
            d2 = -5.0;
        }
        return new Double(d2);
    }

    protected Double divide(Object object, Object object2) {
        double d = (Double)object;
        double d2 = (Double)object2;
        if (d2 > 0.0 && d >= 0.0) {
            double d3 = d / d2;
            return new Double(d3);
        }
        return NADbl;
    }

    protected void addToSortedLists(ArrayList arrayList, ArrayList arrayList2, String string, Double d) {
        int n = arrayList2.size();
        if (n == 0) {
            arrayList.add(string);
            arrayList2.add(d);
            return;
        }
        int n2 = n - 1;
        double d2 = d;
        boolean bl = false;
        for (int i = n2; i > -1; --i) {
            Double d3 = (Double)arrayList2.get(i);
            double d4 = d3;
            if (d2 < d4) {
                arrayList.add(i + 1, string);
                arrayList2.add(i + 1, d);
                bl = true;
                break;
            }
            if (d2 != d4) continue;
            arrayList.add(i, string);
            arrayList2.add(i, d);
            bl = true;
            break;
        }
        if (!bl) {
            arrayList.add(0, string);
            arrayList2.add(0, d);
            bl = true;
        }
    }

    public double convertBytesToMB(double d) {
        double d2 = -5.0;
        try {
            d2 = d / 1048576.0;
        }
        catch (Exception exception) {
            d2 = -5.0;
        }
        return d2;
    }

    public ArrayList getAverageValue(Hashtable hashtable, ArrayList arrayList, int n, int n2, int n3) {
        int n4 = arrayList.size();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        if (arrayList != null && arrayList.size() > 0) {
            String string = "";
            for (int i = n; i <= n2; ++i) {
                double d = 0.0;
                double d2 = 0.0;
                int n5 = 0;
                for (int j = 0; j < n4; ++j) {
                    string = (String)arrayList.get(j);
                    ArrayList arrayList4 = (ArrayList)hashtable.get(string);
                    if (arrayList4 == null || arrayList4.size() <= 0 || (d = ((Double)arrayList4.get(i)).doubleValue()) == -5.0) continue;
                    d2 = d + d2;
                    ++n5;
                }
                double d3 = this.getAverage(d2, n5);
                arrayList2.add(new Double(d3));
            }
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList3.add(new Double(n3));
            for (int i = 1; i < n; ++i) {
                arrayList3.add(NADbl);
            }
            arrayList3.addAll(arrayList2);
        }
        return arrayList3;
    }

    public double getAverage(double d, double d2) {
        double d3 = -5.0;
        try {
            if (d2 > 0.0) {
                d3 = d / d2;
            }
        }
        catch (Exception exception) {
            d3 = -5.0;
        }
        return d3;
    }

    protected double stringtoDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    protected Hashtable getPerfInstance(NaServer naServer, String[] stringArray, String[] stringArray2, String string, String string2) {
        NaElement naElement = new NaElement("perf-object-get-instances-iter-start");
        naElement.addNewChild("objectname", string);
        NaElement naElement2 = new NaElement("counters");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            naElement2.addNewChild("counter", stringArray[i]);
        }
        naElement.addChildElem(naElement2);
        if (stringArray2 != null) {
            NaElement naElement3 = new NaElement("instances");
            n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                naElement3.addNewChild("instance", stringArray2[i]);
            }
            naElement.addChildElem(naElement3);
        }
        return this.getPerfInstance(naServer, stringArray, naElement, string2);
    }

    protected Hashtable getPerfInstance(NaServer naServer, String[] stringArray, NaElement naElement, String string) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, ArrayList> hashtable2 = new Hashtable<String, ArrayList>();
        String string2 = "";
        NaElement naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return hashtable;
        }
        string2 = naElement2.getChildContent("tag");
        String string3 = naElement2.getChildContent("timestamp");
        NaElement naElement3 = null;
        List list = null;
        ArrayList arrayList = null;
        List list2 = null;
        Iterator iterator = null;
        Iterator iterator2 = null;
        String string4 = "";
        naElement = new NaElement("perf-object-get-instances-iter-next");
        naElement.addNewChild("maximum", this.maxIterRecs);
        naElement.addNewChild("tag", string2);
        naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return hashtable;
        }
        int n = naElement2.getChildIntValue("records", 0);
        while (n > 0) {
            naElement3 = naElement2.getChildByName("instances");
            list = naElement3.getChildren();
            iterator = list.iterator();
            arrayList = null;
            list2 = null;
            iterator2 = null;
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string5 = naElement4.getChildContent("name");
                list2 = naElement4.getChildByName("counters").getChildren();
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    naElement4 = (NaElement)iterator2.next();
                    String string6 = naElement4.getChildContent("name");
                    String string7 = naElement4.getChildContent("value");
                    if (string != null && string6.equalsIgnoreCase(string)) {
                        string4 = string7;
                        continue;
                    }
                    hashtable.put(string6, new Double(string7));
                }
                arrayList = this.getPerfList(hashtable, stringArray, string3, string);
                if (string != null && string.length() > 0) {
                    hashtable2.put(string4, arrayList);
                    continue;
                }
                hashtable2.put(string5, arrayList);
            }
            naElement = new NaElement("perf-object-get-instances-iter-next");
            naElement.addNewChild("maximum", this.maxIterRecs);
            naElement.addNewChild("tag", string2);
            naElement2 = this.execONTAPI(naServer, naElement);
            if (naElement2 == null) {
                return hashtable;
            }
            n = naElement2.getChildIntValue("records", 0);
        }
        this.printOut("DEBUG", "finalhash=========>" + hashtable2);
        naElement = new NaElement("perf-object-get-instances-iter-end");
        naElement.addNewChild("tag", string2);
        this.execONTAPI(naServer, naElement);
        return hashtable2;
    }

    protected Hashtable getPerfInstance(NaServer naServer, String[] stringArray, String string, String string2) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, ArrayList> hashtable2 = new Hashtable<String, ArrayList>();
        String string3 = "";
        NaElement naElement = new NaElement("perf-object-get-instances-iter-start");
        naElement.addNewChild("objectname", string);
        NaElement naElement2 = new NaElement("counters");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            naElement2.addNewChild("counter", stringArray[i]);
        }
        naElement.addChildElem(naElement2);
        NaElement naElement3 = this.execONTAPI(naServer, naElement);
        if (naElement3 == null) {
            return hashtable;
        }
        string3 = naElement3.getChildContent("tag");
        String string4 = naElement3.getChildContent("timestamp");
        NaElement naElement4 = null;
        List list = null;
        ArrayList arrayList = null;
        List list2 = null;
        Iterator iterator = null;
        Iterator iterator2 = null;
        String string5 = "";
        naElement = new NaElement("perf-object-get-instances-iter-next");
        naElement.addNewChild("maximum", this.maxIterRecs);
        naElement.addNewChild("tag", string3);
        naElement3 = this.execONTAPI(naServer, naElement);
        if (naElement3 == null) {
            return hashtable;
        }
        int n2 = naElement3.getChildIntValue("records", 0);
        while (n2 > 0) {
            naElement4 = naElement3.getChildByName("instances");
            list = naElement4.getChildren();
            iterator = list.iterator();
            arrayList = null;
            list2 = null;
            iterator2 = null;
            while (iterator.hasNext()) {
                NaElement naElement5 = (NaElement)iterator.next();
                String string6 = naElement5.getChildContent("name");
                list2 = naElement5.getChildByName("counters").getChildren();
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    naElement5 = (NaElement)iterator2.next();
                    String string7 = naElement5.getChildContent("name");
                    String string8 = naElement5.getChildContent("value");
                    if (string2 != null && string7.equalsIgnoreCase(string2)) {
                        string5 = string8;
                        continue;
                    }
                    hashtable.put(string7, new Double(string8));
                }
                arrayList = this.getPerfList(hashtable, stringArray, string4, string2);
                if (string2 != null && string2.length() > 0) {
                    hashtable2.put(string5, arrayList);
                    continue;
                }
                hashtable2.put(string6, arrayList);
            }
            naElement = new NaElement("perf-object-get-instances-iter-next");
            naElement.addNewChild("maximum", this.maxIterRecs);
            naElement.addNewChild("tag", string3);
            naElement3 = this.execONTAPI(naServer, naElement);
            if (naElement3 == null) {
                return hashtable;
            }
            n2 = naElement3.getChildIntValue("records", 0);
        }
        this.printOut("DEBUG", "finalhash=========>" + hashtable2);
        naElement = new NaElement("perf-object-get-instances-iter-end");
        naElement.addNewChild("tag", string3);
        this.execONTAPI(naServer, naElement);
        return hashtable2;
    }

    protected String[] getPerfInstanceList(NaServer naServer, String string) {
        Hashtable hashtable = new Hashtable();
        String string2 = "";
        int n = 50;
        NaElement naElement = new NaElement("perf-object-instance-list-info-iter-start");
        naElement.addNewChild("objectname", string);
        NaElement naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return null;
        }
        string2 = naElement2.getChildContent("tag");
        String string3 = naElement2.getChildContent("records");
        long l = 300L;
        try {
            l = Long.parseLong(string3);
        }
        catch (Exception exception) {
            l = 300L;
        }
        this.printOut("DEBUG_INFO", "records value for start(maxRec) :" + string3);
        NaElement naElement3 = null;
        List list = null;
        Iterator iterator = null;
        Object var14_14 = null;
        String string4 = "";
        naElement = new NaElement("perf-object-instance-list-info-iter-next");
        naElement.addNewChild("maximum", n + "");
        naElement.addNewChild("tag", string2);
        naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return null;
        }
        int n2 = naElement2.getChildIntValue("records", 0);
        this.printOut("DEBUG_INFO", "numRecords  and instArr String array initialized with this initial capacity :" + n2);
        String[] stringArray = null;
        stringArray = new String[(int)l];
        int n3 = 0;
        while (n2 > 0) {
            naElement3 = naElement2.getChildByName("instances");
            list = naElement3.getChildren();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                String string5;
                NaElement naElement4 = (NaElement)iterator.next();
                stringArray[n3] = string5 = naElement4.getChildContent("name");
                ++n3;
            }
            naElement = new NaElement("perf-object-instance-list-info-iter-next");
            naElement.addNewChild("maximum", n + "");
            naElement.addNewChild("tag", string2);
            naElement2 = this.execONTAPI(naServer, naElement);
            if (naElement2 == null) {
                return stringArray;
            }
            n2 = naElement2.getChildIntValue("records", 0);
            this.printOut("DEBUG_INFO", "numRecords inside while loop  :" + n2);
        }
        naElement = new NaElement("perf-object-instance-list-info-iter-end");
        naElement.addNewChild("tag", string2);
        this.execONTAPI(naServer, naElement);
        List<String> list2 = Arrays.asList(stringArray);
        this.printOut("DEBUG", "Instance array for object name " + string + " : " + list2.toString());
        return stringArray;
    }

    private ArrayList getPerfList(Hashtable hashtable, String[] stringArray, String string, String string2) {
        Hashtable hashtable2 = new Hashtable();
        int n = stringArray.length;
        Double d = null;
        String string3 = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(string));
        for (int i = 0; i < n; ++i) {
            string3 = stringArray[i];
            if (string2 != null && string2.equalsIgnoreCase(string3)) continue;
            d = (Double)hashtable.get(string3);
            if (d == null) {
                d = NADbl;
            }
            arrayList.add(d);
        }
        return arrayList;
    }

    protected ArrayList getDiffList(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList2.size() != arrayList.size()) {
            this.printOut("ERROR", "Cannot diff lists of unequal sizes. prev size = " + arrayList2.size() + " and  curr List size " + arrayList.size());
            return null;
        }
        this.printOut("INFO", "getDiffList: prevMeasList is " + arrayList2.toString());
        this.printOut("INFO", "getDiffList: currMeasList is " + arrayList.toString());
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Double d = (Double)arrayList2.get(i);
            Double d2 = (Double)arrayList.get(i);
            if (d.equals(NADbl) || d2.equals(NADbl)) {
                arrayList3.add(NADbl);
                continue;
            }
            double d3 = d;
            double d4 = d2;
            double d5 = d4 - d3;
            if (d5 < 0.0) {
                arrayList3.add(NADbl);
                continue;
            }
            arrayList3.add(new Double(d5));
        }
        this.printOut("INFO", "getDiffList: diffMeasList is " + arrayList3.toString());
        return arrayList3;
    }

    public Hashtable getDDList(ArrayList arrayList, ArrayList arrayList2, String string) {
        Hashtable hashtable = new Hashtable();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            double d = (Double)arrayList2.get(i);
            String string3 = Double.toString(d);
            String string4 = string2 + fieldSep + string3;
            arrayList3.add(string4);
        }
        hashtable.put(string, arrayList3);
        return hashtable;
    }

    protected static ArrayList getDummyList(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(NADbl);
        }
        return arrayList;
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"user_writes"};
        NAUSDBase nAUSDBase = new NAUSDBase(stringArray);
        NaServer naServer = nAUSDBase.getConnection();
        if (naServer == null) {
            return;
        }
        String[] stringArray3 = nAUSDBase.getPerfInstanceList(naServer, "disk");
        nAUSDBase.closeConnection(naServer);
    }
}

