/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

public class NAUSDConsoleLogTest
extends NAUSDBase {
    private static final ArrayList daysList = new ArrayList();
    ArrayList patternArrayList = new ArrayList();
    private final int maxDiffBytes = 999999;
    private final int hexBufferSize = 4004;
    String filePath;
    String searchPattern;
    private int prevFileSize = 0;
    private int currFileSize = 0;
    private Hashtable patternTbl = new Hashtable();
    public Hashtable measDDTbl = new Hashtable();

    public NAUSDConsoleLogTest(String[] stringArray) {
        super(stringArray);
        this.filePath = this.getValueForParam("Syslog_full_path");
        this.searchPattern = this.getValueForParam("searchPattern");
        StringTokenizer stringTokenizer = new StringTokenizer(this.searchPattern, ",");
        String string = null;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n = string.indexOf("=");
            if (n == -1) {
                this.patternArrayList = new ArrayList();
                this.patternArrayList.add(string);
                this.patternTbl.put(string, this.patternArrayList);
                continue;
            }
            this.patternArrayList = new ArrayList();
            String string2 = string.substring(n + 1);
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "*");
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                String string4 = string3.trim();
                this.patternArrayList.add(string4);
            }
            this.patternTbl.put(string.substring(0, n), this.patternArrayList);
        }
        this.isDynamicInfoTest = true;
        this.printOut("DEBUG", "Parsed pattern table is " + this.patternTbl);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    private boolean logHasNewEntries(NaServer naServer) {
        NaElement naElement = new NaElement("file-get-file-info");
        naElement.addNewChild("path", this.filePath);
        NaElement naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return false;
        }
        naElement2 = naElement2.getChildByName("file-info");
        this.currFileSize = naElement2.getChildIntValue("file-size", 0);
        this.printOut("DEBUG", "Previous file size = " + this.prevFileSize + " and current file size = " + this.currFileSize);
        if (this.prevFileSize == 0) {
            this.updatePrevFileSize();
            return false;
        }
        return this.currFileSize != 0 && this.currFileSize != this.prevFileSize;
    }

    private void updatePrevFileSize() {
        this.prevFileSize = this.currFileSize;
    }

    private String convertHexToAscii(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < string.length() - 1; i += 2) {
            String string2 = string.substring(i, i + 2);
            int n = Integer.parseInt(string2, 16);
            stringBuilder.append((char)n);
            stringBuilder2.append(n);
        }
        return stringBuilder.toString();
    }

    private int findFirstLineIdx(String string) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < daysList.size(); ++i) {
            n2 = string.indexOf((String)daysList.get(i));
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        return n == Integer.MAX_VALUE ? 0 : n;
    }

    private ArrayList getLogEntries(NaServer naServer) {
        int n = this.currFileSize - this.prevFileSize;
        if (n < 0) {
            n = this.currFileSize;
        }
        if (n > 999999) {
            this.printOut("DEBUG", "In case of no roll overs and excessive logging, Number of log entries exceeds buffer size. Skipping " + (this.currFileSize - 4004 - this.prevFileSize) + " bytes of log entries");
        }
        int n2 = n > 4004 ? 4004 : n;
        this.printOut("DEBUG", "Going to read " + n2 + " bytes.");
        int n3 = this.currFileSize - n2;
        NaElement naElement = new NaElement("file-read-file");
        naElement.addNewChild("length", Integer.toString(n2));
        naElement.addNewChild("offset", Integer.toString(n3));
        naElement.addNewChild("path", this.filePath);
        this.printOut("DEBUG", "File read -> input params : length = " + n2 + " offset = " + n3 + " path = " + this.filePath);
        NaElement naElement2 = this.execONTAPI(naServer, naElement);
        if (naElement2 == null) {
            return null;
        }
        String string = naElement2.getChildContent("data");
        int n4 = naElement2.getChildIntValue("length", 0);
        if (n4 == 0) {
            this.printOut("DEBUG", "Warning : Tried to read at or past end of log file");
            return null;
        }
        string = this.convertHexToAscii(string);
        this.printOut("SUPER_DEBUG", "Raw log entries " + string);
        int n5 = this.findFirstLineIdx(string);
        string = string.substring(n5);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.printOut("SUPER_DEBUG", "Parsed log lines = ");
        this.printOut("SUPER_DEBUG", arrayList.toString());
        return arrayList;
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        ArrayList<Double> arrayList;
        NaServer naServer = this.getConnection();
        if (naServer == null) {
            return;
        }
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        String string = null;
        Object var7_6 = null;
        String string2 = null;
        Enumeration enumeration = this.patternTbl.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable2.put(string, new Double(0.0));
            this.measDDTbl.put(string, new ArrayList());
        }
        if (this.logHasNewEntries(naServer)) {
            arrayList = this.getLogEntries(naServer);
            if (arrayList == null) {
                this.updatePrevFileSize();
                this.closeConnection(naServer);
                return;
            }
            int n = 0;
            double d = 0.0;
            ArrayList arrayList2 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                string2 = (String)arrayList.get(i);
                int n2 = -1;
                int n3 = 0;
                boolean bl2 = false;
                enumeration = this.patternTbl.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    string = string.trim();
                    this.patternArrayList = (ArrayList)this.patternTbl.get(string);
                    for (int j = 0; j < this.patternArrayList.size(); ++j) {
                        String string3 = (String)this.patternArrayList.get(j);
                        n3 = string2.indexOf(string3 = string3.trim());
                        if (n3 <= n2) {
                            bl2 = false;
                            n = -1;
                            break;
                        }
                        n2 = n3;
                        n = 0;
                        bl2 = true;
                    }
                    if (bl2) {
                        System.out.println("All Patterns are matching :");
                        System.out.println("Pattern name  :" + string);
                        System.out.println("Log line   :" + string2);
                    }
                    if (n == -1) continue;
                    this.printOut("DEBUG", ">> Match for " + string + " in " + string2);
                    d = (Double)hashtable2.get(string);
                    hashtable2.put(string, new Double(d += 1.0));
                    arrayList2 = (ArrayList)this.measDDTbl.get(string);
                    arrayList2.add(string2);
                }
            }
        } else {
            this.printOut("DEBUG", "No new log file entries or error determining log file size or first run of this test");
        }
        this.printOut("DEBUG", "Measure output : ");
        enumeration = hashtable2.keys();
        arrayList = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Double d = (Double)hashtable2.get(string);
            this.printOut("DEBUG", string + " had " + d.toString() + " matches.");
            arrayList = new ArrayList<Double>();
            arrayList.add(d);
            if (bl) continue;
            this.addNewMeasure(string, arrayList);
        }
        this.updatePrevFileSize();
        this.closeConnection(naServer);
    }

    public void freeTest() {
        this.measDDTbl = new Hashtable();
    }

    public static void main(String[] stringArray) {
        NAUSDConsoleLogTest nAUSDConsoleLogTest = new NAUSDConsoleLogTest(stringArray);
        nAUSDConsoleLogTest.debugComputeMeasures(new Hashtable(), true);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        nAUSDConsoleLogTest.debugComputeMeasures(new Hashtable(), true);
    }

    static {
        daysList.add("\nSun ");
        daysList.add("\nMon ");
        daysList.add("\nTue ");
        daysList.add("\nWed ");
        daysList.add("\nThu ");
        daysList.add("\nFri ");
        daysList.add("\nSat ");
    }
}

