/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMNodeComponentIDRepository;
import com.eg.apm.AgentNodeSocketServer;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeDataRepository;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public abstract class NodeBase
extends GenericTest {
    public NodeInfo NodeInfo = null;
    protected ArrayList propsList = new ArrayList();
    private static final int Node_DEFAULT_PORT = 3000;
    private static final String Node_DEFAULT_IP = "127.0.0.1";
    protected static final Logger logger = NodeBTMLogger.nodeLogger;
    protected String logPrefix = " [" + this.reportingName + ":" + this.portNo + "] [" + this.entity + "] ";
    protected String siteID = null;
    private boolean isFirstTime = true;
    private HashMap props = new HashMap();

    public NodeBase(String[] args) {
        super(args);
        this.siteID = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            boolean isMeasureChanged = false;
            if (NodeDataRepository.isMeasureTimeExists(this.siteID)) {
                if (NodeDataRepository.getMeasureTimeByID(this.siteID) != this.measurePeriod) {
                    isMeasureChanged = true;
                    NodeDataRepository.setMeasureTimeByID(this.siteID, this.measurePeriod, isMeasureChanged);
                    logger.info("{} Measure period changed ...{}", (Object)this.logPrefix, (Object)this.measurePeriod);
                }
            } else {
                NodeDataRepository.setMeasureTimeByID(this.siteID, this.measurePeriod, isMeasureChanged);
                logger.info("{} Measure period: {} initialized in NodeRepo period", (Object)this.logPrefix, (Object)this.measurePeriod);
            }
            if (!APMNodeComponentIDRepository.isSiteIdAvailable(this.siteID)) {
                APMNodeComponentIDRepository.registerComponentID(this.siteID, this.entity);
                APMNodeComponentIDRepository.registerIntoOffloadComponentIDTable(this.siteID);
                logger.trace("{} Component id is registered in to the repo id: {}", (Object)this.logPrefix, (Object)this.siteID);
            }
        }
        catch (Exception e) {
            logger.error("{} Measure period initialize error in node base {}", (Object)this.logPrefix, (Object)e);
        }
        boolean btmSocketServerStarted = false;
        try {
            logger.info("{} Initializing NodeBase ...", (Object)this.logPrefix);
            this.NodeInfo = new NodeInfo(this.reportingName);
            try {
                btmSocketServerStarted = AgentNodeSocketServer.isServerSocketCreated();
            }
            catch (Exception e) {
                logger.error("{} Error while checking socket is opened {}", (Object)this.logPrefix, (Object)e);
            }
            BTMOffloadAPMSocketConfiguration configuration = BTMOffloadAPMSocketConfiguration.getBTMOffloadAPMSocketConfiguration("eg_agentTests.ini");
            if (!btmSocketServerStarted) {
                logger.info("{} Opening the port for nodejs client...", (Object)this.logPrefix);
                AgentNodeSocketServer.startServer(configuration);
                btmSocketServerStarted = true;
            } else {
                logger.debug("{} Agent-offload socket port already in open", (Object)this.logPrefix);
            }
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info("{} Node IPAddress is null or empty or none : {}", (Object)this.logPrefix, (Object)this.targetHost);
                logger.info("{} Using Default Node IPAddress : {}", (Object)this.logPrefix, (Object)Node_DEFAULT_IP);
                this.NodeInfo.setNodeIp(Node_DEFAULT_IP);
            } else {
                logger.info("{} Using Node IPAddress : {}", (Object)this.logPrefix, (Object)this.targetHost);
                this.NodeInfo.setNodeIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info("{} Node Port is null or empty or none : {}", (Object)this.logPrefix, (Object)this.portNo);
                logger.info("{} Using Default Node port : {}", (Object)this.logPrefix, (Object)3000);
                this.NodeInfo.setNodePort(3000);
            } else {
                try {
                    int NodePort = Integer.parseInt(this.portNo);
                    logger.info("{} Using Node Port : {}", (Object)this.logPrefix, (Object)NodePort);
                    this.NodeInfo.setNodePort(NodePort);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info("{} Invalid Node port number : {}", (Object)this.logPrefix, (Object)this.portNo);
                    logger.info("{} Using Default Node port : {}", (Object)this.logPrefix, (Object)3000);
                    this.NodeInfo.setNodePort(3000);
                }
            }
            logger.info("{} NodeBase initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception e) {
            logger.error("{} Exception while initializing NodeBase {}", (Object)this.logPrefix, (Object)e);
        }
    }

    void checkForPropsChanges(String[] propsOrder) {
        try {
            HashMap currentPropsTable = new HashMap();
            HashMap modifiedPropsTable = new HashMap();
            HashMap previousPropsTable = new HashMap();
            Object propsValuesByOrder = null;
            if (this.isFirstTime) {
                modifiedPropsTable = this.getProps(propsOrder);
                this.isFirstTime = false;
            } else {
                previousPropsTable = this.props;
                currentPropsTable = this.getProps(propsOrder);
                modifiedPropsTable = this.getModifiedProps(currentPropsTable, previousPropsTable);
                NodeBTMLogger.nodeLogger.debug("{}  currentPropsTable: {}", (Object)this.logPrefix, (Object)currentPropsTable);
                NodeBTMLogger.nodeLogger.debug("{} previousPropsTable: {} ", (Object)this.logPrefix, (Object)previousPropsTable);
                NodeBTMLogger.nodeLogger.debug("{}  modifiedPropsTable: {}", (Object)this.logPrefix, (Object)modifiedPropsTable);
            }
            if (modifiedPropsTable != null && modifiedPropsTable.size() > 0) {
                APMNodeComponentIDRepository.registerNewProps(String.valueOf(this.siteID) + "-" + this.entity, modifiedPropsTable);
            } else {
                NodeBTMLogger.nodeLogger.debug("{}  No difference in props table:", (Object)this.logPrefix);
            }
            this.props = currentPropsTable;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap getProps(String[] propsOrder) {
        HashMap<String, String> propsdata = new HashMap<String, String>();
        int i = 0;
        while (i < propsOrder.length) {
            String testConfValue = this.getValueForParam(propsOrder[i]);
            if (testConfValue != null) {
                propsdata.put(propsOrder[i], testConfValue);
            } else {
                propsdata.put(propsOrder[i], "-");
            }
            ++i;
        }
        return propsdata;
    }

    protected HashMap getModifiedProps(HashMap currentPropsTable, HashMap previousPropsTable) {
        HashMap<String, String> resultTable = new HashMap<String, String>();
        NodeBTMLogger.nodeLogger.debug("{} - getModifiedProps : currentTable: {}  \t  previousTable : {}", new Object[]{this.logPrefix, currentPropsTable, previousPropsTable});
        if (currentPropsTable != null && currentPropsTable.size() > 0) {
            Set currentKeySet = currentPropsTable.keySet();
            for (String currentKey : currentKeySet) {
                String currentValue = (String)currentPropsTable.get(currentKey);
                if (previousPropsTable.containsKey(currentKey)) {
                    String previousValue = (String)previousPropsTable.get(currentKey);
                    if (currentValue.equals(previousValue)) continue;
                    resultTable.put(currentKey, currentValue);
                    continue;
                }
                resultTable.put(currentKey, currentValue);
            }
        }
        return resultTable;
    }
}

