/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeCPU;
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class NodeCPUTest
extends NodeBase {
    public static final String[] propsOrder = new String[]{"enable_cpu_profiling", "cpu_profiling_duration_(ms)", "cpu_dump_location"};
    private HashMap workers = null;
    private ArrayList<String> CpuDumpFilesList;

    public NodeCPUTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        try {
            logger.info("{} Initializing NodeCPUTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeCPUTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.error("{} Exception while initializing {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String string = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            ArrayList<Double> arrayList;
            logger.debug("{} -params {}", (Object)this.logPrefix, (Object)hashtable.toString());
            this.checkForPropsChanges(propsOrder);
            if (!NodeDataRepository.isInfraIdExists(string)) {
                logger.debug("{} siteId: {} is not available", (Object)this.logPrefix, (Object)string);
                return;
            }
            int n = 0;
            if (NodeDataRepository.isInfraIdExists(string)) {
                n = NodeDataRepository.getInfraById(string).getWorkerCount();
            }
            NodeInfraCluster nodeInfraCluster = NodeDataRepository.getInfraById(string);
            NodeInfra nodeInfra = nodeInfraCluster.getMaster();
            try {
                this.CpuDumpFilesList = nodeInfraCluster.cloneCpuDumpList();
                nodeInfraCluster.clearCpuDumpList();
                logger.debug("{} siteId: {}  dump file list : {}", new Object[]{this.logPrefix, string, this.CpuDumpFilesList});
            }
            catch (Exception exception) {
                logger.error("{} siteId: {} error while collecting the dump file list {}", new Object[]{this.logPrefix, string, exception});
            }
            NodeCPU nodeCPU = null;
            if (nodeInfra != null) {
                nodeCPU = nodeInfra.getCpuUsage();
            }
            if (nodeCPU != null) {
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(nodeCPU.getUserPct()));
                arrayList.add(new Double(nodeCPU.getSystemPct()));
                arrayList.add(new Double(nodeCPU.getUserTime()));
                arrayList.add(new Double(nodeCPU.getSystemTime()));
                arrayList.add(new Double(-5.0));
                if (n > 0) {
                    this.addNewMeasure("Master", arrayList);
                } else {
                    this.addNewMeasure(arrayList);
                }
                nodeInfra.setCpuUsage(null);
                logger.debug("{} Master - measures: {}", (Object)this.logPrefix, arrayList);
            } else {
                logger.debug("{}  {} Master - measure is null", (Object)this.logPrefix, (Object)string);
            }
            this.workers = nodeInfraCluster.getWorkers();
            if (this.workers != null && this.workers.size() > 0) {
                nodeCPU = NodeDataRepository.aggregateCPU(this.workers);
                if (nodeCPU != null) {
                    arrayList = new ArrayList();
                    arrayList.add(new Double(nodeCPU.getUserPct()));
                    arrayList.add(new Double(nodeCPU.getSystemPct()));
                    arrayList.add(new Double(nodeCPU.getUserTime()));
                    arrayList.add(new Double(nodeCPU.getSystemTime()));
                    arrayList.add(new Double(nodeInfraCluster.getWorkerCount()));
                    this.addNewMeasure("Workers", arrayList);
                    logger.debug("{} Worker - measures: {}", (Object)this.logPrefix, arrayList);
                } else {
                    logger.debug("{} Worker - aggregated cpu usage is null", (Object)string);
                }
            } else {
                logger.debug("{} {} Worker - measure is null", (Object)this.logPrefix, (Object)string);
            }
        }
        catch (Exception exception) {
            logger.error("{} Exception occurred while collecting Node cpu object : {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public HashMap getWorkers() {
        return this.workers;
    }

    public void setWorkers(HashMap hashMap) {
        this.workers = hashMap;
    }

    public ArrayList<String> getCpuDumpFilesList() {
        return this.CpuDumpFilesList;
    }

    public void setCpuDumpFilesList(ArrayList<String> arrayList) {
        this.CpuDumpFilesList = arrayList;
    }
}

