/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class NsTcpTest
extends EgSnmpGenericTest {
    private static String runOid = ".1.3.6.1.4.1.5951.4.1.1.46";
    private static int numMeasures = 17;
    private static double bToMb = 1048576.0;
    private double prevRxBytes = -1.0;
    private double prevTxBytes = -1.0;
    private double prevServerConns = -1.0;
    private double prevClientConns = -1.0;
    private double prevSynGiveUps = -1.0;
    private double prevSynRetry = -1.0;
    private double prevClientRetries = -1.0;
    private double prevServerRetries = -1.0;
    private double prevReXmits = -1.0;
    private double prevRexmitGiveups = -1.0;

    public NsTcpTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
    }

    private double getValue() {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private void reinit() {
        this.prevRxBytes = -1.0;
        this.prevTxBytes = -1.0;
        this.prevServerConns = -1.0;
        this.prevClientConns = -1.0;
        this.prevSynGiveUps = -1.0;
        this.prevSynRetry = -1.0;
        this.prevClientRetries = -1.0;
        this.prevServerRetries = -1.0;
        this.prevReXmits = -1.0;
        this.prevRexmitGiveups = -1.0;
    }

    public void computeMeasures(Hashtable hashtable) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        double[] dArray = new double[numMeasures];
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = -5.0;
        }
        if (!this.runSnmpCmdForOid(runOid)) {
            this.reinit();
            return;
        }
        if (this.rhs == null || this.lhs == null) {
            this.reinit();
            return;
        }
        for (n = 0; n < this.lhs.length; ++n) {
            if (this.lhs[n].startsWith("1.")) {
                dArray[0] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("2.")) {
                dArray[1] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("8.")) {
                dArray[2] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("10.")) {
                dArray[3] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("12.")) {
                dArray[4] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("14.")) {
                dArray[5] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("15.")) {
                dArray[6] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("17.")) {
                dArray[7] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("19.")) {
                dArray[8] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("62.")) {
                dArray[9] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("64.")) {
                dArray[10] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("37.")) {
                dArray[11] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("39.")) {
                dArray[12] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("48.")) {
                dArray[13] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("47.")) {
                dArray[14] = this.getValue(n);
                continue;
            }
            if (this.lhs[n].startsWith("59.")) {
                dArray[15] = this.getValue(n);
                continue;
            }
            if (!this.lhs[n].startsWith("60.")) continue;
            dArray[16] = this.getValue(n);
        }
        if (dArray[9] >= 0.0) {
            if (this.prevRxBytes >= 0.0) {
                double d = dArray[9] - this.prevRxBytes;
                this.prevRxBytes = dArray[9];
                double d2 = dArray[9] = d >= 0.0 ? d : -5.0;
                if (dArray[9] > 0.0) {
                    dArray[9] = dArray[9] / bToMb;
                }
            } else {
                this.prevRxBytes = dArray[9];
                dArray[9] = -5.0;
            }
        }
        if (dArray[10] >= 0.0) {
            if (this.prevTxBytes >= 0.0) {
                double d = dArray[10] - this.prevTxBytes;
                this.prevTxBytes = dArray[10];
                double d3 = dArray[10] = d >= 0.0 ? d : -5.0;
                if (dArray[10] > 0.0) {
                    dArray[10] = dArray[10] / bToMb;
                }
            } else {
                this.prevTxBytes = dArray[10];
                dArray[10] = -5.0;
            }
        }
        if (dArray[7] >= 0.0) {
            if (this.prevServerConns >= 0.0) {
                double d = dArray[7] - this.prevServerConns;
                this.prevServerConns = dArray[7];
                dArray[7] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevServerConns = dArray[7];
                dArray[7] = -5.0;
            }
        }
        if (dArray[8] >= 0.0) {
            if (this.prevClientConns >= 0.0) {
                double d = dArray[8] - this.prevClientConns;
                this.prevClientConns = dArray[8];
                dArray[8] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevClientConns = dArray[8];
                dArray[8] = -5.0;
            }
        }
        if (dArray[11] >= 0.0) {
            if (this.prevSynGiveUps >= 0.0) {
                double d = dArray[11] - this.prevSynGiveUps;
                this.prevSynGiveUps = dArray[11];
                dArray[11] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevSynGiveUps = dArray[11];
                dArray[11] = -5.0;
            }
        }
        if (dArray[12] >= 0.0) {
            if (this.prevSynRetry >= 0.0) {
                double d = dArray[12] - this.prevSynRetry;
                this.prevSynRetry = dArray[12];
                dArray[12] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevSynRetry = dArray[12];
                dArray[12] = -5.0;
            }
        }
        if (dArray[13] >= 0.0) {
            if (this.prevClientRetries >= 0.0) {
                double d = dArray[13] - this.prevClientRetries;
                this.prevClientRetries = dArray[13];
                dArray[13] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevClientRetries = dArray[13];
                dArray[13] = -5.0;
            }
        }
        if (dArray[14] >= 0.0) {
            if (this.prevServerRetries >= 0.0) {
                double d = dArray[14] - this.prevServerRetries;
                this.prevServerRetries = dArray[14];
                dArray[14] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevServerRetries = dArray[14];
                dArray[14] = -5.0;
            }
        }
        if (dArray[15] >= 0.0) {
            if (this.prevReXmits >= 0.0) {
                double d = dArray[15] - this.prevReXmits;
                this.prevReXmits = dArray[15];
                dArray[15] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevReXmits = dArray[15];
                dArray[15] = -5.0;
            }
        }
        if (dArray[16] >= 0.0) {
            if (this.prevRexmitGiveups >= 0.0) {
                double d = dArray[16] - this.prevRexmitGiveups;
                this.prevRexmitGiveups = dArray[16];
                dArray[16] = d >= 0.0 ? d : -5.0;
            } else {
                this.prevRexmitGiveups = dArray[16];
                dArray[16] = -5.0;
            }
        }
        for (int i = 0; i < dArray.length; ++i) {
            arrayList.add(new Double(dArray[i]));
        }
        this.addNewMeasure(arrayList);
    }
}

