/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraDBFileStTest
extends GenericTest {
    private static final int dbMeasureCount = 2;
    private String orclSID = "";
    private String user = "";
    private String password = "";
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private ArrayList measureList;
    private ArrayList statusArrayList;
    private ArrayList modeArrayList;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraDBFileStTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.orclSID = this.getValueForParam("info");
        String string = this.getValueForParam("cloud_hosted");
        if (this.orclSID == null) {
            this.orclSID = this.getValueForParam("oracle_sid");
        }
        this.isNewDynamicInfoTest = true;
        if (this.orclSID == null || this.orclSID.equalsIgnoreCase("NULL") || this.orclSID.equalsIgnoreCase("none")) {
            this.orclSID = "";
        }
        if (this.user == null || this.user.equalsIgnoreCase("NULL") || this.user.equalsIgnoreCase("none")) {
            this.user = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.orclSID);
        }
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.statusArrayList = new ArrayList();
        this.statusArrayList.add("OFFLINE");
        this.statusArrayList.add("SYSTEM");
        this.statusArrayList.add("ONLINE");
        this.statusArrayList.add("RECOVER");
        this.modeArrayList = new ArrayList();
        this.modeArrayList.add("DISABLED");
        this.modeArrayList.add("READ ONLY");
        this.modeArrayList.add("READ WRITE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.orclSID);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                this.logToErrorFile("Error  :", this.entity, "Failed to find the Oracle version detail for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID);
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.orclSID);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string2 = "select file#, name,status, enabled as access_mode from v$datafile";
        if (this.isMultitenantDb) {
            if (this.isCDB) {
                if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", "OraDBfileStTest doesnot run for CDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                return;
            }
            string2 = "select file#, name,status, enabled as access_mode from v$datafile where con_id > 0";
            object2 = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug);
        } else {
            object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.orclSID, this.user, this.password, debug);
        }
        if (object2 == null) {
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID);
            return;
        }
        try {
            statement = object2.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraDBFileStTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID, exception.toString());
            exception.printStackTrace();
            this.closeConn((Connection)object2);
            return;
        }
        try {
            try {
                System.out.println("[OraDBFileStTest ] Used Query is : " + string2);
                object = statement.executeQuery(string2);
                while (object.next()) {
                    string = object.getString(1).trim();
                    string3 = object.getString(2).trim();
                    string4 = object.getString(3).trim().toUpperCase();
                    string5 = object.getString(4).trim().toUpperCase();
                    this.measureList = new ArrayList();
                    int n = this.statusCheck(string4);
                    int n2 = this.access_modeCheck(string5);
                    this.measureList.add(new Double(n));
                    this.measureList.add(new Double(n2));
                    System.out.println("[OraDBFileStTest] DBF name  " + string3 + "\t Measures " + this.measureList);
                    this.addNewMeasure(string3, this.measureList);
                }
                Object var13_16 = null;
                if (object != null) {
                    this.closeRs((ResultSet)object);
                }
                if (statement != null) {
                    this.closeStmt(statement);
                }
                if (object2 != null) {
                    this.closeConn((Connection)object2);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", " OraDBfileStTest computeMeasures() reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.orclSID, exception.toString());
                exception.printStackTrace();
                Object var13_17 = null;
                if (object != null) {
                    this.closeRs((ResultSet)object);
                }
                if (statement != null) {
                    this.closeStmt(statement);
                }
                if (object2 != null) {
                    this.closeConn((Connection)object2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (object != null) {
                this.closeRs((ResultSet)object);
            }
            if (statement != null) {
                this.closeStmt(statement);
            }
            if (object2 != null) {
                this.closeConn((Connection)object2);
            }
            throw throwable;
        }
    }

    private int statusCheck(String string) {
        int n = this.statusArrayList.indexOf(string);
        if (n == -1) {
            n = 4;
        } else if (n <= -1 || n > 3) {
            n = 4;
        }
        System.out.println("[OraDBFileStTest] Oracle DBF Status value is   :" + n);
        return n;
    }

    private int access_modeCheck(String string) {
        int n = this.modeArrayList.indexOf(string);
        if (n == -1) {
            n = 3;
        } else if (n <= -1 || n > 2) {
            n = 3;
        }
        System.out.println("[OraDBFileStTest] oracle DBF Access Mode Value is     :" + n);
        return n;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraDBFileStTest oraDBFileStTest = new OraDBFileStTest(stringArray);
        oraDBFileStTest.computeMeasures(new Hashtable());
    }
}

