/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class OraTableSpaceTest
extends EgTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private ArrayList tableSpaceNames = new ArrayList();
    private ArrayList prevPhysReads = new ArrayList();
    private ArrayList prevPhysWrites = new ArrayList();
    private String queryStmt;
    private int pctUsedIndex = 0;
    private int physReadRateIndex = 1;
    private int physWriteRateIndex = 2;
    private String index;

    public static void main(String[] stringArray) {
        OraTableSpaceTest oraTableSpaceTest = new OraTableSpaceTest(stringArray);
        oraTableSpaceTest.executeTest();
    }

    public OraTableSpaceTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 3;
        if (stringArray.length < 2 || !stringArray[0].equalsIgnoreCase("-host")) {
            System.err.println("Usage: OraTableSpaceTest -host <hostName> -port <portNo> -sid <sidName> -user <userName> -password <passwd>");
            System.exit(-1);
        }
        this.targetHost = new String(stringArray[1]);
        this.portNo = new String("1521");
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("-port")) {
                    if (++i < stringArray.length) {
                        this.portNo = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: OraTableSpaceTest -host <hostName> -port <portNo> -sid <sidName> -user <userName> -password <passwd>");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-sid") || stringArray[i].equalsIgnoreCase("-info")) {
                    if (++i < stringArray.length) {
                        this.sid = this.oraSid = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: OraTableSpaceTest -host <hostName> -port <portNo> -sid <sidName> -user <userName> -password <passwd>");
                    return;
                }
                if (stringArray[i].equalsIgnoreCase("-user")) {
                    if (++i < stringArray.length) {
                        this.userName = new String(stringArray[i]);
                        continue;
                    }
                    System.err.println("Usage: OraTableSpaceTest -host <hostName> -port <portNo> -sid <sidName> -user <userName> -password <passwd>");
                    return;
                }
                if (!stringArray[i].equalsIgnoreCase("-password")) continue;
                if (++i < stringArray.length) {
                    this.userPasswd = new String(stringArray[i]);
                    continue;
                }
                System.err.println("Usage: OraTableSpaceTest -host <hostName> -port <portNo> -sid <sidName> -user <userName> -password <passwd>");
                return;
            }
        }
        this.queryStmt = "SELECT X.NAME,Y.PCT_FREE, Y.PCT_USED, X.PHYSICAL_READS, X.PHYSICAL_WRITES FROM ( SELECT TS.TS#, TS.NAME, SUM(FS.PHYRDS) AS PHYSICAL_READS, SUM(FS.PHYWRTS) AS PHYSICAL_WRITES FROM V$FILESTAT FS, V$DATAFILE DF, V$TABLESPACE TS, DBA_DATA_FILES DDF WHERE FS.FILE#=DF.FILE# AND DDF.FILE_ID=DF.FILE# AND DDF.TABLESPACE_NAME=TS.NAME GROUP BY TS.TS#, TS.NAME ) X, ( SELECT TABLESPACE_NAME, NVL(100*SUM_FREE_BLOCKS/SUM_ALLOC_BLOCKS,0) AS PCT_FREE, NVL(100 - 100*SUM_FREE_BLOCKS/SUM_ALLOC_BLOCKS,100) AS PCT_USED FROM (SELECT TABLESPACE_NAME, SUM(BLOCKS) AS SUM_ALLOC_BLOCKS FROM DBA_DATA_FILES GROUP BY TABLESPACE_NAME), (SELECT TABLESPACE_NAME AS FS_TS_NAME, MAX(BLOCKS) AS MAX_BLOCKS, COUNT(BLOCKS) AS COUNT_BLOCKS, SUM(BLOCKS) AS SUM_FREE_BLOCKS FROM DBA_FREE_SPACE  GROUP BY TABLESPACE_NAME) WHERE TABLESPACE_NAME = FS_TS_NAME (+)) Y WHERE X.NAME = Y.TABLESPACE_NAME ";
    }

    public boolean executeTest() {
        this.initTest();
        Connection connection = null;
        Object var9_2 = null;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            String string = new String("jdbc:oracle:thin:@" + this.targetHost + ":" + this.portNo + ":" + this.oraSid);
            connection = DriverManager.getConnection(string, this.userName, this.userPasswd);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.queryStmt);
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                this.index = new String(this.siteName + siteAndInfoSeparator + this.oraSid + EgConfigInfo.infoFieldSeparator + string2);
                float f = resultSet.getFloat(2);
                float f2 = resultSet.getFloat(3);
                double d = resultSet.getDouble(4);
                double d2 = resultSet.getDouble(5);
                this.addValueToResultSet(this.index, this.pctUsedIndex, f2);
                int n = this.tableSpaceNames.indexOf(string2);
                if (n == -1) {
                    this.tableSpaceNames.add(string2);
                    this.prevPhysReads.add(new Double(d));
                    this.prevPhysWrites.add(new Double(d2));
                    this.addValueToResultSet(this.index, this.physReadRateIndex, -1.0);
                    this.addValueToResultSet(this.index, this.physWriteRateIndex, -1.0);
                    continue;
                }
                if (this.timeSinceLastTest < 0.0) {
                    this.prevPhysReads.set(n, new Double(d));
                    this.prevPhysWrites.set(n, new Double(d2));
                    this.addValueToResultSet(this.index, this.physReadRateIndex, -1.0);
                    this.addValueToResultSet(this.index, this.physWriteRateIndex, -1.0);
                    continue;
                }
                Double d3 = (Double)this.prevPhysReads.get(n);
                double d4 = d3;
                d3 = (Double)this.prevPhysWrites.get(n);
                double d5 = d3;
                double d6 = (d - d4) / this.timeSinceLastTest;
                d6 = d6 < 0.0 ? -1.0 : d6;
                double d7 = (d2 - d5) / this.timeSinceLastTest;
                d7 = d7 < 0.0 ? -1.0 : d7;
                this.addValueToResultSet(this.index, this.physReadRateIndex, d6);
                this.addValueToResultSet(this.index, this.physWriteRateIndex, d7);
                this.prevPhysReads.set(n, new Double(d));
                this.prevPhysWrites.set(n, new Double(d2));
            }
            resultSet.close();
            statement.close();
            connection.close();
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                connection.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.updateAllResultSets();
            this.errorMsg = new String("Exception while executing OraTableSpaceTest for target: " + this.targetHost);
            return false;
        }
    }
}

