/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class OraTablespacesTest
extends GenericTest {
    private String oraSid;
    private String userName;
    private String userPasswd;
    private String mode = "All";
    private String viewName;
    private ArrayList tableSpaceNames = new ArrayList();
    private ArrayList prevPhysReads = new ArrayList();
    private ArrayList prevPhysWrites = new ArrayList();
    private String query1 = null;
    private String query2 = null;
    private String query3 = null;
    private String query4 = null;
    private boolean isExternal = false;
    private static double bToMb = 1048576.0;
    private static double kbToMb = 1024.0;
    private double defValue = -1.0;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public static void main(String[] stringArray) {
        OraTablespacesTest oraTablespacesTest = new OraTablespacesTest(stringArray);
        oraTablespacesTest.computeMeasures(new Hashtable());
    }

    public OraTablespacesTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.userName = this.getValueForParam("username");
        if (this.userName == null) {
            this.userName = this.getValueForParam("user");
        }
        this.userPasswd = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        this.mode = this.getValueForParam("mode");
        this.viewName = this.getValueForParam("alternate_view");
        String string = this.getValueForParam("isCluster");
        if (string == null) {
            string = this.getValueForParam("isExternal");
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"))) {
            this.isExternal = true;
        }
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string2 = this.getValueForParam("cloud_hosted");
        if (this.userName == null || this.userName.equalsIgnoreCase("NULL") || this.userName.equalsIgnoreCase("none")) {
            this.userName = "";
        }
        if (this.userPasswd == null || this.userPasswd.equalsIgnoreCase("NULL") || this.userPasswd.equalsIgnoreCase("none")) {
            this.userPasswd = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string2 != null && (string2.trim().equalsIgnoreCase("true") || string2.trim().equalsIgnoreCase("yes") || string2.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isExternal && this.isOracleOnCloud) {
            this.isExternal = this.isOracleOnCloud;
        }
        if (!this.isExternal) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        String string3 = "";
        string3 = this.mode != null && this.mode.equalsIgnoreCase("All") ? "" : (this.mode != null && this.mode.equalsIgnoreCase("Read/Write") ? " and ts.status = 'ONLINE' " : (this.mode != null && this.mode.equalsIgnoreCase("ReadOnly") ? " and ts.status = 'READ ONLY' " : ""));
        this.query1 = " SELECT TS.NAME,SUM(FS.PHYRDS) AS PHYSICAL_READS,SUM(FS.PHYWRTS) AS PHYSICAL_WRITES FROM V$FILESTAT FS,V$DATAFILE DF,V$TABLESPACE TS,DBA_DATA_FILES DDF WHERE FS.FILE#=DF.FILE# AND \tDDF.FILE_ID=DF.FILE# AND \tDDF.TABLESPACE_NAME=TS.NAME GROUP BY  TS.NAME ";
        this.query3 = "SELECT   TABLESPACE_NAME, MAX(AUTOEXTENSIBLE) AS AUTOEXTENSIBLE  FROM DBA_DATA_FILES GROUP BY TABLESPACE_NAME ";
        this.query4 = this.viewName == null || this.viewName.equals("") || this.viewName.equalsIgnoreCase("NULL") || this.viewName.equalsIgnoreCase("none") ? "SELECT nvl(max_size.tablespace_name,0),nvl(\"SIZE\"/(1024*1024),0) \"SIZE(MB)\",nvl(free_size.biggest,0),nvl(free_size.smallest,0), nvl(max_size.max_extend / (1024 * 1024),0) \"MAX_SIZE(MB)\",nvl(TRUNC ((max_size.max_extend - \"SIZE\" + free)/ seg_max_next.next_extent),-3) \"EXHAUST_AFTER\",decode(free_size.contents,'UNDO',undo_size.undo_used_size_mb,((\"SIZE\"-free_size.free)/1024/1024)) \"USED\" FROM (SELECT B.tablespace_NAME as tablespace_name, nvl(A.FREE,0) as free,nvl(A.BIGGEST,0) as biggest,nvl(A.SMALLEST,0) as smallest,b.contents FROM (SELECT /*+ use_hash (A.ts A.fi) */ tablespace_name,SUM (BYTES) \"FREE\",MAX (BYTES) \"BIGGEST\",MIN (BYTES) \"SMALLEST\" FROM dba_free_space A GROUP BY tablespace_name) A,(SELECT TABLESPACE_NAME,CONTENTS FROM DBA_TABLESPACES ) B WHERE A.TABLESPACE_NAME(+)=B.tablespace_NAME) free_size,(SELECT B.NAME as tablespace_name, nvl(A.\"SIZE\",0) as \"SIZE\" FROM (SELECT tablespace_name,SUM (BYTES) \"SIZE\" FROM dba_data_files GROUP BY tablespace_name) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) phy_size, (SELECT B.NAME as tablespace_name,  A.NEXT_EXTENT  as next_extent FROM (SELECT tablespace_name, MAX (next_extent) next_extent FROM dba_segments GROUP BY tablespace_name ) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) seg_max_next,(SELECT B.NAME as tablespace_name,a.max_extend FROM (SELECT ts.tablespace_name,SUM (ts_size) max_extend FROM dba_tablespaces ts,(SELECT tablespace_name, autoextensible,GREATEST (maxbytes,BYTES) \"TS_SIZE\" FROM dba_data_files ) df WHERE df.tablespace_name = ts.tablespace_name GROUP BY ts.tablespace_name) A,  (SELECT NAME FROM V$TABLESPACE) B WHERE B.NAME(+)=A.TABLESPACE_NAME) max_size,(SELECT\ttablespace_name,sum(bytes)/1024/1024 undo_used_size_mb \tfrom dba_undo_extents\twhere\tstatus <> 'EXPIRED' group by tablespace_name ) undo_size WHERE max_size.tablespace_name = seg_max_next.tablespace_name AND max_size.tablespace_name = phy_size.tablespace_name AND max_size.tablespace_name = free_size.tablespace_name and\tmax_size.tablespace_name = undo_size.tablespace_name(+)" : "SELECT nvl(max_size.tablespace_name,0),nvl(\"SIZE\"/(1024*1024),0) \"SIZE(MB)\", nvl(free_size.biggest,0),nvl(free_size.smallest,0), nvl(max_size.max_extend / (1024 * 1024),0) \"MAX_SIZE(MB)\",nvl(TRUNC ((max_size.max_extend - \"SIZE\" + free)/ seg_max_next.next_extent),-3) \"EXHAUST_AFTER\",decode(free_size.contents,'UNDO',undo_size.undo_used_size_mb,((\"SIZE\"-free_size.free)/1024/1024)) \"USED\" FROM (SELECT B.tablespace_NAME as tablespace_name, nvl(A.FREE,0) as free,nvl(A.BIGGEST,0) as biggest,nvl(A.SMALLEST,0) as smallest,b.contents FROM (SELECT /*+ use_hash (A.ts A.fi) */ tablespace_name,SUM (BYTES) \"FREE\",MAX (BYTES) \"BIGGEST\",MIN (BYTES) \"SMALLEST\" FROM " + this.viewName + " A GROUP BY tablespace_name) A,(SELECT " + "TABLESPACE_NAME,CONTENTS FROM DBA_TABLESPACES ) B WHERE A.TABLESPACE_NAME(+)=B.tablespace_NAME) free_size," + "(SELECT B.NAME as tablespace_name, nvl(A.\"SIZE\",0) as \"SIZE\" FROM (SELECT tablespace_name,SUM (BYTES) \"SIZE\" " + "FROM dba_data_files GROUP BY tablespace_name) A,(SELECT NAME FROM V$TABLESPACE ) B WHERE " + "A.TABLESPACE_NAME(+)=B.NAME ) phy_size, (SELECT B.NAME as tablespace_name,  A.NEXT_EXTENT  as next_extent " + "FROM (SELECT tablespace_name, MAX (next_extent) next_extent FROM dba_segments GROUP BY tablespace_name ) A," + "(SELECT NAME FROM V$TABLESPACE ) B WHERE A.TABLESPACE_NAME(+)=B.NAME ) seg_max_next,(SELECT B.NAME as " + "tablespace_name,a.max_extend FROM (SELECT ts.tablespace_name,SUM (ts_size) max_extend FROM dba_tablespaces ts," + "(SELECT tablespace_name, autoextensible,GREATEST (maxbytes,BYTES) \"TS_SIZE\" FROM dba_data_files ) df " + "WHERE df.tablespace_name = ts.tablespace_name GROUP BY ts.tablespace_name) A,  (SELECT NAME FROM V$TABLESPACE) B " + "WHERE B.NAME(+)=A.TABLESPACE_NAME) max_size,(SELECT\ttablespace_name,sum(bytes)/1024/1024 undo_used_size_mb \tfrom dba_undo_extents\twhere\tstatus <> 'EXPIRED' group by tablespace_name ) undo_size WHERE max_size.tablespace_name = seg_max_next.tablespace_name AND " + "max_size.tablespace_name = phy_size.tablespace_name AND max_size.tablespace_name = free_size.tablespace_name " + "and\tmax_size.tablespace_name = undo_size.tablespace_name(+)";
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        Object object;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            object = new ArrayList();
            object = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object != null && ((ArrayList)object).size() > 2) {
                int n = (Integer)((ArrayList)object).get(0);
                string2 = (String)((ArrayList)object).get(1);
                if (string2.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                this.logToErrorFile("Error  :", this.entity, "Failed to find the Oracle version detail for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            }
        }
        if (this.isDataguardEnabled) {
            object = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug, this.reportingName);
            if (object == null || ((Hashtable)object).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                string2 = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!string2.equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        double d = -5.0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable<Object, ArrayList> hashtable2 = new Hashtable<Object, ArrayList>();
        Connection connection = null;
        Object var14_14 = null;
        try {
            connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.userName, this.userPasswd, debug);
            if (connection == null) {
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                return;
            }
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTableSpacesTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                return;
            }
            resultSet = statement.executeQuery(this.query4);
            String string3 = "";
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            while (resultSet.next()) {
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                object = resultSet.getString(1);
                double d2 = resultSet.getDouble(2);
                double d3 = resultSet.getDouble(3);
                d3 /= bToMb;
                double d4 = resultSet.getDouble(4);
                d4 /= bToMb;
                double d5 = resultSet.getDouble(5);
                if (d5 == 0.0) continue;
                double d6 = resultSet.getDouble(6);
                double d7 = resultSet.getDouble(7);
                double d8 = d5 - d7;
                if (d2 > 0.0) {
                    d = d7 / d2 * 100.0;
                }
                if (arrayList != null && !arrayList.contains(object)) {
                    arrayList.add(object);
                }
                double d9 = 0.0;
                if (d8 < 0.0) {
                    d8 = 0.0;
                    d9 = 0.0;
                } else {
                    d9 = d8 * 100.0 / d5;
                }
                arrayList3.add(new Double(d));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(-1.0));
                arrayList3.add(new Double(d5));
                arrayList3.add(new Double(d2));
                arrayList3.add(new Double(d8));
                arrayList3.add(new Double(d9));
                arrayList3.add(new Double(d3));
                arrayList3.add(new Double(d4));
                arrayList3.add(new Double(d6));
                hashtable2.put(object, arrayList3);
            }
            resultSet.close();
            statement.close();
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTableSpacesTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return;
            }
            resultSet = statement.executeQuery(this.query1);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                if (arrayList2 != null && !arrayList2.contains(object)) {
                    arrayList2.add(object);
                }
                double d10 = resultSet.getDouble(2);
                double d11 = resultSet.getDouble(3);
                if (!arrayList.contains(object)) continue;
                int n = this.tableSpaceNames.indexOf(object);
                if (n == -1) {
                    this.tableSpaceNames.add(object);
                    this.prevPhysReads.add(new Double(d10));
                    this.prevPhysWrites.add(new Double(d11));
                    continue;
                }
                if (this.timeSinceLastTest < 0.0) {
                    this.prevPhysReads.set(n, new Double(d10));
                    this.prevPhysWrites.set(n, new Double(d11));
                    continue;
                }
                Double d12 = (Double)this.prevPhysReads.get(n);
                double d13 = d12;
                d12 = (Double)this.prevPhysWrites.get(n);
                double d14 = d12;
                double d15 = (d10 - d13) / this.timeSinceLastTest;
                d15 = d15 < 0.0 ? -1.0 : d15;
                double d16 = (d11 - d14) / this.timeSinceLastTest;
                d16 = d16 < 0.0 ? -1.0 : d16;
                ArrayList arrayList4 = (ArrayList)hashtable2.get(object);
                if (arrayList4 != null) {
                    arrayList4.set(1, new Double(d15));
                    arrayList4.set(2, new Double(d16));
                    hashtable2.put(object, arrayList4);
                }
                this.prevPhysReads.set(n, new Double(d10));
                this.prevPhysWrites.set(n, new Double(d11));
            }
            resultSet.close();
            statement.close();
            try {
                statement = connection.createStatement();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "OraTableSpacesTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                exception.printStackTrace();
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                return;
            }
            resultSet = statement.executeQuery(this.query3);
            while (resultSet.next()) {
                object = resultSet.getString(1);
                ArrayList arrayList5 = (ArrayList)hashtable2.get(object);
                if (arrayList5 == null) continue;
                string3 = resultSet.getString(2);
                boolean bl = false;
                if (string3 != null && string3.equalsIgnoreCase("Yes")) {
                    bl = true;
                }
                arrayList5.set(3, new Double((double)bl));
                hashtable2.put(object, arrayList5);
            }
            arrayList.clear();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                ArrayList arrayList6 = (ArrayList)hashtable2.get(string4);
                if (arrayList6 == null) continue;
                this.addNewMeasure(string4, arrayList6);
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            System.out.println("GET CONN FAILED!!!");
            exception.printStackTrace();
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception5) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception6) {
                    // empty catch block
                }
            }
            exception.printStackTrace();
            try {
                connection.close();
            }
            catch (Exception exception7) {
                // empty catch block
            }
            this.errorMsg = new String("Exception while executing OraTablespacesTest for target: " + this.targetHost);
        }
    }
}

