/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class OraTransRollTest
extends GenericTest {
    public String oraSid = "";
    public String username = "";
    public String password = "";
    int defValue = -1;
    ArrayList prevList = new ArrayList();
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;

    public OraTransRollTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        this.setSid(this.oraSid);
        this.isNewDynamicInfoTest = true;
        if (this.isPassive) {
            this.defValue = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        double d4 = -5.0;
        double d5 = -5.0;
        int n = 0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        ArrayList arrayList3 = new ArrayList();
        String string = "SELECT NAME,  VALUE FROM V$SYSSTAT WHERE NAME IN ('user commits', 'user rollbacks', 'transaction rollbacks')";
        if (this.checkOracleVersion) {
            arrayList3 = ConnectionManager.checkOracleVersion(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
            this.checkOracleVersion = false;
            if (arrayList3 != null && arrayList3.size() > 2) {
                int n2 = (Integer)arrayList3.get(0);
                object = (String)arrayList3.get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n2 >= 12) {
                    this.isOracle12c = true;
                    String string2 = (String)arrayList3.get(2);
                    if (string2.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
            }
        }
        try {
            try {
                connection = this.isMultitenantDb && !this.isCDB ? ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug) : ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
                if (connection == null) {
                    this.logToErrorFile("Error", "OraTransRollTest connection is null for : ", this.targetHost);
                    Object var24_19 = null;
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    if (n == 0) {
                        d = resultSet.getDouble(2);
                        arrayList2.add(new Double(d));
                    } else if (n != 1 && n == 2) {
                        d2 = resultSet.getDouble(2);
                        arrayList2.add(new Double(d2));
                        if (!this.prevList.isEmpty()) {
                            d4 = (Double)this.prevList.get(0);
                            d3 = (Double)this.prevList.get(1);
                            if (d >= d4 && d2 >= d3) {
                                d5 = (d2 -= d3) * 100.0 / ((d -= d4) + d2);
                                this.prevList = (ArrayList)arrayList2.clone();
                                arrayList.add(new Double(d));
                                arrayList.add(new Double(d2));
                                arrayList.add(new Double(d5));
                            } else {
                                this.prevList = (ArrayList)arrayList2.clone();
                                arrayList.add(new Double(-1.0));
                                arrayList.add(new Double(-1.0));
                                arrayList.add(new Double(-1.0));
                            }
                        } else {
                            this.prevList = (ArrayList)arrayList2.clone();
                            arrayList.add(new Double(-1.0));
                            arrayList.add(new Double(-1.0));
                            arrayList.add(new Double(-1.0));
                        }
                    }
                    ++n;
                }
                if (debug) {
                    System.out.println("[OraTransRollTest]===>output" + arrayList);
                }
                this.addNewMeasure(arrayList);
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in OraTransRollTest.computeMeasures():" + exception.toString());
                this.logToErrorFile("Exception Occured in OraTransRollTest:", ".computeMeasures()", "Unable to getconnection " + exception.toString());
                exception.printStackTrace();
                object = new ArrayList();
                ((ArrayList)object).add(new Double(-1.0));
                ((ArrayList)object).add(new Double(-1.0));
                ((ArrayList)object).add(new Double(-1.0));
                this.addNewMeasure((ArrayList)object);
                Object var24_21 = null;
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var24_22 = null;
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            throw throwable;
        }
        Object var24_20 = null;
        this.closeRs(resultSet);
        this.closeStmt(statement);
        this.closeConn(connection);
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraTransRollTest oraTransRollTest = new OraTransRollTest(stringArray);
        oraTransRollTest.computeMeasures(new Hashtable());
    }
}

