/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class PepPrsServerTest
extends GenericTest {
    private String psAdmin_home = "";
    private String domain = "";
    private String cmd = "";
    private String exeCmc = "";
    private String debugFlag = "";
    private String sys_OS = "";
    private String[] envp = null;
    private Hashtable preHash = null;
    private boolean debug = false;

    public PepPrsServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.psAdmin_home = this.getValueForParam("psAdmin_home");
        this.domain = this.getValueForParam("domain");
        this.debugFlag = this.getValueForParam("debug");
        this.envp = new String[2];
        if (this.psAdmin_home == null || this.psAdmin_home.equalsIgnoreCase("NULL") || this.psAdmin_home.equalsIgnoreCase("none")) {
            this.psAdmin_home = "";
        }
        if (this.domain == null || this.domain.equalsIgnoreCase("NULL") || this.domain.equalsIgnoreCase("none")) {
            this.domain = "";
        }
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
        this.cmd = "printserver";
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (this.sys_OS.trim().startsWith("WIN")) {
            this.psAdmin_home.replace('/', '\\');
            this.exeCmc = EgInstallInfo.getInstallDir() + "\\lib\\PeopleProcessScheduler.bat " + this.psAdmin_home + " " + this.domain + " " + this.cmd;
        } else {
            this.psAdmin_home.replace('\\', '/');
            this.envp[0] = "PATH=" + EgInstallInfo.getInstallDir() + "/bin";
            this.envp[1] = "LD_LIBRARY_PATH=/usr/lib";
            this.exeCmc = EgInstallInfo.getInstallDir() + "/bin/PeopleProcessScheduler.sh " + this.psAdmin_home + " " + this.domain + " " + this.cmd;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        double d = -5.0;
        double d2 = -5.0;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        EgUtilities egUtilities = EgUtilities.createInstance();
        arrayList = this.sys_OS.trim().startsWith("WIN") ? egUtilities.getExecOutputLines(this.exeCmc) : egUtilities.getExecOutputLinesForUnix(this.exeCmc, this.envp);
        if (arrayList == null || arrayList.size() == 0) {
            this.logToErrorFile("Error:", "PepPrsServerTest.computeMeasures", "PepPrsServerTest Server details measures not available");
            System.out.println("[PepPrsServerTest] Error in executing the command ..." + this.exeCmc);
            return;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (this.debug) {
            System.out.println("out==================>" + arrayList2);
        }
        if (arrayList2 == null || arrayList2.size() == 0) {
            this.logToErrorFile("Error:", "PepPrsServerTest.computeMeasures", "output is null:" + this.targetHost + " reportingName:" + this.reportingName);
            return;
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            ++n;
            if (string.startsWith("---------")) break;
        }
        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
        try {
            Object object;
            for (int i = n; i < arrayList2.size(); ++i) {
                String string = (String)arrayList2.get(i);
                if (string == null || string.trim().length() == 0) continue;
                object = new StringTokenizer(string, " ");
                int n2 = ((StringTokenizer)object).countTokens();
                String string2 = "";
                if (((StringTokenizer)object).countTokens() != 9) continue;
                Object object2 = ((StringTokenizer)object).nextToken();
                String string3 = ((StringTokenizer)object).nextToken();
                String string4 = ((StringTokenizer)object).nextToken();
                String string5 = ((StringTokenizer)object).nextToken();
                string2 = (String)object2 + "#" + string3 + "#" + string5;
                object2 = new ArrayList();
                string3 = ((StringTokenizer)object).nextToken();
                if (string3 != null && string3.length() > 0) {
                    d = this.checkValue(string3);
                }
                if ((string4 = ((StringTokenizer)object).nextToken()) != null && string4.length() > 0) {
                    d2 = this.checkValue(string4);
                }
                string5 = ((StringTokenizer)object).nextToken();
                String string6 = "";
                String string7 = "";
                if (string5 != null && string5.trim().equalsIgnoreCase("(")) {
                    string6 = ((StringTokenizer)object).nextToken();
                    string7 = ((StringTokenizer)object).nextToken();
                } else {
                    string6 = string5;
                }
                ((ArrayList)object2).add(new Double(d));
                ((ArrayList)object2).add(new Double(d2));
                hashtable2.put(string2, object2);
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                for (String string : hashtable2.keySet()) {
                    if (this.preHash != null && this.preHash.size() > 0) {
                        object = (ArrayList)this.preHash.get(string);
                        ArrayList arrayList3 = (ArrayList)hashtable2.get(string);
                        if (object == null || arrayList3 == null) continue;
                        double d3 = (Double)((ArrayList)object).get(0);
                        double d4 = (Double)((ArrayList)object).get(1);
                        double d5 = (Double)arrayList3.get(0);
                        double d6 = (Double)arrayList3.get(1);
                        double d7 = -5.0;
                        double d8 = -5.0;
                        if (d5 >= 0.0 && d3 >= 0.0) {
                            d7 = d5 - d3;
                        }
                        if (d6 >= 0.0 && d4 >= 0.0) {
                            d8 = d6 - d4;
                        }
                        double d9 = d8 / this.timeSinceLastTest;
                        double d10 = d7 / this.timeSinceLastTest;
                        ArrayList<Double> arrayList4 = new ArrayList<Double>();
                        arrayList4.add(new Double(d7));
                        arrayList4.add(new Double(d8));
                        arrayList4.add(new Double(d10));
                        arrayList4.add(new Double(d9));
                        if (this.debug) {
                            System.out.println("[PepPrsServerTest] Info=====" + string + "=======Values========>" + arrayList4);
                        }
                        this.addNewMeasure(string, arrayList4);
                        continue;
                    }
                    object = new ArrayList();
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    if (this.debug) {
                        System.out.println("[PepPrsServerTest] Info=====" + string + "=======Values========>" + object);
                    }
                    this.addNewMeasure(string, (ArrayList)object);
                }
            }
            this.preHash = (Hashtable)hashtable2.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error:", "PepPrsServerTest.computeMeasures", "error occured:" + this.targetHost + " reportingName:" + this.reportingName + " errormsg:" + exception.toString());
        }
    }

    public double checkValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        PepPrsServerTest pepPrsServerTest = new PepPrsServerTest(stringArray);
        try {
            while (true) {
                pepPrsServerTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

