/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class PsPartStatusTest
extends EgSnmpGenericTest {
    private static String descOid = ".1.3.6.1.4.1.2334.2.1.3.2.1";
    Hashtable partitionNameHT = new Hashtable();
    Hashtable framesCountHT = new Hashtable();
    Hashtable bwFailHT = new Hashtable();
    Hashtable cirFailsHT = new Hashtable();
    private static final int PsPartStatusTest_measureCount = 3;

    public PsPartStatusTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
    }

    private void start() {
        this.partitionNameHT = new Hashtable();
        this.framesCountHT = new Hashtable();
        this.bwFailHT = new Hashtable();
        this.cirFailsHT = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        this.start();
        try {
            boolean bl = this.runSnmpCmdForOid(descOid);
            if (!bl || this.lhs == null || this.lhs.length == 0) {
                return;
            }
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.lhs[i].startsWith("2.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    this.partitionNameHT.put(this.lhs[i], this.rhs[i]);
                    continue;
                }
                if (this.lhs[i].startsWith("53.")) {
                    this.lhs[i] = this.lhs[i].substring(3);
                    this.framesCountHT.put(this.lhs[i], this.rhs[i]);
                    continue;
                }
                if (this.lhs[i].startsWith("40.")) {
                    this.lhs[i] = this.lhs[i].substring(3);
                    this.bwFailHT.put(this.lhs[i], this.rhs[i]);
                    continue;
                }
                if (!this.lhs[i].startsWith("10.")) continue;
                this.lhs[i] = this.lhs[i].substring(3);
                this.cirFailsHT.put(this.lhs[i], this.rhs[i]);
            }
            if (debug) {
                System.out.println();
                System.out.println("*************SNMP WALK Output Hashtable values************");
                System.out.println("[PsPartStatusTest] Descriptor value " + this.partitionNameHT);
                System.out.println("[PsPartStatusTest] Frames count " + this.framesCountHT);
                System.out.println("[PsPartStatusTest] Bandwidth failures " + this.bwFailHT);
                System.out.println("[PsPartStatusTest] CIR fails count " + this.cirFailsHT);
                System.out.println("**********************************************************");
                System.out.println();
            }
            Enumeration enumeration = this.partitionNameHT.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.startsWith(".")) continue;
                String string2 = (String)this.partitionNameHT.get(string);
                String string3 = (String)this.framesCountHT.get(string);
                String string4 = (String)this.bwFailHT.get(string);
                String string5 = (String)this.cirFailsHT.get(string);
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = "-5";
                }
                if (string4 == null || string4.trim().length() == 0) {
                    string4 = "-5";
                }
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = "-5";
                }
                if (debug) {
                    System.out.println();
                    System.out.println("[PsPartStatusTest] Frames count ==> " + string3);
                    System.out.println("[PsPartStatusTest] Bandwidth Failures ==> " + string4);
                    System.out.println("[PsPartStatusTest] Cir fails count ==> " + string5);
                    System.out.println();
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(string3));
                arrayList.add(new Double(string4));
                arrayList.add(new Double(string5));
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", this.entity + ",error occur in computeMeasures", exception.toString());
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        PsPartStatusTest psPartStatusTest = new PsPartStatusTest(stringArray);
        psPartStatusTest.computeMeasures(new Hashtable());
    }
}

