/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RUMSummaryData {
    private double totalPageLoadTime = 0.0;
    private double totalFrontEndTime = 0.0;
    private double totalDocumentReadyTime = 0.0;
    private double firstByteTime = 0.0;
    private double responseAvailableTime = 0.0;
    private double totalRequest = 0.0;
    private double totalPageIFrameRequest = 0.0;
    private double totalSSLRequest = 0.0;
    private double totalDNSLookUpTime = 0.0;
    private double totalTCPConnectionTime = 0.0;
    private double normalRequestCount = 0.0;
    private double satisfiedRequestCount = 0.0;
    private double slowRequest = 0.0;
    private double frustratedRequest = 0.0;
    private double toleratedRequest = 0.0;
    private double errorRequest = 0.0;
    private double networkTime = 0.0;
    private double domProcessingTime = 0.0;
    private double domDownloadTime = 0.0;
    private double pageRenderingTime = 0.0;
    private double slowPercentage = 0.0;
    private double errorPercentage = 0.0;
    private double normalPercentage = 0.0;
    private double totalSslHandshakeTime = 0.0;
    private double totalAppCacheTime = 0.0;
    private double totalRedirectionTime = 0.0;
    private double totalBrowserWaitTime = 0.0;
    private double totalBrowserInitialReqTime = 0.0;
    private HashSet sessionList = new HashSet();
    private Set uniqueIPSet = new HashSet();
    private ArrayList RUMData = new ArrayList();
    private ArrayList ddDataList = new ArrayList();
    private ArrayList rscDataList = new ArrayList();
    private ArrayList errDataList = new ArrayList();
    private double requestPerMinute = 0.0;
    DecimalFormat formatter = new DecimalFormat("##.#");

    public void setDDData(ArrayList ddList) {
        this.ddDataList.add(ddList);
    }

    public ArrayList getDDDataList() {
        return this.ddDataList;
    }

    public void setDDResourceData(ArrayList ddList) {
        this.rscDataList.add(ddList);
    }

    public ArrayList getDDResourceData() {
        return this.rscDataList;
    }

    public void setDDErrorData(ArrayList allErrorDDList) {
        this.errDataList = allErrorDDList;
    }

    public ArrayList getDDErrorData() {
        return this.errDataList;
    }

    public void setRequestCount(double d) {
        this.totalRequest += d;
    }

    public Double getRequestCount() {
        return new Double(this.totalRequest);
    }

    public void setPageIFrameRequestCount(double d) {
        this.totalPageIFrameRequest += d;
    }

    public Double getPageIFrameRequestCount() {
        return new Double(this.totalPageIFrameRequest);
    }

    public void setPageLoadTime(Double d) {
        this.totalPageLoadTime += d.doubleValue();
    }

    public Double getAveragePageLoadTime() {
        double averagePageLoadTime = 0.0;
        try {
            averagePageLoadTime = this.totalPageLoadTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averagePageLoadTime));
    }

    public void setFrontEndTime(Double d) {
        this.totalFrontEndTime += d.doubleValue();
    }

    public Double getAverageFrontEndTime() {
        double averageFrontEndTime = 0.0;
        try {
            averageFrontEndTime = this.totalFrontEndTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageFrontEndTime));
    }

    public void setDocumentReadyTime(Double d) {
        this.totalDocumentReadyTime += d.doubleValue();
    }

    public Double getAverageDocumentReadyTime() {
        double averageDocumentReadyTime = 0.0;
        try {
            averageDocumentReadyTime = this.totalDocumentReadyTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageDocumentReadyTime));
    }

    public void setNormalRequestCount(double normalRequestCount) {
        this.normalRequestCount += normalRequestCount;
    }

    public Double getNormalRequestCount() {
        return new Double(this.normalRequestCount);
    }

    public void setSlowRequestCount(double d) {
        this.slowRequest += d;
    }

    public Double getSlowRequestCount() {
        return new Double(this.slowRequest);
    }

    public void setErrorRequestCount(double d) {
        this.errorRequest += d;
    }

    public Double getErrorRequestCount() {
        return new Double(this.errorRequest);
    }

    public void setSatisfiedRequestCount(double d) {
        this.satisfiedRequestCount += d;
    }

    public Double getSatisfiedRequestCount() {
        return new Double(this.satisfiedRequestCount);
    }

    public void setFrustratedRequestCount(double d) {
        this.frustratedRequest += d;
    }

    public void setToleratedRequestCount(double d) {
        this.toleratedRequest += d;
    }

    public Double getToleratedRequestCount() {
        return new Double(this.toleratedRequest);
    }

    public Double getFrustratedRequestCount() {
        return new Double(this.frustratedRequest);
    }

    public void setFirstByteTime(Double d) {
        this.firstByteTime += d.doubleValue();
    }

    public Double getAverageFirstByteTime() {
        double averageFirstByteTime = 0.0;
        try {
            averageFirstByteTime = this.firstByteTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageFirstByteTime));
    }

    public void setResponseAvailableTime(Double d) {
        this.responseAvailableTime += d.doubleValue();
    }

    public Double getAverageResponseAvailableTime() {
        double averageResponseAvailableTime = 0.0;
        try {
            averageResponseAvailableTime = this.responseAvailableTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageResponseAvailableTime));
    }

    public void setNetworkTime(Double d) {
        this.networkTime += d.doubleValue();
    }

    public Double getAverageNetworkTime() {
        double averageNetworkTime = 0.0;
        try {
            averageNetworkTime = this.networkTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageNetworkTime));
    }

    public void setDomProcessingTime(Double d) {
        this.domProcessingTime += d.doubleValue();
    }

    public Double getDomProcessingTime() {
        double averageDomProcessingTime = 0.0;
        try {
            averageDomProcessingTime = this.domProcessingTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageDomProcessingTime));
    }

    public void setDomDownloadTime(Double d) {
        this.domDownloadTime += d.doubleValue();
    }

    public Double getDomDownloadTime() {
        double averageDomDownloadTime = 0.0;
        try {
            averageDomDownloadTime = this.domDownloadTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageDomDownloadTime));
    }

    public void setPageRenderingTime(Double d) {
        this.pageRenderingTime += d.doubleValue();
    }

    public Double getPageRenderingTime() {
        double averagePageRenderingTime = 0.0;
        try {
            averagePageRenderingTime = this.pageRenderingTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averagePageRenderingTime));
    }

    public void setUserSession(String s) {
        if (s != null && !s.equalsIgnoreCase("null") && s.length() != 0 && !s.equals("-")) {
            this.sessionList.add(s);
        }
    }

    public String getUserSession() {
        int session = this.sessionList.size();
        if (session == 0) {
            session = -5;
        }
        String userSession = String.valueOf(session);
        return userSession;
    }

    public void setRUMData(RUMMeasureData data) {
        this.RUMData.add(data);
    }

    public ArrayList getRUMData() {
        return this.RUMData;
    }

    public void setSlowPercentage(Double slowPercentage) {
        this.slowPercentage = this.slowRequest / this.totalRequest * 100.0;
    }

    public Double getSlowPercentage() {
        return EgRUMBase.getDoubleValue(this.formatter.format(this.slowPercentage), new Double(0.0));
    }

    public void setErrorPercentage(Double errorPercentage) {
        this.errorPercentage = this.errorRequest / this.totalRequest * 100.0;
    }

    public Double getErrorPercentage() {
        return EgRUMBase.getDoubleValue(this.formatter.format(this.errorPercentage), new Double(0.0));
    }

    public void setNormalPercentage(double normalPercentage) {
        this.normalPercentage = this.normalRequestCount / this.totalRequest * 100.0;
    }

    public Double getNormalPercentage() {
        return EgRUMBase.getDoubleValue(this.formatter.format(this.normalPercentage), new Double(0.0));
    }

    public void setRequestPerMinute(Double requestPerMinute) {
        this.requestPerMinute = this.totalRequest / requestPerMinute;
    }

    public Double getRequestPerMinute() {
        return new Double(Math.round(this.requestPerMinute));
    }

    public void setTCPConnectionTime(Double d) {
        if (d > -1.0) {
            this.totalTCPConnectionTime += d.doubleValue();
        }
    }

    public Double getTCPConnectionTime() {
        double averageTCPConnectionTime = 0.0;
        try {
            averageTCPConnectionTime = this.totalTCPConnectionTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageTCPConnectionTime));
    }

    public void setDNSLookUpTime(Double d) {
        if (d > -1.0) {
            this.totalDNSLookUpTime += d.doubleValue();
        }
    }

    public Double getDNSLookUpTime() {
        double averageDNSLookUpTime = 0.0;
        try {
            averageDNSLookUpTime = this.totalDNSLookUpTime / this.totalRequest;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Double(Math.round(averageDNSLookUpTime));
    }

    public void setSslHandshakeTime(Double currentSslHandshakeTime) {
        if (currentSslHandshakeTime > -1.0) {
            this.totalSslHandshakeTime += currentSslHandshakeTime.doubleValue();
            this.totalSSLRequest += 1.0;
        }
    }

    public Double getAverageSslHandshakeTime() {
        double averageSslHandShakeTime = 0.0;
        try {
            if (this.totalSslHandshakeTime > 0.0 && this.totalSSLRequest > 0.0) {
                averageSslHandShakeTime = this.totalSslHandshakeTime / this.totalSSLRequest;
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.debug("Exception occured while calculating AverageSslHandshakeTime in RUMSummaryData.  totalSslHandshakeTime:" + this.totalSslHandshakeTime + " totalRequest:" + this.totalRequest);
        }
        return new Double(Math.round(averageSslHandShakeTime));
    }

    public void setAppCacheTime(Double currentAppCacheTime) {
        if (currentAppCacheTime > 0.0) {
            this.totalAppCacheTime += currentAppCacheTime.doubleValue();
        }
    }

    public Double getAverageAppCacheTime() {
        double averageAppCacheTime = 0.0;
        try {
            if (this.totalAppCacheTime > 0.0 && this.totalPageIFrameRequest > 0.0) {
                averageAppCacheTime = this.totalAppCacheTime / this.totalPageIFrameRequest;
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.debug("Exception occured while calculating AverageAppCacheTime in RUMSummaryData.  totalAppCacheTime:" + this.totalAppCacheTime + " totalRequest:" + this.totalRequest);
        }
        return new Double(Math.round(averageAppCacheTime));
    }

    public void setRedirectionTime(Double currentRedirectionTime) {
        if (currentRedirectionTime > 0.0) {
            this.totalRedirectionTime += currentRedirectionTime.doubleValue();
        }
    }

    public Double getAverageRedirectionTime() {
        double averageRedirectionTime = 0.0;
        try {
            if (this.totalRedirectionTime > 0.0 && this.totalPageIFrameRequest > 0.0) {
                averageRedirectionTime = this.totalRedirectionTime / this.totalPageIFrameRequest;
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.debug("Exception occured while calculating AverageRedirectionTime in RUMSummaryData.  totalRedirectionTime:" + this.totalRedirectionTime + " totalRequest:" + this.totalRequest);
        }
        return new Double(Math.round(averageRedirectionTime));
    }

    public void setBrowserWaitTime(Double currentBrowserWaitTime) {
        if (currentBrowserWaitTime > 0.0) {
            this.totalBrowserWaitTime += currentBrowserWaitTime.doubleValue();
        }
    }

    public Double getAverageBrowserWaitTime() {
        double averageBrowserWaitTime = 0.0;
        try {
            if (this.totalBrowserWaitTime > 0.0 && this.totalPageIFrameRequest > 0.0) {
                averageBrowserWaitTime = this.totalBrowserWaitTime / this.totalPageIFrameRequest;
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.debug("Exception occured while calculating AverageBrowserWaitTime in RUMSummaryData.  totalBrowserWaitTime:" + this.totalBrowserWaitTime + " totalRequest:" + this.totalRequest);
        }
        return new Double(Math.round(averageBrowserWaitTime));
    }

    public void setBrowserInitialReqTime(Double currentBrowserInitialReqTime) {
        if (currentBrowserInitialReqTime > 0.0) {
            this.totalBrowserInitialReqTime += currentBrowserInitialReqTime.doubleValue();
        }
    }

    public Double getAverageBrowserInitialReqTime() {
        double averageBrowserInitialReqTime = 0.0;
        try {
            if (this.totalBrowserInitialReqTime > 0.0 && this.totalPageIFrameRequest > 0.0) {
                averageBrowserInitialReqTime = this.totalBrowserInitialReqTime / this.totalPageIFrameRequest;
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.debug("Exception occured while calculating AverageBrowserInitialReqTime in RUMSummaryData.  totalBrowserInitialReqTime:" + this.totalBrowserInitialReqTime + " totalPageIFrameRequest:" + this.totalPageIFrameRequest);
        }
        return new Double(Math.round(averageBrowserInitialReqTime));
    }

    public void setUniqueIPCount(String ip) {
        try {
            if (ip != null && !ip.equalsIgnoreCase("null") && ip.length() != 0 && !ip.equals("-")) {
                this.uniqueIPSet.add(ip);
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.warn("RUMSummaryData - Exception while adding the UniqueIP" + e.getMessage());
        }
    }

    public String getUniqueIPCount() {
        String uniqueIPsString = new String("-5");
        try {
            int uniqueIPs = this.uniqueIPSet.size();
            if (uniqueIPs != 0) {
                uniqueIPsString = String.valueOf(uniqueIPs);
            }
        }
        catch (Exception e) {
            EgRUMBase.logger.warn("RUMSummaryData - Exception while computing Unique IP Count" + e.getMessage());
        }
        return uniqueIPsString;
    }
}

