/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.eg.apm.EgLogbackManager;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;

public abstract class RedisBase
extends GenericTest {
    public RedisInfo redisInfo = null;
    boolean isItAgentLessComp = false;
    private static final String COLON_DELIMITER = ":";
    private static final String COMMA_DELIMITER = ",";
    private static final String EQUALS_DELIMITER = "=";
    private static final String HASH_DELIMITER = "#";
    private static final int REDIS_DEFAULT_PORT = 6379;
    private static final String REDIS_DEFAULT_IP = "127.0.0.1";
    public static String installDir = EgInstallInfo.getInstallDir();
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    public static final Logger logger = EgLogbackManager.getInstance().getLogger("REDIS_LOGGER");
    protected final String testStart = " " + this.entity + " - Test cycle START";
    protected final String testEnd = " " + this.entity + " - Test cycle END";
    protected String logPrefix = " [" + this.reportingName + ":" + this.portNo + "] [" + this.entity + "] ";
    private static String descriptorName = "";
    boolean isDescriptorName = false;
    protected static Date modifiedDate;
    private static double previousUpTime;
    private static boolean isRestarted;

    public RedisBase(String[] stringArray) {
        super(stringArray);
        try {
            logger.info(this.logPrefix + " Initializing RedisBase ...");
            this.redisInfo = new RedisInfo(this.reportingName);
            String string = this.getValueForParam("Redis_password");
            if (string == null || string.length() <= 0 || string.equalsIgnoreCase("none")) {
                logger.info(this.logPrefix + " REDIS password is null or empty or none : " + string);
                logger.info(this.logPrefix + " Continuing without password");
            } else {
                this.redisInfo.setRedisPass(string);
                logger.info(this.logPrefix + " Redis Server is enabled with password authentication.");
            }
            this.isItAgentLessComp = this.isSSH && this.alos != null && this.alos.equalsIgnoreCase("LINUX");
            logger.debug(this.logPrefix + " isItAgentLessComp flag : " + this.isItAgentLessComp);
            if (this.targetHost == null || this.targetHost.length() <= 0 || this.targetHost.equalsIgnoreCase("none")) {
                logger.info(this.logPrefix + " REDIS IPAddress is null or empty or none : " + this.targetHost);
                logger.info(this.logPrefix + " Using Default REDIS IPAddress :" + REDIS_DEFAULT_IP);
                this.redisInfo.setRedisIp(REDIS_DEFAULT_IP);
            } else {
                logger.info(this.logPrefix + " Using REDIS IPAddress :" + this.targetHost);
                this.redisInfo.setRedisIp(this.targetHost);
            }
            if (this.portNo == null || this.portNo.length() <= 0 || this.portNo.equalsIgnoreCase("none")) {
                logger.info(this.logPrefix + " REDIS Port is null or empty or none : " + this.portNo);
                logger.info(this.logPrefix + " Using Default REDIS port :" + 6379);
                this.redisInfo.setRedisPort(6379);
            } else {
                try {
                    int n = Integer.parseInt(this.portNo);
                    logger.info(this.logPrefix + " Using REDIS Port :" + n);
                    this.redisInfo.setRedisPort(n);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.info(this.logPrefix + " Invalid Redis port number :" + this.portNo);
                    logger.info(this.logPrefix + " Using Default REDIS port :" + 6379);
                    this.redisInfo.setRedisPort(6379);
                }
            }
            this.updateINIFileObject();
            logger.info(this.logPrefix + " RedisBase initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisBase", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetrics(String string) {
        if (string == null || string.length() <= 0) {
            logger.info(this.logPrefix + "REDIS_COMMAND is NULL or EMPTY hence returning null String");
            return null;
        }
        String string2 = null;
        Jedis jedis = null;
        try {
            jedis = this.getConnection();
            if (jedis == null) {
                logger.info(this.logPrefix + "JEDIS Connection object is NULL hence returning null String");
                String string3 = null;
                return string3;
            }
            string2 = jedis.info(string);
            logger.debug(this.logPrefix + " Successfully executed the REDIS Command");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [getRedisMetrics] Exception occured while connecting to Redis..", (Throwable)exception);
        }
        finally {
            this.closeConnection(jedis);
            jedis = null;
        }
        logger.debug(this.logPrefix + " Result for REDIS Command [" + string + "] :" + string2);
        return string2;
    }

    public Jedis getConnection() {
        Jedis jedis = null;
        try {
            jedis = new Jedis(this.redisInfo.getRedisIp(), this.redisInfo.getRedisPort());
            String string = this.redisInfo.getRedisPass();
            if (string == null || string.length() <= 0 || string.equalsIgnoreCase("none")) {
                logger.debug(this.logPrefix + " REDIS password is null or empty or none : " + string + " Hence returning the JEDIS Connection WITHOUT authenticating.");
                logger.debug(this.logPrefix + " JEDIS Connection is created successfully !!!");
                return jedis;
            }
            jedis.auth(string);
            logger.debug(this.logPrefix + " Password authentication is success !!!");
            logger.debug(this.logPrefix + " JEDIS Connection is created successfully with password authentication !!!");
            return jedis;
        }
        catch (JedisConnectionException jedisConnectionException) {
            logger.error(this.logPrefix + " [getConnection] Error while connecting to Redis Server ", (Throwable)jedisConnectionException);
            throw jedisConnectionException;
        }
        catch (JedisDataException jedisDataException) {
            logger.error(this.logPrefix + " [getConnection] Error while authenticating Redis Server", (Throwable)jedisDataException);
            throw jedisDataException;
        }
    }

    public void closeConnection(Jedis jedis) {
        if (jedis == null) {
            logger.info(this.logPrefix + " JEDIS Connection null or already closed !!!");
        } else {
            try {
                if (jedis.isConnected()) {
                    jedis.close();
                    jedis = null;
                    logger.debug(this.logPrefix + " JEDIS Connection is closed successfully !!!");
                } else {
                    jedis = null;
                    logger.info(this.logPrefix + " JEDIS Connection is already closed !!!");
                }
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + " [closeConnection] Error while closing the Jedis connection " + exception);
            }
        }
    }

    public void updateINIFileObject() {
        if (iniFilePath != null && iniFilePath.length() != 0 && !iniFilePath.equalsIgnoreCase("none")) {
            try {
                IniFile iniFile = new IniFile(installDir + iniFilePath);
                this.redisInfo.setEgMeasures(iniFile);
                logger.debug(this.logPrefix + " [updateINIFileObject] updating the INI File : " + iniFilePath);
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + " [updateINIFileObject] Exception Occured  :" + iniFilePath, (Throwable)exception);
            }
        }
    }

    private boolean hasDescriptorName(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.indexOf(COLON_DELIMITER) > -1 && string.indexOf(EQUALS_DELIMITER) > -1;
    }

    public boolean isValidMeasureLine(String string, String string2) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.indexOf(string2) > -1;
    }

    public boolean isValidCategoryLine(String string) {
        if (string == null || string.length() <= 0) {
            return false;
        }
        return string.indexOf(HASH_DELIMITER) >= 0;
    }

    public Hashtable parseMetrics(String string, boolean bl) {
        logger.debug(this.logPrefix + " Inside [parseMetrics] the redis measures are being parsed ");
        Hashtable hashtable = new Hashtable();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            String string2 = "";
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            Hashtable<String, Hashtable<String, String>> hashtable4 = new Hashtable<String, Hashtable<String, String>>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = stringTokenizer.nextToken().trim();
                if (this.isValidMeasureLine(string6, COLON_DELIMITER)) {
                    if (bl && this.hasDescriptorName(string6)) {
                        string3 = string6.substring(0, string6.indexOf(COLON_DELIMITER)).trim();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string6.substring(string6.indexOf(COLON_DELIMITER) + 1).trim(), COMMA_DELIMITER);
                        hashtable3 = new Hashtable();
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string7 = stringTokenizer2.nextToken();
                            if (!this.isValidMeasureLine(string7, EQUALS_DELIMITER)) continue;
                            string4 = string7.substring(0, string7.indexOf(EQUALS_DELIMITER)).trim();
                            string5 = string7.substring(string7.indexOf(EQUALS_DELIMITER) + 1).trim();
                            string4 = string4.contains(COLON_DELIMITER) ? string4.replace(COLON_DELIMITER, "") : string4;
                            hashtable3.put(string4, string5);
                        }
                        hashtable4.put(string3, hashtable3);
                        continue;
                    }
                    string4 = string6.substring(0, string6.indexOf(COLON_DELIMITER)).trim();
                    string5 = string6.substring(string6.indexOf(COLON_DELIMITER) + 1).trim();
                    hashtable2.put(string4, string5);
                    continue;
                }
                if (!this.isValidCategoryLine(string6)) continue;
                string2 = string6.substring(1).trim();
            }
            if (bl) {
                logger.debug(this.logPrefix + " [parseMetrics] the result table is info based ");
                hashtable.put(string2, hashtable4);
            } else {
                logger.debug(this.logPrefix + " [parseMetrics] the result table is non-info based ");
                hashtable.put(string2, hashtable2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [parseMetrics] Exception occured while fetching the values from testTable ", (Throwable)exception);
        }
        logger.info(this.logPrefix + " [parseMetrics] The Resultant table of parsed metrics : \n" + hashtable);
        return hashtable;
    }

    public long getModifiedTime() {
        IniFile iniFile = this.redisInfo.getEgMeasures();
        long l = IniFile.getLastModified(installDir + iniFilePath);
        logger.info(this.logPrefix + " [getModifiedTime] The INI File : " + iniFilePath + " was modified latestly on " + l);
        return l;
    }

    public Hashtable getIndexTable(String string) {
        IniFile iniFile = this.redisInfo.getEgMeasures();
        String[] stringArray = iniFile.getVariables(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], iniFile.getValue(string, stringArray[i]));
        }
        logger.info(this.logPrefix + " [getIndexTable] returning the table of INI name and index of the Subject " + string + " in indexMappingTable : " + hashtable);
        return hashtable;
    }

    public Hashtable getNameTable(String string) {
        IniFile iniFile = this.redisInfo.getEgMeasures();
        String[] stringArray = iniFile.getVariables(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = iniFile.getValue(string, stringArray[i]);
            String string3 = "";
            if (string2.contains(COMMA_DELIMITER)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, COMMA_DELIMITER);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken();
                    hashtable.put(string3, stringArray[i]);
                }
                continue;
            }
            hashtable.put(string2, stringArray[i]);
        }
        logger.info(this.logPrefix + " [getNameTable] returning the table of redis name and INI name of the Subject " + string + " in nameMappingTable : " + hashtable);
        return hashtable;
    }

    public ArrayList getNameList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Hashtable hashtable = this.getNameTable(string);
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            arrayList.add(string2);
        }
        logger.info(this.logPrefix + " [getNameList] returning the list of redis name of the Subject " + string + " in redisNameList : " + arrayList);
        return arrayList;
    }

    public ArrayList finalMeasures(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Double(-5.0));
        }
        logger.info(this.logPrefix + " [finalMeasures] creating and initializing the measure list ");
        return arrayList;
    }

    public void getRedisMeasureNonInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureNonInfoBased]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                modifiedDate = new Date(l2);
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + hashtable2);
            logger.debug(this.logPrefix + " measureNameTable  :" + hashtable3);
            logger.debug(this.logPrefix + " redisNameList     :" + arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug(this.logPrefix + " [getRedisMeasureNonInfoBased] The Metric key and value table is : " + hashtable4);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureNonInfoBased] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureNonInfoBased] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d = Double.parseDouble(object.toString());
                        arrayList2.set(n, new Double(d));
                        logger.debug(this.logPrefix + " [getRedisMeasureNonInfoBased] index : " + n + " ==> metric name : " + string4 + " value: " + d);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureNonInfoBased] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
                logger.info(this.logPrefix + "  [getRedisMeasureNonInfoBased]  The ArrayList  measure contains = " + arrayList2);
                this.addMeasures(arrayList2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureNonInfoBased] ", (Throwable)exception);
        }
    }

    public void getRedisMeasureInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureInfoBased]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                modifiedDate = new Date(l2);
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
                l = l2;
            }
            logger.debug(" metricObject      :" + hashtable);
            logger.debug(" measureIndexTable :" + hashtable2);
            logger.debug(" measureNameTable  :" + hashtable3);
            logger.debug(" redisNameList     :" + arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                logger.debug(this.logPrefix + "[getRedisMeasureInfoBased] The Test Name is  : " + string3);
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug(this.logPrefix + " [getRedisMeasureInfoBased] The Discriptor Table is : " + hashtable4);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureInfoBased] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Hashtable hashtable5 = null;
                    try {
                        hashtable5 = (Hashtable)hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureInfoBased] Exception occured while getting fetching the values from discriptor table ", (Throwable)exception);
                    }
                    this.isDescriptorName = true;
                    descriptorName = string4;
                    if (hashtable5 == null || hashtable5.size() <= 0) continue;
                    Iterator iterator3 = (Iterator)((Object)hashtable5.keys());
                    while (iterator3.hasNext()) {
                        String string5 = (String)iterator3.next();
                        Object object = null;
                        try {
                            object = hashtable5.get(string5);
                        }
                        catch (Exception exception) {
                            logger.error(this.logPrefix + " [getRedisMeasureInfoBased] Exception occured while getting fetching the values from metric table " + hashtable5, (Throwable)exception);
                        }
                        if (!arrayList.contains(string5)) continue;
                        String string6 = (String)hashtable3.get(string5);
                        int n = Integer.parseInt(hashtable2.get(string6).toString());
                        try {
                            double d = Double.parseDouble(object.toString());
                            arrayList2.set(n, new Double(d));
                            logger.debug(this.logPrefix + " [getRedisMeasureInfoBased] discriptor : " + descriptorName + " index : " + n + " ==> metric name : " + string5 + " value : " + d);
                        }
                        catch (Exception exception) {
                            logger.error(this.logPrefix + " [getRedisMeasureInfoBased] Exception occured while parsing String to Double", (Throwable)exception);
                        }
                    }
                    logger.info(this.logPrefix + " [getRedisMeasureInfoBased] " + descriptorName + ",The ArrayList  measure contains = " + arrayList2);
                    this.addMeasures(descriptorName, arrayList2);
                }
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureNonInfoBased] ", (Throwable)exception);
        }
    }

    public boolean isRedisRestarted() {
        String string = this.getMetrics("Server");
        Hashtable hashtable = this.parseMetrics(string, false);
        Hashtable hashtable2 = (Hashtable)hashtable.get("Server");
        Object v = hashtable2.get("uptime_in_seconds");
        try {
            double d = Double.parseDouble(v.toString());
            logger.debug(this.logPrefix + "The up time of Redis : " + d);
            logger.debug(this.logPrefix + "The previous uptime of Redis : " + previousUpTime);
            if (previousUpTime > d) {
                isRestarted = true;
                previousUpTime = d;
                logger.debug(this.logPrefix + " [getRedisMeasureForCommandStats] Redis Server has been restarted......");
            } else {
                isRestarted = false;
                previousUpTime = d;
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [getRedisMeasureForCommandStats] Exception occured while parsing the String to Double", (Throwable)exception);
        }
        return isRestarted;
    }

    static {
        previousUpTime = 0.0;
        isRestarted = false;
    }
}

