/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import redis.clients.jedis.Jedis;

public class RedisClntGrpTest
extends RedisBase {
    boolean uploadStatus = false;
    public static final Hashtable flagDiscriptionTable = new Hashtable();
    private String clientList = "";

    static {
        flagDiscriptionTable.put("O", "Slave in monitor mode");
        flagDiscriptionTable.put("S", "Normal slave server");
        flagDiscriptionTable.put("M", "Master");
        flagDiscriptionTable.put("x", "MULTI/EXEC context");
        flagDiscriptionTable.put("b", "Waiting in a blocking operation");
        flagDiscriptionTable.put("i", "Waiting for a VM I/O");
        flagDiscriptionTable.put("d", "A watched keys has been modified - EXEC will fail");
        flagDiscriptionTable.put("c", "Connection to be closed after writing entire reply");
        flagDiscriptionTable.put("u", "Unblocked");
        flagDiscriptionTable.put("U", "Connected via a Unix domain socket");
        flagDiscriptionTable.put("r", "Readonly mode against a cluster node");
        flagDiscriptionTable.put("A", "Connection to be closed ASAP");
        flagDiscriptionTable.put("N", "No specific flag set");
    }

    public RedisClntGrpTest(String[] args) {
        super(args);
        try {
            this.needAgentlessDD = true;
            logger.info(String.valueOf(this.logPrefix) + " Initializing RedisClientByGroupTest ...");
            this.setMeasureCount(this.measureCount);
            logger.info(String.valueOf(this.logPrefix) + " RedisClientByGroupTest initialized successfully");
        }
        catch (Exception e) {
            logger.error(String.valueOf(this.logPrefix) + " Exception while initializing RedisClientByGroupTest", (Throwable)e);
        }
    }

    public void computeMeasures(Hashtable params) {
        try {
            try {
                logger.debug(String.valueOf(this.logPrefix) + this.testStart);
                this.getClientListByGroup();
            }
            catch (Exception exp) {
                logger.error(String.valueOf(this.logPrefix) + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exp);
                logger.debug(String.valueOf(this.logPrefix) + this.testEnd);
            }
        }
        finally {
            logger.debug(String.valueOf(this.logPrefix) + this.testEnd);
        }
    }

    public ArrayList getClientDetails() {
        String clientList = this.getclientList();
        logger.debug("[RedisClientByGroupTest] [getClientDetails] The Client List is :  \n" + clientList);
        StringTokenizer lineTokenizer = new StringTokenizer(clientList, "\n");
        ArrayList clientsDetails = new ArrayList();
        while (lineTokenizer.hasMoreTokens()) {
            String lineString = lineTokenizer.nextToken().trim();
            if (lineString.contains("cmd=replconf")) continue;
            StringTokenizer spaceTokenizer = new StringTokenizer(lineString, " ");
            ArrayList<String> innerList = new ArrayList<String>();
            while (spaceTokenizer.hasMoreTokens()) {
                String tokenString = spaceTokenizer.nextToken();
                int equal_index = tokenString.indexOf("=");
                if (equal_index <= 0) continue;
                String value = tokenString.substring(equal_index + 1);
                innerList.add(value);
            }
            clientsDetails.add(innerList);
        }
        return clientsDetails;
    }

    public boolean getClientListByGroup() {
        ArrayList clientsList = null;
        boolean success = false;
        String groupSeperator = ":";
        try {
            clientsList = this.getClientDetails();
            if (clientsList == null || clientsList.size() == 0) {
                this.finalMeasures(this.measureCount);
                logger.info(String.valueOf(this.logPrefix) + " Redis Client List Details is null or empty, hence sending -5 values for all measures ");
                return success;
            }
            logger.debug("[" + this.reportingName + ":" + this.portNo + "][RedisClientByGroupTest] [getClientListByGroup] The ClientDetails are " + clientsList);
            int i = 0;
            while (i < clientsList.size()) {
                String events;
                String oll;
                String multi;
                String psub;
                String sub;
                String db;
                String idle;
                String age;
                String name;
                String fd;
                ArrayList measure = this.finalMeasures(this.measureCount);
                ArrayList valueList = (ArrayList)clientsList.get(i);
                String id = (String)valueList.get(0);
                if (id == null || id.length() == 0) {
                    id = "-";
                }
                String ipAndPort = (String)valueList.get(1);
                String ip = ipAndPort.substring(0, ipAndPort.indexOf(58));
                String port = ipAndPort.substring(ipAndPort.indexOf(58) + 1);
                if (ipAndPort == null || ipAndPort.length() == 0) {
                    ip = "-";
                    port = "-";
                }
                if ((fd = (String)valueList.get(2)) == null || fd.length() == 0) {
                    fd = "-";
                }
                if ((name = (String)valueList.get(3)) == null || name.length() == 0) {
                    name = "-";
                }
                if ((age = (String)valueList.get(4)) == null || age.length() == 0) {
                    age = "-";
                }
                if ((idle = (String)valueList.get(5)) == null || idle.length() == 0) {
                    idle = "-";
                }
                String flags = (String)valueList.get(6);
                if ((flags = (String)flagDiscriptionTable.get(flags)) == null || flags.length() == 0) {
                    flags = "-";
                }
                if ((db = (String)valueList.get(7)) == null || db.length() == 0) {
                    db = "-";
                }
                if ((sub = (String)valueList.get(8)) == null || sub.length() == 0) {
                    sub = "-";
                }
                if ((psub = (String)valueList.get(9)) == null || psub.length() == 0) {
                    psub = "-";
                }
                if ((multi = (String)valueList.get(10)) == null || multi.length() == 0) {
                    multi = "-";
                }
                String qbuf = (String)valueList.get(11);
                if ((qbuf = EgUtils.convertMemoryValues(qbuf, "B", "MB")) == null || qbuf.length() == 0) {
                    qbuf = "-";
                }
                String qbuf_free = (String)valueList.get(12);
                qbuf_free = EgUtils.convertMemoryValues(qbuf, "B", "MB");
                if (qbuf_free == null || qbuf_free.length() == 0) {
                    qbuf_free = "-";
                }
                String obl = (String)valueList.get(13);
                if ((obl = EgUtils.convertMemoryValues(obl, "B", "MB")) == null || obl.length() == 0) {
                    obl = "-";
                }
                if ((oll = (String)valueList.get(14)) == null || oll.length() == 0) {
                    oll = "-";
                }
                String omem = (String)valueList.get(15);
                if ((omem = EgUtils.convertMemoryValues(omem, "B", "MB")) == null || omem.length() == 0) {
                    omem = "-";
                }
                if ((events = (String)valueList.get(16)) == null || events.length() == 0) {
                    events = "-";
                } else if (events.equals("r")) {
                    events = "readable";
                } else if (events.equals("w")) {
                    events = "writable";
                }
                String cmd = (String)valueList.get(17);
                if (cmd == null || cmd.length() == 0) {
                    cmd = "-";
                }
                measure.set(0, new Double(id));
                measure.set(1, new Double(-5.0));
                measure.set(2, new Double(port));
                measure.set(3, new Double(fd));
                measure.set(4, new Double(db));
                measure.set(5, new Double(age));
                measure.set(6, new Double(idle));
                measure.set(7, new Double(sub));
                measure.set(8, new Double(psub));
                measure.set(9, new Double(qbuf));
                measure.set(10, new Double(qbuf_free));
                measure.set(11, new Double(obl));
                measure.set(12, new Double(oll));
                measure.set(13, new Double(omem));
                if (!name.equals("-")) {
                    this.addNewMeasure(String.valueOf(ip) + ":" + name, measure);
                    logger.info("[" + this.reportingName + ":" + this.portNo + "][RedisClientByGroupTest] [getClientListByGroup] " + ip + ":" + " Client Name: " + name + " , The ArrayList measure contains =" + measure);
                } else {
                    this.addNewMeasure(String.valueOf(ip) + ":" + id, measure);
                    logger.info("[" + this.reportingName + ":" + this.portNo + "][RedisClientByGroupTest] [getClientListByGroup]  " + ip + ":" + "Client ID: " + id + " : The ArrayList measure contains = " + measure);
                }
                ++i;
            }
            success = true;
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + ":" + this.portNo + "][RedisClientByGroupTest] [getClientListByGroup] Exception while fetching the values", (Throwable)e);
        }
        return success;
    }

    public String getclientList() {
        Jedis jedis = this.getConnection();
        if (jedis == null) {
            logger.debug("[getRedisMeasureClient] [getclientList] jedis is returning null...");
        } else {
            this.clientList = jedis.clientList();
            logger.debug("[getRedisMeasureClient] [getclientList] The Client List is :  \n" + this.clientList);
            jedis.close();
        }
        return this.clientList;
    }

    public static void main(String[] args) {
        RedisClntGrpTest dd = new RedisClntGrpTest(null);
        dd.computeMeasures(new Hashtable());
    }
}

