/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import redis.clients.jedis.Jedis;

public class RedisClusterTest
extends RedisBase {
    private static final String REDIS_CLUSTER_COMMAND = "Cluster";
    private static final String indexSubject = "REDIS_CLUSTER_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_CLUSTER_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private Hashtable previousClusterNodesDetails = new Hashtable();
    private Hashtable currentClusterNodesDetails = new Hashtable();
    Hashtable addedClusterNodesDetails = new Hashtable();
    Hashtable deletedClusterNodesDetails = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static Date modifiedDate;
    private static final boolean isInfoBased = false;
    public boolean isClusterEnabled = false;

    public RedisClusterTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisClusterTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisClusterTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisClusterTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_CLUSTER_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Cluster Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                ArrayList arrayList = this.getRedisCluster(hashtable2, string);
                logger.info(this.logPrefix + "  [computeMeasures]  The ArrayList  measure contains = " + arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public ArrayList getRedisCluster(Hashtable hashtable, String string) {
        ArrayList arrayList = this.finalMeasures(this.measureCount);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisCluster]  metricObject is null or empty ,thus returning null");
            return arrayList;
        }
        long l = this.getModifiedTime();
        if (l - this.lastModifiedTime > 0L) {
            modifiedDate = new Date(l);
            this.updateINIFileObject();
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = l;
        }
        logger.debug(this.logPrefix + " metricObject :" + hashtable);
        logger.debug(this.logPrefix + " measureIndexTable :" + measureIndexTable);
        logger.debug(this.logPrefix + " measureNameTable  :" + measureNameTable);
        logger.debug(this.logPrefix + " redisNameList     :" + redisNameList);
        Iterator iterator = (Iterator)((Object)hashtable.keys());
        block9: while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Hashtable hashtable2 = null;
            try {
                hashtable2 = (Hashtable)hashtable.get(string2);
                logger.debug(this.logPrefix + " [getRedisCluster] The Metric key and value table is : " + hashtable2);
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + " [getRedisCluster] Exception occured while fetching the values from testTable ", (Throwable)exception);
            }
            if (hashtable2 == null || hashtable2.size() <= 0) continue;
            Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
            while (iterator2.hasNext()) {
                String string3 = (String)iterator2.next();
                Object object = null;
                try {
                    object = hashtable2.get(string3);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisCluster] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                }
                if (!redisNameList.contains(string3)) continue;
                String string4 = (String)measureNameTable.get(string3);
                int n = Integer.parseInt(measureIndexTable.get(string4).toString());
                try {
                    double d = Double.parseDouble(object.toString());
                    if (n == 0 && d == 1.0) {
                        String string5 = "clusterInfo";
                        this.isClusterEnabled = true;
                        logger.debug("[" + this.reportingName + ":" + this.portNo + "] [RedisClusterTest] [getClusterNodesDetails] Is cluster enabled  : " + this.isClusterEnabled);
                        this.getClusterNodesDetails();
                        String string6 = this.getClusterDetails(string5);
                        string = string + string6;
                        logger.debug(this.logPrefix + " [getRedisCluster]  Cluster info command result : " + string);
                        Hashtable hashtable3 = this.parseMetrics(string, false);
                        arrayList = this.getRedisClusterWithClusterInfo(hashtable3, arrayList);
                        return arrayList;
                    }
                    this.isClusterEnabled = false;
                    logger.debug("[" + this.reportingName + ":" + this.portNo + "] [RedisClusterTest] [getClusterNodesDetails] Is cluster enabled  : " + this.isClusterEnabled);
                    arrayList.set(n, new Double(d));
                    return arrayList;
                }
                catch (Exception exception) {
                    try {
                        logger.error(this.logPrefix + " [getRedisCluster] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                    catch (Exception exception2) {
                        logger.error(this.logPrefix + " Exception occered in [getRedisCluster] ", (Throwable)exception2);
                        break block9;
                    }
                }
            }
        }
        return arrayList;
    }

    public ArrayList getRedisClusterWithClusterInfo(Hashtable hashtable, ArrayList arrayList) {
        try {
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug(this.logPrefix + " [getRedisClusterWithClusterInfo] The Metric key and value table is : " + hashtable2);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisClusterWithClusterInfo] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                        logger.debug(this.logPrefix + " [getRedisClusterWithClusterInfo] The metric name is : " + string2 + " and its value is : " + object);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisClusterWithClusterInfo] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    String string4 = object.toString();
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    try {
                        double d;
                        if (n == 0) {
                            arrayList.set(n, new Double(-5.0));
                            continue;
                        }
                        if (n == 5) {
                            if (string4.equalsIgnoreCase("fail")) {
                                d = 0.0;
                                arrayList.set(n, new Double(d));
                                logger.debug(this.logPrefix + " [getRedisClusterWithClusterInfo]  index : " + n + " ==> metric name : " + string2 + " value : " + d);
                                continue;
                            }
                            if (!string4.equalsIgnoreCase("ok")) continue;
                            d = 1.0;
                            arrayList.set(n, new Double(d));
                            logger.debug(this.logPrefix + " [getRedisClusterWithClusterInfo]  index : " + n + " ==> metric name : " + string2 + " value : " + d);
                            continue;
                        }
                        d = Double.parseDouble(string4);
                        arrayList.set(n, new Double(d));
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisClusterWithClusterInfo] Exception occured while parsing String to Double");
                    }
                }
                arrayList.set(12, new Double(this.addedClusterNodesDetails.size()));
                arrayList.set(13, new Double(this.deletedClusterNodesDetails.size()));
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisClusterWithClusterInfo] ", (Throwable)exception);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterDetails(String string) {
        Jedis jedis = null;
        String string2 = null;
        try {
            jedis = this.getConnection();
            string2 = null;
            if (string.equalsIgnoreCase("clusterInfo")) {
                string2 = jedis.clusterInfo();
            } else if (string.equalsIgnoreCase("clusterNodes") && this.isClusterEnabled) {
                string2 = jedis.clusterNodes();
            }
        }
        catch (Exception exception) {
            logger.error("[" + this.reportingName + ":" + this.portNo + "] [RedisClusterTest] [getClusterDetails] Exception occured while connecting redis cluster " + exception);
        }
        finally {
            this.closeConnection(jedis);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Hashtable getClusterNodesDetails() {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        try {
            boolean bl = this.isClusterEnabled;
            if (bl) {
                String string = "clusterNodes";
                String string2 = this.getClusterDetails(string);
                logger.debug("[" + this.reportingName + ":" + this.portNo + "] [RedisClusterTest] [getClusterNodesDetails] Cluster nodes result : " + string2);
                if (string2 != null && string2.length() > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
                        String string3 = "-";
                        String string4 = "-";
                        String string5 = "-";
                        String string6 = "-";
                        String string7 = "-";
                        String string8 = "-";
                        String string9 = "-";
                        String string10 = "-";
                        String string11 = "";
                        String string12 = "-";
                        String string13 = stringTokenizer.nextToken().trim();
                        String[] stringArray = string13.split(" ");
                        string3 = stringArray[0];
                        String string14 = stringArray[1];
                        if (string14.contains(":") && string14.length() > 5) {
                            StringTokenizer stringTokenizer2 = new StringTokenizer(string14, ":");
                            while (stringTokenizer2.hasMoreTokens()) {
                                string4 = stringTokenizer2.nextToken();
                                string5 = stringTokenizer2.nextToken();
                                string5 = string5.contains("@") ? string5.substring(0, string5.indexOf("@")) : string5;
                            }
                        }
                        string6 = stringArray[2];
                        string7 = stringArray[3];
                        string8 = stringArray[4];
                        string9 = stringArray[5];
                        string10 = stringArray[6];
                        string11 = stringArray[7];
                        string12 = stringArray.length > 8 ? stringArray[8] : "-";
                        hashtable3.put("nodeId", string3);
                        hashtable3.put("ip", string4);
                        hashtable3.put("port", string5);
                        hashtable3.put("flag", string6);
                        hashtable3.put("masterId", string7);
                        hashtable3.put("pingSent", string8);
                        hashtable3.put("pongReceived", string9);
                        hashtable3.put("configVersion", string10);
                        hashtable3.put("linkStaus", string11);
                        hashtable3.put("slot", string12);
                        hashtable.put(string3, hashtable3);
                        hashtable2 = hashtable3;
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error("[" + this.reportingName + ":" + this.portNo + "][RedisClusterTest] [getClusterNodesDetails] Exception while fetching the values", (Throwable)exception);
        }
        finally {
            logger.debug("[" + this.reportingName + ":" + this.portNo + "]  RedisClusterTest - Test cycle END ");
        }
        logger.info(this.logPrefix + "  [getClusterNodesDetails]  previousClusterNodesDetails  = " + this.previousClusterNodesDetails);
        this.currentClusterNodesDetails = hashtable;
        logger.info(this.logPrefix + "  [getClusterNodesDetails]  currentClusterNodesDetails  = " + this.currentClusterNodesDetails);
        this.getAddedClusterNodesDetails();
        this.getDeletedClusterNodesDetails();
        this.previousClusterNodesDetails = this.currentClusterNodesDetails;
        return hashtable;
    }

    Hashtable getAddedClusterNodesDetails() {
        Hashtable hashtable = new Hashtable();
        if (!this.previousClusterNodesDetails.isEmpty()) {
            Iterator iterator = this.currentClusterNodesDetails.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (this.previousClusterNodesDetails.containsKey(k)) continue;
                Hashtable hashtable2 = (Hashtable)this.currentClusterNodesDetails.get(k);
                hashtable.put(k, hashtable2);
            }
        }
        logger.info(this.logPrefix + "  [getAddedClusterNodesDetails]  addedNodes  = " + hashtable);
        this.addedClusterNodesDetails = hashtable;
        return hashtable;
    }

    private Hashtable getDeletedClusterNodesDetails() {
        Hashtable hashtable = new Hashtable();
        if (!this.currentClusterNodesDetails.isEmpty()) {
            Iterator iterator = this.previousClusterNodesDetails.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                if (this.currentClusterNodesDetails.containsKey(k)) continue;
                Hashtable hashtable2 = (Hashtable)this.previousClusterNodesDetails.get(k);
                hashtable.put(k, hashtable2);
            }
        }
        logger.info(this.logPrefix + "  [getDeletedClusterNodesDetails] deletedNodes = " + hashtable);
        this.deletedClusterNodesDetails = hashtable;
        return hashtable;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisClusterTest redisClusterTest = new RedisClusterTest(stringArray);
        while (true) {
            redisClusterTest.computeMeasures(new Hashtable());
            Thread.sleep(10000L);
        }
    }
}

