/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import redis.clients.jedis.Jedis;

public class RedisServerTest
extends RedisBase {
    private static final String REDIS_HITRATIO_COMMAND = "Stats";
    private static final String indexSubject = "REDIS_HITRATIO_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_HITRATIO_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private double previousHitValue = 0.0;
    private double previousMissValue = 0.0;
    private static Date modifiedDate;

    public RedisServerTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisServerTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisClientTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisServerTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_HITRATIO_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis HitRatio Details is null or empty, hence sending -5 values for all measures ");
            } else {
                ArrayList arrayList = this.finalMeasures(this.measureCount);
                Hashtable hashtable2 = this.parseMetrics(string, false);
                arrayList.set(0, this.getRedisMeasureForHitRatio(hashtable2));
                arrayList.set(1, this.getRedisLatency());
                this.addNewMeasure(arrayList);
                logger.info(this.logPrefix + "  [getRedisMeasureForHitRatio]  The ArrayList  measure contains = " + arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public Double getRedisMeasureForHitRatio(Hashtable hashtable) {
        Double d = new Double(-5.0);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureForHitRatio]  metricObject is null or empty ,thus returning null");
            return d;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                modifiedDate = new Date(l);
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + measureIndexTable);
            logger.debug(this.logPrefix + " measureNameTable  :" + measureNameTable);
            logger.debug(this.logPrefix + " redisNameList     :" + redisNameList);
            double d2 = 0.0;
            double d3 = 0.0;
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug(this.logPrefix + " [getRedisMeasureForHitRatio] The Metric key and value table is : " + hashtable2);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureForHitRatio] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForHitRatio] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    try {
                        if (n == 0) {
                            d2 = Double.parseDouble(object.toString());
                            logger.debug(this.logPrefix + " [getRedisMeasureForHitRatio] Previous hit value : " + this.previousHitValue + " The new hit value is  : " + d2);
                            continue;
                        }
                        if (n != 1) continue;
                        d3 = Double.parseDouble(object.toString());
                        logger.debug(this.logPrefix + " [getRedisMeasureForHitRatio] Previous hit value : " + this.previousMissValue + " The new miss value is  : " + d3);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForHitRatio] Exception occured while parsing String to Double");
                    }
                }
            }
            if (this.previousHitValue < d2 || this.previousMissValue < d3) {
                double d4 = d2 - this.previousHitValue;
                double d5 = d3 - this.previousMissValue;
                double d6 = d4 / (d4 + d5) * 100.0;
                d = new Double(new DecimalFormat("##").format(d6));
                this.previousHitValue = d2;
                this.previousMissValue = d3;
            } else if (this.isRedisRestarted()) {
                double d7 = d2 / (d2 + d3) * 100.0;
                d = new Double(new DecimalFormat("##").format(d7));
            } else {
                d = new Double(-5.0);
                logger.info(this.logPrefix + "  [getRedisMeasureForHitRatio] No Hit Rate right now... ");
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureForHitRatio] ", (Throwable)exception);
        }
        return d;
    }

    public Double getRedisLatency() {
        Double d;
        block5: {
            d = new Double(-5.0);
            try {
                Jedis jedis = this.getConnection();
                List list = jedis.time();
                jedis.info();
                List list2 = jedis.time();
                this.closeConnection(jedis);
                double d2 = Double.parseDouble((String)list.get(1));
                logger.debug(this.logPrefix + " [getRedisLatency] Starting Time : " + d2);
                double d3 = Double.parseDouble((String)list2.get(1));
                logger.debug(this.logPrefix + " [getRedisLatency] Ending Time : " + d3);
                try {
                    String string = new DecimalFormat("##.##").format((d3 - d2) / 1000.0);
                    if (string != null) {
                        d = new Double(string);
                        break block5;
                    }
                    d = new Double(-5.0);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " Exception occured while parsing String to Double", (Throwable)exception);
                }
            }
            catch (Exception exception) {
                logger.error(this.logPrefix + " Exception occered in getRedisMeasure", (Throwable)exception);
            }
        }
        return d;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisServerTest redisServerTest = new RedisServerTest(stringArray);
        while (true) {
            redisServerTest.computeMeasures(new Hashtable());
            Thread.sleep(10000L);
        }
    }
}

