/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisStatsTest
extends RedisBase {
    private static final String REDIS_STATS_COMMAND = "Stats";
    private static final String indexSubject = "REDIS_STATS_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_STATS_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private double previousValueOfCommands = 0.0;
    private double previousValueOfRejectedConnections = 0.0;
    private double previousValueOfEvictedKeys = 0.0;
    private double previousValueOfConnections = 0.0;
    private double previousValueOfHit = 0.0;
    private double previousValueOfMiss = 0.0;
    private double previousValueOfNetInput = 0.0;
    private double previousValueOfNetOutput = 0.0;
    private double previousValueOfExpiredKeys = 0.0;

    public RedisStatsTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisStatsTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisStatsTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisStatsTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_STATS_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Stats Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureForStats(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public void getRedisMeasureForStats(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureForStats]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                new Date(l);
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + measureIndexTable);
            logger.debug(this.logPrefix + " measureNameTable  :" + measureNameTable);
            logger.debug(this.logPrefix + " redisNameList     :" + redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                Object object;
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug(this.logPrefix + " [getRedisMeasureForStats] The Metric key and value table is : " + hashtable2);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureForStats] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                double d = 0.0;
                double d2 = 0.0;
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object2 = null;
                    try {
                        object2 = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForStats] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    object = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(object).toString());
                    double d3 = 0.0;
                    try {
                        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6 && n != 7 && n != 8 && n != 19) {
                            d3 = Double.parseDouble(object2.toString());
                            arrayList.set(n, new Double(d3));
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] index : " + n + " ==> metric name : " + string2 + " value : " + d3);
                            continue;
                        }
                        if (n == 0) {
                            double d4 = Double.parseDouble(object2.toString());
                            d3 = d4 >= this.previousValueOfHit ? d4 - this.previousValueOfHit : d4;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfHit : " + this.previousValueOfHit + " HitsKeyValue : " + d4);
                            this.previousValueOfHit = d4;
                            d = d3;
                        } else if (n == 1) {
                            double d5 = Double.parseDouble(object2.toString());
                            d3 = d5 >= this.previousValueOfMiss ? d5 - this.previousValueOfMiss : d5;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfMissValue : " + this.previousValueOfMiss + " missedKeyValue : " + d5);
                            this.previousValueOfMiss = d5;
                            d2 = d3;
                        } else if (n == 2) {
                            double d6 = Double.parseDouble(object2.toString());
                            d3 = d6 >= this.previousValueOfExpiredKeys ? d6 - this.previousValueOfExpiredKeys : d6;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfExpiredKeys : " + this.previousValueOfExpiredKeys + " expiredKeyValue : " + d6);
                            this.previousValueOfExpiredKeys = d6;
                        } else if (n == 3) {
                            double d7 = Double.parseDouble(object2.toString());
                            d3 = d7 >= this.previousValueOfEvictedKeys ? d7 - this.previousValueOfEvictedKeys : d7;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfEvictedKeys : " + this.previousValueOfEvictedKeys + " evictedKeyValue : " + d7);
                            this.previousValueOfEvictedKeys = d7;
                        } else if (n == 4) {
                            double d8 = Double.parseDouble(object2.toString());
                            d3 = d8 >= this.previousValueOfRejectedConnections ? d8 - this.previousValueOfRejectedConnections : d8;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfRejectedConnections : " + this.previousValueOfRejectedConnections + " rejectecdConnValue : " + d8);
                            this.previousValueOfRejectedConnections = d8;
                        } else if (n == 5) {
                            double d9 = Double.parseDouble(object2.toString());
                            d3 = d9 >= this.previousValueOfConnections ? d9 - this.previousValueOfConnections : d9;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfConnections : " + this.previousValueOfConnections + " connValue : " + d9);
                            this.previousValueOfConnections = d9;
                        } else if (n == 6) {
                            double d10 = Double.parseDouble(object2.toString());
                            d3 = d10 >= this.previousValueOfCommands ? d10 - this.previousValueOfCommands : d10;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfCommands : " + this.previousValueOfCommands + " cmdValue : " + d10);
                            this.previousValueOfCommands = d10;
                        } else if (n == 7) {
                            double d11 = Double.parseDouble(EgUtils.convertMemoryValues(object2.toString(), "B", "MB"));
                            d3 = d11 >= this.previousValueOfNetInput ? d11 - this.previousValueOfNetInput : d11;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfNetInput : " + this.previousValueOfNetInput + " totalNetIns : " + d11);
                            this.previousValueOfNetInput = d11;
                        } else if (n == 8) {
                            double d12 = Double.parseDouble(EgUtils.convertMemoryValues(object2.toString(), "B", "MB"));
                            d3 = d12 >= this.previousValueOfNetOutput ? d12 - this.previousValueOfNetOutput : d12;
                            logger.debug(this.logPrefix + " [getRedisMeasureForStats] " + string2 + "-index:" + n + " ==> previousValueOfNetOutput : " + this.previousValueOfNetOutput + " new totalNetOuts : " + d12);
                            this.previousValueOfNetOutput = d12;
                        }
                        arrayList.set(n, new Double(d3));
                        logger.debug(this.logPrefix + " [getRedisMeasureForStats] index : " + n + " ==> metric name : " + string2 + " value : " + d3);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForStats] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
                double d13 = d + d2;
                object = null;
                object = d13 > 0.0 && this.measurePeriod > 0L ? new Double(new DecimalFormat("##").format(d13 / (double)this.measurePeriod * 1000.0)) : new Double(0.0);
                arrayList.set(19, object);
                logger.debug(this.logPrefix + " [getRedisMeasureForStats] index : 19\t ==> metric name : lookups per second  value : " + object);
                logger.info(this.logPrefix + "  [getRedisMeasureForStats] The ArrayList  measure contains = " + arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureForStats] ", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) throws InterruptedException {
        while (true) {
            RedisStatsTest redisStatsTest = new RedisStatsTest(stringArray);
            redisStatsTest.computeMeasures(new Hashtable());
            Thread.sleep(60000L);
        }
    }
}

