/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisUptimeTest
extends RedisBase {
    private static final String REDIS_SERVER_COMMAND = "Server";
    private static final String indexSubject = "REDIS_UPTIME_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_UPTIME_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;

    public RedisUptimeTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisUptimeTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisUptimeTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisUptimeTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_SERVER_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Server Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureNonInfoBased(hashtable2, nameSubject, indexSubject, measureIndexTable, measureNameTable, redisNameList, this.lastModifiedTime);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public void getRedisMeasureNonInfoBased(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureNonInfoBased]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                modifiedDate = new Date(l2);
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + hashtable2);
            logger.debug(this.logPrefix + " measureNameTable  :" + hashtable3);
            logger.debug(this.logPrefix + " redisNameList     :" + arrayList);
            ArrayList arrayList2 = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug(this.logPrefix + " [getRedisMeasureNonInfoBased] The Metric key and value table is : " + hashtable4);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureNonInfoBased] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureNonInfoBased] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d = Double.parseDouble(object.toString());
                        if (n == 0) {
                            arrayList2.set(n, new Double(new DecimalFormat("##").format(d /= 60.0)));
                        } else {
                            arrayList2.set(n, new Double(d));
                        }
                        logger.debug(this.logPrefix + " [getRedisMeasureNonInfoBased] index : " + n + " ==> metric name : " + string4 + " value: " + d);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureNonInfoBased] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
                logger.info(this.logPrefix + "  [getRedisMeasureNonInfoBased]  The ArrayList  measure contains = " + arrayList2);
                this.addNewMeasure(arrayList2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureNonInfoBased] ", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        RedisUptimeTest redisUptimeTest = new RedisUptimeTest(stringArray);
        redisUptimeTest.computeMeasures(new Hashtable());
    }
}

