/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.sap.mw.jco.JCO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SapAlertsJco2Test
extends AsAbapJco2Base {
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private int alert = 0;
    private int redAlert = 0;
    private int yellowAlert = 0;
    private int greenAlert = 0;
    private int active = 0;
    private int completed = 0;
    private int autocompleted = 0;
    public Hashtable ddHash = new Hashtable();
    public String monSets = "";
    public String mons = "";
    protected static final TimeZone UTCTZ = TimeZone.getTimeZone("UTC");
    public String MonitorName = "";
    public String MonitorSetName = "";
    public Hashtable detHT;
    public int testFreqMins = 0;
    private long lastUpdateMillis;
    protected SimpleDateFormat fixedParamSDF = new SimpleDateFormat("yyyyMMddHHmmss");
    private static Hashtable timestampFormatsTbl = new Hashtable();
    private static Hashtable SAPJavaTZTbl;
    boolean isFirstTime = true;
    private String auditLvlStr = null;
    protected TimeZone userTZ;
    private Calendar SAPUserCal = new GregorianCalendar();
    public static final SimpleDateFormat APISDF;
    public SimpleDateFormat userSDF;
    private static final ArrayList perfAttrList;
    public static final String MON_SET_NAME = "SAP CCMS Monitor Templates";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SapAlertsJco2Test(String[] stringArray) {
        super(stringArray);
        String string;
        this.lastUpdateMillis = System.currentTimeMillis();
        this.setMeasureCount(7);
        this.monSets = this.getValueForParam("Sets");
        this.mons = this.getValueForParam("Monitors");
        this.printOut("INFO  : monitor sets are " + this.monSets + " and monitors are " + this.mons);
        this.detHT = this.parseMonDetails(this.monSets, this.mons);
        if (fieldSep.length() == 0) {
            string = sync0;
            synchronized (string) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        string = this.getValueForParam("egMeasPeriod");
        try {
            int n = Integer.parseInt(string);
            this.testFreqMins = n / 60;
        }
        catch (NumberFormatException numberFormatException) {
            this.printOut("ERROR : Could not parse measure period " + string + " : " + numberFormatException.toString());
            this.logToErrorFile("ERROR", this.thisServer, "Could not parse measure period " + string + ". Using 5 mintes. Exception : " + numberFormatException.toString());
            this.testFreqMins = 5;
        }
        this.auditLvlStr = this.getValueForParam("XMI_Audit_Level");
    }

    public synchronized Hashtable getDDData() {
        return this.ddHash;
    }

    public void resetDDData() {
        if (this.ddHash.size() != 0) {
            this.ddHash = new Hashtable();
        }
    }

    public synchronized Hashtable getMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        this.resetDDData();
        JCO.Client client2 = this.getConnection();
        if (client2 == null) {
            Enumeration enumeration = this.detHT.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ArrayList arrayList = (ArrayList)this.detHT.get(string);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.MonitorName = (String)arrayList.get(i);
                    this.getNotAvailableMeasure(hashtable2, this.MonitorName);
                }
            }
            return hashtable2;
        }
        String[] stringArray = this.getUTCRangeFromTestFreq();
        if (!this.logonToXMI("XAL", "1.0", client2)) {
            Enumeration enumeration = this.detHT.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                ArrayList arrayList = (ArrayList)this.detHT.get(string);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.MonitorName = (String)arrayList.get(i);
                    this.getNotAvailableMeasure(hashtable2, this.MonitorName);
                }
            }
            return hashtable2;
        }
        this.setXMIAuditLevel(this.auditLvlStr, client2);
        if (this.isFirstTime) {
            this.setDatePatternAndTimeZone(client2);
            this.isFirstTime = false;
        }
        Enumeration enumeration = this.detHT.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)this.detHT.get(string);
            for (int i = 0; i < arrayList.size(); ++i) {
                this.MonitorName = (String)arrayList.get(i);
                if (this.processAlerts(string, this.MonitorName, stringArray, client2, hashtable2)) continue;
                this.getNotAvailableMeasure(hashtable2, this.MonitorName);
            }
        }
        if (client2 != null) {
            this.logoffAndReleaseClient(client2);
        }
        return hashtable2;
    }

    boolean processAlerts(String string, String string2, String[] stringArray, JCO.Client client2, Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            JCO.Table table = this.getTreeNodesTblForMonitor(string, string2, client2);
            if (table == null) {
                return false;
            }
            JCO.Function function = this.createFunction("BAPI_SYSTEM_MT_GETALERTDATA");
            if (function == null) {
                return false;
            }
            function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            function.getImportParameterList().setValue("X", "GET_ALERT_HISTORY");
            function.getImportParameterList().setValue(stringArray[0], "START_TIMESTAMP");
            function.getImportParameterList().setValue(stringArray[1], "END_TIMESTAMP");
            JCO.ParameterList parameterList = function.getTableParameterList();
            parameterList.setValue(table, "TREE_NODES");
            try {
                this.executeFunction(function, client2, false);
            }
            catch (Exception exception) {
                this.printOut("ERROR : Exception while executing BAPI_SYSTEM_MT_GETALERTDATA function : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MT_GETALERTDATA function : " + exception.toString());
                return false;
            }
            JCO.Table table2 = parameterList.getTable("ALERT_DATA");
            String string3 = "";
            String string4 = "";
            String string5 = "";
            this.alert = 0;
            this.redAlert = 0;
            this.yellowAlert = 0;
            this.greenAlert = 0;
            this.active = 0;
            this.completed = 0;
            this.autocompleted = 0;
            this.printOut("INFO : Number of alerts for monitor " + string2 + " = " + table2.getNumRows());
            for (int i = 0; i < table2.getNumRows(); ++i) {
                table2.setRow(i);
                string5 = "No";
                String string6 = table2.getString("ALERTDATE");
                String string7 = table2.getString("ALERTTIME");
                String[] stringArray2 = this.convJCOTime2UserTime(string6, string7);
                string6 = stringArray2[0];
                string7 = stringArray2[1];
                String string8 = table2.getString("MSG");
                String string9 = table2.getString("ALSYSID");
                String string10 = table2.getString("MTMCNAME");
                String string11 = table2.getString("OBJECTNAME");
                String string12 = table2.getString("FIELDNAME");
                String string13 = table2.getString("VALUE");
                String string14 = table2.getString("SEVERITY");
                String string15 = table2.getString("STATUS");
                String string16 = table2.getString("MSEGNAME");
                String string17 = table2.getString("ALUNIQNUM");
                String string18 = table2.getString("ALINDEX");
                ++this.alert;
                int n = Integer.parseInt(string13);
                int n2 = Integer.parseInt(string15);
                if (n == 0) {
                    string4 = "grey";
                } else if (n == 1) {
                    string4 = "green";
                    ++this.greenAlert;
                } else if (n == 2) {
                    string4 = "yellow";
                    ++this.yellowAlert;
                } else if (n == 3) {
                    string4 = "red";
                    ++this.redAlert;
                }
                if (n2 == 40) {
                    string15 = "Active";
                    string5 = "Yes";
                    ++this.active;
                } else if (n2 == 200) {
                    string15 = "Done";
                    ++this.completed;
                } else if (n2 == 205) {
                    string15 = "AutoCompleted";
                    ++this.autocompleted;
                }
                string3 = string6 + fieldSep + string7 + fieldSep + string9 + fieldSep + string10 + fieldSep + string11 + fieldSep + string12 + fieldSep + string15 + fieldSep + string14 + fieldSep + string4 + fieldSep + string8;
                arrayList2.add(string3);
            }
            arrayList.add(new Double(this.alert));
            arrayList.add(new Double(this.redAlert));
            arrayList.add(new Double(this.yellowAlert));
            arrayList.add(new Double(this.greenAlert));
            arrayList.add(new Double(this.active));
            arrayList.add(new Double(this.completed));
            arrayList.add(new Double(this.autocompleted));
            this.printOut("INFO  : Adding alert summary for monitor : " + string2 + " : " + arrayList.toString());
            this.ddHash.put(string2, arrayList2);
            hashtable.put(string + ":" + string2, arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public String[] getUTCRangeFromTestFreq() {
        this.updateSAPUserCal();
        Date date = this.SAPUserCal.getTime();
        this.fixedParamSDF.setTimeZone(UTCTZ);
        String string = this.fixedParamSDF.format(date);
        this.SAPUserCal.add(12, -this.testFreqMins);
        Date date2 = this.SAPUserCal.getTime();
        this.SAPUserCal.add(12, this.testFreqMins);
        String string2 = this.fixedParamSDF.format(date2);
        String[] stringArray = new String[]{string2, string};
        this.printOut("INFO : testFrequency " + this.testFreqMins + " minutes converted to range: " + string2 + " to " + string);
        return stringArray;
    }

    private void addMillis2Cal(long l) {
        if (l < 0L) {
            return;
        }
        if (l <= Integer.MAX_VALUE) {
            this.SAPUserCal.add(14, (int)l);
        } else {
            this.SAPUserCal.add(14, Integer.MAX_VALUE);
            this.addMillis2Cal(l - Integer.MAX_VALUE);
        }
    }

    public void updateSAPUserCal() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastUpdateMillis;
        this.addMillis2Cal(l2);
        this.lastUpdateMillis = l;
        this.printOut("INFO  : Incremented user specific SAP Server time with " + l2 + " ms");
    }

    protected void setDatePatternAndTimeZone(JCO.Client client2) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        JCO.Function function = this.createFunction("BAPI_USER_GET_DETAIL");
        this.printOut("Setting date pattern and timezone");
        if (function == null) {
            string = "UTC";
            string5 = (String)timestampFormatsTbl.get("1");
            this.printOut("Set usertimezone to UTC");
        } else {
            try {
                JCO.Structure structure;
                function.getImportParameterList().setValue(this.sapUser, "USERNAME");
                this.executeFunction(function, client2, false);
                JCO.Table table = function.getTableParameterList().getTable("RETURN");
                string3 = table.getString("TYPE");
                if (string3.length() != 0 && !string3.equals("S") && !string3.equals("I")) {
                    this.logToErrorFile("ERROR", this.entity, this.thisServer + " : " + "Exec error");
                    this.printOut("ERROR   :Error while executing BAPI_USER_GET_DETAIL");
                    this.printOut("ERROR   :Type : " + table.getString("TYPE"));
                    this.printOut("ERROR   :Message : " + table.getString("MESSAGE"));
                    string = "UTC";
                    string5 = (String)timestampFormatsTbl.get("1");
                }
                if ((structure = function.getExportParameterList().getStructure("DEFAULTS")) != null) {
                    string4 = structure.getString("DATFM");
                    string5 = (String)timestampFormatsTbl.get(string4);
                } else {
                    string5 = (String)timestampFormatsTbl.get("1");
                }
                JCO.Structure structure2 = function.getExportParameterList().getStructure("LOGONDATA");
                if (structure2 != null) {
                    string = structure2.getString("TZONE").trim();
                }
                if (string.length() == 0) {
                    this.printOut("INFO    :Timezone could not be obtained from logondata structure. Trying the address structure");
                    JCO.Structure structure3 = function.getExportParameterList().getStructure("ADDRESS");
                    string = structure3.getString("TIME_ZONE");
                    if (string == null || string.trim().length() == 0) {
                        this.printOut("ERROR   :User's timezone information unavailable. Defaulting to UTC and dd/MM/yyyy HH:mm:ss");
                        string = "UTC";
                    }
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, this.thisServer + " : Exception while executing BAPI_USER_GET_DETAIL : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, EgInstallInfo.getStackTraceAsString(exception));
                this.printOut("ERROR   :Exception while executing BAPI_USER_GET_DETAIL : " + exception.toString());
                string = "UTC";
                string5 = (String)timestampFormatsTbl.get("1");
            }
            try {
                string2 = (String)SAPJavaTZTbl.get(string);
                if (string2 != null) {
                    this.printOut("INFO    :Got timezone " + string + " from address structure");
                } else {
                    this.printOut("ERROR   :Could not retrieve TimeZone (JDK) Id time for SAP timezone " + string + ". Using UTC instead.");
                    string2 = "UTC";
                }
                this.printOut("INFO    :JDK Timezone Id for SAP user is " + string2);
                this.printOut("INFO    :User date pattern is " + string5);
                if (string5 == null) {
                    string5 = (String)timestampFormatsTbl.get("1");
                }
                this.userSDF = new SimpleDateFormat(string5);
                this.userTZ = TimeZone.getTimeZone(string2);
            }
            catch (Exception exception) {
                this.logToErrorFile("ERROR", this.entity, this.thisServer + " : Exception while executing BAPI_USER_GET_DETAIL : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, EgInstallInfo.getStackTraceAsString(exception));
                this.printOut("ERROR   :Exception while executing BAPI_USER_GET_DETAIL : " + exception.toString());
                string = "UTC";
                string5 = (String)timestampFormatsTbl.get("1");
            }
        }
    }

    void getNotAvailableMeasure(Hashtable hashtable, String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        hashtable.put(string, arrayList);
    }

    public Hashtable parseMonDetails(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
        StringTokenizer stringTokenizer3 = null;
        Hashtable hashtable = new Hashtable();
        int n2 = stringTokenizer.countTokens();
        int n3 = n2 < (n = stringTokenizer2.countTokens()) ? n2 : n;
        this.printOut("INFO   : Number of valid iterations of monitor details is " + n3);
        for (int i = 0; i < n3; ++i) {
            String string3 = stringTokenizer.nextToken().trim();
            String string4 = stringTokenizer2.nextToken();
            stringTokenizer3 = new StringTokenizer(string4, "~#~");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer3.hasMoreTokens()) {
                String string5 = stringTokenizer3.nextToken().trim();
                arrayList.add(string5);
            }
            hashtable.put(string3, arrayList);
        }
        this.printOut("INFO  : Parsed monitor details : " + hashtable.toString());
        return hashtable;
    }

    public String[] convJCOTime2UserTime(String string, String string2) {
        return this.convDateTime(string, string2, APISDF, UTCTZ, this.userSDF, this.userTZ);
    }

    public String[] convDateTime(String string, String string2, SimpleDateFormat simpleDateFormat, TimeZone timeZone, SimpleDateFormat simpleDateFormat2, TimeZone timeZone2) {
        Date date = null;
        String string3 = string + " " + string2;
        simpleDateFormat.setTimeZone(timeZone);
        String[] stringArray = new String[2];
        try {
            date = simpleDateFormat.parse(string3);
        }
        catch (ParseException parseException) {
            this.printOut("ERROR  :Error while trying to convert SAP timestamp " + string3);
            stringArray[0] = "???";
            stringArray[1] = "???";
            return stringArray;
        }
        simpleDateFormat2.setTimeZone(timeZone2);
        String string4 = simpleDateFormat2.format(date);
        int n = string4.indexOf(" ");
        if (n > 0) {
            stringArray[0] = string4.substring(0, n);
            stringArray[1] = string4.substring(n + 1);
            return stringArray;
        }
        this.printOut("INFO  : Could not split converted timestamp '" + string4 + "'");
        stringArray[0] = "???";
        stringArray[1] = "???";
        return stringArray;
    }

    protected JCO.Table getTreeNodesTblForMonitor(String string, String string2, JCO.Client client2) {
        Object var4_4 = null;
        long l = System.currentTimeMillis();
        String string3 = "BAPI_SYSTEM_MON_GETTREE not found in SAP.";
        JCO.Function function = null;
        try {
            function = this.createFunction("BAPI_SYSTEM_MON_GETTREE");
        }
        catch (Exception exception) {
            this.printOut("Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Error while executing BAPI_SYSTEM_MON_GETTREE : " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        if (function == null) {
            this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETTREE");
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        JCO.Table table = null;
        Object var13_14 = null;
        String string4 = new String();
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        try {
            function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            JCO.Structure structure = function.getImportParameterList().getStructure("MONITOR_NAME");
            structure.setValue(string2, "MONI_NAME");
            structure.setValue(string, "MS_NAME");
            this.executeFunction(function, client2, true);
            table = function.getTableParameterList().getTable("TREE_NODES");
            bl = perfAttrList.contains(string2);
            int n = table.getNumRows();
            if (debug) {
                this.printOut(table.toString());
            }
        }
        catch (Exception exception) {
            this.printOut("Exception while trying to get monitor tree: " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, "Exception while trying to get monitor tree: " + exception.toString());
            boolean bl2 = false;
        }
        return table;
    }

    public static void main(String[] stringArray) {
        SapAlertsJco2Test sapAlertsJco2Test = new SapAlertsJco2Test(stringArray);
        int n = 3;
        sapAlertsJco2Test.printOut("Will run " + n + " times.");
        for (int i = 0; i < n; ++i) {
            sapAlertsJco2Test.printOut("getMeasures : " + (i + 1));
            System.out.println("Got measures : " + sapAlertsJco2Test.getMeasures(new Hashtable()));
        }
    }

    static {
        timestampFormatsTbl.put("1", "dd.MM.yyyy HH:mm:ss");
        timestampFormatsTbl.put("2", "MM/dd/yyyy HH:mm:ss");
        timestampFormatsTbl.put("3", "MM-dd-yyyy HH:mm:ss");
        timestampFormatsTbl.put("4", "yyyy.MM.dd HH:mm:ss");
        timestampFormatsTbl.put("5", "yyyy/MM/dd HH:mm:ss");
        timestampFormatsTbl.put("5", "yyyy-MM-dd HH:mm:ss");
        SAPJavaTZTbl = new Hashtable();
        SAPJavaTZTbl = new Hashtable();
        SAPJavaTZTbl.put("ALA", "US/Alaska");
        SAPJavaTZTbl.put("ALAW", "US/Aleutian");
        SAPJavaTZTbl.put("AST", "America/Halifax");
        SAPJavaTZTbl.put("AUSACT", "Australia/ACT");
        SAPJavaTZTbl.put("AUSNSW", "Australia/NSW");
        SAPJavaTZTbl.put("AUSQLD", "Australia/Queensland");
        SAPJavaTZTbl.put("AUSTAS", "Australia/Tasmania");
        SAPJavaTZTbl.put("AUSVIC", "Australia/Victoria");
        SAPJavaTZTbl.put("AUSWA", "Australia/West");
        SAPJavaTZTbl.put("AZOREN", "Atlantic/Cape_Verde");
        SAPJavaTZTbl.put("BRAZIL", "BET");
        SAPJavaTZTbl.put("BRZLAN", "America/Panama");
        SAPJavaTZTbl.put("BRZLEA", "Brazil/East");
        SAPJavaTZTbl.put("BRZLWE", "Brazil/West");
        SAPJavaTZTbl.put("CAT", "CAT");
        SAPJavaTZTbl.put("CET", "CET");
        SAPJavaTZTbl.put("CHILE", "Chile/Continental");
        SAPJavaTZTbl.put("CHILEE", "Chile/EasterIsland");
        SAPJavaTZTbl.put("CST", "CST");
        SAPJavaTZTbl.put("CSTNO", "Chile/EasterIsland");
        SAPJavaTZTbl.put("CYPRUS", "Israel");
        SAPJavaTZTbl.put("EET", "EET");
        SAPJavaTZTbl.put("EGYPT", "Egypt");
        SAPJavaTZTbl.put("EST", "America/New_York");
        SAPJavaTZTbl.put("EST_", "America/Montreal");
        SAPJavaTZTbl.put("ESTNO", "America/Indiana/Indianapolis");
        SAPJavaTZTbl.put("FLKLND", "Chile/Continental");
        SAPJavaTZTbl.put("GST", "America/Godthab");
        SAPJavaTZTbl.put("GSTE", "America/Scoresbysund");
        SAPJavaTZTbl.put("GSTW", "America/Thule");
        SAPJavaTZTbl.put("HAW", "US/Hawaii");
        SAPJavaTZTbl.put("IRAQ", "EAT");
        SAPJavaTZTbl.put("ISRAEL", "Israel");
        SAPJavaTZTbl.put("JAPAN", "Japan");
        SAPJavaTZTbl.put("JORDAN", "Asia/Amman");
        SAPJavaTZTbl.put("LBANON", "Asia/Beirut");
        SAPJavaTZTbl.put("MST", "America/Denver");
        SAPJavaTZTbl.put("MSTNO", "America/Phoenix");
        SAPJavaTZTbl.put("NZST", "NZ");
        SAPJavaTZTbl.put("PARAGY", "Chile/Continental");
        SAPJavaTZTbl.put("PIERRE", "America/Miquelon");
        SAPJavaTZTbl.put("PST", "America/Los_Angeles");
        SAPJavaTZTbl.put("RUS03", "Europe/Moscow");
        SAPJavaTZTbl.put("SYRIA", "Asia/Damascus");
        SAPJavaTZTbl.put("UTC+1", "Etc/GMT-1");
        SAPJavaTZTbl.put("UTC+2", "Etc/GMT-2");
        SAPJavaTZTbl.put("UTC+3", "Etc/GMT-3");
        SAPJavaTZTbl.put("UTC+4", "Etc/GMT-4");
        SAPJavaTZTbl.put("UTC+5", "Etc/GMT-5");
        SAPJavaTZTbl.put("UTC+6", "Etc/GMT-6");
        SAPJavaTZTbl.put("UTC+7", "Etc/GMT-7");
        SAPJavaTZTbl.put("UTC+8", "Etc/GMT-8");
        SAPJavaTZTbl.put("UTC+9", "Etc/GMT-9");
        SAPJavaTZTbl.put("UTC+10", "Etc/GMT-10");
        SAPJavaTZTbl.put("UTC+11", "Etc/GMT-11");
        SAPJavaTZTbl.put("UTC+12", "Etc/GMT-12");
        SAPJavaTZTbl.put("UTC+13", "Etc/GMT-13");
        SAPJavaTZTbl.put("UTC+14", "Etc/GMT-14");
        SAPJavaTZTbl.put("UTC-1", "Etc/GMT+1");
        SAPJavaTZTbl.put("UTC-2", "Etc/GMT+2");
        SAPJavaTZTbl.put("UTC-3", "Etc/GMT+3");
        SAPJavaTZTbl.put("UTC-4", "Etc/GMT+4");
        SAPJavaTZTbl.put("UTC-5", "Etc/GMT+5");
        SAPJavaTZTbl.put("UTC-6", "Etc/GMT+6");
        SAPJavaTZTbl.put("UTC-7", "Etc/GMT+7");
        SAPJavaTZTbl.put("UTC-8", "Etc/GMT+8");
        SAPJavaTZTbl.put("UTC-9", "Etc/GMT+9");
        SAPJavaTZTbl.put("UTC-10", "Etc/GMT+10");
        SAPJavaTZTbl.put("UTC-11", "Etc/GMT+11");
        SAPJavaTZTbl.put("UTC-12", "Etc/GMT+12");
        SAPJavaTZTbl.put("WAT", "Etc/GMT-1");
        SAPJavaTZTbl.put("WDFT", "CET");
        SAPJavaTZTbl.put("NFDL", "Canada/Newfoundland");
        SAPJavaTZTbl.put("NST", "Canada/Newfoundland");
        SAPJavaTZTbl.put("IRAN", "Asia/Tehran");
        SAPJavaTZTbl.put("AFGHAN", "Asia/Kabul");
        SAPJavaTZTbl.put("INDIA", "Asia/Calcutta");
        SAPJavaTZTbl.put("UTC+53", "Asia/Calcutta");
        SAPJavaTZTbl.put("UTC+63", "Indian/Cocos");
        SAPJavaTZTbl.put("AUSNT", "Australia/North");
        SAPJavaTZTbl.put("AUSSA", "Australia/South");
        SAPJavaTZTbl.put("AUSLHI", "Australia/Lord_Howe");
        SAPJavaTZTbl.put("NORFLK", "Pacific/Norfolk");
        SAPJavaTZTbl.put("NZCHA", "Pacific/Chatham");
        SAPJavaTZTbl.put("NEPAL", "Asia/Katmandu");
        SAPJavaTZTbl.put("UTC", "UTC");
        APISDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        perfAttrList = new ArrayList();
        perfAttrList.add("Entire System");
        perfAttrList.add("Communications");
        perfAttrList.add("Background Processing");
        perfAttrList.add("Database");
        perfAttrList.add("Buffers");
        perfAttrList.add("System Configuration");
        perfAttrList.add("Spool System");
    }
}

