/*
 * Decompiled with CFR 0.152.
 */
import com.sap.mw.jco.JCO;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SapMonsJco2_cf
extends AsAbapJco2Base {
    private String MonSet = "";
    ArrayList MonsetList;
    JCO.Client clientConn = null;

    public SapMonsJco2_cf(String[] stringArray) {
        super(stringArray);
        this.setConfigInfoTestFlag(true);
        this.MonSet = this.getValueForParam("monitor_sets");
        String string = this.MonSet.toUpperCase();
        TreeSet<String> treeSet = new TreeSet<String>();
        if (string.indexOf("ALL") != -1 || string.indexOf("NONE") != -1) {
            treeSet = this.getAllSets();
            if (treeSet == null) {
                this.printOut("ERROR : Error while getting the list of all sets");
                treeSet = new TreeSet<String>();
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(this.MonSet, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    treeSet.add(string2);
                }
                catch (Exception exception) {
                    this.printOut("ERROR : Exception while adding String " + string2 + " to treeset : " + exception.toString());
                    this.logToErrorFile("ERROR", this.thisServer, "Exception while adding String " + string2 + " to treeset : " + exception.toString());
                }
            }
        }
        this.MonsetList = new ArrayList(treeSet);
        this.printOut("Parsed monitor set list : " + this.MonsetList.toString());
        this.setMeasureCount(2);
    }

    public boolean prepConn() {
        this.printOut("DEBUG : Going to prepare connection");
        this.clientConn = this.getConnection();
        if (this.clientConn == null || !this.clientConn.isValid()) {
            this.printOut("ERROR : Could not get all monitor sets due to unavailability of connection");
            this.logToErrorFile("ERROR", this.thisServer, "Could not get all monitor sets due to unavailability of connection");
            this.releaseClient(this.clientConn);
            return false;
        }
        if (!this.logonToXMI(this.clientConn)) {
            this.printOut("ERROR : Could not logon to XMI interface");
            this.logToErrorFile("ERROR", this.thisServer, "Could not logon to XMI interface");
            this.releaseClient(this.clientConn);
            return false;
        }
        this.printOut("Obtained connection and logged onto XMI");
        return true;
    }

    public TreeSet getAllSets() {
        if (!this.prepConn()) {
            return null;
        }
        JCO.Function function = this.createFunction("BAPI_SYSTEM_MS_GETLIST");
        if (function == null) {
            this.printOut("ERROR : Could not get all sets due to JCO Error");
            this.releaseClient(this.clientConn);
            return null;
        }
        function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
        try {
            this.executeFunction(function, this.clientConn, true);
        }
        catch (Exception exception) {
            this.printOut("ERROR : Exception while executing BAPI_SYSTEM_MS_GETLIST : " + exception.toString());
            this.printOut("ERROR : " + EgInstallInfo.getStackTraceAsString(exception));
            this.logToErrorFile("ERROR", this.thisServer, "Exception while executing BAPI_SYSTEM_MS_GETLIST : " + exception.toString());
            this.logToErrorFile("ERROR", this.thisServer, EgInstallInfo.getStackTraceAsString(exception));
            this.releaseClient(this.clientConn);
            return null;
        }
        JCO.Table table = function.getTableParameterList().getTable("MONITOR_SETS");
        int n = table.getNumRows();
        TreeSet<String> treeSet = new TreeSet<String>();
        this.printOut("INFO : Obtained " + n + " monitor sets");
        if (n > 0) {
            this.printOut("INFO : Obtained " + n + " monitor sets");
            for (int i = 0; i < n; ++i) {
                String string = table.getString("NAME");
                treeSet.add(string);
                table.nextRow();
            }
        }
        return treeSet;
    }

    public Hashtable getMeasures() {
        String string = "";
        Hashtable hashtable = new Hashtable();
        if (!(this.clientConn != null && this.clientConn.isValid() || this.prepConn())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-");
            for (int i = 0; i < this.MonsetList.size(); ++i) {
                string = (String)this.MonsetList.get(i);
                hashtable.put(string, arrayList);
            }
            this.releaseClient(this.clientConn);
            return hashtable;
        }
        int n = this.MonsetList.size();
        for (int i = 0; i < n; ++i) {
            string = (String)this.MonsetList.get(i);
            this.addMonsToMeasHT(hashtable, string);
        }
        this.releaseClient(this.clientConn);
        this.clientConn = null;
        return hashtable;
    }

    public void addMonsToMeasHT(Hashtable hashtable, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            JCO.Function function;
            this.printOut("INFO : Trying to get monitors for set " + string);
            if (this.clientConn == null) {
                this.printOut("ERROR! clientConn is null");
            }
            if (!this.clientConn.isValid()) {
                this.printOut("ERROR! clientConn is not valid!");
            }
            if ((function = this.createFunction("BAPI_SYSTEM_MON_GETLIST")) == null) {
                this.printOut("Error : Could not create function BAPI_SYSTEM_MON_GETLIST");
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            function.getImportParameterList().setValue(this.eGSapXMIUser, "EXTERNAL_USER_NAME");
            JCO.Structure structure = function.getImportParameterList().getStructure("MONI_SET_NAME");
            if (structure == null) {
                this.printOut("Error : Could not get structure MONI_SET_NAME");
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            structure.setValue(string, "NAME");
            try {
                this.executeFunction(function, this.clientConn, true);
            }
            catch (Exception exception) {
                this.printOut("ERROR : Exception while executing BAPI_SYSTEM_MON_GETLIST function : " + exception.toString());
                this.logToErrorFile("ERROR", this.entity, "Exception while executing BAPI_SYSTEM_MON_GETLIST function : " + exception.toString());
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            JCO.Table table = function.getTableParameterList().getTable("MONITOR_NAMES");
            int n = table.getNumRows();
            if (n == 0) {
                arrayList.add("-");
                hashtable.put(string, arrayList);
                return;
            }
            TreeSet<String> treeSet = new TreeSet<String>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n; ++i) {
                String string3 = table.getString("MONI_NAME");
                treeSet.add(string3);
                table.nextRow();
            }
            Iterator iterator = treeSet.iterator();
            if (iterator.hasNext()) {
                string2 = (String)iterator.next();
                stringBuffer.append(" [ " + string2 + " ] ");
            }
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                stringBuffer.append(",");
                stringBuffer.append(" [ " + string2 + " ] ");
            }
            arrayList.add(stringBuffer.toString());
            this.printOut("INFO : SapMons_cf] MonSetName " + string + " " + arrayList + ". List size = " + arrayList.size());
            hashtable.put(string, arrayList);
        }
        catch (Exception exception) {
            arrayList.add("-");
            hashtable.put(string, arrayList);
            this.printOut("ERROR : Exception while trying to get montiors in set " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.entity, this.thisServer + " : " + "Exception while trying to get montiors in set " + string + " : " + exception.toString());
            this.logToErrorFile("ERROR", this.thisServer, EgInstallInfo.getStackTraceAsString(exception));
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            stringArray[i + 1] = EgCrypt.decrypt(stringArray[i + 1]);
            break;
        }
        SapMonsJco2_cf sapMonsJco2_cf = new SapMonsJco2_cf(stringArray);
        sapMonsJco2_cf.decryptPassword();
        System.out.println("Measures = " + sapMonsJco2_cf.getMeasures().toString());
    }
}

