/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class SnmpSystemTest
extends EgSnmpGenericTest {
    private static String ssIoSentOid = ".1.3.6.1.4.1.2021.11.57";
    private static String ssIoRcvOid = ".1.3.6.1.4.1.2021.11.58";
    private static String ssSysInterruptsOid = ".1.3.6.1.4.1.2021.11.59";
    private static String ssContextOid = ".1.3.6.1.4.1.2021.11.60";
    private static String ssUserCpuOid = ".1.3.6.1.4.1.2021.11.9";
    private static String ssSystemCpuOid = ".1.3.6.1.4.1.2021.11.10";
    private static String ssErrorOid = ".1.3.6.1.4.1.2021.11.2";
    Hashtable prevIoSent = new Hashtable();
    Hashtable prevIoRcv = new Hashtable();
    Hashtable prevSysInterrupts = new Hashtable();
    Hashtable prevContextSwitches = new Hashtable();
    private static int numMeasures = 6;

    public SnmpSystemTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getResults(ssIoSentOid, this.prevIoSent);
        Hashtable hashtable3 = this.getResults(ssIoRcvOid, this.prevIoRcv);
        Hashtable hashtable4 = this.getResults(ssSysInterruptsOid, this.prevSysInterrupts);
        Hashtable hashtable5 = this.getResults(ssContextOid, this.prevContextSwitches);
        Hashtable hashtable6 = this.getResults(ssUserCpuOid);
        Hashtable hashtable7 = this.getResults(ssSystemCpuOid);
        ArrayList arrayList = this.getNames(ssErrorOid);
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                double d;
                String string = (String)arrayList.get(i);
                int n = string.indexOf(":");
                if (n < 0) continue;
                String string2 = string.substring(0, n);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                Double d2 = new Double(-5.0);
                Double d3 = (Double)hashtable2.get(string2);
                if (d3 == null) {
                    arrayList2.add(d2);
                } else {
                    d = d3;
                    if (this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(-5.0));
                    }
                }
                d3 = (Double)hashtable3.get(string2);
                if (d3 == null) {
                    arrayList2.add(d2);
                } else {
                    d = d3;
                    if (this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(-5.0));
                    }
                }
                d3 = (Double)hashtable4.get(string2);
                if (d3 == null) {
                    arrayList2.add(d2);
                } else {
                    d = d3;
                    if (this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(-5.0));
                    }
                }
                d3 = (Double)hashtable5.get(string2);
                if (d3 == null) {
                    arrayList2.add(d2);
                } else {
                    d = d3;
                    if (this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(-5.0));
                    }
                }
                d3 = (Double)hashtable6.get(string2);
                if (d3 == null) {
                    arrayList2.add(d2);
                } else {
                    d = d3;
                    arrayList2.add(new Double(d));
                }
                d3 = (Double)hashtable7.get(string2);
                if (d3 == null) {
                    arrayList2.add(d2);
                } else {
                    d = d3;
                    arrayList2.add(new Double(d));
                }
                this.addNewMeasure(string, arrayList2);
            }
        }
    }

    private ArrayList getNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.runSnmpCmdForOid(string) || this.lhs == null || this.lhs.length == 0) {
            return arrayList;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            arrayList.add(this.lhs[i] + ":" + this.rhs[i]);
        }
        return arrayList;
    }

    private Hashtable getResults(String string, Hashtable hashtable) {
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        if (!this.runSnmpCmdForOid(string) || this.lhs == null || this.lhs.length == 0) {
            hashtable = new Hashtable<String, Double>();
            return hashtable2;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            double d = this.getValue(i);
            Double d2 = (Double)hashtable.get(this.lhs[i]);
            double d3 = -5.0;
            if (d2 != null && (d3 = d - d2) < 0.0) {
                d3 = -5.0;
            }
            hashtable.put(this.lhs[i], new Double(d));
            hashtable2.put(this.lhs[i], new Double(d3));
        }
        return hashtable2;
    }

    private Hashtable getResults(String string) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        if (!this.runSnmpCmdForOid(string) || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            double d = this.getValue(i);
            hashtable.put(this.lhs[i], new Double(d));
        }
        return hashtable;
    }
}

