/*
 * Decompiled with CFR 0.152.
 */
import com.eg.snmpgetsubtree;
import java.util.ArrayList;

public class Snmpwalk
extends GenericTest {
    private String snmpVersion = "1";
    private String snmpCommunity = "public";
    private String snmpPort = "161";
    private String v3User = "";
    private String v3AuthPwd = "";
    private String v3AuthProtocol = "";
    private String v3EncryptProtocol = "";
    private String v3EncryptPwd = "";
    private String snmpOID = "";
    private String hostIP = "";
    private String context = "none";
    private int timeout = 10;
    private boolean encryptionEnabled = false;
    private boolean argsLengthGTZero = true;

    public Snmpwalk(String[] stringArray) {
        super(stringArray);
        if (stringArray.length == 0) {
            System.out.println("No host IP specified.");
            System.out.println("Usage: snmpwalk [options...] <host IP> {<community>} [<objectID>]");
            System.out.println("-h       host IP.");
            System.out.println("-v 1|2|3 specifies snmp version to use.");
            System.out.println("-c       set the community name (v1 or v2c)");
            System.out.println("SNMP Version 3 specific");
            System.out.println("-n       context name (e.g., bridge1).");
            System.out.println("-u       security name (e.g., bert).");
            System.out.println("-at      authentication protocol (MD5|SHA)");
            System.out.println("-A       authentication protocol pass phrase.");
            System.out.println("-pt      privacy protocol (DES|AES).");
            System.out.println("-X       privacy protocol pass phrase");
            System.out.println("General communication options");
            System.out.println("-p      use port P instead of the default port.");
            System.out.println("-t      use timeout instead of default timeout.");
            this.argsLengthGTZero = false;
        }
        this.snmpOID = this.getValueForParam("oid");
        this.hostIP = this.getValueForParam("h");
        this.snmpVersion = this.getValueForParam("v");
        this.snmpPort = this.getValueForParam("p");
        String string = this.getValueForParam("t");
        if (this.snmpPort == null || this.snmpPort.trim().length() == 0) {
            this.snmpPort = "161";
        }
        this.timeout = string == null || string.trim().length() == 0 ? 10 : Integer.parseInt(string);
        if (this.snmpVersion == null) {
            this.snmpVersion = "1";
        }
        if (this.snmpVersion.equalsIgnoreCase("1") || this.snmpVersion.equalsIgnoreCase("2")) {
            this.snmpCommunity = this.getValueForParam("c");
            if (this.snmpCommunity == null) {
                this.snmpCommunity = "none";
            }
        } else {
            this.v3User = this.getValueForParam("u");
            this.v3AuthPwd = this.getValueForParam("A");
            this.v3AuthProtocol = this.getValueForParam("at");
            this.v3EncryptProtocol = this.getValueForParam("pt");
            this.v3EncryptPwd = this.getValueForParam("X");
            this.context = this.getValueForParam("n");
            String string2 = this.getValueForParam("ee");
            if (string2 != null && string2.equalsIgnoreCase("yes")) {
                this.encryptionEnabled = true;
            }
        }
    }

    public void getSnmpWalk() {
        try {
            if (!this.argsLengthGTZero) {
                return;
            }
            if (this.snmpVersion.equals("1") || this.snmpVersion.equals("2")) {
                if (this.snmpCommunity == null || this.snmpCommunity.equals("none")) {
                    System.out.println("Please provide community string");
                }
            } else {
                if (this.v3User == null || this.v3User.trim().length() == 0) {
                    System.out.println("Please provide username");
                }
                if (this.v3AuthPwd == null || this.v3AuthPwd.trim().length() == 0) {
                    System.out.println("Please provide authentication password");
                }
                if (this.v3AuthProtocol == null || this.v3AuthProtocol.trim().length() == 0) {
                    System.out.println("Please provide authentication protocol");
                }
                if (this.context == null || this.context.trim().length() == 0) {
                    this.context = "";
                }
                if (this.encryptionEnabled) {
                    if (this.v3EncryptProtocol == null || this.v3EncryptProtocol.trim().length() == 0) {
                        System.out.println("Please provide encryption type");
                    }
                    if (this.v3EncryptPwd == null || this.v3EncryptPwd.trim().length() == 0) {
                        System.out.println("Please provide encryption password");
                    }
                    return;
                }
            }
            if (this.snmpOID == null || this.snmpOID.trim().length() == 0) {
                this.snmpOID = ".1.3.6.1.2.1";
            }
            if (this.hostIP == null || this.hostIP.trim().length() == 0) {
                System.out.println("Please provide host IP");
            }
            String[] stringArray = null;
            stringArray = this.snmpVersion.equalsIgnoreCase("1") || this.snmpVersion.equalsIgnoreCase("2") ? new String[]{"-p", this.snmpPort, "-c", this.snmpCommunity, "-o", "-v", this.snmpVersion.equalsIgnoreCase("1") ? "1" : "2", this.hostIP, this.snmpOID, "udp"} : (!this.encryptionEnabled ? new String[]{"-o", "-w", "2", "-v", "3", "-p", this.snmpPort, "-u", this.v3User, "-a", this.v3AuthProtocol, "-A", this.v3AuthPwd, this.hostIP, this.snmpOID, "-n", this.context, "udp"} : new String[]{"-o", "-w", "2", "-v", "3", "-p", this.snmpPort, "-u", this.v3User, "-a", this.v3AuthProtocol, "-A", this.v3AuthPwd, "-x", this.v3EncryptProtocol, "-X", this.v3EncryptPwd, this.hostIP, this.snmpOID, "-n", this.context, "udp"});
            ArrayList arrayList = new ArrayList();
            if (stringArray != null && stringArray.length > 0) {
                snmpgetsubtree snmpgetsubtree2 = new snmpgetsubtree(stringArray, this.timeout);
                arrayList = snmpgetsubtree2.getSubTree();
            }
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string = (String)arrayList.get(i);
                    if (string.startsWith("snmpgetsubtree")) continue;
                    System.out.println(string);
                }
            } else {
                System.out.println("No Response !!!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Snmpwalk snmpwalk2 = new Snmpwalk(stringArray);
        snmpwalk2.getSnmpWalk();
    }
}

