/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybMessageHandler;
import com.sybase.jdbcx.SybPreparedStatement;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class SybDbStats {
    private String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    private String firstUrl = "jdbc:sybase:Tds:";
    private String sqlText = "";
    private SybConnection conn = null;
    public String[] dbNames;
    private double[] dbSize;
    private double[] dbUtil;
    private double[] dbReserved;
    private double[] dbData;
    private double[] dbIndex;
    private double[] dbUnused;
    private static Hashtable sybCharsetHash = new Hashtable();

    public SybDbStats(String string, String string2, String string3, String string4, String string5) {
        this.conn = this.getConnection(string, string2, string4, string5, false);
    }

    public boolean executeDbSpace() {
        if (this.conn == null) {
            System.out.println("SybDbStats: ExecuteDBSpace :Failed to establish a connection!");
            return false;
        }
        ArrayList arrayList = this.getDatabases(this.conn);
        if (arrayList == null) {
            this.dbNames = null;
            return false;
        }
        int n = arrayList.size();
        this.dbNames = new String[n];
        this.dbSize = new double[n];
        this.dbUtil = new double[n];
        this.dbReserved = new double[n];
        this.dbData = new double[n];
        this.dbIndex = new double[n];
        this.dbUnused = new double[n];
        for (int i = 0; i < n; ++i) {
            String string;
            this.dbNames[i] = string = (String)arrayList.get(i);
            this.getSpaceUsageFor(this.conn, string, i);
        }
        return true;
    }

    public boolean executeDbSpace(ArrayList arrayList, ArrayList arrayList2) {
        String string;
        int n;
        if (this.conn == null) {
            System.out.println("SybDbStats: ExecuteDBSpace :Failed to establish a connection!");
            return false;
        }
        ArrayList arrayList3 = new ArrayList();
        if (arrayList != null && arrayList.size() > 0) {
            arrayList3 = (ArrayList)arrayList.clone();
        } else {
            ArrayList arrayList4 = this.getDatabases(this.conn);
            for (n = 0; n < arrayList4.size(); ++n) {
                string = (String)arrayList4.get(n);
                if (arrayList2 != null && arrayList2.contains(string)) continue;
                arrayList3.add(string);
            }
        }
        if (arrayList3 == null) {
            this.dbNames = null;
            return false;
        }
        int n2 = arrayList3.size();
        this.dbNames = new String[n2];
        this.dbSize = new double[n2];
        this.dbUtil = new double[n2];
        this.dbReserved = new double[n2];
        this.dbData = new double[n2];
        this.dbIndex = new double[n2];
        this.dbUnused = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.dbNames[n] = string = (String)arrayList3.get(n);
            this.getSpaceUsageFor(this.conn, string, n);
        }
        return true;
    }

    public ArrayList getDbSpaceStats(String string) {
        int n = 6;
        if (this.dbNames == null || this.dbNames.length == 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Double(-1.0));
            }
            return arrayList;
        }
        int n2 = -1;
        for (int i = 0; i < this.dbNames.length; ++i) {
            if (!this.dbNames[i].equals(string)) continue;
            n2 = i;
            break;
        }
        if (n2 < 0) {
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Double(-1.0));
            }
            return arrayList;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        arrayList.add(new Double(this.dbSize[n2]));
        arrayList.add(new Double(this.dbUtil[n2]));
        arrayList.add(new Double(this.dbReserved[n2]));
        arrayList.add(new Double(this.dbData[n2]));
        arrayList.add(new Double(this.dbIndex[n2]));
        arrayList.add(new Double(this.dbUnused[n2]));
        return arrayList;
    }

    public ArrayList executeQuery(String string, String string2) {
        if (this.conn == null) {
            System.out.println("SybDbStats: execute Query : Failed to establish a connection!");
            return null;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            while (resultSet.next()) {
                String string3 = "";
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 1; i <= n; ++i) {
                    try {
                        string3 = resultSet.getString(i);
                        string3 = string3.trim();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    stringBuffer.append(string3);
                    if (i >= n) continue;
                    stringBuffer.append(string2);
                }
                String string4 = stringBuffer.toString();
                arrayList.add(string4);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String string) {
        if (this.conn == null) {
            System.out.println("SybDbStats: execute : Failed to establish a connection!");
        }
        Statement statement = null;
        try {
            try {
                statement = this.conn.createStatement();
                statement.execute(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var5_4 = null;
                this.closeStmt(statement);
            }
            Object var5_3 = null;
            this.closeStmt(statement);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closeStmt(statement);
            throw throwable;
        }
    }

    public void close() {
        if (this.conn == null) {
            return;
        }
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4) {
        return this.getConnection(string, string2, string3, string4, false);
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4, boolean bl) {
        try {
            Object object;
            String string5;
            String string6 = "iso_1";
            String string7 = string + ":" + string2;
            if (sybCharsetHash != null && sybCharsetHash.size() > 0) {
                if (sybCharsetHash.containsKey(string7)) {
                    string6 = (String)sybCharsetHash.get(string7);
                } else {
                    string5 = SybDbStats.getCharSetName(string, string2, string3, string4);
                    if (string5 != null && string5.length() > 0) {
                        string6 = string5;
                    }
                }
            } else {
                string5 = SybDbStats.getCharSetName(string, string2, string3, string4);
                if (string5 != null && string5.length() > 0) {
                    string6 = string5;
                }
            }
            Class.forName(this.driver);
            string5 = "";
            if (bl) {
                object = EgConfigInfo.egAgentConfigDir + "eg_sybase.ini";
                IniFile iniFile = new IniFile((String)object);
                String string8 = iniFile.getValue("EG_SYBASE", "DB_NAME");
                string5 = "jdbc:sybase:Tds:" + string + ":" + string2 + "/" + string8 + "";
            } else {
                string5 = "jdbc:sybase:Tds:" + string + ":" + string2;
            }
            object = new Properties();
            ((Properties)object).put("user", string3);
            ((Properties)object).put("password", string4);
            ((Properties)object).put("charset", string6);
            ((Properties)object).put("IS_CLOSED_TEST", "INTERNAL");
            this.conn = (SybConnection)DriverManager.getConnection(string5, (Properties)object);
        }
        catch (Exception exception) {
            String string9 = exception.toString();
            if (string9.indexOf("java.net.ConnectException") >= 0) {
                System.out.println("\nConnection could not be established with the Sybase Adaptive server.\n");
            }
            exception.printStackTrace();
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getCommandFor(String var1_1) {
        block13: {
            if (this.conn == null) {
                return null;
            }
            var2_2 = "dbcc sqltext(" + var1_1 + ")";
            var3_3 = null;
            try {
                this.conn.setSybMessageHandler(new SybMessageHandler(){

                    public SQLException messageHandler(SQLException sQLException) {
                        String string = "";
                        if (sQLException != null) {
                            SybDbStats.this.parseMessage(sQLException.getMessage());
                        }
                        return sQLException;
                    }
                });
                var3_3 = (SybStatement)this.conn.createStatement();
                var3_3.executeUpdate(var2_2);
                var6_4 = null;
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_6 = null;
                if (var3_3 != null) {
                    try {
                        var3_3.close();
                        var3_3 = null;
                    }
                    catch (Exception var7_9) {
                        var7_9.printStackTrace();
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                    var3_3 = null;
                }
                catch (Exception var7_7) {
                    var7_7.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block13;
                catch (Exception var4_10) {
                    System.err.println(var4_10);
                    var4_10.printStackTrace();
                    var6_5 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                            var3_3 = null;
                        }
                        catch (Exception var7_8) {
                            var7_8.printStackTrace();
                        }
                    }
                }
            }
        }
        if (this.sqlText != null && this.sqlText.length() > 0) {
            this.sqlText = this.sqlText.replace('\r', ' ');
            this.sqlText = this.sqlText.replace('\n', ' ');
        }
        return this.sqlText;
    }

    private void parseMessage(String string) {
        if (string.trim().toUpperCase().startsWith("SQL TEXT:")) {
            this.sqlText = "";
            this.sqlText = string;
            int n = this.sqlText.indexOf(":");
            if (n != -1) {
                this.sqlText = this.sqlText.substring(n + 1);
            }
        }
    }

    public ArrayList getTopApps() {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "SELECT convert(varchar(64), program_name) as Program, count(*) as CliCount, convert(float, sum(cpu)) / convert(float, sum(datediff(second, loggedindatetime, getdate()))) as score,  convert(float, sum(cpu)) / convert(float, sum(datediff(second, loggedindatetime, getdate()))) / count(*) as ProgramBadnessFactor FROM master.dbo.sysprocesses WHERE datediff(second,loggedindatetime, getdate()) > 0 and spid > 10 and program_name!='' GROUP BY  convert(varchar(64), program_name) ORDER BY score DESC";
        ArrayList arrayList = new ArrayList();
        try {
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            while (resultSet.next()) {
                String string2 = "";
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                String string3 = resultSet.getString(1).trim();
                long l = resultSet.getLong(2);
                double d = resultSet.getDouble(3);
                double d2 = resultSet.getDouble(4);
                arrayList2.add(string3);
                arrayList2.add(new Long(l));
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d2));
                arrayList.add(arrayList2);
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        return arrayList;
    }

    public ArrayList getAppDetails() {
        System.err.println("Inside the getAppDetails");
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "SELECT spid, convert(varchar(64),db_name(dbid)) as DBName, cpu, datediff(second,loggedindatetime, getdate()) as Secs, convert(float, cpu / datediff(second,loggedindatetime, getdate())) as PScore, convert(varchar(64), hostname) as Host, convert(varchar(128), program_name) as Program, convert(varchar(12), suser_name(suid)) as Login FROM master.dbo.sysprocesses WHERE datediff(second,loggedindatetime, getdate()) > 0 and spid > 10 and program_name !='' ORDER BY PScore desc";
        if (this.conn == null) {
            System.out.println("SybDbStats: getAppDetails :Failed to establish a connection!");
            return null;
        }
        ArrayList arrayList = new ArrayList();
        try {
            String string2;
            Object object;
            String string3;
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            while (resultSet.next()) {
                string3 = "";
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                object = resultSet.getString(1).trim();
                string2 = resultSet.getString(2).trim();
                double d = resultSet.getDouble(3);
                double d2 = resultSet.getDouble(4);
                double d3 = resultSet.getDouble(5);
                String string4 = resultSet.getString(6);
                string4 = string4 != null ? string4.trim() : "-";
                String string5 = resultSet.getString(7).trim();
                arrayList2.add(object);
                arrayList2.add(string2);
                arrayList2.add(string4);
                arrayList2.add(string5);
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d2));
                arrayList2.add(new Double(d3));
                arrayList.add(arrayList2);
            }
            if (arrayList != null && arrayList.size() > 0) {
                string3 = "dbcc traceon(3604,1)";
                this.execute(string3);
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (ArrayList)arrayList.get(i);
                    string2 = (String)((ArrayList)object).get(0);
                    String string6 = this.getCommandFor(string2);
                    ((ArrayList)object).add(string6);
                }
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        return arrayList;
    }

    public ArrayList getBlockers() {
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "select distinct 'blocker' = p.spid, 'login' = convert(varchar(12), suser_name(p.suid)), 'Time' = getdate(), 'database' = convert(varchar(12),  db_name(p.dbid)), cmd, physical_io, memusage, hostprocess from master..syslocks l, master..sysprocesses p where p.spid = l.spid and p.blocked=0 and exists  (select * from master..sysprocesses p2 \twhere p2.blocked = p.spid \tand time_blocked > 30 \t) if @@rowcount > 0 begin print '' print 'Some blocking is normal.  If blocking persists, record the' print 'information above and use the kill SPID command to kill the' print 'blocking process.  Use the SPID from the blocker column.' end else print 'No blocking detected at this time.'";
        if (this.conn == null) {
            System.out.println("SybDbStats: getBlockers :Failed to establish a connection!");
            return null;
        }
        ArrayList arrayList = new ArrayList();
        try {
            String string2;
            String string3;
            Object object;
            String string4;
            statement = this.conn.createStatement();
            resultSet = statement.executeQuery(string);
            if (resultSet == null) {
                this.closeStmt(statement);
                return null;
            }
            while (resultSet.next()) {
                string4 = "";
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                object = resultSet.getString(1).trim();
                string3 = resultSet.getString(2).trim();
                string2 = resultSet.getString(3).trim();
                String string5 = resultSet.getString(4).trim();
                String string6 = resultSet.getString(5);
                double d = resultSet.getDouble(6);
                double d2 = resultSet.getDouble(7);
                String string7 = resultSet.getString(8);
                arrayList2.add(object);
                arrayList2.add(string3);
                arrayList2.add(string5);
                arrayList2.add(string6);
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d2));
                arrayList.add(arrayList2);
            }
            if (arrayList != null && arrayList.size() > 0) {
                string4 = "dbcc traceon(3604,1)";
                this.execute(string4);
                for (int i = 0; i < arrayList.size(); ++i) {
                    object = (ArrayList)arrayList.get(i);
                    string3 = (String)((ArrayList)object).get(0);
                    string2 = this.getCommandFor(string3);
                    ((ArrayList)object).set(3, string2);
                }
            }
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.closeRs(resultSet);
            this.closeStmt(statement);
        }
        return arrayList;
    }

    private void getSpaceUsageFor(SybConnection sybConnection, String string, int n) {
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        String string2 = "USE ";
        String string3 = "sp_spaceused";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        string2 = string2 + string;
        try {
            sybStatement = (SybStatement)sybConnection.createStatement();
            sybStatement.execute(string2);
            resultSet = sybStatement.executeQuery(string3);
            if (resultSet == null) {
                this.closeStmt((Statement)sybStatement);
                this.dbSize[n] = -1.0;
                this.dbUtil[n] = -1.0;
                this.dbReserved[n] = -1.0;
                this.dbData[n] = -1.0;
                this.dbIndex[n] = -1.0;
                this.dbUnused[n] = -1.0;
                return;
            }
            while (resultSet.next()) {
                string4 = resultSet.getString("database_size");
            }
            this.closeRs(resultSet);
            if (sybStatement.getMoreResults()) {
                resultSet = sybStatement.getResultSet();
                if (resultSet == null) {
                    this.closeStmt((Statement)sybStatement);
                    return;
                }
                while (resultSet.next()) {
                    string7 = resultSet.getString("reserved");
                    string6 = resultSet.getString("data");
                    string8 = resultSet.getString("index_size");
                    string9 = resultSet.getString("unused");
                }
                this.closeRs(resultSet);
            }
            this.closeStmt((Statement)sybStatement);
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            double d4 = -1.0;
            double d5 = -1.0;
            d = this.parse(string4);
            d2 = this.parse(string7);
            d3 = this.parse(string6);
            d4 = this.parse(string8);
            d5 = this.parse(string9);
            double d6 = -1.0;
            if (d != 0.0) {
                d6 = d2 * 100.0 / d;
            }
            this.dbSize[n] = d;
            this.dbUtil[n] = d6;
            this.dbReserved[n] = d2;
            this.dbData[n] = d3;
            this.dbIndex[n] = d4;
            this.dbUnused[n] = d5;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception === " + exception.getMessage());
            this.closeRs(resultSet);
            this.closeStmt((Statement)sybStatement);
            this.dbSize[n] = -1.0;
            this.dbUtil[n] = -1.0;
            this.dbReserved[n] = -1.0;
            this.dbData[n] = -1.0;
            this.dbIndex[n] = -1.0;
            this.dbUnused[n] = -1.0;
        }
    }

    private double parse(String string) {
        if (string == null || string.length() == 0) {
            return -1.0;
        }
        if (string.indexOf("MB") < 0 && string.indexOf("KB") < 0) {
            return -1.0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            return -1.0;
        }
        String string2 = stringTokenizer.nextToken();
        double d = Double.parseDouble(string2);
        if (stringTokenizer.nextToken().equalsIgnoreCase("KB")) {
            d /= 1024.0;
        }
        return d;
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ArrayList getDatabases(SybConnection sybConnection) {
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "SELECT name FROM master.dbo.sysdatabases";
        try {
            sybStatement = (SybStatement)sybConnection.createStatement();
            resultSet = sybStatement.executeQuery(string);
            while (resultSet != null && resultSet.next()) {
                String string2 = resultSet.getString(1);
                if (arrayList.indexOf(string2) >= 0) continue;
                arrayList.add(string2);
            }
            this.closeRs(resultSet);
            this.closeStmt((Statement)sybStatement);
            return arrayList;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception === " + exception.getMessage());
            this.closeRs(resultSet);
            this.closeStmt((Statement)sybStatement);
            return null;
        }
    }

    public Hashtable executeDbSpaceUsingQuery(ArrayList arrayList, ArrayList arrayList2) {
        Hashtable hashtable = new Hashtable();
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        String string = "select Database_name = convert(char(20),db_name(d.dbid)),database_size=str(sum(case when u.segmap != 4 then u.size*4096/1048576 end),10,1),reserved_data=str(sum(case when u.segmap != 4 then size-curunreservedpgs(u.dbid,u.lstart,u.unreservedpgs) end)*4096/1048576,10,1),unused_space=str(sum(curunreservedpgs(u.dbid,u.lstart,u.unreservedpgs))*4096/1048576,10,1) FROM sysdatabases d,sysusages u WHERE u.dbid = d.dbid GROUP BY d.dbid ORDER BY db_name(d.dbid)";
        if (this.conn == null) {
            System.out.println("SybDbStats: executeDbSpaceUsingQuery :Failed to establish a connection!");
            return null;
        }
        try {
            sybStatement = (SybStatement)this.conn.createStatement();
            resultSet = sybStatement.executeQuery(string);
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            double d = -5.0;
            double d2 = -5.0;
            double d3 = -5.0;
            double d4 = -5.0;
            while (resultSet != null && resultSet.next()) {
                string2 = resultSet.getString(1);
                string3 = resultSet.getString(2);
                string4 = resultSet.getString(3);
                string5 = resultSet.getString(4);
                if (arrayList != null && arrayList.size() > 0 && !arrayList.contains(string2) || arrayList2 != null && arrayList2.size() > 0 && arrayList2.contains(string2)) continue;
                d = this.getDoubleValue(string3);
                d2 = this.getDoubleValue(string4);
                d3 = this.getDoubleValue(string5);
                if (d != 0.0) {
                    d4 = d2 * 100.0 / d;
                }
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                arrayList3.add(new Double(d));
                arrayList3.add(new Double(d4));
                arrayList3.add(new Double(d2));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(-5.0));
                arrayList3.add(new Double(d3));
                hashtable.put(string2, arrayList3);
            }
            this.closeRs(resultSet);
            this.closeStmt((Statement)sybStatement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Exception === " + exception.getMessage());
            this.closeRs(resultSet);
            this.closeStmt((Statement)sybStatement);
            return null;
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = 0.0;
        if (string == null || string.length() == 0 || string.equalsIgnoreCase("none")) {
            d = 0.0;
        } else {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                d = 0.0;
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCharSetName(String var0, String var1_1, String var2_2, String var3_3) {
        var4_4 = var0 + ":" + var1_1;
        var5_5 = "";
        if (SybDbStats.sybCharsetHash != null && SybDbStats.sybCharsetHash.size() > 0 && SybDbStats.sybCharsetHash.containsKey(var4_4)) {
            return (String)SybDbStats.sybCharsetHash.get(var4_4);
        }
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        try {
            block73: {
                Class.forName("com.sybase.jdbc2.jdbc.SybDriver");
                var9_9 = "jdbc:sybase:Tds:" + var0 + ":" + var1_1;
                var10_11 = new Properties();
                var10_11.put("user", var2_2);
                var10_11.put("password", var3_3);
                var10_11.put("charset", "iso_1");
                var10_11.put("IS_CLOSED_TEST", "INTERNAL");
                var10_11.put("REPEAT_READ", "false");
                try {
                    var6_6 = (SybConnection)DriverManager.getConnection(var9_9, var10_11);
                }
                catch (Exception var11_16) {
                    System.out.println("Connection failed for targetHost :" + var0);
                    System.out.println("Returning charset as empty for targetHost :" + var0);
                    var11_16.printStackTrace();
                    var12_19 = null;
                    var15_22 = null;
                    if (var8_8 != null) {
                        try {
                            var8_8.close();
                            var8_8 = null;
                        }
                        catch (Exception var16_29) {
                            // empty catch block
                        }
                    }
                    if (var7_7 != null) {
                        try {
                            var7_7.close();
                            var7_7 = null;
                        }
                        catch (Exception var16_29) {
                            var16_29.printStackTrace();
                        }
                    }
                    if (var6_6 == null) return var12_19;
                    try {
                        var6_6.close();
                        return var12_19;
                    }
                    catch (Exception var16_29) {
                        var16_29.printStackTrace();
                    }
                    return var12_19;
                }
                if (var6_6 != null) break block73;
                System.out.println("Connection is null for targetHost :" + var0);
                System.out.println("Returning charset as empty for targetHost :" + var0);
                var11_17 = null;
                var15_23 = null;
                if (var8_8 == null) ** GOTO lbl221
                ** GOTO lbl215
            }
            var6_6.setAutoCommit(false);
            try {
                var7_7 = (SybPreparedStatement)var6_6.prepareCall("{call sp_serverinfo server_csname}");
            }
            catch (Exception var11_18) {
                block65: {
                    block64: {
                        var11_18.printStackTrace();
                        if (var6_6 != null) {
                            try {
                                var6_6.close();
                                var6_6 = null;
                            }
                            catch (Exception var12_20) {
                                block63: {
                                    block62: {
                                        var12_20.printStackTrace();
                                        var13_36 = null;
                                        var15_24 = null;
                                        if (var8_8 != null) {
                                            ** try [egrp 8[TRYBLOCK] [18 : 580->593)] { 
lbl84:
                                            // 1 sources

                                            var8_8.close();
                                            var8_8 = null;
                                            break block62;
lbl87:
                                            // 1 sources

                                            catch (Exception var16_31) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var7_7 != null) {
                                        ** try [egrp 9[TRYBLOCK] [19 : 600->613)] { 
lbl92:
                                        // 1 sources

                                        var7_7.close();
                                        var7_7 = null;
                                        break block63;
lbl95:
                                        // 1 sources

                                        catch (Exception var16_31) {
                                            var16_31.printStackTrace();
                                        }
                                    }
                                }
                                if (var6_6 == null) return var13_36;
                                ** try [egrp 10[TRYBLOCK] [20 : 625->638)] { 
lbl100:
                                // 1 sources

                                var6_6.close();
                                return var13_36;
lbl102:
                                // 1 sources

                                catch (Exception var16_31) {
                                    var16_31.printStackTrace();
                                }
                                return var13_36;
                            }
                        }
                        var12_21 = null;
                        var15_25 = null;
                        if (var8_8 != null) {
                            ** try [egrp 8[TRYBLOCK] [18 : 580->593)] { 
lbl110:
                            // 1 sources

                            var8_8.close();
                            var8_8 = null;
                            break block64;
lbl113:
                            // 1 sources

                            catch (Exception var16_32) {
                                // empty catch block
                            }
                        }
                    }
                    if (var7_7 != null) {
                        ** try [egrp 9[TRYBLOCK] [19 : 600->613)] { 
lbl118:
                        // 1 sources

                        var7_7.close();
                        var7_7 = null;
                        break block65;
lbl121:
                        // 1 sources

                        catch (Exception var16_32) {
                            var16_32.printStackTrace();
                        }
                    }
                }
                if (var6_6 == null) return var12_21;
                ** try [egrp 10[TRYBLOCK] [20 : 625->638)] { 
lbl126:
                // 1 sources

                var6_6.close();
                return var12_21;
lbl128:
                // 1 sources

                catch (Exception var16_32) {
                    var16_32.printStackTrace();
                }
                return var12_21;
            }
            var8_8 = var7_7.executeQuery();
            while (var8_8.next()) {
                var5_5 = var8_8.getString(1);
            }
            SybDbStats.sybCharsetHash.put(var4_4, var5_5);
            System.out.println("Default CharacterSet :: " + var5_5 + " For the index :" + var4_4);
            ** GOTO lbl237
        }
        catch (Exception var9_10) {
            block67: {
                block66: {
                    var9_10.printStackTrace();
                    if (var8_8 != null) {
                        try {
                            var8_8.close();
                            var8_8 = null;
                        }
                        catch (Exception var10_12) {
                            // empty catch block
                        }
                    }
                    if (var7_7 != null) {
                        try {
                            var7_7.close();
                            var7_7 = null;
                        }
                        catch (Exception var10_13) {
                            var10_13.printStackTrace();
                        }
                    }
                    if (var6_6 != null) {
                        try {
                            var6_6.close();
                            var6_6 = null;
                        }
                        catch (Exception var10_15) {
                            var10_15.printStackTrace();
                        }
                    }
                    var10_14 = var5_5;
                    var15_27 = null;
                    if (var8_8 != null) {
                        ** try [egrp 8[TRYBLOCK] [18 : 580->593)] { 
lbl167:
                        // 1 sources

                        var8_8.close();
                        var8_8 = null;
                        break block66;
lbl170:
                        // 1 sources

                        catch (Exception var16_34) {
                            // empty catch block
                        }
                    }
                }
                if (var7_7 != null) {
                    ** try [egrp 9[TRYBLOCK] [19 : 600->613)] { 
lbl175:
                    // 1 sources

                    var7_7.close();
                    var7_7 = null;
                    break block67;
lbl178:
                    // 1 sources

                    catch (Exception var16_34) {
                        var16_34.printStackTrace();
                    }
                }
            }
            if (var6_6 == null) return var10_14;
            ** try [egrp 10[TRYBLOCK] [20 : 625->638)] { 
lbl183:
            // 1 sources

            var6_6.close();
            return var10_14;
lbl185:
            // 1 sources

            catch (Exception var16_34) {
                var16_34.printStackTrace();
            }
            return var10_14;
        }
        {
            block72: {
                block71: {
                    block70: {
                        block74: {
                            catch (Throwable var14_37) {
                                block69: {
                                    block68: {
                                        var15_28 = null;
                                        if (var8_8 != null) {
                                            ** try [egrp 8[TRYBLOCK] [18 : 580->593)] { 
lbl193:
                                            // 1 sources

                                            var8_8.close();
                                            var8_8 = null;
                                            break block68;
lbl196:
                                            // 1 sources

                                            catch (Exception var16_35) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (var7_7 != null) {
                                        ** try [egrp 9[TRYBLOCK] [19 : 600->613)] { 
lbl201:
                                        // 1 sources

                                        var7_7.close();
                                        var7_7 = null;
                                        break block69;
lbl204:
                                        // 1 sources

                                        catch (Exception var16_35) {
                                            var16_35.printStackTrace();
                                        }
                                    }
                                }
                                if (var6_6 == null) throw var14_37;
                                ** try [egrp 10[TRYBLOCK] [20 : 625->638)] { 
lbl209:
                                // 1 sources

                                var6_6.close();
                                var6_6 = null;
                                throw var14_37;
lbl212:
                                // 1 sources

                                catch (Exception var16_35) {
                                    var16_35.printStackTrace();
                                }
                                throw var14_37;
                            }
lbl215:
                            // 1 sources

                            ** try [egrp 8[TRYBLOCK] [18 : 580->593)] { 
lbl216:
                            // 1 sources

                            var8_8.close();
                            var8_8 = null;
                            break block74;
lbl219:
                            // 1 sources

                            catch (Exception var16_30) {
                                // empty catch block
                            }
                        }
                        if (var7_7 != null) {
                            ** try [egrp 9[TRYBLOCK] [19 : 600->613)] { 
lbl224:
                            // 1 sources

                            var7_7.close();
                            var7_7 = null;
                            break block70;
lbl227:
                            // 1 sources

                            catch (Exception var16_30) {
                                var16_30.printStackTrace();
                            }
                        }
                    }
                    if (var6_6 == null) return var11_17;
                    ** try [egrp 10[TRYBLOCK] [20 : 625->638)] { 
lbl232:
                    // 1 sources

                    var6_6.close();
                    return var11_17;
lbl234:
                    // 1 sources

                    catch (Exception var16_30) {
                        var16_30.printStackTrace();
                    }
                    return var11_17;
lbl237:
                    // 1 sources

                    var15_26 = null;
                    if (var8_8 != null) {
                        ** try [egrp 8[TRYBLOCK] [18 : 580->593)] { 
lbl240:
                        // 1 sources

                        var8_8.close();
                        var8_8 = null;
                        break block71;
lbl243:
                        // 1 sources

                        catch (Exception var16_33) {
                            // empty catch block
                        }
                    }
                }
                if (var7_7 != null) {
                    ** try [egrp 9[TRYBLOCK] [19 : 600->613)] { 
lbl248:
                    // 1 sources

                    var7_7.close();
                    var7_7 = null;
                    break block72;
lbl251:
                    // 1 sources

                    catch (Exception var16_33) {
                        var16_33.printStackTrace();
                    }
                }
            }
            if (var6_6 == null) return var5_5;
            try {}
            catch (Exception var16_33) {}
            var16_33.printStackTrace();
            return var5_5;
            var6_6.close();
            var6_6 = null;
            return var5_5;
        }
    }
}

