/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SybMonDataCacheTest
extends GenericTest {
    private String user;
    private String passwd;
    private String s_debug = "false";
    private boolean isDebug = false;
    private String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    private static final int i_measureCount = 2;
    private SybStatement stmt = null;
    private Hashtable prev_hitRatioHash = new Hashtable();
    private Hashtable prev_hitRatioDDHash = new Hashtable();
    public Hashtable ddHitRatioHash = new Hashtable();
    public Hashtable ddObjCountHash = new Hashtable();
    private ArrayList allInfoList = new ArrayList();
    private String s_hitRatioQuery = "";
    private String s_hitRatioDDQuery = "";
    private String s_objCountquery = "";
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";

    public SybMonDataCacheTest(String[] stringArray) {
        super(stringArray);
        Comparable<Boolean> comparable;
        this.setMeasureCount(2);
        this.isDynamicInfoTest = true;
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.s_debug = this.getValueForParam("isdebug");
        try {
            comparable = new Boolean(this.s_debug);
            this.isDebug = (Boolean)comparable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isDebug = false;
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append(" select CacheID, CacheName, ");
        ((StringBuffer)comparable).append(" BufferPools, CacheSearches, PhysicalReads, ");
        ((StringBuffer)comparable).append(" LogicalReads, PhysicalWrites, Stalls from monDataCache ");
        String string = "5";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" set rowcount " + string + " select CacheID,");
        stringBuffer.append(" ObjectID, IndexID, DBID, ");
        stringBuffer.append("  OwnerUserID, CachedKB, CacheName, ");
        stringBuffer.append("  DBName, OwnerName,ObjectName,ProcessesAccessing ");
        stringBuffer.append(" from monCachedObject  order by CacheName,CachedKB desc ");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(" set rowcount " + string + " select CacheID, ");
        stringBuffer2.append("  ObjectID, IndexID, DBID, OwnerUserID, CachedKB, ");
        stringBuffer2.append("  CacheName, DBName, OwnerName,ObjectName,ProcessesAccessing ");
        stringBuffer2.append(" from monCachedObject where ProcessesAccessing > 0 order by ProcessesAccessing desc  ");
        this.s_hitRatioQuery = ((StringBuffer)comparable).toString();
        this.s_hitRatioDDQuery = stringBuffer.toString();
        this.s_objCountquery = stringBuffer2.toString();
    }

    public void freeTest() {
        this.ddHitRatioHash = new Hashtable();
        this.ddObjCountHash = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        if (this.isFirstTime) {
            string = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd);
            if (string != null && string.length() > 0) {
                this.defaultCharSet = string;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        if ((string = this.getConnection(this.targetHost, this.portNo, this.user, this.passwd)) == null) {
            return;
        }
        try {
            this.stmt = (SybStatement)string.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SybMonDataCacheTest Create Statement ", exception.toString());
            exception.printStackTrace();
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
            return;
        }
        if (this.isDebug) {
            System.out.println("[" + this.getClass().getName() + "]-s_hitRatioQuery String :: " + this.s_hitRatioQuery);
            System.out.println("[" + this.getClass().getName() + "]-s_hitRatioDDQuery String :: " + this.s_hitRatioDDQuery);
            System.out.println("[" + this.getClass().getName() + "]-s_objCountquery String :: " + this.s_objCountquery);
        }
        Hashtable hashtable2 = this.getDataHitRatio(this.s_hitRatioQuery);
        Hashtable hashtable3 = this.getDataHitRatioDD(this.s_hitRatioDDQuery);
        Hashtable hashtable4 = this.getObjCount(this.s_objCountquery);
        if (this.isDebug) {
            System.out.println("[" + this.getClass().getName() + "]- ::: Query Output :::");
            System.out.println("[" + this.getClass().getName() + "]-cur_hitRatioHash   ==>" + hashtable2);
            System.out.println("[" + this.getClass().getName() + "]-prev_hitRatioHash  ==>" + this.prev_hitRatioHash);
            System.out.println("[" + this.getClass().getName() + "]-hitRatio DD Hash  ==>" + hashtable3);
            System.out.println("[" + this.getClass().getName() + "]-objCount Hash ==>" + hashtable4);
        }
        try {
            try {
                if (this.prev_hitRatioHash != null && this.prev_hitRatioHash.size() > 0) {
                    this.allInfoList = new ArrayList();
                    this.getKeys(hashtable2);
                    this.getKeys(hashtable4);
                    int n = 0;
                    if (this.allInfoList != null) {
                        n = this.allInfoList.size();
                    }
                    for (int i = 0; i < n; ++i) {
                        String string2 = (String)this.allInfoList.get(i);
                        ArrayList arrayList = (ArrayList)hashtable2.get(string2);
                        double d = (Double)arrayList.get(0);
                        double d2 = (Double)arrayList.get(1);
                        ArrayList arrayList2 = (ArrayList)this.prev_hitRatioHash.get(string2);
                        if (arrayList2 == null) continue;
                        double d3 = (Double)arrayList2.get(0);
                        double d4 = (Double)arrayList2.get(1);
                        double d5 = 0.0;
                        d5 = d >= d3 && d2 >= d4 ? (d - d3) * 100.0 / (d2 - d4) : d * 100.0 / d2;
                        if (d5 > 0.0) {
                            this.setDataHitRatioDDValue(hashtable3, this.prev_hitRatioDDHash, string2);
                        }
                        ArrayList arrayList3 = (ArrayList)hashtable4.get(string2);
                        int n2 = 0;
                        if (arrayList3 != null) {
                            n2 = arrayList3.size();
                        }
                        ArrayList<Double> arrayList4 = new ArrayList<Double>();
                        arrayList4.add(new Double(d5));
                        arrayList4.add(new Double(n2));
                        if (this.isDebug) {
                            System.out.println("[" + this.getClass().getName() + "]-Final Measure  ==>" + string2 + "-->" + arrayList4);
                            System.out.println("[" + this.getClass().getName() + "]-ddHitRatioHash ==>" + this.ddHitRatioHash);
                        }
                        this.addNewMeasure(string2, arrayList4);
                    }
                } else {
                    Enumeration enumeration = hashtable4.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        ArrayList arrayList = (ArrayList)hashtable4.get(string3);
                        int n = 0;
                        if (arrayList != null) {
                            n = arrayList.size();
                        }
                        ArrayList<Double> arrayList5 = new ArrayList<Double>();
                        arrayList5.add(new Double(-5.0));
                        arrayList5.add(new Double(n));
                        this.addNewMeasure(string3, arrayList5);
                    }
                }
                Object var25_26 = null;
                if (this.stmt != null) {
                    this.closeStmt(this.stmt);
                }
                if (string != null) {
                    this.closeConn((SybConnection)string);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "SybMonDataCacheTest computeMeasures ", exception.toString());
                exception.printStackTrace();
                Object var25_27 = null;
                if (this.stmt != null) {
                    this.closeStmt(this.stmt);
                }
                if (string != null) {
                    this.closeConn((SybConnection)string);
                }
            }
        }
        catch (Throwable throwable) {
            Object var25_28 = null;
            if (this.stmt != null) {
                this.closeStmt(this.stmt);
            }
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
            throw throwable;
        }
        this.prev_hitRatioHash = (Hashtable)hashtable2.clone();
        this.prev_hitRatioDDHash = (Hashtable)hashtable3.clone();
    }

    private void getKeys(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.allInfoList.contains(string)) continue;
            this.allInfoList.add(string);
        }
    }

    private void setDataHitRatioDDValue(Hashtable hashtable, Hashtable hashtable2, String string) {
        ArrayList arrayList = (ArrayList)hashtable.get(string);
        ArrayList arrayList2 = (ArrayList)hashtable2.get(string);
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        }
        for (int i = 0; i < n; ++i) {
            Hashtable hashtable3 = (Hashtable)arrayList.get(i);
            Hashtable hashtable4 = (Hashtable)arrayList2.get(i);
            if (hashtable4 == null) continue;
            Enumeration enumeration = hashtable3.keys();
            while (enumeration.hasMoreElements()) {
                ArrayList arrayList3;
                String string2 = (String)enumeration.nextElement();
                ArrayList arrayList4 = (ArrayList)hashtable3.get(string2);
                ArrayList arrayList5 = (ArrayList)hashtable4.get(string2);
                String string3 = (String)arrayList4.get(0);
                String string4 = (String)arrayList4.get(1);
                String string5 = (String)arrayList4.get(2);
                String string6 = (String)arrayList4.get(3);
                String string7 = (String)arrayList4.get(4);
                double d = 0.0;
                double d2 = 0.0;
                try {
                    d = (Double)arrayList4.get(5);
                }
                catch (Exception exception) {
                    d = 0.0;
                }
                try {
                    d2 = (Double)arrayList5.get(5);
                }
                catch (Exception exception) {
                    d2 = 0.0;
                }
                double d3 = 0.0;
                d3 = d >= d2 ? d - d2 : 0.0;
                String string8 = (String)arrayList4.get(6);
                String string9 = (String)arrayList4.get(7);
                String string10 = (String)arrayList4.get(8);
                String string11 = (String)arrayList4.get(9);
                String string12 = (String)arrayList4.get(10);
                if (!(d3 > 0.0)) continue;
                String string13 = string3 + "~!~" + string4 + "~!~" + string5 + "~!~" + string6 + "~!~" + string7 + "~!~" + d3 + "~!~" + string8 + "~!~" + string9 + "~!~" + string10 + "~!~" + string11 + "~!~" + string12;
                if (this.isDebug) {
                    System.out.println("[SybmonDataCacheTest]-setDataHitRatioDDValue()-ddLine ===> " + string13);
                }
                if (this.ddHitRatioHash.containsKey(string)) {
                    arrayList3 = (ArrayList)this.ddHitRatioHash.get(string);
                    arrayList3.add(string13);
                    continue;
                }
                arrayList3 = new ArrayList();
                arrayList3.add(string13);
                this.ddHitRatioHash.put(string, arrayList3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getDataHitRatio(String string) {
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        try {
            block12: {
                try {
                    ArrayList<Double> arrayList;
                    resultSet = this.stmt.executeQuery(string);
                    String string2 = "";
                    String string3 = "";
                    double d = 0.0;
                    double d2 = 0.0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    boolean bl = true;
                    String string4 = "";
                    while (resultSet.next()) {
                        string2 = resultSet.getString(1);
                        string3 = resultSet.getString(2);
                        d = resultSet.getDouble(4);
                        d2 = resultSet.getDouble(6);
                        if (bl) {
                            d3 = d2;
                            d4 = d;
                            bl = false;
                            string4 = string3;
                        } else if (string4.equalsIgnoreCase(string3)) {
                            d3 += d2;
                            d4 += d;
                        } else {
                            arrayList = new ArrayList();
                            arrayList.add(new Double(d3));
                            arrayList.add(new Double(d4));
                            hashtable.put(string4, arrayList);
                            d3 = d2;
                            d4 = d;
                        }
                        string4 = string3;
                    }
                    if (bl) break block12;
                    arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    hashtable.put(string4, arrayList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var18_15 = null;
                    if (resultSet != null) {
                        this.closeRs(resultSet);
                    }
                }
            }
            Object var18_14 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            throw throwable;
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getDataHitRatioDD(String string) {
        ResultSet resultSet = null;
        Hashtable<String, Cloneable> hashtable = new Hashtable<String, Cloneable>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        double d = 0.0;
        try {
            try {
                resultSet = this.stmt.executeQuery(string);
                while (resultSet.next()) {
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    arrayList = new ArrayList();
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    string5 = resultSet.getString(4);
                    string6 = resultSet.getString(5);
                    d = resultSet.getDouble(6);
                    string7 = resultSet.getString(7);
                    string8 = resultSet.getString(8);
                    string9 = resultSet.getString(9);
                    string10 = resultSet.getString(10);
                    string11 = resultSet.getString(11);
                    string12 = string2 + "," + string3 + "," + string4 + "," + string5 + "," + string6 + "," + d + "," + string7 + "," + string8 + "," + string9 + "," + string10 + "," + string11;
                    arrayList.add(string2);
                    arrayList.add(string3);
                    arrayList.add(string4);
                    arrayList.add(string5);
                    arrayList.add(string6);
                    arrayList.add(new Double(d));
                    arrayList.add(string7);
                    arrayList.add(string8);
                    arrayList.add(string9);
                    arrayList.add(string10);
                    arrayList.add(string11);
                    String string13 = string8 + "_" + string10;
                    if (hashtable.containsKey(string7)) {
                        cloneable2 = (ArrayList)hashtable.get(string7);
                        cloneable = new Hashtable();
                        ((Hashtable)cloneable).put(string13, arrayList);
                        ((ArrayList)cloneable2).add(cloneable);
                        hashtable.put(string7, cloneable2);
                        continue;
                    }
                    cloneable2 = new Hashtable();
                    cloneable = new ArrayList();
                    ((Hashtable)cloneable2).put(string13, arrayList);
                    ((ArrayList)cloneable).add(cloneable2);
                    hashtable.put(string7, cloneable);
                }
                Object var22_21 = null;
                if (resultSet != null) {
                    this.closeRs(resultSet);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "SybMonDataCacheTest execute DD Query ", exception.toString());
                exception.printStackTrace();
                Object var22_22 = null;
                if (resultSet != null) {
                    this.closeRs(resultSet);
                }
            }
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            throw throwable;
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getObjCount(String string) {
        ResultSet resultSet = null;
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        double d = 0.0;
        try {
            try {
                resultSet = this.stmt.executeQuery(string);
                while (resultSet.next()) {
                    ArrayList<String> arrayList;
                    ArrayList arrayList2;
                    string2 = resultSet.getString(1);
                    string3 = resultSet.getString(2);
                    string4 = resultSet.getString(3);
                    string5 = resultSet.getString(4);
                    string6 = resultSet.getString(5);
                    d = resultSet.getDouble(6);
                    string7 = resultSet.getString(7);
                    string8 = resultSet.getString(8);
                    string9 = resultSet.getString(9);
                    string10 = resultSet.getString(10);
                    string11 = resultSet.getString(11);
                    string12 = string2 + "~!~" + string3 + "~!~" + string4 + "~!~" + string5 + "~!~" + string6 + "~!~" + d + "~!~" + string7 + "~!~" + string8 + "~!~" + string9 + "~!~" + string10 + "~!~" + string11;
                    if (hashtable.containsKey(string7)) {
                        arrayList2 = (ArrayList)hashtable.get(string7);
                        if (!arrayList2.contains(string3)) {
                            arrayList2.add(string3);
                        }
                        if (!(d > 0.0)) continue;
                        arrayList = (ArrayList<String>)this.ddObjCountHash.get(string7);
                        arrayList.add(string12);
                        this.ddObjCountHash.put(string7, arrayList);
                        continue;
                    }
                    arrayList2 = new ArrayList();
                    arrayList2.add(string3);
                    hashtable.put(string7, arrayList2);
                    if (!(d > 0.0)) continue;
                    arrayList = new ArrayList<String>();
                    arrayList.add(string12);
                    this.ddObjCountHash.put(string7, arrayList);
                }
                Object var20_19 = null;
                if (resultSet != null) {
                    this.closeRs(resultSet);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "SybMonDataCacheTest execute Test Query ", exception.toString());
                exception.printStackTrace();
                Object var20_20 = null;
                if (resultSet != null) {
                    this.closeRs(resultSet);
                }
            }
        }
        catch (Throwable throwable) {
            Object var20_21 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            throw throwable;
        }
        return hashtable;
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4) {
        try {
            Class.forName(this.driver);
            String string5 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", this.defaultCharSet);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("REPEAT_READ", "false");
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string5, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "Exception while Connection ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SybMonDataCacheTest sybMonDataCacheTest = new SybMonDataCacheTest(stringArray);
        sybMonDataCacheTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(5000L);
            sybMonDataCacheTest.computeMeasures(new Hashtable());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

