/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class SybResponseTest
extends GenericTest {
    String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    String user = "";
    String password = "";
    String query = "select * from sysobjects";
    String index = "";
    private int availability = 0;
    private double responseTime = -5.0;
    public double dbConnAvailable = -5.0;
    public double dbConResTime = -5.0;
    public int qryProAvailable = -5;
    public double qryExecTime = -5.0;
    public int noOfRecords = -5;
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";
    public ArrayList sybRespDDList = new ArrayList();

    public SybResponseTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
    }

    public static void main(String[] stringArray) {
        System.out.println("Starting test ........");
        SybResponseTest sybResponseTest = new SybResponseTest(stringArray);
        for (int i = 0; i < 20; ++i) {
            sybResponseTest.computeMeasures(new Hashtable());
            try {
                Thread.sleep(1500L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        if (this.isFirstTime) {
            object = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.password);
            if (object != null && ((String)object).length() > 0) {
                this.defaultCharSet = object;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
            }
        }
        object = null;
        Object var3_3 = null;
        Statement statement = null;
        Connection connection = null;
        this.availability = 0;
        this.responseTime = -5.0;
        this.dbConnAvailable = -5.0;
        this.dbConResTime = -5.0;
        this.qryProAvailable = -5;
        this.qryExecTime = -5.0;
        this.noOfRecords = -5;
        try {
            try {
                Class.forName(this.driver);
                Properties properties = new Properties();
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("charset", this.defaultCharSet);
                properties.put("IS_CLOSED_TEST", "INTERNAL");
                this.index = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
                long l = System.currentTimeMillis();
                String string = "jdbc:sybase:Tds:" + this.targetHost + ":" + this.portNo;
                try {
                    connection = DriverManager.getConnection(string, properties);
                }
                catch (Exception exception) {
                    this.dbConnAvailable = 0.0;
                    this.dbConResTime = -5.0;
                    this.closeConn(connection);
                    String string2 = EgInstallInfo.getStackTraceAsString(exception);
                    this.sybRespDDList.add(string2);
                    System.out.println("sybRespDDList :" + this.sybRespDDList);
                }
                long l2 = 0L;
                if (connection != null) {
                    this.dbConnAvailable = 100.0;
                    this.availability = 100;
                    this.qryProAvailable = 0;
                    long l3 = System.currentTimeMillis();
                    this.dbConResTime = (double)(l3 - l) / 1000.0;
                    l2 = System.currentTimeMillis();
                    try {
                        statement = connection.createStatement();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (statement != null) {
                        object = statement.executeQuery(this.query);
                    }
                    if (object != null) {
                        this.noOfRecords = 0;
                        this.qryProAvailable = 100;
                        long l4 = System.currentTimeMillis();
                        this.qryExecTime = (double)(l4 - l2) / 1000.0;
                        try {
                            while (object.next()) {
                                ++this.noOfRecords;
                            }
                        }
                        catch (Exception exception) {
                            this.noOfRecords = 0;
                        }
                    } else {
                        this.qryProAvailable = 0;
                        this.qryExecTime = -5.0;
                    }
                }
                try {
                    this.closeRs((ResultSet)object);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long l5 = System.currentTimeMillis();
                this.responseTime = this.availability == 100 ? (double)(l5 - l) / 1000.0 : -5.0;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                if (this.measureCount > 2) {
                    arrayList.add(new Double(this.dbConnAvailable));
                    arrayList.add(new Double(this.dbConResTime));
                    arrayList.add(new Double(this.qryProAvailable));
                    arrayList.add(new Double(this.qryExecTime));
                    arrayList.add(new Double(this.noOfRecords));
                }
                this.addNewMeasure(arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (object != null) {
                    try {
                        object.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                this.responseTime = this.dbConResTime;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(this.availability));
                arrayList.add(new Double(this.responseTime));
                if (this.measureCount > 2) {
                    arrayList.add(new Double(this.dbConnAvailable));
                    arrayList.add(new Double(this.dbConResTime));
                    arrayList.add(new Double(this.qryProAvailable));
                    arrayList.add(new Double(this.qryExecTime));
                    arrayList.add(new Double(this.noOfRecords));
                }
                this.addNewMeasure(arrayList);
                String string = EgInstallInfo.getStackTraceAsString(exception);
                this.sybRespDDList.add(string);
                this.errorMsg = new String("Exception " + exception.toString() + " while" + "executing SybResponseTest for target: " + this.targetHost);
                Object var18_25 = null;
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            Object var18_24 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn(connection);
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn(connection);
            throw throwable;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void freeTest() {
        this.sybRespDDList = new ArrayList();
    }
}

