/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class SybServerNetIOTest
extends GenericTest {
    private String user;
    private String passwd;
    private String s_debug = "false";
    private boolean isDebug = false;
    private String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    private static final int i_measureCount = 5;
    private ArrayList prevList = new ArrayList();
    private double defValue = -1.0;
    private String query = "";
    private boolean isFirstTime = true;
    private String defaultCharSet = "";

    public SybServerNetIOTest(String[] stringArray) {
        super(stringArray);
        Comparable<Boolean> comparable;
        this.setMeasureCount(5);
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.s_debug = this.getValueForParam("isdebug");
        try {
            comparable = new Boolean(this.s_debug);
            this.isDebug = (Boolean)comparable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isDebug = false;
        }
        if (this.isPassive) {
            this.defValue = -5.0;
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append(" select ( PacketsSent + PacketsReceived ) tot_packets , ");
        ((StringBuffer)comparable).append(" PacketsSent tot_packet_sent, PacketsReceived tot_packet_received, ");
        ((StringBuffer)comparable).append(" BytesSent tot_bytes_sent, BytesReceived tot_bytes_received from monNetworkIO ");
        this.query = ((StringBuffer)comparable).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        if (this.isFirstTime) {
            string = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd);
            if (string != null && string.length() > 0) {
                this.defaultCharSet = string;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        string = this.getConnection(this.targetHost, this.portNo, this.user, this.passwd);
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        System.out.println("[SybServerNetIOTest]Query : " + this.query);
        System.out.println("isDebug is " + this.isDebug);
        if (string == null) {
            return;
        }
        try {
            sybStatement = (SybStatement)string.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
            return;
        }
        try {
            try {
                ArrayList<Double> arrayList = new ArrayList<Double>();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                resultSet = sybStatement.executeQuery(this.query);
                while (resultSet.next()) {
                    arrayList = new ArrayList();
                    d = resultSet.getDouble(1);
                    d2 = resultSet.getDouble(2);
                    d3 = resultSet.getDouble(3);
                    d4 = resultSet.getDouble(4);
                    d5 = resultSet.getDouble(5);
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    arrayList.add(new Double(d5));
                }
                if (this.prevList != null && this.prevList.size() > 0) {
                    double d6 = (Double)arrayList.get(0);
                    double d7 = (Double)this.prevList.get(0);
                    double d8 = (Double)arrayList.get(1);
                    double d9 = (Double)this.prevList.get(1);
                    double d10 = (Double)arrayList.get(2);
                    double d11 = (Double)this.prevList.get(2);
                    double d12 = (Double)arrayList.get(3);
                    double d13 = (Double)this.prevList.get(3);
                    double d14 = (Double)arrayList.get(4);
                    double d15 = (Double)this.prevList.get(4);
                    double d16 = 0.0;
                    double d17 = 0.0;
                    double d18 = 0.0;
                    double d19 = 0.0;
                    double d20 = 0.0;
                    d16 = d6 >= d7 ? d6 - d7 : d6;
                    d17 = d8 >= d9 ? d8 - d9 : d8;
                    d18 = d10 >= d11 ? d10 - d11 : d10;
                    d19 = d12 >= d13 ? d12 - d13 : d12;
                    d20 = d14 >= d15 ? d14 - d15 : d14;
                    ArrayList<Double> arrayList2 = new ArrayList<Double>();
                    double d21 = -1.0;
                    double d22 = -1.0;
                    double d23 = -1.0;
                    double d24 = -1.0;
                    double d25 = -1.0;
                    d21 = this.timeSinceLastTest < 0.0 || d16 < 0.0 ? -1.0 : d16 / this.timeSinceLastTest;
                    d22 = this.timeSinceLastTest < 0.0 || d17 < 0.0 ? -1.0 : d17 / this.timeSinceLastTest;
                    d23 = this.timeSinceLastTest < 0.0 || d18 < 0.0 ? -1.0 : d18 / this.timeSinceLastTest;
                    d24 = this.timeSinceLastTest < 0.0 || d19 < 0.0 ? -1.0 : d19 / 1024.0 / this.timeSinceLastTest;
                    d25 = this.timeSinceLastTest < 0.0 || d20 < 0.0 ? -1.0 : d20 / 1024.0 / this.timeSinceLastTest;
                    arrayList2.add(new Double(d21));
                    arrayList2.add(new Double(d22));
                    arrayList2.add(new Double(d23));
                    arrayList2.add(new Double(d24));
                    arrayList2.add(new Double(d25));
                    if (this.isDebug) {
                        System.out.println("[" + this.getClass().getName() + "]-Final MeasureList : " + arrayList2);
                    }
                    this.addNewMeasure(arrayList2);
                } else if (this.isPassive) {
                    ArrayList<Double> arrayList3 = new ArrayList<Double>();
                    arrayList3.add(new Double(this.defValue));
                    arrayList3.add(new Double(this.defValue));
                    arrayList3.add(new Double(this.defValue));
                    arrayList3.add(new Double(this.defValue));
                    arrayList3.add(new Double(this.defValue));
                    System.out.println("[SybServerNetIOTest]-First time measure:" + arrayList3);
                    this.addNewMeasure(arrayList3);
                }
                this.prevList = (ArrayList)arrayList.clone();
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", "SybServerNetIOTest execute query ", exception.toString());
                exception.printStackTrace();
                if (this.isPassive) {
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(this.defValue));
                    arrayList.add(new Double(this.defValue));
                    arrayList.add(new Double(this.defValue));
                    arrayList.add(new Double(this.defValue));
                    arrayList.add(new Double(this.defValue));
                    this.addNewMeasure(arrayList);
                }
                Object var58_37 = null;
                if (resultSet != null) {
                    this.closeRs(resultSet);
                }
                if (sybStatement != null) {
                    this.closeStmt(sybStatement);
                }
                if (string != null) {
                    this.closeConn((SybConnection)string);
                }
            }
            Object var58_36 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
        }
        catch (Throwable throwable) {
            Object var58_38 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
            throw throwable;
        }
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4) {
        try {
            Class.forName(this.driver);
            String string5 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", this.defaultCharSet);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("REPEAT_READ", "false");
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string5, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "Exception while Connection ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SybServerNetIOTest sybServerNetIOTest = new SybServerNetIOTest(stringArray);
        sybServerNetIOTest.computeMeasures(new Hashtable());
    }
}

