/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TibSqlNetHelper
extends Thread {
    public boolean done = false;
    private TibSqlNetTest test = null;
    public String tibSqlNetDDString = "";

    public TibSqlNetHelper(TibSqlNetTest tibSqlNetTest) {
        this.test = tibSqlNetTest;
        this.start();
    }

    public void run() {
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        String string = "jdbc:tibero:thin:@" + this.test.targetHost + ":" + this.test.portNo + ":" + this.test.tibSid;
        try {
            long l;
            long l2 = System.currentTimeMillis();
            try {
                connection = this.newConnection(string, this.test.username, this.test.password);
            }
            catch (Exception exception) {
                this.test.connAvailability = 0.0;
                this.test.connRespTime = -5.0;
                this.done = true;
            }
            if (connection == null) {
                this.done = true;
                return;
            }
            long l3 = 0L;
            if (connection != null) {
                this.test.connAvailability = 100.0;
                l = System.currentTimeMillis();
                this.test.connRespTime = (double)(l - l2) / 1000.0;
                l3 = System.currentTimeMillis();
                statement = connection.createStatement();
                if (statement != null) {
                    resultSet = statement.executeQuery(this.test.tibQuery);
                }
            }
            if (resultSet != null) {
                this.test.noOfRecords = 0;
                this.test.queryAvailability = 100.0;
                l = System.currentTimeMillis();
                this.test.queryRespTime = (double)(l - l3) / 1000.0;
                try {
                    while (resultSet.next()) {
                        ++this.test.noOfRecords;
                    }
                }
                catch (Exception exception) {
                    this.test.noOfRecords = 0;
                }
            } else {
                this.test.queryAvailability = -5.0;
                this.test.queryRespTime = -5.0;
            }
            this.test.availability = this.test.connAvailability == 100.0 && this.test.queryAvailability == 100.0 ? 100.0 : 0.0;
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            l = System.currentTimeMillis();
            this.test.totRespTime = this.test.availability == 100.0 ? (double)(l - l2) / 1000.0 : -5.0;
            this.done = true;
        }
        catch (Exception exception) {
            System.out.println("TibSqlNetTest failed " + exception.toString() + " " + string + " " + this.test.username);
            this.closeRs(resultSet);
            this.closeStmt(statement);
            this.closeConn(connection);
            this.done = true;
            this.tibSqlNetDDString = EgInstallInfo.getStackTraceAsString(exception);
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private Connection newConnection(String string, String string2, String string3) throws SQLException {
        Connection connection = null;
        long l = System.currentTimeMillis();
        try {
            TbDataSource tbDataSource = new TbDataSource();
            tbDataSource.setURL(string);
            tbDataSource.setUser(string2);
            tbDataSource.setPassword(string3);
            connection = tbDataSource.getConnection();
        }
        catch (Exception exception) {
            System.out.println("Error  while getting connection for TIBERO SQLNET Test..." + exception.getMessage());
            this.tibSqlNetDDString = EgInstallInfo.getStackTraceAsString(exception);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 >= 60000L) {
                System.out.println("TIBERO SQLNET  test got stuck while getting connection...");
                l = l2;
            }
            return null;
        }
        return connection;
    }
}

