/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class VNXeConfigBase
extends GenericTest {
    EgUtilities egu;
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double KB_TO_GB = 1048576.0;
    protected static final double KB_TO_MB = 1024.0;
    protected static final double MICROSEC_TO_MILLISEC = 1000.0;
    protected final long SECONDS_TO_HOURS = 3600L;
    protected static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    protected static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    protected static String fieldSep = new String("");
    protected static String sync0 = new String("x");
    protected String spaIP = "";
    protected String username = "";
    protected String password = "";
    protected String cliPath = "";
    protected String sysOS = "";
    protected String strTimeout = "";
    protected long tmp_timeout = 300L;
    protected int egTestFreq = 0;
    protected static final Hashtable VNXE_CMDS = new Hashtable();
    protected String vnxeVersion = "1600";
    protected String cmdPath = null;
    protected String cmdPathDebug = null;
    protected int intervalCLI = 60;
    protected int num_DD_Messages = 10;
    protected String systemName = " VNXe ";
    protected static final String DEBUG_COMPUTE_MEASURE_METHOD_NAME = "[debugComputeMeasures] :";
    protected static final String HYPHEN = "-";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VNXeConfigBase(String[] stringArray) {
        super(stringArray);
        String string = "VNXeConfigBase";
        string = this.methodNameTemplate(string);
        this.isNewDynamicInfoTest = true;
        this.needAgentlessDD = true;
        this.fixedTestPeriod = true;
        this.egu = EgUtilities.createInstance((boolean)true);
        this.spaIP = this.targetHost;
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.cliPath = this.getValueForParam("unisphere_cli_path");
        this.strTimeout = this.getValueForParam("timeout");
        this.vnxeVersion = this.getValueForParam("vnxe_Version");
        if (this.username == null || this.username.equalsIgnoreCase("none") || this.username.trim().length() == 0) {
            this.printOut(string + "Username is null or empty, asign default value : " + this.username);
            this.putErrorMessageToLogfile(string + "Username is null or empty, asign default value : " + this.username);
            this.username = "none";
        }
        if (this.password == null || this.password.equalsIgnoreCase("none") || this.password.trim().length() == 0) {
            this.password = "none";
            this.printOut(string + "Password is null or empty, asign default value : " + this.password);
            this.putErrorMessageToLogfile(string + "Password is null or empty, asign default value : " + this.password);
        }
        if (this.cliPath == null || this.cliPath.equalsIgnoreCase("none") || this.cliPath.trim().length() == 0) {
            this.printOut(string + "Unisphere path is null or empty : " + this.cliPath);
            this.putErrorMessageToLogfile(string + "Unisphere path is null or empty : " + this.cliPath);
            this.cliPath = "";
        }
        if (this.vnxeVersion == null || this.vnxeVersion.equalsIgnoreCase("none") || this.vnxeVersion.trim().length() == 0) {
            this.printOut(string + "Storage version is null or empty, assign version 1600 : " + this.vnxeVersion);
            this.putErrorMessageToLogfile(string + "Storage version is null or empty, assign version 1600 : " + this.vnxeVersion);
            this.vnxeVersion = "1600";
        } else if (!this.vnxeVersion.equalsIgnoreCase("1600")) {
            this.systemName = " Unity ";
        }
        if (this.strTimeout == null || this.strTimeout.trim().length() == 0 || this.strTimeout.equalsIgnoreCase("none")) {
            this.tmp_timeout = 300L;
        } else {
            try {
                this.tmp_timeout = Long.parseLong(this.strTimeout);
            }
            catch (Exception exception) {
                this.tmp_timeout = 300L;
                exception.printStackTrace();
            }
        }
        if (this.spaIP == null) {
            this.spaIP = "";
        }
        this.sysOS = System.getProperty("os.name");
        if (this.sysOS == null) {
            this.putErrorMessageToLogfile(string + "Operating System Name not Found");
            return;
        }
        this.sysOS = this.sysOS.trim().toUpperCase();
        if (this.sysOS.trim().startsWith("WIN")) {
            this.cliPath.replace('/', '\\');
            if (!this.cliPath.endsWith("\\")) {
                this.cliPath = this.cliPath + "\\";
            }
            this.cmdPath = "\"" + this.cliPath + "uemcli" + "\"" + " -d " + this.spaIP + " -u " + this.username + " -p " + this.password;
            this.cmdPathDebug = "\"" + this.cliPath + "uemcli" + "\"" + " -d " + this.spaIP + " -u " + this.username + " -p " + EgCrypt.encrypt(this.password);
            this.printOut(string + "Command line path for Windows OS : " + this.cmdPathDebug);
        } else {
            this.cliPath.replace('\\', '/');
            if (!this.cliPath.endsWith("/")) {
                this.cliPath = this.cliPath + "/";
            }
            this.cmdPath = this.cliPath + "uemcli" + " -d " + this.spaIP + " -u " + this.username + " -p " + this.password;
            this.cmdPathDebug = this.cliPath + "uemcli" + " -d " + this.spaIP + " -u " + this.username + " -p ********** ";
            this.printOut(string + "Command line path for Linux OS : " + this.cmdPathDebug);
        }
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
        this.printOut(string + "Storage IP : " + this.spaIP);
        this.printOut(string + "Username : " + this.username);
        this.printOut(string + "Unisphere path : " + this.cliPath);
        this.printOut(string + "Timeout : " + this.tmp_timeout);
        this.printOut(string + this.systemName + "Version : " + this.vnxeVersion);
        VNXE_CMDS.put("battery", "/env/bat show -detail");
        VNXE_CMDS.put("diskShow", "/env/disk show -detail");
        VNXE_CMDS.put("dpe", "/env/dpe show -detail");
        VNXE_CMDS.put("ethernet", "/net/port/eth show -detail");
        VNXE_CMDS.put("fan", "/env/fan show -detail");
        VNXE_CMDS.put("fc", "/net/port/fc show -detail");
        VNXE_CMDS.put("host", "/remote/host show -detail");
        VNXE_CMDS.put("initiator", "/remote/initiator show -detail");
        VNXE_CMDS.put("ioModule", "/env/iomodule show -detail");
        VNXE_CMDS.put("iscsi", "/net/iscsi/node show -detail");
        VNXE_CMDS.put("lun", "/stor/prov/luns/lun show -detail");
        VNXE_CMDS.put("memory", "/env/mm show -detail");
        VNXE_CMDS.put("powerSupply", "/env/ps show -detail");
        VNXE_CMDS.put("SAS", "/net/port/sas show -detail");
        VNXE_CMDS.put("SP", "/env/sp show -detail");
        VNXE_CMDS.put("SSD", "/env/ssd show -detail");
        VNXE_CMDS.put("storagePool", "/stor/config/pool show -detail");
        VNXE_CMDS.put("storageDG", "/stor/config/dg show -detail");
        VNXE_CMDS.put("VMFS", "/stor/prov/vmware/vmfs show -detail");
        VNXE_CMDS.put("VM", "/virt/vmw/vm show -detail");
        VNXE_CMDS.put("System", "/sys/general show -detail");
        VNXE_CMDS.put("SysInfo", "/sys/info show -detail");
        VNXE_CMDS.put("License", "/sys/lic show -detail");
        VNXE_CMDS.put("ESRS", "/sys/support/esrs show -detail");
        VNXE_CMDS.put("ManagementInterface", "/net/if show -detail");
        VNXE_CMDS.put("EXS", "/virt/vmw/esx show -detail");
        VNXE_CMDS.put("RemoteSystem", "/remote/sys show -detail");
        VNXE_CMDS.put("AlertSetting", "/event/alert/conf show -detail");
    }

    protected String checkStateStr(String string) {
        String string2 = HYPHEN;
        if (string == null || string.trim().length() == 0) {
            return HYPHEN;
        }
        string2 = string.equalsIgnoreCase("OK (5)") ? "Normal" : (string.equalsIgnoreCase("OK BUT (7)") ? "Normal but needs attention" : (string.equalsIgnoreCase("Unknown (0)") ? "Unknown" : (string.equalsIgnoreCase("Degraded/Warning (10)") ? "Degraded/Warning" : (string.equalsIgnoreCase("Minor failure (15)") ? "Minor failure" : (string.equalsIgnoreCase("Major failure (20)") ? "Major failure" : (string.equalsIgnoreCase("Critical failure (25)") ? "Critical failure" : (string.equalsIgnoreCase("Non-recoverable error (30)") ? "Non-recoverable error" : string)))))));
        return string2;
    }

    Hashtable getCLIData(ArrayList arrayList, String[] stringArray, String string) {
        String string2 = "getCLIData";
        string2 = this.methodNameTemplate(string2);
        Hashtable<Object, ArrayList> hashtable = new Hashtable<Object, ArrayList>();
        try {
            if (arrayList == null || arrayList.size() == 0) {
                return hashtable;
            }
            ArrayList arrayList2 = null;
            block2: for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = "" + arrayList.get(i);
                string3 = this.removeStartsNumber(string3).trim();
                this.printOut(string2 + "Line ----> " + string3);
                String string4 = string3.toUpperCase();
                if (string4.indexOf("=") == -1) continue;
                string4 = string4.substring(0, string4.indexOf("=")).trim();
                for (int j = 0; j < stringArray.length; ++j) {
                    if (string4.equalsIgnoreCase(stringArray[0])) {
                        if (arrayList2 != null && arrayList2.size() > 0 && !arrayList2.get(0).toString().equalsIgnoreCase(HYPHEN)) {
                            if (string == null) {
                                hashtable.put(arrayList2.get(0), arrayList2);
                            } else {
                                hashtable.put(string, arrayList2);
                            }
                        }
                        arrayList2 = this.setDefaultValueToList(stringArray.length);
                    }
                    if (!string4.equalsIgnoreCase(stringArray[j])) continue;
                    arrayList2.set(j, this.getAttributeVale(string3));
                    continue block2;
                }
            }
            if (arrayList2 != null && arrayList2.size() > 0 && !arrayList2.get(0).toString().equalsIgnoreCase(HYPHEN)) {
                if (string == null) {
                    hashtable.put(arrayList2.get(0), arrayList2);
                } else {
                    hashtable.put(string, arrayList2);
                }
            }
            return hashtable;
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + "Error in adding measure", exception);
            return null;
        }
    }

    ArrayList setDefaultValueToList(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(HYPHEN);
        }
        return arrayList;
    }

    String getAttributeVale(String string) {
        if (string == null || string.trim().length() == 0) {
            return HYPHEN;
        }
        String string2 = string.lastIndexOf("=") > -1 ? string.substring(string.indexOf("=") + 1, string.length()) : HYPHEN;
        string2 = string2.trim().length() == 0 ? HYPHEN : string2;
        return string2.trim();
    }

    String removeStartsNumber(String string) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        String string2 = "";
        if (string.lastIndexOf("=") > -1) {
            string2 = string.substring(0, string.indexOf("="));
            string2 = string2.indexOf(":") > -1 ? string2.substring(string2.indexOf(":") + 1, string2.length()) + "" + string.substring(string.lastIndexOf("="), string.length()) : string;
        } else {
            return string;
        }
        return string2;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + string3);
        this.putErrorMessageToLogfile(string2 + string3);
    }
}

