/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WLClusterTest
extends GenericTest {
    static final String EGURKHA_NAME = "egurkha";
    static final String EGURKHA_MONITOR = "monitoring";
    private String user = "system";
    private String password = "weblogic";
    private boolean isSsl = false;
    private String uri = "egurkha/WLClusterTest.jsp";
    private String server = "";
    private long timeout;
    private int defVersion = 6;
    private int version = 0;
    private String url;
    private String ssl;
    private String host;
    private String port;
    private String protocol = "t3";
    double fragmentsSent_last = -5.0;
    double fragmentsReceived_last = -5.0;
    double fragmentsDropped_last = -5.0;
    double messagesLost_last = -5.0;
    double resendRequests_last = -5.0;
    private WebLogicHelperThread sh;
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String tempHost = "";
    boolean useJMX = false;
    protected long jspTimeout;

    public WLClusterTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(7);
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        String string = this.getValueForParam("jspTimeout");
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string);
    }

    public static void main(String[] stringArray) {
        WLClusterTest wLClusterTest = new WLClusterTest(stringArray);
        wLClusterTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        this.user = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.server = (String)hashtable.get("server");
        this.ssl = (String)hashtable.get("ssl");
        this.url = (String)hashtable.get("url");
        this.s_useWarFile = (String)hashtable.get("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
        }
        String string = this.getValueForParam("encryptPass");
        if (string != null && string.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.ssl != null) {
            this.isSsl = new Boolean(this.ssl);
        }
        if (this.version == 0) {
            String string2 = this.getValueForParam("version");
            if (!string2.equalsIgnoreCase("none")) {
                int n = string2.indexOf(".");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                try {
                    this.version = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.version = 0;
                }
            }
            if (this.version == 0) {
                this.version = this.discovery();
            }
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            if (this.isSsl) {
                this.url = "https://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3s";
            } else {
                this.url = "http://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3";
            }
        } else {
            this.url = this.url.toLowerCase();
            if (this.isSsl) {
                if (this.url.indexOf("https") < 0) {
                    this.url = this.findAndReplaceString(this.url, "http", "https");
                }
                this.protocol = "t3s";
            }
        }
        if (this.version >= 12) {
            this.useJMX = true;
        }
        if (this.useJMX) {
            this.uri = "egurkha/WLClusterTestUsingJMX.jsp";
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (this.version >= 6) {
            ArrayList arrayList = this.returnMeasures();
            System.out.println("al_values   :" + arrayList);
            if (arrayList == null || arrayList.size() == 0) {
                this.addNewMeasure(null);
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                String string3 = (String)arrayList.get(i);
                if (string3 != null) {
                    object = new StringTokenizer(string3, ":");
                    if (((StringTokenizer)object).countTokens() != 2) {
                        this.addNewMeasure(null);
                        return;
                    }
                    ((StringTokenizer)object).nextToken();
                    string3 = ((StringTokenizer)object).nextToken();
                    object = new StringTokenizer(string3, ",");
                    if (((StringTokenizer)object).countTokens() != 7) {
                        this.addNewMeasure(null);
                        return;
                    }
                } else {
                    this.addNewMeasure(null);
                    return;
                }
                d = Double.parseDouble(((StringTokenizer)object).nextToken());
                d2 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d3 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d4 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d5 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d6 = Double.parseDouble(((StringTokenizer)object).nextToken());
                d7 = Double.parseDouble(((StringTokenizer)object).nextToken());
                object = new ArrayList();
                ((ArrayList)object).add(new Double(d));
                if (this.fragmentsSent_last != -5.0) {
                    double d8 = d2 - this.fragmentsSent_last;
                    ((ArrayList)object).add(new Double(d8 >= 0.0 ? d8 / this.timeSinceLastTest : -5.0));
                    d8 = d3 - this.fragmentsReceived_last;
                    ((ArrayList)object).add(new Double(d8 >= 0.0 ? d8 / this.timeSinceLastTest : -5.0));
                    d8 = d4 - this.fragmentsDropped_last;
                    ((ArrayList)object).add(new Double(d8 >= 0.0 ? d8 / this.timeSinceLastTest : -5.0));
                    d8 = d5 - this.messagesLost_last;
                    ((ArrayList)object).add(new Double(d8 >= 0.0 ? d8 / this.timeSinceLastTest : -5.0));
                    d8 = d6 - this.resendRequests_last;
                    ((ArrayList)object).add(new Double(d8 >= 0.0 ? d8 / this.timeSinceLastTest : -5.0));
                } else {
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                    ((ArrayList)object).add(new Double(-5.0));
                }
                ((ArrayList)object).add(new Double(d7));
                this.addNewMeasure((ArrayList)object);
                this.fragmentsSent_last = d2;
                this.fragmentsReceived_last = d3;
                this.fragmentsDropped_last = d4;
                this.messagesLost_last = d5;
                this.resendRequests_last = d6;
            }
        }
    }

    private ArrayList returnMeasures() {
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "getWLClusterTest.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                return null;
            }
            WLCommandExecute wLCommandExecute = new WLCommandExecute();
            if (this.useJMX) {
                return wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLClusterTestUsingJMX");
            }
            return wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLClusterTest");
        }
        HttpURLConnection httpURLConnection = null;
        Object var2_3 = null;
        Object var3_4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            string = this.url + "/" + this.uri + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        String string2 = this.url + "/" + this.uri + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=********&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        System.out.println("[" + this.reportingName + ":" + this.entity + "]  measureUri : " + string2);
        URL uRL = null;
        System.out.println(this.entity + ":" + this.reportingName + " Version : " + this.version + " URL : " + string);
        if (this.isSsl) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var10_15 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
                ArrayList arrayList2 = null;
                int n = 0;
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    n = connectionThread.code;
                    arrayList2 = connectionThread.data;
                }
                connectionThread = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    System.out.println("code " + n + "  Data  :" + arrayList2);
                    return null;
                }
                if (arrayList2 == null || arrayList2.size() == 0) {
                    return null;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3 = (String)arrayList2.get(i);
                    if (string3.startsWith("WLClusterTest")) {
                        arrayList.add(string3);
                        continue;
                    }
                    System.out.println(this.entity + ":" + this.reportingName + "  ===> URL connection output :" + string3);
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }
        try {
            uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList3 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList3 = connectionThread.data;
            }
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                System.out.println("code " + n + "  Data  :" + arrayList3);
                return null;
            }
            if (arrayList3 == null || arrayList3.size() == 0) {
                return null;
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                String string4 = (String)arrayList3.get(i);
                if (string4.startsWith("WLClusterTest")) {
                    arrayList.add(string4);
                    continue;
                }
                System.out.println(this.entity + ":" + this.reportingName + "  ===> URL connection output :" + string4);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
        return arrayList;
    }

    public int discovery() {
        long l;
        this.sh = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), this.isSsl);
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (this.sh.done) {
                return this.sh.version;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                this.sh.stop();
                this.sh = null;
                return this.defVersion;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        this.sh.stop();
        this.sh = null;
        return this.defVersion;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

