/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WLEJBLockTest
extends WLBaseTest_F {
    private double lockManagerAccessCount_last = -5.0;
    private double timeoutTotalCount_last = -5.0;
    private double waiterTotalCount_last = -5.0;
    private String protocol = "t3";
    private Hashtable lastMeasures = new Hashtable();
    private Hashtable newLastMeasures = new Hashtable();
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private boolean useJMX = false;

    public WLEJBLockTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.needToStoreMeasuresForDD = true;
        this.doNotTakeAverageList.add(new Integer(1));
        this.doNotTakeAverageList.add(new Integer(2));
        this.doNotTakeAverageList.add(new Integer(3));
        this.doNotTakeAverageList.add(new Integer(4));
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.server = this.getValueForParam("server");
        this.ssl = this.getValueForParam("ssl");
        this.url = this.getValueForParam("url");
        this.s_useWarFile = this.getValueForParam("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
        }
        String string2 = this.getValueForParam("showServerName");
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            this.showServer = false;
        }
        if ((string = this.getValueForParam("encryptPass")) != null && string.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        this.newLastMeasures = new Hashtable();
        if (this.weblogicVersion == 0) {
            String string3 = this.getValueForParam("version");
            if (!string3.equalsIgnoreCase("none")) {
                int n = string3.indexOf(".");
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                }
                try {
                    this.weblogicVersion = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    this.weblogicVersion = 0;
                }
            }
            if (this.weblogicVersion == 0) {
                this.discovery();
            }
        }
        System.out.println(this.entity + ":" + this.reportingName + " weblogicVersion :" + this.weblogicVersion);
        if (this.weblogicVersion < 6) {
            this.lastMeasures = new Hashtable();
            this.logToErrorFile("Error", "WLEJBLockTest", "WebLogic version number is " + this.weblogicVersion + ". Can't monitor WebLogic Server version prior to 6");
            return;
        }
        boolean bl = false;
        bl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("yes"));
        this.protocol = bl ? "t3s" : "t3";
        if (this.weblogicVersion >= 12) {
            this.useJMX = true;
        }
        ArrayList arrayList = null;
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "getWLEJBLockTest.computeMeasures", "Invalid arguments");
                this.lastMeasures = new Hashtable();
                return;
            }
            object = new WLCommandExecute();
            arrayList = this.useJMX ? ((WLCommandExecute)object).executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLEJBLockTestUsingJMX") : ((WLCommandExecute)object).executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLEJBLockTest");
        } else {
            arrayList = this.useJMX ? this.getMeasuresFromJSP("WLEJBLockTestUsingJMX") : this.getMeasuresFromJSP("WLEJBLockTest");
        }
        if (arrayList == null || arrayList.size() == 0) {
            this.lastMeasures = new Hashtable();
            return;
        }
        object = this.getComponentsToBeMonitored();
        String string4 = this.server + "_";
        int n = string4.length();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string5 = (String)arrayList.get(i);
            if (string5 == null || (n3 = string5.indexOf(":")) == -1 || (n3 = (string5 = string5.substring(n3 + 1)).indexOf(",")) == -1) continue;
            String string6 = string5.substring(0, n3);
            if (!this.showServer && string6.startsWith(string4)) {
                string6 = string6.substring(n);
            }
            if (!this.isAuto && object != null && ((Vector)object).size() > 0 && !((Vector)object).contains(string6)) continue;
            string5 = string5.substring(n3 + 1);
            try {
                n3 = string5.indexOf(",");
                if (n3 == -1) continue;
                double d = Double.parseDouble(string5.substring(0, n3));
                if ((n3 = (string5 = string5.substring(n3 + 1)).indexOf(",")) == -1) continue;
                double d2 = Double.parseDouble(string5.substring(0, n3));
                if ((n3 = (string5 = string5.substring(n3 + 1)).indexOf(",")) == -1) continue;
                double d3 = Double.parseDouble(string5.substring(0, n3));
                string5 = string5.substring(n3 + 1);
                double d4 = Double.parseDouble(string5);
                this.populateLastMeasures(string6);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                arrayList2.add(new Double(d));
                if (this.lockManagerAccessCount_last == -5.0) {
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                } else {
                    double d5 = d2 - this.lockManagerAccessCount_last;
                    arrayList2.add(new Double(d5 >= 0.0 ? d5 / this.timeSinceLastTest : -5.0));
                    d5 = d3 - this.timeoutTotalCount_last;
                    arrayList2.add(new Double(d5 >= 0.0 ? d5 / this.timeSinceLastTest : -5.0));
                    d5 = d4 - this.waiterTotalCount_last;
                    arrayList2.add(new Double(d5 >= 0.0 ? d5 / this.timeSinceLastTest : -5.0));
                }
                this.lockManagerAccessCount_last = d2;
                this.timeoutTotalCount_last = d3;
                this.waiterTotalCount_last = d4;
                this.addNewMeasure(string6, arrayList2);
                this.saveLastMeasures(string6);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.logToErrorFile("Error", "WLEJBLockTest.computeMeasures ", string6 + " : " + numberFormatException.toString());
                numberFormatException.printStackTrace();
            }
        }
        this.lastMeasures = this.newLastMeasures;
    }

    private void populateLastMeasures(String string) {
        if (!this.lastMeasures.isEmpty() && this.lastMeasures.containsKey(string)) {
            String string2 = (String)this.lastMeasures.get(string);
            int n = string2.indexOf(",");
            this.lockManagerAccessCount_last = Double.parseDouble(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(",");
            this.timeoutTotalCount_last = Double.parseDouble(string2.substring(0, n));
            this.waiterTotalCount_last = Double.parseDouble(string2.substring(n + 1));
            return;
        }
        this.lockManagerAccessCount_last = -5.0;
        this.timeoutTotalCount_last = -5.0;
        this.waiterTotalCount_last = -5.0;
    }

    private void saveLastMeasures(String string) {
        String string2 = this.lockManagerAccessCount_last + "," + this.timeoutTotalCount_last + "," + this.waiterTotalCount_last;
        this.newLastMeasures.put(string, string2);
    }
}

