/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WLJoltConnPoolTest
extends GenericTest {
    static final String EGURKHA_NAME = "egurkha";
    static final String EGURKHA_MONITOR = "monitoring";
    private String user = "system";
    private String password = "weblogic";
    private boolean isSsl = false;
    private String uri = "egurkha/WLJoltConnPoolTest.jsp";
    private String server = "";
    private long timeout;
    private int defVersion = 6;
    private int version = 0;
    private String url;
    private String ssl;
    private String protocol = "t3";
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String tempHost = "";
    private WebLogicHelperThread sh;
    protected long jspTimeout;

    public WLJoltConnPoolTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        String string = this.getValueForParam("jspTimeout");
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase("null") || string.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string);
    }

    public static void main(String[] stringArray) {
        WLJoltConnPoolTest wLJoltConnPoolTest = new WLJoltConnPoolTest(stringArray);
        wLJoltConnPoolTest.executeTest();
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        this.user = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.server = (String)hashtable.get("server");
        this.ssl = (String)hashtable.get("ssl");
        this.url = (String)hashtable.get("url");
        String string = this.getValueForParam("encryptPass");
        this.s_useWarFile = (String)hashtable.get("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
        }
        if (string != null && string.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.ssl != null) {
            this.isSsl = new Boolean(this.ssl);
        }
        if (this.version == 0) {
            object = this.getValueForParam("version");
            if (!((String)object).equalsIgnoreCase("none")) {
                int n = ((String)object).indexOf(".");
                if (n >= 0) {
                    object = ((String)object).substring(0, n);
                }
                try {
                    this.version = Integer.parseInt((String)object);
                }
                catch (Exception exception) {
                    this.version = 0;
                }
            }
            if (this.version == 0) {
                this.version = this.discovery();
            }
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            if (this.isSsl) {
                this.url = "https://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3s";
            } else {
                this.url = "http://" + this.tempHost + ":" + this.portNo;
                this.protocol = "t3";
            }
        } else {
            this.url = this.url.toLowerCase();
            if (this.isSsl) {
                if (this.url.indexOf("https") < 0) {
                    this.url = this.findAndReplaceString(this.url, "http", "https");
                }
                this.protocol = "t3s";
            }
        }
        if (this.version >= 6) {
            object = new ArrayList();
            ArrayList arrayList = this.returnMeasures();
            if (arrayList == null || arrayList.size() == 0) {
                this.logToErrorFile("Error", "WLJoltConnPoolTest.computeMeasures", " output is null targetHost:" + this.targetHost + " reportingName:" + this.reportingName);
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = new ArrayList<Double>();
                String string2 = (String)arrayList.get(i);
                if (string2 != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                    if (stringTokenizer.countTokens() != 2) {
                        System.out.println("WLJoltConnPoolTest less than 2 tokens delmiter colon " + string2);
                        this.logToErrorFile("Error", "WLJoltConnPoolTest.computeMeasures", " output is less than 2 tokens targetHost:" + this.targetHost + " reportingName:" + this.reportingName);
                        return;
                    }
                    stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    stringTokenizer = new StringTokenizer(string2, ",");
                    if (stringTokenizer.countTokens() != 5) {
                        System.out.println("WLJoltConnPoolTest less than 7 tokens delimiter coma " + string2);
                        this.logToErrorFile("Error", "WLJoltConnPoolTest.computeMeasures", " output is less than 5 tokens targetHost:" + this.targetHost + " reportingName:" + this.reportingName);
                        return;
                    }
                    String string3 = stringTokenizer.nextToken();
                    String string4 = stringTokenizer.nextToken();
                    double d = 0.0;
                    if (string3 == null || string3.trim().length() == 0) continue;
                    if (string4.trim().equalsIgnoreCase("active")) {
                        d = 1.0;
                    }
                    double d2 = Double.parseDouble(stringTokenizer.nextToken());
                    double d3 = Double.parseDouble(stringTokenizer.nextToken());
                    double d4 = Double.parseDouble(stringTokenizer.nextToken());
                    double d5 = -5.0;
                    double d6 = -5.0;
                    if (d2 > 0.0) {
                        d5 = d3 / d2 * 100.0;
                        d6 = d4 / d2 * 100.0;
                    }
                    ((ArrayList)object).add(new Double(d));
                    ((ArrayList)object).add(new Double(d2));
                    ((ArrayList)object).add(new Double(d3));
                    ((ArrayList)object).add(new Double(d4));
                    ((ArrayList)object).add(new Double(d5));
                    ((ArrayList)object).add(new Double(d6));
                    this.addNewMeasure(string3, (ArrayList)object);
                    continue;
                }
                this.logToErrorFile("Error", "WLJoltConnPoolTest.computeMeasures", " output value is null targetHost:" + this.targetHost + " reportingName:" + this.reportingName);
                return;
            }
        }
    }

    private ArrayList returnMeasures() {
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "WLJoltConnPoolTest.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                return null;
            }
            WLCommandExecute wLCommandExecute = new WLCommandExecute();
            return wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLJoltConnPoolTest");
        }
        String string = "";
        HttpURLConnection httpURLConnection = null;
        Object var3_4 = null;
        Object var4_5 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            string2 = this.url + "/" + this.uri + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        String string3 = this.url + "/" + this.uri + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=*********&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
        System.out.println("[" + this.reportingName + ":" + this.entity + "]  measureUri : " + string3);
        URL uRL = null;
        if (this.isSsl) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var11_16 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.connect();
                ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
                ArrayList arrayList2 = null;
                int n = 0;
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    n = connectionThread.code;
                    arrayList2 = connectionThread.data;
                }
                connectionThread = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (arrayList2 == null || arrayList2.size() == 0) {
                    return null;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string4 = (String)arrayList2.get(i);
                    if (!string4.startsWith("WLJoltConnPoolTest")) continue;
                    arrayList.add(string4);
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                return null;
            }
        }
        try {
            uRL = new URL(string2);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false);
            ArrayList arrayList3 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                arrayList3 = connectionThread.data;
            }
            connectionThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (arrayList3 == null || arrayList3.size() == 0) {
                return null;
            }
            for (int i = 0; i < arrayList3.size(); ++i) {
                String string5 = (String)arrayList3.get(i);
                if (!string5.startsWith("WLJoltConnPoolTest")) continue;
                arrayList.add(string5);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
        return arrayList;
    }

    public int discovery() {
        long l;
        this.sh = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), this.isSsl);
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (this.sh.done) {
                return this.sh.version;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                this.sh.stop();
                this.sh = null;
                return this.defVersion;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        this.sh.stop();
        this.sh = null;
        return this.defVersion;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        while (string.indexOf(string2) > -1) {
            stringBuffer.append(string.substring(0, string.indexOf(string2)) + string3);
            string = string.substring(string.indexOf(string2) + string2.length(), string.length());
        }
        if (string.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

