/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class XIOSCtrlrTest
extends XtremIOBase {
    private static final int XTREM_IO_STORAGE_CONTROLLERS_MEASURE_COUNT = 13;

    public XIOSCtrlrTest(String[] stringArray) {
        super(stringArray);
        try {
            this.setMeasureCount(13);
        }
        catch (Exception exception) {
            this.printOut("Error in constructor " + exception.toString());
            this.putErrorMessageToLogfile("Error in constructor " + exception.toString());
        }
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        if (this.xioAPIVersion <= 1.0) {
            this.printOut("This test supports EMC XtremIO API version 2 and above only ");
            this.putWarningMessageToLogfile("This test supports EMC XtremIO API version 2 and above only ");
            return;
        }
        Hashtable hashtable2 = this.getStorageControllers();
        if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
            this.printOut("Could not collect the  data ,so test returing ");
            this.putWarningMessageToLogfile("Could not collect the  data ,so test returing ");
            return;
        }
        this.printOut("Storage Controllers Hashtable " + hashtable2, debug);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            ArrayList arrayList;
            Object object;
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2.lastIndexOf("/") > -1 && this.xioAPIVersion > 1.0) {
                object = string2;
                object = ((String)object).substring(0, ((String)object).lastIndexOf("/"));
                this.printOut("Temp href :" + (String)object);
                string2 = (String)object + "?name=" + string + "&cluster-name=" + this.monitoredCluster;
            }
            this.printOut("Storage controllers name  :" + string + " href  :" + string2);
            object = this.getStorageControllerdata(string2);
            if (object != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
                arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                for (int i = 0; i < 13; ++i) {
                    arrayList.add(((ArrayList)object).get(i));
                }
                if (bl) continue;
                this.addNewMeasure(string, arrayList);
                continue;
            }
            arrayList = new ArrayList();
            for (int i = 0; i < 13; ++i) {
                arrayList.add(new Double(-5.0));
            }
            if (!bl) {
                this.addNewMeasure(string, arrayList);
            }
            this.printOut("Storage controller Name  :" + string + " measureArrayList(Passing defaultvalues) :" + arrayList, true);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        XIOSCtrlrTest xIOSCtrlrTest = new XIOSCtrlrTest(stringArray);
        xIOSCtrlrTest.debugComputeMeasures(new Hashtable(), true);
    }

    private ArrayList getStorageControllerdata(String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = this.getJSONDataFromURL(string);
        JSONObject jSONObject = null;
        if (string2 != null && string2.length() > 0) {
            JSONParser jSONParser = new JSONParser();
            try {
                jSONObject = (JSONObject)jSONParser.parse(string2);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"content");
            String string3 = (String)jSONObject2.get((Object)"current-health-state");
            double d = this.healthState(string3);
            this.printOut("Storage controllers current health state:" + d);
            arrayList.add(new Double(d));
            String string4 = (String)jSONObject2.get((Object)"enabled-state");
            double d2 = this.scEnabledState(string4);
            this.printOut("Storage controllers enabled state:" + d2);
            arrayList.add(new Double(d2));
            String string5 = (String)jSONObject2.get((Object)"fan-health-state");
            double d3 = this.healthState(string5);
            this.printOut("Storage controllers fan health state:" + d3);
            arrayList.add(new Double(d3));
            String string6 = (String)jSONObject2.get((Object)"fru-lifecycle-state");
            double d4 = this.fruLifeCycleState(string6);
            this.printOut("Storage controllers fru Life Cycle State:" + d4);
            arrayList.add(new Double(d4));
            String string7 = (String)jSONObject2.get((Object)"internal-sensor-health-state");
            double d5 = this.healthState(string7);
            this.printOut("Storage controllers internal sensor health state:" + d5);
            arrayList.add(new Double(d5));
            String string8 = (String)jSONObject2.get((Object)"iscsi-daemon-state");
            double d6 = this.iscsiDaemonState(string8);
            this.printOut("Storage controllers iscsi Daemon State:" + d6);
            arrayList.add(new Double(d6));
            String string9 = (String)jSONObject2.get((Object)"journal-state");
            double d7 = this.journalState(string9);
            this.printOut("Storage controllers journal State:" + d7);
            arrayList.add(new Double(d7));
            String string10 = (String)jSONObject2.get((Object)"low-ram-level");
            double d8 = this.lowRAMLevel(string10);
            this.printOut("Storage controllers low Ram Level:" + d8);
            arrayList.add(new Double(d8));
            String string11 = (String)jSONObject2.get((Object)"mgmt-link-health-level");
            double d9 = this.healthState(string11);
            this.printOut("Storage controllers mgmt Link Health:" + d9);
            arrayList.add(new Double(d9));
            String string12 = (String)jSONObject2.get((Object)"remote-journal-health-state");
            double d10 = this.journalState(string12);
            this.printOut("Storage controllers remote Journal Health State:" + d10);
            arrayList.add(new Double(d10));
            String string13 = (String)jSONObject2.get((Object)"temperature-health-state");
            double d11 = this.healthState(string13);
            this.printOut("Storage controllers temperature Health State:" + d11);
            arrayList.add(new Double(d11));
            String string14 = "" + jSONObject2.get((Object)"voltage-health-state");
            double d12 = this.healthState(string14);
            this.printOut("Storage controllers voltage Health state:" + d12);
            arrayList.add(new Double(d12));
            String string15 = "" + jSONObject2.get((Object)"mgmt-port-state");
            double d13 = this.mgmtPortState(string15);
            this.printOut("Storage controllers mgmt Port State:" + d13);
            arrayList.add(new Double(d13));
        }
        return arrayList;
    }

    private double mgmtPortState(String string) {
        double d = -5.0;
        if (string == null || string.trim().length() == 0) {
            d = -5.0;
        } else {
            if (string.equalsIgnoreCase("up")) {
                d = 0.0;
            }
            if (string.equalsIgnoreCase("down")) {
                d = 1.0;
            }
            if (string.equalsIgnoreCase("unknown")) {
                d = -1.0;
            }
        }
        return d;
    }

    private double journalState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("healthy") ? 0.0 : -1.0);
        return d;
    }

    private double lowRAMLevel(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("ok") ? 0.0 : -1.0);
        return d;
    }

    private double iscsiDaemonState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("healthy") ? 0.0 : (string.equalsIgnoreCase("failed") ? 1.0 : -1.0));
        return d;
    }

    private double scEnabledState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("enabled") ? 0.0 : (string.equalsIgnoreCase("user_disabled") ? 1.0 : (string.equalsIgnoreCase("system_disabled") ? 2.0 : -1.0)));
        return d;
    }

    private double healthState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("level_1_clear") ? 0.0 : (string.equalsIgnoreCase("level_2_unknown") ? 1.0 : (string.equalsIgnoreCase("level_3_warning") ? 2.0 : (string.equalsIgnoreCase("level_4_minor") ? 3.0 : (string.equalsIgnoreCase("level_5_major") ? 4.0 : (string.equalsIgnoreCase("level_6_critical") ? 5.0 : -1.0))))));
        return d;
    }
}

